/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.system;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.JFrame;
import se.swedsoft.bookkeeping.app.Path;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSStandardText;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.util.SSMailMessage;
import se.swedsoft.bookkeeping.data.util.SSMailServer;
import se.swedsoft.bookkeeping.data.util.SymetricCrypter;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.util.SSUtil;

public class SSMail {
    public static SymetricCrypter crypter = new SymetricCrypter(new byte[]{79, 83, -113, -40, 13, 33, 28, -28});
    private static final boolean SHOULD_DEBUG_PRINT = false;
    private static final File PDF_FILE_DIR = new File(Path.get(Path.APP_DATA), "pdftoemail");

    private SSMail() {
    }

    public static boolean sendMail(String pTo, String pSubject, String pFileName) throws AddressException, MessagingException {
        SSUtil.verifyNotNull("Arguments to sendMail can not be null", pTo, pSubject, pFileName);
        if (SSQueryDialog.showDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "mail.send", pTo) != 0) {
            return false;
        }
        SSNewCompany company = SSDB.getInstance().getCurrentCompany();
        SSMailMessage message = new SSMailMessage(company.getEMail(), pTo, company.getMailServer().getBccAddresses(), pSubject, company.getStandardText(SSStandardText.Email), new File(PDF_FILE_DIR, pFileName).getPath());
        MimeMessage mimeMessage = SSMail.makeMessage(company.getMailServer(), message);
        Transport.send(mimeMessage);
        return true;
    }

    public static MimeMessage makeMessage(SSMailServer server, SSMailMessage mail) throws MessagingException {
        SSUtil.verifyNotNull("server", server);
        SSUtil.verifyNotNull("Email message fields", mail.getFrom(), mail.getTo(), mail.getSubject());
        Session session = SSMail.makeSession(server);
        MimeMessage message = SSMail.makeMime(mail, session);
        Multipart multipart = SSMail.makeMultipart(mail);
        message.setContent(multipart);
        return message;
    }

    private static MimeMessage makeMime(SSMailMessage mail, Session session) throws MessagingException {
        MimeMessage message = new MimeMessage(session);
        message.setFrom(new InternetAddress(mail.getFrom()));
        message.addRecipient(Message.RecipientType.TO, new InternetAddress(mail.getTo()));
        if (mail.getBcc() != null && !"".equals(mail.getBcc())) {
            for (String bcc : Arrays.asList(mail.getBcc().split(",[ ]*"))) {
                message.addRecipient(Message.RecipientType.BCC, new InternetAddress(bcc));
            }
        }
        message.setSubject(mail.getSubject());
        return message;
    }

    private static Multipart makeMultipart(SSMailMessage mail) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(SSUtil.convertNullToEmpty(mail.getBodyText()));
        ((Multipart)multipart).addBodyPart(messageBodyPart);
        if (mail.getFileName() != null) {
            messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(mail.getFileName());
            messageBodyPart.setDataHandler(new DataHandler(source));
            messageBodyPart.setFileName(mail.getFileName().substring(mail.getFileName().lastIndexOf(File.separator) + 1));
            ((Multipart)multipart).addBodyPart(messageBodyPart);
        }
        return multipart;
    }

    private static Session makeSession(final SSMailServer server) {
        Properties props = new Properties();
        System.getProperties();
        props.put("mail.smtp.host", server.getURI().getHost());
        props.put("mail.smtp.port", Integer.toString(server.getURI().getPort()));
        props.put("mail.smtp.auth", Boolean.toString(server.isAuth()));
        props.put("mail.smtp.ssl.enable", Boolean.toString(server.isSSL()));
        props.put("mail.smtp.starttls.enable", Boolean.toString(server.isStartTLS()));
        Authenticator auth = null;
        if (server.isAuth()) {
            auth = new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(server.getUsername(), crypter.decrypt(server.getPassword()));
                }
            };
        }
        Session session = Session.getInstance(props, auth);
        session.setDebug(false);
        return session;
    }

    public static void onError(String message, String resourceName) throws MailValidationException {
        throw new MailValidationException(message, resourceName);
    }

    private static boolean isOk(SSNewCompany company, Object o, String resourceName) {
        try {
            String s;
            if (company.getMailServer() == null) {
                SSMail.onError("invalid mail server at current company", "mail.nosmtpserver");
            }
            if (SSUtil.isNullOrEmpty(company.getEMail())) {
                SSMail.onError("invalid mail address at current company", "mail.nocompanyemailaddress");
            }
            if (o == null) {
                SSMail.onError("Argument object is null", resourceName);
            }
            if (o instanceof SSCustomer) {
                s = ((SSCustomer)o).getEMail();
            } else if (o instanceof SSSupplier) {
                s = ((SSSupplier)o).getEMail();
            } else {
                throw new ClassCastException("o is of wrong type");
            }
            if (SSUtil.isNullOrEmpty(s)) {
                SSMail.onError("No mail address", resourceName);
            }
        }
        catch (MailValidationException e) {
            new SSErrorDialog(SSMainFrame.getInstance(), e.getResourceName());
            return false;
        }
        return true;
    }

    public static boolean isOk(SSCustomer iCustomer) {
        return SSMail.isOk(SSDB.getInstance().getCurrentCompany(), iCustomer, "mail.nocustomeremailaddress");
    }

    public static boolean isOk(SSSupplier iSupplier) {
        return SSMail.isOk(SSDB.getInstance().getCurrentCompany(), iSupplier, "mail.nosupplieremailaddress");
    }

    private static class MailValidationException
    extends Exception {
        private final String resourceName;

        public MailValidationException(String message, String resourceName) {
            super(message);
            this.resourceName = resourceName;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }
}

