/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.data.system;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class SSMemoryWarning {
    private final Collection<Listener> listeners = new ArrayList<Listener>();
    private static final MemoryPoolMXBean tenuredGenPool = SSMemoryWarning.findTenuredGenPool();

    public SSMemoryWarning() {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification n, Object hb) {
                if (n.getType().equals("java.management.memory.threshold.exceeded")) {
                    long maxMemory = tenuredGenPool.getUsage().getMax();
                    long usedMemory = tenuredGenPool.getUsage().getUsed();
                    for (Listener listener : SSMemoryWarning.this.listeners) {
                        listener.memoryUsageLow(usedMemory, maxMemory);
                    }
                }
            }
        }, null, null);
    }

    public boolean addListener(Listener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public static void setPercentageUsageThreshold(double percentage) {
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Percentage not in range");
        }
        long maxMemory = tenuredGenPool.getUsage().getMax();
        long warningThreshold = (long)((double)maxMemory * percentage);
        tenuredGenPool.setUsageThreshold(warningThreshold);
    }

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.data.system.SSMemoryWarning");
        sb.append("{listeners=").append(this.listeners);
        sb.append('}');
        return sb.toString();
    }

    public static interface Listener {
        public void memoryUsageLow(long var1, long var3);
    }
}

