/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.accountingyear;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSDBConfig;
import se.swedsoft.bookkeeping.data.system.SSYearLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.accountingyear.dialog.SSEditAccountingYearDialog;
import se.swedsoft.bookkeeping.gui.accountingyear.dialog.SSNewAccountingYearDialog;
import se.swedsoft.bookkeeping.gui.accountingyear.util.SSSystemYearDataModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.frame.SSFrameManager;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSDateCellRenderer;

public class SSAccountingYearFrame
extends SSDefaultTableFrame {
    private static SSAccountingYearFrame cInstance;
    private SSTable iTable;
    private SSDefaultTableModel<SSNewAccountingYear> iModel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSAccountingYearFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static void showFrame(final SSMainFrame pMainFrame, int pWidth, int pHeight, boolean pShowNewDialog) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSAccountingYearFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        if (pShowNewDialog) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SSNewAccountingYearDialog.showDialog(pMainFrame, cInstance.getModel());
                }
            });
        }
    }

    public static SSAccountingYearFrame getInstance() {
        return cInstance;
    }

    private SSAccountingYearFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("accountingyearframe.title"), width, height);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                SSAccountingYearFrame.this.updateFrame();
            }
        });
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_OPENITEM", "accountingyearframe.openbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountingYearFrame.this.openSelectedAccountingYear();
            }
        });
        toolBar.add(iButton);
        toolBar.addSeparator();
        this.iTable.addSelectionDependentComponent(iButton);
        iButton = new SSButton("ICON_NEWITEM", "accountingyearframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountingYearFrame.this.updateFrame();
                SSNewAccountingYearDialog.showDialog(SSAccountingYearFrame.this.getMainFrame(), SSAccountingYearFrame.this.iModel);
                SSAccountingYearFrame.this.updateFrame();
            }
        });
        iButton.setEnabled(true);
        toolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "accountingyearframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountingYearFrame.this.editSelectedAccountingYear();
            }
        });
        toolBar.add(iButton);
        this.iTable.addSelectionDependentComponent(iButton);
        iButton = new SSButton("ICON_DELETEITEM", "accountingyearframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountingYearFrame.this.deleteSelectedAccountingYear();
            }
        });
        toolBar.add(iButton);
        this.iTable.addSelectionDependentComponent(iButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iModel = new SSSystemYearDataModel();
        List<SSNewAccountingYear> iYears = SSDB.getInstance().getYears();
        Collections.sort(iYears, new Comparator<SSNewAccountingYear>(){

            @Override
            public int compare(SSNewAccountingYear o1, SSNewAccountingYear o2) {
                return o1.getFrom().compareTo(o2.getFrom());
            }
        });
        this.iModel.setObjects(iYears);
        this.iTable = new SSTable();
        this.iTable.setDefaultRenderer(Date.class, new SSDateCellRenderer());
        this.iTable.setSingleSelect();
        this.iTable.setColumnSortingEnabled(false);
        this.iTable.setModel(this.iModel);
        this.iTable.getColumnModel().getColumn(0).setPreferredWidth(55);
        this.iTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.iTable.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.iTable.getColumnModel().getColumn(3).setPreferredWidth(200);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountingYearFrame.this.openSelectedAccountingYear();
            }
        });
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return iPanel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    private SSNewAccountingYear getSelected() {
        int selected = this.iTable.getSelectedRow();
        if (selected >= 0) {
            return this.iModel.getObject(selected);
        }
        return null;
    }

    public SSDefaultTableModel<SSNewAccountingYear> getModel() {
        return this.iModel;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    private void openSelectedAccountingYear() {
        SSNewAccountingYear iNewYear = this.getSelected();
        if (iNewYear == null) {
            new SSErrorDialog(this.getMainFrame(), "accountingyearframe.selectone");
            return;
        }
        if (iNewYear.equals(SSDB.getInstance().getCurrentYear())) {
            cInstance.dispose();
            return;
        }
        iNewYear = SSDB.getInstance().getAccountingYear(iNewYear);
        if (iNewYear == null) {
            new SSErrorDialog(this.getMainFrame(), "accountingyearframe.yeargone");
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog((JFrame)this.getMainFrame(), SSBundle.getBundle(), "accountingyearframe.replaceyear", iNewYear.toRenderString());
        if (iDialog.getResponce() != 0) {
            return;
        }
        SSYearLock.removeLock(SSDB.getInstance().getCurrentYear());
        SSDB.getInstance().setCurrentYear(iNewYear);
        SSDB.getInstance().initYear(true);
        SSDBConfig.setYearId(SSDB.getInstance().getCurrentCompany().getId(), iNewYear.getId());
        SSYearLock.applyLock(iNewYear);
        SSFrameManager.getInstance().close();
    }

    private void editSelectedAccountingYear() {
        SSNewAccountingYear iAccountingYear = this.getSelected();
        this.updateFrame();
        if (iAccountingYear == null) {
            new SSErrorDialog(this.getMainFrame(), "accountingyearframe.selectone");
            return;
        }
        iAccountingYear = SSDB.getInstance().getAccountingYear(iAccountingYear);
        if (iAccountingYear == null) {
            new SSErrorDialog(this.getMainFrame(), "accountingyearframe.yeargone");
            return;
        }
        if (!iAccountingYear.equals(SSDB.getInstance().getCurrentYear())) {
            String iCurrent = SSDB.getInstance().getCurrentYear() == null ? "" : SSDB.getInstance().getCurrentYear().toRenderString();
            String iNew = iAccountingYear.toRenderString();
            SSQueryDialog iDialog = new SSQueryDialog((JFrame)this.getMainFrame(), SSBundle.getBundle(), "accountingyearframe.openyear", iNew, iCurrent);
            if (iDialog.getResponce() != 0) {
                return;
            }
            SSYearLock.removeLock(SSDB.getInstance().getCurrentYear());
            SSDB.getInstance().setCurrentYear(iAccountingYear);
            SSDB.getInstance().initYear(true);
            SSDBConfig.setYearId(SSDB.getInstance().getCurrentCompany().getId(), iAccountingYear.getId());
            SSYearLock.applyLock(iAccountingYear);
            SSFrameManager.getInstance().close();
        }
        SSNewAccountingYear iYearData = SSDB.getInstance().getCurrentYear();
        SSEditAccountingYearDialog.showDialog(this.getMainFrame(), iYearData, this.iModel);
        this.updateFrame();
    }

    private void deleteSelectedAccountingYear() {
        SSQueryDialog iDialog;
        SSNewAccountingYear pAccountingYear = this.getSelected();
        if (pAccountingYear == null) {
            new SSErrorDialog(this.getMainFrame(), "accountingyearframe.selectone");
            return;
        }
        this.updateFrame();
        boolean lockRemoved = false;
        if (pAccountingYear.equals(SSDB.getInstance().getCurrentYear())) {
            SSYearLock.removeLock(pAccountingYear);
            lockRemoved = true;
        }
        if ((iDialog = new SSQueryDialog((JFrame)this.getMainFrame(), SSBundle.getBundle(), "accountingyearframe.delete", pAccountingYear.toRenderString())).getResponce() != 0) {
            if (lockRemoved) {
                SSYearLock.applyLock(pAccountingYear);
            }
            return;
        }
        this.updateFrame();
        if (SSYearLock.isLocked(pAccountingYear)) {
            new SSErrorDialog(this.getMainFrame(), "accountingyearframe.yearopen");
            if (lockRemoved) {
                SSYearLock.applyLock(pAccountingYear);
            }
            return;
        }
        if (pAccountingYear.equals(SSDB.getInstance().getCurrentYear())) {
            SSYearLock.removeLock(SSDB.getInstance().getCurrentYear());
            SSDBConfig.setYearId(SSDB.getInstance().getCurrentCompany().getId(), null);
            SSDB.getInstance().setCurrentYear(null);
        }
        SSDB.getInstance().deleteAccountingYear(pAccountingYear);
        this.updateFrame();
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getYears());
        SSDB.getInstance().notifyListeners("YEAR", SSDB.getInstance().getCurrentYear(), null);
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.accountingyear.SSAccountingYearFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

