/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.accountingyear;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.calc.SSBalanceCalculator;
import se.swedsoft.bookkeeping.calc.math.SSAccountMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.accountingyear.panel.SSStartingAmountPanel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSProgressDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.print.report.SSStartingAmountPrinter;

public class SSStartingAmountFrame
extends SSDefaultTableFrame {
    private static SSStartingAmountFrame cInstance;
    private SSStartingAmountPanel iStartingAmountPanel;
    private SSNewAccountingYear iAccountingYear = SSDB.getInstance().getCurrentYear();

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSStartingAmountFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static SSStartingAmountFrame getInstance() {
        return cInstance;
    }

    private SSStartingAmountFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("startingammountframe.title"), width, height);
        this.iStartingAmountPanel.setInBalance(this.iAccountingYear.getInBalance(), SSAccountMath.getBalanceAccounts(this.iAccountingYear));
        this.addCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cInstance != null) {
                    SSQueryDialog iDialog = new SSQueryDialog((JFrame)SSStartingAmountFrame.this.getMainFrame(), SSBundle.getBundle(), "startingammountpanel.saveonclose", new Object[0]);
                    int iResponce = iDialog.getResponce();
                    if (iResponce != 0) {
                        SSPostLock.removeLock("startingamount" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId());
                        return;
                    }
                    SSStartingAmountFrame.this.iAccountingYear.setInBalance(SSStartingAmountFrame.this.iStartingAmountPanel.getInBalance());
                    SSDB.getInstance().updateAccountingYear(SSStartingAmountFrame.this.iAccountingYear);
                    SSPostLock.removeLock("startingamount" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId());
                }
            }
        });
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_SAVEITEM", "startingammountframe.savebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSStartingAmountFrame.this.iAccountingYear.setInBalance(SSStartingAmountFrame.this.iStartingAmountPanel.getInBalance());
                SSDB.getInstance().updateAccountingYear(SSStartingAmountFrame.this.iAccountingYear);
                SSPostLock.removeLock("startingamount" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId());
                cInstance = null;
                SSStartingAmountFrame.this.setVisible(false);
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_CANCELITEM", "startingammountframe.cancelbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock("startingamount" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId());
                cInstance = null;
                SSStartingAmountFrame.this.setVisible(false);
            }
        });
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_REDO", "startingammountframe.importbalancebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSStartingAmountFrame.this.importFromLastYearBalanceReport();
            }
        });
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_PRINT", "startingammountframe.printbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSStartingAmountFrame.this.printStartingAmmounts();
            }
        });
        toolBar.add(iButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iStartingAmountPanel = new SSStartingAmountPanel();
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iStartingAmountPanel.getPanel(), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return iPanel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    private void printStartingAmmounts() {
        SSProgressDialog.runProgress(this.getMainFrame(), new Runnable(){

            @Override
            public void run() {
                SSNewAccountingYear iAccountingYear = SSDB.getInstance().getCurrentYear();
                Date iFrom = iAccountingYear.getFrom();
                Date iTo = iAccountingYear.getTo();
                SSStartingAmountPrinter iPrinter = new SSStartingAmountPrinter(SSStartingAmountFrame.this.iStartingAmountPanel.getInBalance(), iFrom, iTo);
                iPrinter.preview(SSStartingAmountFrame.this.getMainFrame());
            }
        });
    }

    private void importFromLastYearBalanceReport() {
        SSNewAccountingYear iPreviousYear = SSDB.getInstance().getPreviousYear();
        if (iPreviousYear == null) {
            new SSErrorDialog(this.getMainFrame(), "startingammountpanel.nopreviousyear");
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog((JFrame)this.getMainFrame(), SSBundle.getBundle(), "startingammountpanel.importbalance", new Object[0]);
        int iResponce = iDialog.getResponce();
        if (iResponce != 0) {
            return;
        }
        Map<SSAccount, BigDecimal> iOutBalance = SSBalanceCalculator.getOutBalance(iPreviousYear);
        this.iStartingAmountPanel.setInBalance(iOutBalance);
    }

    public void actionPerformed(ActionEvent e) {
        this.iStartingAmountPanel = null;
        this.iAccountingYear = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.accountingyear.SSStartingAmountFrame");
        sb.append("{iAccountingYear=").append(this.iAccountingYear);
        sb.append(", iStartingAmountPanel=").append(this.iStartingAmountPanel);
        sb.append('}');
        return sb.toString();
    }
}

