/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.accountingyear.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.accountingyear.panel.SSAccountingYearPanel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;

public class SSEditAccountingYearDialog {
    private static ResourceBundle bundle = SSBundle.getBundle();

    private SSEditAccountingYearDialog() {
    }

    public static void showDialog(SSMainFrame iMainFrame, final SSNewAccountingYear pAccountingYear, SSDefaultTableModel<SSNewAccountingYear> pModel) {
        if (SSPostLock.isLocked(pAccountingYear.getId())) {
            new SSErrorDialog(iMainFrame, "postlock.accountingyear");
            return;
        }
        SSPostLock.applyLock(pAccountingYear.getId());
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("accountingyearframe.edit.title"));
        final SSAccountingYearPanel iPanel = new SSAccountingYearPanel();
        iPanel.setShowAccountPlanPanel(false);
        iPanel.setAccountingYear(pAccountingYear);
        iPanel.addOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewAccountingYear iYear = iPanel.getAccountingYear();
                iYear.setId(pAccountingYear.getId());
                SSDB.getInstance().updateAccountingYear(iYear);
                SSPostLock.removeLock(pAccountingYear.getId());
                iDialog.closeDialog();
            }
        });
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock(pAccountingYear.getId());
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SSPostLock.removeLock(pAccountingYear.getId());
            }
        });
        iDialog.add((Component)iPanel.getPanel(), "Center");
        iDialog.pack();
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }
}

