/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.accountingyear.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.accountplans.util.SSAccountPlanTableModel;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;

public class SSAccountingYearPanel {
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    protected SSDateChooser iFrom;
    protected SSDateChooser iTo;
    protected JPanel iAccountPlanPanel;
    protected SSTableComboBox<SSAccountPlan> iAccountPlan;
    protected JRadioButton iRadioUseLast;
    protected JRadioButton iRadioAccountPlan;
    private SSNewAccountingYear iAccountingYear;

    public SSAccountingYearPanel() {
        this.$$$setupUI$$$();
        ButtonGroup iGroup = new ButtonGroup();
        iGroup.add(this.iRadioUseLast);
        iGroup.add(this.iRadioAccountPlan);
        this.iRadioAccountPlan.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SSAccountingYearPanel.this.iAccountPlan.setEnabled(SSAccountingYearPanel.this.iRadioAccountPlan.isSelected());
            }
        });
        this.iAccountPlan.setModel(SSAccountPlanTableModel.getDropDownModel());
        this.iAccountPlan.setSelected(this.iAccountPlan.getFirst());
    }

    public void setAccountingYear(SSNewAccountingYear pAccountingYear) {
        this.iAccountingYear = pAccountingYear;
        this.iFrom.setDate(this.iAccountingYear.getFrom());
        this.iTo.setDate(this.iAccountingYear.getTo());
        this.iAccountPlan.setSelected(this.iAccountingYear.getAccountPlan());
    }

    public SSNewAccountingYear getAccountingYear() {
        this.iAccountingYear.setFrom(this.iFrom.getDate());
        this.iAccountingYear.setTo(this.iTo.getDate());
        if (this.iAccountPlanPanel.isVisible()) {
            SSAccountPlan iAccountPlan = this.getAccountPlan();
            this.iAccountingYear.setAccountPlan(new SSAccountPlan(iAccountPlan, true));
        }
        return this.iAccountingYear;
    }

    public SSAccountPlan getAccountPlan() {
        SSNewAccountingYear iLast = SSDB.getInstance().getLastYear();
        if (this.iRadioUseLast.isSelected() && iLast != null && iLast.getAccountPlan() != null) {
            return iLast.getAccountPlan();
        }
        return this.iAccountPlan.getSelected();
    }

    public void setYearFromAndTo() {
        SSNewAccountingYear iLast = SSDB.getInstance().getLastYear();
        this.iRadioUseLast.setEnabled(iLast != null);
        this.iRadioAccountPlan.setEnabled(this.iAccountPlan.getFirst() != null);
        if (iLast == null && this.iAccountPlan.getFirst() == null) {
            this.iButtonPanel.getOkButton().setEnabled(false);
            return;
        }
        if (iLast != null) {
            this.iRadioUseLast.setSelected(true);
            Date iFrom = iLast.getFrom();
            Date iTo = iLast.getTo();
            Calendar calendarFrom = Calendar.getInstance();
            Calendar calendarTo = Calendar.getInstance();
            calendarFrom.setTime(iFrom);
            calendarTo.setTime(iTo);
            calendarTo.add(5, 1);
            int diffYear = calendarTo.get(1) - calendarFrom.get(1);
            int diffMonth = calendarTo.get(2) - calendarFrom.get(2);
            calendarTo.add(5, -1);
            calendarFrom.add(1, diffYear);
            calendarFrom.add(2, diffMonth);
            calendarFrom.set(5, calendarTo.getActualMinimum(5));
            calendarTo.add(1, diffYear);
            calendarTo.add(2, diffMonth);
            calendarTo.set(5, calendarTo.getActualMaximum(5));
            this.iFrom.setDate(calendarFrom.getTime());
            this.iTo.setDate(calendarTo.getTime());
        } else {
            Calendar iCalendar = Calendar.getInstance();
            int year = iCalendar.get(1);
            iCalendar.clear();
            iCalendar.set(1, year);
            iCalendar.set(2, 0);
            iCalendar.set(5, 1);
            this.iFrom.setDate(iCalendar.getTime());
            iCalendar.set(2, 11);
            iCalendar.set(5, 31);
            this.iTo.setDate(iCalendar.getTime());
            this.iAccountPlan.setSelected(this.iAccountPlan.getFirst());
        }
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener e) {
        this.iButtonPanel.addOkActionListener(e);
    }

    public void addCancelAction(ActionListener e) {
        this.iButtonPanel.addCancelActionListener(e);
    }

    public void setShowAccountPlanPanel(boolean iShow) {
        this.iAccountPlanPanel.setVisible(iShow);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.accountingyear.panel.SSAccountingYearPanel");
        sb.append("{iAccountingYear=").append(this.iAccountingYear);
        sb.append(", iAccountPlan=").append(this.iAccountPlan);
        sb.append(", iAccountPlanPanel=").append(this.iAccountPlanPanel);
        sb.append(", iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iFrom=").append(this.iFrom);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iRadioAccountPlan=").append(this.iRadioAccountPlan);
        sb.append(", iRadioUseLast=").append(this.iRadioUseLast);
        sb.append(", iTo=").append(this.iTo);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        SSDateChooser sSDateChooser;
        SSDateChooser sSDateChooser2;
        SSButtonPanel sSButtonPanel;
        JPanel jPanel2;
        this.iPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel2.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("accountingyearpanel.datefrom"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iFrom = sSDateChooser2 = new SSDateChooser();
        sSDateChooser2.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel3.add((Component)sSDateChooser2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(220, -1), null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("accountingyearpanel.dateto"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTo = sSDateChooser = new SSDateChooser();
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        ((Component)sSDateChooser).setEnabled(true);
        jPanel3.add((Component)sSDateChooser, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, new Dimension(220, -1), null, null));
        this.iAccountPlanPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iRadioUseLast = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(false);
        jRadioButton2.setInheritsPopupMenu(false);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("book").getString("accountingyearpanel.uselast"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.iRadioAccountPlan = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("book").getString("accountingyearpanel.accountplan"));
        jPanel.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iAccountPlan = sSTableComboBox;
        jPanel.add(sSTableComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 3, null, new Dimension(220, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

