/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.accountplans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.accountplans.SSAccountPlanDialog;
import se.swedsoft.bookkeeping.gui.accountplans.util.SSAccountPlanTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSProgressDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSExcelFileChooser;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.importexport.excel.SSAccountPlanExporter;
import se.swedsoft.bookkeeping.importexport.excel.SSAccountPlanImporter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;
import se.swedsoft.bookkeeping.print.report.SSAccountPlanPrinter;

public class SSAccountPlanFrame
extends SSDefaultTableFrame {
    private static SSAccountPlanFrame cInstance;
    private SSTable iTable;
    private SSAccountPlanTableModel iModel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSAccountPlanFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static SSAccountPlanFrame getInstance() {
        return cInstance;
    }

    private SSAccountPlanFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("accountplanframe.title"), width, height);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                SSAccountPlanFrame.this.updateFrame();
            }
        });
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "accountplanframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountPlanFrame.this.updateFrame();
                SSAccountPlanDialog.newDialog(SSAccountPlanFrame.this.getMainFrame(), SSAccountPlanFrame.this.iModel);
                SSAccountPlanFrame.this.updateFrame();
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "accountplanframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountPlanFrame.this.editSelectedAccountPlan();
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "accountplanframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountPlan iSelected = (SSAccountPlan)SSAccountPlanFrame.this.iModel.getSelectedRow(SSAccountPlanFrame.this.iTable);
                String iName = null;
                if (iSelected != null) {
                    iName = iSelected.getName();
                    iSelected = SSAccountPlanFrame.this.getAccountPlan(iSelected);
                }
                SSAccountPlanFrame.this.updateFrame();
                if (iSelected != null) {
                    SSAccountPlanDialog.copyDialog(SSAccountPlanFrame.this.getMainFrame(), iSelected, SSAccountPlanFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSAccountPlanFrame.this.getMainFrame(), "accountplanframe.accountplangone", iName);
                }
                SSAccountPlanFrame.this.updateFrame();
            }
        });
        iToolBar.add(iButton);
        this.iTable.addSelectionDependentComponent(iButton);
        iButton = new SSButton("ICON_DELETEITEM", "accountplanframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountPlanFrame.this.deleteSelectedAccountPlan();
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        this.iTable.addSelectionDependentComponent(iButton);
        iButton = new SSButton("ICON_IMPORT", "accountplanframe.importbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSExcelFileChooser iFilechooser = SSExcelFileChooser.getInstance();
                if (iFilechooser.showOpenDialog(SSAccountPlanFrame.this.getMainFrame()) == 0) {
                    SSAccountPlanImporter iImporter = new SSAccountPlanImporter(iFilechooser.getSelectedFile());
                    try {
                        iImporter.doImport();
                    }
                    catch (IOException ex) {
                        SSErrorDialog.showDialog(SSAccountPlanFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    catch (SSImportException ex) {
                        SSErrorDialog.showDialog(SSAccountPlanFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    SSAccountPlanFrame.this.iModel.fireTableDataChanged();
                    SSAccountPlanFrame.this.updateFrame();
                }
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EXPORT", "accountplanframe.exportbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountPlan iSelected = SSAccountPlanFrame.this.getSelected();
                String iName = iSelected.getName();
                if ((iSelected = SSAccountPlanFrame.this.getAccountPlan(iSelected)) == null) {
                    new SSErrorDialog(SSAccountPlanFrame.this.getMainFrame(), "accountplanframe.accountplangone", iName);
                    return;
                }
                SSAccountPlanFrame.this.updateFrame();
                SSExcelFileChooser iFilechooser = SSExcelFileChooser.getInstance();
                iFilechooser.setSelectedFile(new File(iSelected.getName() + ".xls"));
                if (iFilechooser.showSaveDialog(SSAccountPlanFrame.this.getMainFrame()) == 0) {
                    SSAccountPlanExporter iExporter = new SSAccountPlanExporter(iFilechooser.getSelectedFile());
                    try {
                        iExporter.doExport(iSelected);
                    }
                    catch (IOException ex) {
                        SSErrorDialog.showDialog(SSAccountPlanFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    catch (SSExportException ex) {
                        SSErrorDialog.showDialog(SSAccountPlanFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_PRINT", "accountplanframe.printbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountPlan pAccountPlan = SSAccountPlanFrame.this.getSelected();
                if (pAccountPlan == null) {
                    new SSErrorDialog(SSAccountPlanFrame.this.getMainFrame(), "accountplanframe.selectone");
                    return;
                }
                SSAccountPlanFrame.this.updateFrame();
                String iName = pAccountPlan.getName();
                final SSAccountPlan iAccountPlan = SSAccountPlanFrame.this.getAccountPlan(pAccountPlan);
                if (iAccountPlan == null) {
                    new SSErrorDialog(SSAccountPlanFrame.this.getMainFrame(), "accountplanframe.accountplangone", iName);
                    return;
                }
                SSProgressDialog.runProgress(SSAccountPlanFrame.this.getMainFrame(), new Runnable(){

                    @Override
                    public void run() {
                        SSAccountPlanPrinter iPrinter = new SSAccountPlanPrinter(iAccountPlan);
                        iPrinter.preview(SSAccountPlanFrame.this.getMainFrame());
                    }
                });
            }
        });
        iToolBar.add(iButton);
        this.iTable.addSelectionDependentComponent(iButton);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSAccountPlanTableModel();
        this.iModel.addColumn(SSAccountPlanTableModel.COLUMN_NAME);
        this.iModel.addColumn(SSAccountPlanTableModel.COLUMN_TYPE);
        this.iModel.addColumn(SSAccountPlanTableModel.COLUMN_ASSESSMENTYEAR);
        this.iModel.setObjects(SSDB.getInstance().getAccountPlans());
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSAccountPlanFrame.this.editSelectedAccountPlan();
            }
        });
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return iPanel;
    }

    private SSAccountPlan getSelected() {
        int selected = this.iTable.getSelectedRow();
        if (selected >= 0) {
            return (SSAccountPlan)this.iModel.getObject(selected);
        }
        return null;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return false;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    private void editSelectedAccountPlan() {
        SSAccountPlan pAccountPlan = this.getSelected();
        if (pAccountPlan == null) {
            new SSErrorDialog(this.getMainFrame(), "accountplanframe.selectone");
            return;
        }
        this.updateFrame();
        String iName = pAccountPlan.getName();
        pAccountPlan = this.getAccountPlan(pAccountPlan);
        if (pAccountPlan != null) {
            SSAccountPlanDialog.editDialog(this.getMainFrame(), pAccountPlan, this.iModel);
        } else {
            new SSErrorDialog(this.getMainFrame(), "accountplanframe.accountplangone", iName);
        }
        this.updateFrame();
    }

    private void deleteSelectedAccountPlan() {
        SSAccountPlan pAccountPlan = this.getSelected();
        if (pAccountPlan == null) {
            new SSErrorDialog(this.getMainFrame(), "accountplanframe.selectone");
            return;
        }
        String iName = pAccountPlan.getName();
        SSAccountPlan iAccountPlan = this.getAccountPlan(pAccountPlan);
        if (iAccountPlan == null) {
            this.updateFrame();
            new SSErrorDialog(this.getMainFrame(), "accountplanframe.accountplangone", iName);
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog((JFrame)this.getMainFrame(), SSBundle.getBundle(), "accountplanframe.delete", iAccountPlan.getName());
        int iResponce = iDialog.getResponce();
        this.updateFrame();
        if (iResponce != 0) {
            return;
        }
        String lockString = "accountplan" + iAccountPlan.getId();
        if (SSPostLock.isLocked(lockString)) {
            this.updateFrame();
            new SSErrorDialog(this.getMainFrame(), "accountplanframe.accountplanopen", iAccountPlan.getName());
            return;
        }
        SSDB.getInstance().deleteAccountPlan(iAccountPlan);
        this.iModel.fireTableDataChanged();
        this.updateFrame();
    }

    public SSAccountPlan getAccountPlan(SSAccountPlan iAccountPlan) {
        return SSDB.getInstance().getAccountPlan(iAccountPlan);
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getAccountPlans());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.accountplans.SSAccountPlanFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

