/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.backup.util;

import java.util.Date;
import java.util.List;
import javax.swing.table.TableCellRenderer;
import se.swedsoft.bookkeeping.data.backup.SSBackup;
import se.swedsoft.bookkeeping.data.backup.util.SSBackupType;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSDateTimeCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSBackupTableModel
extends SSTableModel<SSBackup> {
    public static SSTableColumn<SSBackup> COLUMN_DATE = new SSTableColumn<SSBackup>(SSBundle.getBundle().getString("backuptable.column.1")){

        @Override
        public Object getValue(SSBackup iBackup) {
            return iBackup.getDate();
        }

        @Override
        public void setValue(SSBackup iBackup, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return Date.class;
        }

        @Override
        public int getDefaultWidth() {
            return 120;
        }

        @Override
        public TableCellRenderer getCellRenderer() {
            return new SSDateTimeCellRenderer();
        }
    };
    public static SSTableColumn<SSBackup> COLUMN_FILENAME = new SSTableColumn<SSBackup>(SSBundle.getBundle().getString("backuptable.column.2")){

        @Override
        public Object getValue(SSBackup iBackup) {
            return iBackup.getFilename();
        }

        @Override
        public void setValue(SSBackup iBackup, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 240;
        }
    };
    public static SSTableColumn<SSBackup> COLUMN_TYPE = new SSTableColumn<SSBackup>(SSBundle.getBundle().getString("backuptable.column.3")){

        @Override
        public Object getValue(SSBackup iBackup) {
            if (iBackup.getType() == SSBackupType.COMPANY) {
                return null;
            }
            return SSBundle.getBundle().getString("backupframe.allcompanies");
        }

        @Override
        public void setValue(SSBackup iBackup, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 240;
        }
    };

    public SSBackupTableModel(List<SSBackup> iBackups) {
        super(iBackups);
    }

    @Override
    public Class getType() {
        return SSBackup.class;
    }
}

