/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.budget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSBudget;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.budget.panel.SSBudgetMainPanel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSProgressDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.print.report.SSBudgetPrinter;

public class SSBudgetFrame
extends SSDefaultTableFrame {
    private static SSBudgetFrame cInstance;
    private SSNewAccountingYear iAccountingYear = SSDB.getInstance().getCurrentYear();
    private SSBudgetMainPanel iBudgetMainPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSBudgetFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static SSBudgetFrame getInstance() {
        return cInstance;
    }

    private SSBudgetFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        super(pMainFrame, SSBundle.getBundle().getString("budgetframe.title"), pWidth, pHeight);
        this.addCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cInstance != null) {
                    SSQueryDialog iDialog = new SSQueryDialog((JFrame)SSBudgetFrame.this.getMainFrame(), SSBundle.getBundle(), "budgetframe.saveonclose", new Object[0]);
                    int iResponce = iDialog.getResponce();
                    if (iResponce != 0) {
                        SSPostLock.removeLock("budget" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId());
                        return;
                    }
                    SSBudgetFrame.this.iAccountingYear.setBudget(SSBudgetFrame.this.iBudgetMainPanel.getBudget());
                    SSDB.getInstance().updateAccountingYear(SSBudgetFrame.this.iAccountingYear);
                    SSPostLock.removeLock("budget" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId());
                }
            }
        });
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_SAVEITEM", "budgetframe.savebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSBudgetFrame.this.iAccountingYear.setBudget(SSBudgetFrame.this.iBudgetMainPanel.getBudget());
                SSDB.getInstance().updateAccountingYear(SSBudgetFrame.this.iAccountingYear);
                SSPostLock.removeLock("budget" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId());
                cInstance = null;
                SSBudgetFrame.this.setVisible(false);
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_CANCELITEM", "budgetframe.cancelbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock("budget" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId());
                cInstance = null;
                SSBudgetFrame.this.setVisible(false);
            }
        });
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_PRINT", "budgetframe.printbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SSMainFrame iMainFrame = SSBudgetFrame.this.getMainFrame();
                final Date iFrom = SSDB.getInstance().getCurrentYear().getFrom();
                final Date iTo = SSDB.getInstance().getCurrentYear().getTo();
                SSProgressDialog.runProgress(iMainFrame, new Runnable(){

                    @Override
                    public void run() {
                        SSBudgetPrinter iPrinter = new SSBudgetPrinter(iFrom, iTo);
                        iPrinter.preview(iMainFrame);
                    }
                });
            }
        });
        toolBar.add(iButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        SSBudget iBudget = new SSBudget(SSDB.getInstance().getCurrentYear().getBudget());
        this.iBudgetMainPanel = new SSBudgetMainPanel(iBudget);
        return this.iBudgetMainPanel.getPanel();
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        this.iAccountingYear = null;
        this.iBudgetMainPanel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.budget.SSBudgetFrame");
        sb.append("{iAccountingYear=").append(this.iAccountingYear);
        sb.append(", iBudgetMainPanel=").append(this.iBudgetMainPanel);
        sb.append('}');
        return sb.toString();
    }
}

