/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.budget.util;

import java.math.BigDecimal;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSBudget;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;

public class SSMonthlyTableModel
extends SSDefaultTableModel<SSMonth> {
    private SSBudget iBudget;
    private SSAccount iAccount;

    public SSMonthlyTableModel(SSBudget pBudget, SSAccount pAccount) {
        this.iBudget = pBudget;
        this.iAccount = pAccount;
    }

    @Override
    public Class<?> getType() {
        return SSMonth.class;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return BigDecimal.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SSMonth month = (SSMonth)this.getObject(rowIndex);
        Object value = null;
        switch (columnIndex) {
            case 0: {
                value = month.toString();
                break;
            }
            case 1: {
                value = this.iAccount == null ? new BigDecimal(0) : this.iBudget.getValueForAccountAndMonth(this.iAccount, month);
            }
        }
        return value;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.iAccount != null && columnIndex == 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SSMonth month = (SSMonth)this.getObject(rowIndex);
        if (columnIndex == 1 && this.iAccount != null) {
            this.iBudget.setSaldoForAccountAndMonth(this.iAccount, month, (BigDecimal)aValue);
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void setAccount(SSAccount pAccount) {
        this.iAccount = pAccount;
        this.fireTableDataChanged();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.budget.util.SSMonthlyTableModel");
        sb.append("{iAccount=").append(this.iAccount);
        sb.append(", iBudget=").append(this.iBudget);
        sb.append('}');
        return sb.toString();
    }
}

