/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.company;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.system.SSCompanyLock;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSDBConfig;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.data.system.SSYearLock;
import se.swedsoft.bookkeeping.data.util.SSConfig;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.accountingyear.SSAccountingYearFrame;
import se.swedsoft.bookkeeping.gui.company.SSCompanyDialog;
import se.swedsoft.bookkeeping.gui.company.util.SSCompanyTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.frame.SSFrameManager;
import se.swedsoft.bookkeeping.gui.util.frame.SSInternalFrame;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;

public class SSCompanyFrame
extends SSDefaultTableFrame {
    private static SSCompanyFrame cInstance;
    private SSTable iTable;
    private JCheckBox iShowAtStartup;
    private SSDefaultTableModel<SSNewCompany> iModel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSCompanyFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static SSCompanyFrame getInstance() {
        return cInstance;
    }

    private SSCompanyFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("companyframe.title"), width, height);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                SSCompanyFrame.this.updateFrame();
            }
        });
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_OPENITEM", "companyframe.openbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCompanyFrame.this.openSelectedCompany();
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        this.iTable.addSelectionDependentComponent(iButton);
        iButton = new SSButton("ICON_NEWITEM", "companyframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCompanyFrame.this.updateFrame();
                SSCompanyDialog.newDialog(SSCompanyFrame.this.getMainFrame(), SSCompanyFrame.this.iModel);
            }
        });
        iButton.setEnabled(true);
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "companyframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCompanyFrame.this.editSelectedCompany();
            }
        });
        iToolBar.add(iButton);
        this.iTable.addSelectionDependentComponent(iButton);
        iButton = new SSButton("ICON_DELETEITEM", "companyframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCompanyFrame.this.deleteSelectedCompany();
            }
        });
        iToolBar.add(iButton);
        this.iTable.addSelectionDependentComponent(iButton);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iModel = new SSCompanyTableModel();
        this.updateFrame();
        this.iShowAtStartup = new JCheckBox(SSBundle.getBundle().getString("companyframe.showatstart"));
        this.iShowAtStartup.setSelected((Boolean)SSConfig.getInstance().get("companyframe.showatstart", true));
        this.iShowAtStartup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSConfig.getInstance().set("companyframe.showatstart", SSCompanyFrame.this.iShowAtStartup.isSelected());
            }
        });
        this.iTable = new SSTable();
        this.iTable.setSingleSelect();
        this.iTable.setColumnSortingEnabled(false);
        this.iTable.setModel(this.iModel);
        this.iTable.getColumnModel().getColumn(0).setPreferredWidth(70);
        this.iTable.getColumnModel().getColumn(0).setMaxWidth(70);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCompanyFrame.this.openSelectedCompany();
            }
        });
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.add((Component)this.iShowAtStartup, "South");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return iPanel;
    }

    private SSNewCompany getSelected() {
        int selected = this.iTable.getSelectedRow();
        if (selected >= 0) {
            return this.iModel.getObject(selected);
        }
        return null;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return false;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    private void openSelectedCompany() {
        SSNewCompany iNewCompany = this.getSelected();
        if (iNewCompany == null) {
            new SSErrorDialog(this.getMainFrame(), "companyframe.selectonecompany");
            return;
        }
        if (iNewCompany.equals(SSDB.getInstance().getCurrentCompany())) {
            cInstance.dispose();
            return;
        }
        iNewCompany = SSDB.getInstance().getCompany(iNewCompany);
        if (iNewCompany == null) {
            new SSErrorDialog(this.getMainFrame(), "companyframe.companygone");
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog((JFrame)this.getMainFrame(), SSBundle.getBundle(), "companyframe.replacecompany", iNewCompany.getName());
        if (iDialog.getResponce() != 0) {
            return;
        }
        SSCompanyLock.removeLock(SSDB.getInstance().getCurrentCompany());
        SSYearLock.removeLock(SSDB.getInstance().getCurrentYear());
        SSDB.getInstance().setCurrentCompany(iNewCompany);
        SSDBConfig.setCompanyId(iNewCompany.getId());
        SSCompanyLock.applyLock(iNewCompany);
        SSDB.getInstance().setCurrentYear(null);
        SSFrameManager.getInstance().close();
        SSNewAccountingYear iYear = SSDBConfig.loadCompanySetting(iNewCompany.getId());
        if (iYear == null) {
            SSDBConfig.setYearId(iNewCompany.getId(), null);
            SSAccountingYearFrame.showFrame(this.getMainFrame(), 500, 300, false);
        } else {
            SSDB.getInstance().setCurrentYear(iYear);
            SSYearLock.applyLock(iYear);
            SSDBConfig.setYearId(iNewCompany.getId(), iYear.getId());
        }
        SSDB.getInstance().init(true);
    }

    private void editSelectedCompany() {
        SSNewCompany pCompany = this.getSelected();
        this.updateFrame();
        if (pCompany == null) {
            new SSErrorDialog(this.getMainFrame(), "companyframe.selectonecompany");
            return;
        }
        pCompany = SSDB.getInstance().getCompany(pCompany);
        if (pCompany == null) {
            new SSErrorDialog(this.getMainFrame(), "companyframe.companygone");
            return;
        }
        if (!pCompany.equals(SSDB.getInstance().getCurrentCompany())) {
            if (SSPostLock.isLocked("sieimport" + pCompany.getId())) {
                this.updateFrame();
                new SSErrorDialog(this.getMainFrame(), "companyframe.sieimportopen");
                return;
            }
            String iCurrent = SSDB.getInstance().getCurrentCompany() == null ? "" : SSDB.getInstance().getCurrentCompany().getName();
            String iNew = pCompany.getName();
            SSQueryDialog iDialog = new SSQueryDialog((JFrame)this.getMainFrame(), SSBundle.getBundle(), "companyframe.editcompany.openquery", iNew, iCurrent);
            if (iDialog.getResponce() != 0) {
                this.updateFrame();
                return;
            }
            SSInternalFrame.closeAllFrames();
            SSCompanyLock.removeLock(SSDB.getInstance().getCurrentCompany());
            SSYearLock.removeLock(SSDB.getInstance().getCurrentYear());
            SSDB.getInstance().setCurrentCompany(pCompany);
            SSDBConfig.setCompanyId(pCompany.getId());
            SSCompanyLock.applyLock(pCompany);
            SSDB.getInstance().setCurrentYear(null);
            SSFrameManager.getInstance().close();
            SSNewAccountingYear iYear = SSDBConfig.loadCompanySetting(pCompany.getId());
            if (iYear == null) {
                SSDBConfig.setYearId(pCompany.getId(), null);
                SSAccountingYearFrame.showFrame(this.getMainFrame(), 500, 300, false);
            } else {
                SSDB.getInstance().setCurrentYear(iYear);
                SSYearLock.applyLock(iYear);
                SSDBConfig.setYearId(pCompany.getId(), iYear.getId());
            }
            SSDB.getInstance().init(true);
        }
        if (cInstance != null) {
            this.updateFrame();
        }
        SSCompanyDialog.editDialog(this.getMainFrame(), SSDB.getInstance().getCurrentCompany(), this.iModel);
    }

    private void deleteSelectedCompany() {
        SSQueryDialog iDialog;
        SSNewCompany pCompany = this.getSelected();
        if (pCompany == null) {
            new SSErrorDialog(this.getMainFrame(), "companyframe.selectonecompany");
            return;
        }
        this.updateFrame();
        boolean lockRemoved = false;
        if (pCompany.equals(SSDB.getInstance().getCurrentCompany())) {
            SSCompanyLock.removeLock(pCompany);
            lockRemoved = true;
        }
        if ((iDialog = new SSQueryDialog((JFrame)this.getMainFrame(), SSBundle.getBundle(), "companyframe.deletecompany", pCompany.getName())).getResponce() != 0) {
            if (lockRemoved) {
                SSCompanyLock.applyLock(pCompany);
            }
            return;
        }
        this.updateFrame();
        if (SSCompanyLock.isLocked(pCompany)) {
            new SSErrorDialog(this.getMainFrame(), "companyframe.companyremoveopen");
            if (lockRemoved) {
                SSCompanyLock.applyLock(pCompany);
            }
            return;
        }
        boolean iCurrentRemoved = false;
        if (pCompany.equals(SSDB.getInstance().getCurrentCompany())) {
            SSYearLock.removeLock(SSDB.getInstance().getCurrentYear());
            SSFrameManager.getInstance().close();
            iCurrentRemoved = true;
        }
        SSDB.getInstance().deleteCompany(pCompany);
        if (iCurrentRemoved) {
            SSDB.getInstance().setCurrentCompany(null);
            SSDB.getInstance().setCurrentYear(null);
        }
        this.updateFrame();
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getCompanies());
        SSDB.getInstance().notifyListeners("COMPANY", SSDB.getInstance().getCurrentCompany(), null);
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        this.iShowAtStartup = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.company.SSCompanyFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iShowAtStartup=").append(this.iShowAtStartup);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

