/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.company.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.company.pages.SSCompanyPage;
import se.swedsoft.bookkeeping.gui.company.pages.SSCompanyPageAdditional;
import se.swedsoft.bookkeeping.gui.company.pages.SSCompanyPageAddress;
import se.swedsoft.bookkeeping.gui.company.pages.SSCompanyPageAutoIncrement;
import se.swedsoft.bookkeeping.gui.company.pages.SSCompanyPageDefaultAccount;
import se.swedsoft.bookkeeping.gui.company.pages.SSCompanyPageGeneral;
import se.swedsoft.bookkeeping.gui.company.pages.SSCompanyPageStandardText;
import se.swedsoft.bookkeeping.gui.company.pages.SSCompanyPageTax;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.graphics.SSIcon;

public class SSCompanySettingsDialog
extends SSDialog
implements ListSelectionListener {
    private List<SSCompanyPage> iPages;
    private SSNewCompany iCompany;
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JPanel iContainer;
    private JList iNavigator;

    public SSCompanySettingsDialog(SSMainFrame iMainFrame, String iDialogTitle) {
        super(iMainFrame, iDialogTitle);
        this.$$$setupUI$$$();
        this.iPages = new LinkedList<SSCompanyPage>();
        this.iPages.add(new SSCompanyPageGeneral(this));
        this.iPages.add(new SSCompanyPageAddress(this));
        this.iPages.add(new SSCompanyPageAdditional(this));
        this.iPages.add(new SSCompanyPageStandardText(this));
        this.iPages.add(new SSCompanyPageDefaultAccount(this));
        this.iPages.add(new SSCompanyPageTax(this));
        this.iPages.add(new SSCompanyPageAutoIncrement(this));
        this.setPanel(this.iPanel);
        this.iButtonPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCompanySettingsDialog.this.closeDialog(0);
            }
        });
        this.iButtonPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCompanySettingsDialog.this.closeDialog(2);
            }
        });
        this.getRootPane().setDefaultButton(this.iButtonPanel.getOkButton());
        this.iContainer.setLayout(new BorderLayout());
        this.iNavigator.setModel(new DefaultComboBoxModel<Object>(this.iPages.toArray()));
        this.iNavigator.addListSelectionListener(this);
        this.iNavigator.setFixedCellHeight(24);
        this.iNavigator.setCellRenderer(new NavigatorCellRenderer());
        this.iNavigator.setSelectedIndex(0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int iSelected = this.iNavigator.getSelectedIndex();
        SSCompanyPage iPage = this.iPages.get(iSelected);
        iPage.setDialog(this);
        this.iContainer.removeAll();
        this.iContainer.add((Component)iPage.getPanel(), "Center");
        this.iContainer.validate();
        this.repaint();
    }

    public void setCompany(SSNewCompany iCompany) {
        this.iCompany = iCompany;
        for (SSCompanyPage iPage : this.iPages) {
            iPage.setCompany(iCompany);
        }
    }

    public SSNewCompany getCompany() {
        for (SSCompanyPage iPage : this.iPages) {
            iPage.getCompany();
        }
        return this.iCompany;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.company.panel.SSCompanySettingsDialog");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCompany=").append(this.iCompany);
        sb.append(", iContainer=").append(this.iContainer);
        sb.append(", iNavigator=").append(this.iNavigator);
        sb.append(", iPages=").append(this.iPages);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JList jList;
        SSButtonPanel sSButtonPanel;
        JPanel jPanel2;
        this.iPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), 2, 4, false, false));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel2.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel3.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        this.iNavigator = jList = new JList();
        jList.setSelectionMode(0);
        jScrollPane.setViewportView(jList);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.iContainer = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private class NavigatorCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private NavigatorCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = Integer.toString(index + 1) + ". " + ((SSCompanyPage)value).getName();
            this.setText(s);
            this.setIcon(cellHasFocus ? SSIcon.getIcon("ICON_TASKLIST16", SSIcon.IconState.HIGHLIGHTED) : SSIcon.getIcon("ICON_TASKLIST16", SSIcon.IconState.NORMAL));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(0, 3, 0, 0));
            return this;
        }
    }
}

