/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.creditinvoice.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCreditInvoice;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.company.panel.SSAdressPanel;
import se.swedsoft.bookkeeping.gui.company.panel.SSDefaultAccountPanel;
import se.swedsoft.bookkeeping.gui.customer.util.SSCustomerTableModel;
import se.swedsoft.bookkeeping.gui.invoice.util.SSInvoiceRowTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSInputVerifier;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSCurrencyTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDeliveryTermTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDeliveryWayTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSPaymentTermTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSDeleteAction;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSTraversalAction;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSTaxCodeCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSTaxCodeCellRenderer;
import se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherRowTableModelOld;

public class SSCreditInvoicePanel {
    private SSCreditInvoice iCreditInvoice;
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JFormattedTextField iNumber;
    private JFormattedTextField iCrediting;
    private SSBigDecimalTextField iCurrencyRate;
    private SSDateChooser iDate;
    private SSTableComboBox<SSCustomer> iCustomer;
    private JTextField iCustomerName;
    private JCheckBox iTaxFree;
    private SSBigDecimalTextField iDelayInterest;
    private SSAdressPanel iDeliveryAddress;
    private SSAdressPanel iInvoiceAddress;
    private JTextArea iText;
    private JTextField iYourContactPerson;
    private JTextField iOurContactPerson;
    private SSBigDecimalTextField iTaxRate1;
    private SSBigDecimalTextField iTaxRate2;
    private SSBigDecimalTextField iTaxRate3;
    private JCheckBox iEuSaleCommodity;
    private JCheckBox iEuSaleYhirdPartCommodity;
    private SSEditableTableComboBox<SSDeliveryWay> iDeliveryWay;
    private SSEditableTableComboBox<SSDeliveryTerm> iDeliveryTerm;
    private SSEditableTableComboBox<SSPaymentTerm> iPaymentTerm;
    private SSEditableTableComboBox<SSCurrency> iCurrency;
    private SSTable iTable;
    private SSDefaultAccountPanel iDefaultAccounts;
    private JCheckBox iEntered;
    private SSBigDecimalTextField iNetSum;
    private SSBigDecimalTextField iTaxSum1;
    private SSBigDecimalTextField iTaxSum2;
    private SSBigDecimalTextField iTaxSum3;
    private SSBigDecimalTextField iRoundingSum;
    private SSBigDecimalTextField iTotalSum;
    private JLabel iTaxLabel1;
    private JLabel iTaxLabel2;
    private JLabel iTaxLabel3;
    private JCheckBox iSavecustomerandproducts;
    private SSInvoiceRowTableModel iModel;
    private SSTable iVoucherTable;
    private SSVoucherRowTableModelOld iVoucherTableModel;
    private JButton iRefreshVoucher;
    private SSInputVerifier iInputVerifier;
    private JCheckBox isStockInfluencing;

    public SSCreditInvoicePanel(SSDialog iOwner) {
        this.$$$setupUI$$$();
        this.iNumber.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("0"))));
        this.iNumber.setHorizontalAlignment(4);
        this.iTable.setColorReadOnly(true);
        this.iTable.setColumnSortingEnabled(false);
        this.iTable.setSingleSelect();
        this.iModel = new SSInvoiceRowTableModel();
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_PRODUCT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_DESCRIPTION, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_UNITPRICE, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_QUANTITY, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_UNIT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_DISCOUNT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_SUM, false);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_TAX, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_ACCOUNT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_PROJECT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_RESULTUNIT, true);
        this.iModel.setupTable(this.iTable);
        this.iModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SSCreditInvoicePanel.this.updateSumFields();
            }
        });
        this.iVoucherTableModel = new SSVoucherRowTableModelOld(false, true);
        this.iVoucherTable.setModel(this.iVoucherTableModel);
        SSVoucherRowTableModelOld.setupTable(this.iVoucherTable, this.iVoucherTableModel);
        this.iCustomer.setModel(SSCustomerTableModel.getDropDownModel());
        this.iCustomer.setSearchColumns(0, 1);
        this.iCustomer.setAllowCustomValues(true);
        this.iCustomer.addSelectionListener(new SSSelectionListener<SSCustomer>(){

            @Override
            public void selected(SSCustomer selected) {
                if (selected != null) {
                    SSCreditInvoicePanel.this.iModel.setCustomer(selected);
                    SSCreditInvoicePanel.this.iCreditInvoice.setCustomer(selected);
                    if (selected.getDiscount() != null) {
                        for (SSSaleRow iRow : SSCreditInvoicePanel.this.iModel.getObjects()) {
                            iRow.setDiscount(selected.getDiscount().doubleValue() == new BigDecimal(0).doubleValue() ? null : selected.getDiscount());
                        }
                    }
                    SSCreditInvoicePanel.this.setCreditInvoice(SSCreditInvoicePanel.this.iCreditInvoice);
                }
            }
        });
        new SSTraversalAction(this.iTable){

            @Override
            protected Point doTraversal(Point iPosition) {
                if (iPosition.x <= 4) {
                    ++iPosition.x;
                }
                if (iPosition.x == 5) {
                    ++iPosition.y;
                    iPosition.x = 0;
                    if (iPosition.y == SSCreditInvoicePanel.this.iModel.getRowCount()) {
                        SSCreditInvoicePanel.this.iButtonPanel.getOkButton().requestFocus();
                        return null;
                    }
                }
                return iPosition;
            }
        };
        new SSDeleteAction(this.iTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSSaleRow iSelected = (SSSaleRow)SSCreditInvoicePanel.this.iModel.getSelectedRow(SSCreditInvoicePanel.this.iTable);
                if (iSelected != null) {
                    SSQueryDialog dialog = new SSQueryDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "tenderframe.deleterow", iSelected.toString());
                    if (dialog.getResponce() != 0) {
                        return null;
                    }
                    SSCreditInvoicePanel.this.iModel.deleteRow(iSelected);
                }
                return iPosition;
            }
        };
        this.iCurrency.getComboBox().setModel(SSCurrencyTableModel.getDropDownModel());
        this.iCurrency.getComboBox().setSearchColumns(0);
        this.iCurrency.setEditingFactory(SSCurrencyTableModel.getEditingFactory(iOwner));
        this.iDeliveryWay.getComboBox().setModel(SSDeliveryWayTableModel.getDropDownModel());
        this.iDeliveryWay.getComboBox().setSearchColumns(0);
        this.iDeliveryWay.setEditingFactory(SSDeliveryWayTableModel.getEditingFactory(iOwner));
        this.iDeliveryTerm.getComboBox().setModel(SSDeliveryTermTableModel.getDropDownModel());
        this.iDeliveryTerm.getComboBox().setSearchColumns(0);
        this.iDeliveryTerm.setEditingFactory(SSDeliveryTermTableModel.getEditingFactory(iOwner));
        this.iPaymentTerm.getComboBox().setModel(SSPaymentTermTableModel.getDropDownModel());
        this.iPaymentTerm.getComboBox().setSearchColumns(0);
        this.iPaymentTerm.setEditingFactory(SSPaymentTermTableModel.getEditingFactory(iOwner));
        this.iTaxRate1.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSCreditInvoicePanel.this.iCreditInvoice.setTaxRate1(SSCreditInvoicePanel.this.iTaxRate1.getValue());
                SSCreditInvoicePanel.this.updateTaxTexts();
                SSCreditInvoicePanel.this.updateSumFields();
            }
        });
        this.iTaxRate2.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSCreditInvoicePanel.this.iCreditInvoice.setTaxRate2(SSCreditInvoicePanel.this.iTaxRate2.getValue());
                SSCreditInvoicePanel.this.updateTaxTexts();
                SSCreditInvoicePanel.this.updateSumFields();
            }
        });
        this.iTaxRate3.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSCreditInvoicePanel.this.iCreditInvoice.setTaxRate3(SSCreditInvoicePanel.this.iTaxRate3.getValue());
                SSCreditInvoicePanel.this.updateTaxTexts();
                SSCreditInvoicePanel.this.updateSumFields();
            }
        });
        this.iTaxFree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCreditInvoicePanel.this.iCreditInvoice.setTaxFree(SSCreditInvoicePanel.this.iTaxFree.isSelected());
                SSCreditInvoicePanel.this.updateSumFields();
            }
        });
        this.iRefreshVoucher.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucher iVoucher = SSCreditInvoicePanel.this.iCreditInvoice.generateVoucher();
                SSCreditInvoicePanel.this.iVoucherTableModel.setVoucher(iVoucher);
            }
        });
        this.iInputVerifier = new SSInputVerifier();
        this.iInputVerifier.add(this.iCustomer);
        this.iInputVerifier.add(this.iCustomerName);
        this.iInputVerifier.addListener(new SSInputVerifier.SSVerifierListener(){

            @Override
            public void updated(SSInputVerifier iVerifier, boolean iValid) {
                JComponent iCurrent = iVerifier.getCurrentComponent();
                if (iCurrent == SSCreditInvoicePanel.this.iCustomer) {
                    // empty if block
                }
                SSCreditInvoicePanel.this.iButtonPanel.getOkButton().setEnabled(iValid);
            }
        });
        this.addKeyListeners();
    }

    public void dispose() {
        ActionListener[] iActionListeners;
        PropertyChangeListener[] iPropertyChangeListeners;
        this.iModel.setCustomer(null);
        this.iPanel.removeAll();
        this.iPanel = null;
        this.iButtonPanel.dispose();
        this.iButtonPanel = null;
        this.iCrediting.removeAll();
        this.iCrediting = null;
        this.iTable.dispose();
        this.iTable = null;
        this.iNumber.removeAll();
        this.iNumber = null;
        this.iCurrencyRate.removeAll();
        this.iCurrencyRate = null;
        this.iDate.dispose();
        this.iDate = null;
        this.iCustomer.dispose();
        this.iCustomer = null;
        this.iCustomerName = null;
        this.iTaxFree = null;
        this.iDelayInterest = null;
        this.iDeliveryAddress = null;
        this.iInvoiceAddress = null;
        this.iText.removeAll();
        this.iText = null;
        this.iYourContactPerson.removeAll();
        this.iYourContactPerson = null;
        this.iOurContactPerson.removeAll();
        this.iOurContactPerson = null;
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners = this.iTaxRate1.getPropertyChangeListeners()) {
            this.iTaxRate1.removePropertyChangeListener(iPropertyChangeListener);
        }
        this.iTaxRate1.removeAll();
        this.iTaxRate1 = null;
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners = this.iTaxRate2.getPropertyChangeListeners()) {
            this.iTaxRate2.removePropertyChangeListener(iPropertyChangeListener);
        }
        this.iTaxRate2.removeAll();
        this.iTaxRate2 = null;
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners = this.iTaxRate3.getPropertyChangeListeners()) {
            this.iTaxRate3.removePropertyChangeListener(iPropertyChangeListener);
        }
        this.iTaxRate3.removeAll();
        this.iTaxRate3 = null;
        this.iEuSaleCommodity.removeAll();
        this.iEuSaleCommodity = null;
        this.iEuSaleYhirdPartCommodity.removeAll();
        this.iEuSaleYhirdPartCommodity = null;
        this.iDeliveryWay.dispose();
        this.iDeliveryWay = null;
        this.iDeliveryTerm.dispose();
        this.iDeliveryTerm = null;
        this.iPaymentTerm.dispose();
        this.iPaymentTerm = null;
        this.iCurrency.dispose();
        this.iCurrency = null;
        this.iDefaultAccounts.dispose();
        this.iDefaultAccounts = null;
        this.iNetSum.removeAll();
        this.iNetSum = null;
        this.iTaxSum1.removeAll();
        this.iTaxSum1 = null;
        this.iTaxSum2.removeAll();
        this.iTaxSum2 = null;
        this.iTaxSum3.removeAll();
        this.iTaxSum3 = null;
        this.iRoundingSum.removeAll();
        this.iRoundingSum = null;
        this.iTotalSum.removeAll();
        this.iTotalSum = null;
        this.iTaxLabel1 = null;
        this.iTaxLabel2 = null;
        this.iTaxLabel3 = null;
        this.iSavecustomerandproducts = null;
        this.iModel = null;
        this.iInputVerifier = null;
        this.iVoucherTable.dispose();
        this.iVoucherTable = null;
        for (ActionListener iActionListener : iActionListeners = this.iRefreshVoucher.getActionListeners()) {
            this.iRefreshVoucher.removeActionListener(iActionListener);
        }
        this.iRefreshVoucher.removeAll();
        this.iRefreshVoucher = null;
        this.iModel = null;
        this.iVoucherTableModel = null;
        this.iEntered = null;
        this.isStockInfluencing = null;
        this.iInputVerifier = null;
    }

    public boolean isValid() {
        return this.iInputVerifier.isValid();
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener pActionListener) {
        this.iButtonPanel.addOkActionListener(pActionListener);
    }

    public void addCancelAction(ActionListener pActionListener) {
        this.iButtonPanel.addCancelActionListener(pActionListener);
    }

    public void setCreditInvoice(SSCreditInvoice pOrder) {
        this.iCreditInvoice = pOrder;
        this.iVoucherTableModel.setVoucher(this.iCreditInvoice.getVoucher());
        this.iModel.setObjects(this.iCreditInvoice.getRows());
        this.iNumber.setValue(this.iCreditInvoice.getNumber());
        this.iCrediting.setValue(this.iCreditInvoice.getCreditingNr());
        this.iDate.setDate(this.iCreditInvoice.getDate());
        this.iCustomer.setText(this.iCreditInvoice.getCustomerNr());
        for (SSCustomer pCustomer : SSDB.getInstance().getCustomers()) {
            if (!pCustomer.getNumber().equals(this.iCustomer.getText())) continue;
            this.iModel.setCustomer(pCustomer);
        }
        this.iCustomerName.setText(this.iCreditInvoice.getCustomerName());
        this.iOurContactPerson.setText(this.iCreditInvoice.getOurContactPerson());
        this.iYourContactPerson.setText(this.iCreditInvoice.getYourContactPerson());
        this.iDelayInterest.setValue(this.iCreditInvoice.getDelayInterest());
        this.iCurrency.setSelected(this.iCreditInvoice.getCurrency());
        this.iCurrencyRate.setValue(this.iCreditInvoice.getCurrencyRate());
        this.iPaymentTerm.setSelected(this.iCreditInvoice.getPaymentTerm(), true);
        this.iDeliveryTerm.setSelected(this.iCreditInvoice.getDeliveryTerm());
        this.iDeliveryWay.setSelected(this.iCreditInvoice.getDeliveryWay());
        this.iEntered.setSelected(this.iCreditInvoice.isEntered());
        this.isStockInfluencing.setSelected(this.iCreditInvoice.isStockInfluencing());
        this.iTaxFree.setSelected(this.iCreditInvoice.getTaxFree());
        this.iTaxRate1.setValue(this.iCreditInvoice.getTaxRate1());
        this.iTaxRate2.setValue(this.iCreditInvoice.getTaxRate2());
        this.iTaxRate3.setValue(this.iCreditInvoice.getTaxRate3());
        this.iEuSaleCommodity.setSelected(this.iCreditInvoice.getEuSaleCommodity());
        this.iEuSaleYhirdPartCommodity.setSelected(this.iCreditInvoice.getEuSaleThirdPartCommodity());
        this.iText.setText(this.iCreditInvoice.getText());
        this.iInvoiceAddress.setAdress(this.iCreditInvoice.getInvoiceAddress());
        this.iDeliveryAddress.setAdress(this.iCreditInvoice.getDeliveryAddress());
        this.iDefaultAccounts.setDefaultAccounts(this.iCreditInvoice.getDefaultAccounts());
        this.updateSumFields();
        this.updateTaxTexts();
        this.iSavecustomerandproducts.setSelected(true);
        this.iInputVerifier.update();
    }

    public SSCreditInvoice getCreditInvoice() {
        this.iCreditInvoice.setDate(this.iDate.getDate());
        this.iCreditInvoice.setCustomerNr(this.iCustomer.getText());
        this.iCreditInvoice.setCustomerName(this.iCustomerName.getText());
        this.iCreditInvoice.setOurContactPerson(this.iOurContactPerson.getText());
        this.iCreditInvoice.setYourContactPerson(this.iYourContactPerson.getText());
        this.iCreditInvoice.setDelayInterest(this.iDelayInterest.getValue());
        this.iCreditInvoice.setCurrency(this.iCurrency.getSelected());
        this.iCreditInvoice.setCurrencyRate(this.iCurrencyRate.getValue());
        this.iCreditInvoice.setPaymentTerm(this.iPaymentTerm.getSelected());
        this.iCreditInvoice.setDeliveryTerm(this.iDeliveryTerm.getSelected());
        this.iCreditInvoice.setDeliveryWay(this.iDeliveryWay.getSelected());
        this.iCreditInvoice.setTaxFree(this.iTaxFree.isSelected());
        this.iCreditInvoice.setTaxRate1(this.iTaxRate1.getValue());
        this.iCreditInvoice.setTaxRate2(this.iTaxRate2.getValue());
        this.iCreditInvoice.setTaxRate3(this.iTaxRate3.getValue());
        this.iCreditInvoice.setEntered(this.iEntered.isSelected());
        this.iCreditInvoice.setStockInfluencing(this.isStockInfluencing.isSelected());
        this.iCreditInvoice.setText(this.iText.getText());
        this.iCreditInvoice.setInvoiceAddress(this.iInvoiceAddress.getAddress());
        this.iCreditInvoice.setDeliveryAddress(this.iDeliveryAddress.getAddress());
        this.iCreditInvoice.setDefaultAccounts(this.iDefaultAccounts.getDefaultAccounts());
        this.iCreditInvoice.generateVoucher();
        return this.iCreditInvoice;
    }

    public void addKeyListeners() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SSCreditInvoicePanel.this.iCustomerName.requestFocusInWindow();
            }
        });
        this.iCustomerName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCreditInvoicePanel.this.iOurContactPerson.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iOurContactPerson.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCreditInvoicePanel.this.iYourContactPerson.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iYourContactPerson.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCreditInvoicePanel.this.iDate.getEditor().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDate.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCreditInvoicePanel.this.iDeliveryTerm.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDeliveryTerm.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCreditInvoicePanel.this.iPaymentTerm.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPaymentTerm.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCreditInvoicePanel.this.iDeliveryWay.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDeliveryWay.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCreditInvoicePanel.this.iTable.requestFocusInWindow();
                            SSCreditInvoicePanel.this.iTable.changeSelection(0, 0, false, false);
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getOkButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCreditInvoicePanel.this.iButtonPanel.getCancelButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getCancelButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCreditInvoicePanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iNumber.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SSCreditInvoicePanel.this.iCustomerName.requestFocusInWindow();
                    }
                });
            }
        });
        this.iInvoiceAddress.addKeyListeners();
        this.iDeliveryAddress.addKeyListeners();
    }

    public boolean doSaveCustomerAndProducts() {
        return this.iSavecustomerandproducts.isSelected();
    }

    private void updateTaxTexts() {
        SSTaxCodeCellEditor iEditor = new SSTaxCodeCellEditor();
        SSTaxCodeCellRenderer iRenderer = new SSTaxCodeCellRenderer();
        String iTaxText = SSBundle.getBundle().getString("tenderframe.tax");
        BigDecimal iTaxRate1 = this.iTaxRate1.getValue() == null ? new BigDecimal(25) : this.iTaxRate1.getValue();
        BigDecimal iTaxRate2 = this.iTaxRate2.getValue() == null ? new BigDecimal(12) : this.iTaxRate2.getValue();
        BigDecimal iTaxRate3 = this.iTaxRate3.getValue() == null ? new BigDecimal(6) : this.iTaxRate3.getValue();
        NumberFormat iFormat = NumberFormat.getNumberInstance();
        iEditor.setValue(SSTaxCode.TAXRATE_0, new BigDecimal(0));
        iEditor.setValue(SSTaxCode.TAXRATE_1, iTaxRate1);
        iEditor.setValue(SSTaxCode.TAXRATE_2, iTaxRate2);
        iEditor.setValue(SSTaxCode.TAXRATE_3, iTaxRate3);
        iRenderer.setValue(SSTaxCode.TAXRATE_0, new BigDecimal(0));
        iRenderer.setValue(SSTaxCode.TAXRATE_1, iTaxRate1);
        iRenderer.setValue(SSTaxCode.TAXRATE_2, iTaxRate2);
        iRenderer.setValue(SSTaxCode.TAXRATE_3, iTaxRate3);
        this.iTaxLabel1.setText(iTaxText + ' ' + iFormat.format(iTaxRate1) + '%');
        this.iTaxLabel2.setText(iTaxText + ' ' + iFormat.format(iTaxRate2) + '%');
        this.iTaxLabel3.setText(iTaxText + ' ' + iFormat.format(iTaxRate3) + '%');
        this.iTable.setDefaultEditor(SSTaxCode.class, iEditor);
        this.iTable.setDefaultRenderer(SSTaxCode.class, iRenderer);
        this.iModel.fireTableDataChanged();
    }

    private void updateSumFields() {
        BigDecimal iNetSum = SSInvoiceMath.getNetSum(this.iCreditInvoice);
        Map<SSTaxCode, BigDecimal> iTaxSum = SSInvoiceMath.getTaxSum(this.iCreditInvoice);
        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(this.iCreditInvoice);
        BigDecimal iRounding = SSInvoiceMath.getRounding(this.iCreditInvoice);
        this.iNetSum.setValue(iNetSum);
        this.iTaxSum1.setValue(iTaxSum.get(SSTaxCode.TAXRATE_1));
        this.iTaxSum2.setValue(iTaxSum.get(SSTaxCode.TAXRATE_2));
        this.iTaxSum3.setValue(iTaxSum.get(SSTaxCode.TAXRATE_3));
        if (!SSDB.getInstance().getCurrentCompany().isRoundingOff()) {
            this.iRoundingSum.setValue(iRounding);
        }
        this.iTotalSum.setValue(iTotalSum);
    }

    public void setSavecustomerandproductsSelected(boolean iSelected) {
        this.iSavecustomerandproducts.setSelected(iSelected);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.creditinvoice.panel.SSCreditInvoicePanel");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCrediting=").append(this.iCrediting);
        sb.append(", iCreditInvoice=").append(this.iCreditInvoice);
        sb.append(", iCurrency=").append(this.iCurrency);
        sb.append(", iCurrencyRate=").append(this.iCurrencyRate);
        sb.append(", iCustomer=").append(this.iCustomer);
        sb.append(", iCustomerName=").append(this.iCustomerName);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iDefaultAccounts=").append(this.iDefaultAccounts);
        sb.append(", iDelayInterest=").append(this.iDelayInterest);
        sb.append(", iDeliveryAddress=").append(this.iDeliveryAddress);
        sb.append(", iDeliveryTerm=").append(this.iDeliveryTerm);
        sb.append(", iDeliveryWay=").append(this.iDeliveryWay);
        sb.append(", iEntered=").append(this.iEntered);
        sb.append(", iEuSaleCommodity=").append(this.iEuSaleCommodity);
        sb.append(", iEuSaleYhirdPartCommodity=").append(this.iEuSaleYhirdPartCommodity);
        sb.append(", iInputVerifier=").append(this.iInputVerifier);
        sb.append(", iInvoiceAddress=").append(this.iInvoiceAddress);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iNetSum=").append(this.iNetSum);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iOurContactPerson=").append(this.iOurContactPerson);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iPaymentTerm=").append(this.iPaymentTerm);
        sb.append(", iRefreshVoucher=").append(this.iRefreshVoucher);
        sb.append(", iRoundingSum=").append(this.iRoundingSum);
        sb.append(", iSavecustomerandproducts=").append(this.iSavecustomerandproducts);
        sb.append(", isStockInfluencing=").append(this.isStockInfluencing);
        sb.append(", iTable=").append(this.iTable);
        sb.append(", iTaxFree=").append(this.iTaxFree);
        sb.append(", iTaxLabel1=").append(this.iTaxLabel1);
        sb.append(", iTaxLabel2=").append(this.iTaxLabel2);
        sb.append(", iTaxLabel3=").append(this.iTaxLabel3);
        sb.append(", iTaxRate1=").append(this.iTaxRate1);
        sb.append(", iTaxRate2=").append(this.iTaxRate2);
        sb.append(", iTaxRate3=").append(this.iTaxRate3);
        sb.append(", iTaxSum1=").append(this.iTaxSum1);
        sb.append(", iTaxSum2=").append(this.iTaxSum2);
        sb.append(", iTaxSum3=").append(this.iTaxSum3);
        sb.append(", iText=").append(this.iText);
        sb.append(", iTotalSum=").append(this.iTotalSum);
        sb.append(", iVoucherTable=").append(this.iVoucherTable);
        sb.append(", iVoucherTableModel=").append(this.iVoucherTableModel);
        sb.append(", iYourContactPerson=").append(this.iYourContactPerson);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JButton jButton;
        SSTable sSTable;
        JCheckBox jCheckBox3;
        SSBigDecimalTextField sSBigDecimalTextField;
        SSBigDecimalTextField sSBigDecimalTextField2;
        SSBigDecimalTextField sSBigDecimalTextField3;
        SSDefaultAccountPanel sSDefaultAccountPanel;
        SSBigDecimalTextField sSBigDecimalTextField4;
        SSAdressPanel sSAdressPanel;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JTextArea jTextArea;
        SSAdressPanel sSAdressPanel2;
        JFormattedTextField jFormattedTextField;
        SSBigDecimalTextField sSBigDecimalTextField5;
        SSDateChooser sSDateChooser;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JFormattedTextField jFormattedTextField2;
        JCheckBox jCheckBox6;
        SSBigDecimalTextField sSBigDecimalTextField6;
        SSBigDecimalTextField sSBigDecimalTextField7;
        SSBigDecimalTextField sSBigDecimalTextField8;
        SSBigDecimalTextField sSBigDecimalTextField9;
        SSBigDecimalTextField sSBigDecimalTextField10;
        SSBigDecimalTextField sSBigDecimalTextField11;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        SSTable sSTable2;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), 4, 2, false, false));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(5, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("invoiceframe.panel.1"), null, jPanel2, null);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, new Dimension(-1, 120), null, null));
        this.iTable = sSTable2 = new SSTable();
        jScrollPane.setViewportView(sSTable2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 6, new Insets(0, 2, 4, 2), 2, 0, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("tenderframe.netsum"));
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxLabel1 = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("tenderframe.tax"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(80, -1), null));
        this.iTaxLabel2 = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("tenderframe.tax"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxLabel3 = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("tenderframe.tax"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("book").getString("tenderframe.rounding"));
        jPanel3.add((Component)jLabel5, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("book").getString("tenderframe.totalsum"));
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 5, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iNetSum = sSBigDecimalTextField11 = new SSBigDecimalTextField();
        sSBigDecimalTextField11.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField11, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, new Dimension(-1, 20)));
        this.iTaxSum1 = sSBigDecimalTextField10 = new SSBigDecimalTextField();
        sSBigDecimalTextField10.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField10, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 3, null, new Dimension(100, -1), new Dimension(-1, 20)));
        this.iTaxSum2 = sSBigDecimalTextField9 = new SSBigDecimalTextField();
        sSBigDecimalTextField9.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField9, new GridConstraints(1, 2, 1, 1, 8, 1, 3, 3, null, new Dimension(100, -1), new Dimension(-1, 20)));
        this.iTaxSum3 = sSBigDecimalTextField8 = new SSBigDecimalTextField();
        sSBigDecimalTextField8.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField8, new GridConstraints(1, 3, 1, 1, 8, 1, 3, 3, null, new Dimension(100, -1), new Dimension(-1, 20)));
        this.iRoundingSum = sSBigDecimalTextField7 = new SSBigDecimalTextField();
        sSBigDecimalTextField7.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField7, new GridConstraints(1, 4, 1, 1, 0, 1, 7, 3, null, null, new Dimension(-1, 20)));
        this.iTotalSum = sSBigDecimalTextField6 = new SSBigDecimalTextField();
        sSBigDecimalTextField6.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField6, new GridConstraints(1, 5, 1, 1, 0, 1, 7, 3, null, null, new Dimension(-1, 20)));
        this.iSavecustomerandproducts = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("book").getString("tenderframe.dontsavecustomerandproducts"));
        jCheckBox6.setVerticalTextPosition(0);
        jCheckBox6.setSelected(true);
        jCheckBox6.setInheritsPopupMenu(false);
        jCheckBox6.setHorizontalAlignment(2);
        jCheckBox6.setVerticalAlignment(3);
        jPanel2.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 10, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(8, 6, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("book").getString("creditinvoiceframe.number"));
        jPanel4.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iNumber = jFormattedTextField2 = new JFormattedTextField();
        jFormattedTextField2.setEditable(false);
        jPanel4.add((Component)jFormattedTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("book").getString("invoiceframe.date"));
        jPanel4.add((Component)jLabel8, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("book").getString("tenderframe.yourcontactperson"));
        jPanel4.add((Component)jLabel9, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iYourContactPerson = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(5, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, 20)));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("book").getString("tenderframe.ourcontactperson"));
        jPanel4.add((Component)jLabel10, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iOurContactPerson = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, 20)));
        this.iCustomerName = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, 20)));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("book").getString("tenderframe.customername"));
        jPanel4.add((Component)jLabel11, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("book").getString("tenderframe.customernr"));
        jPanel4.add((Component)jLabel12, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("book").getString("creditinvoiceframe.crediting"));
        jPanel4.add((Component)jLabel13, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDate = sSDateChooser = new SSDateChooser();
        ((Component)sSDateChooser).setEnabled(true);
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel4.add((Component)sSDateChooser, new GridConstraints(0, 4, 1, 1, 4, 0, 1, 3, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, 22)));
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("book").getString("tenderframe.deliveryterm"));
        jPanel4.add((Component)jLabel14, new GridConstraints(1, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel15 = new JLabel();
        this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("book").getString("tenderframe.paymentterm"));
        jPanel4.add((Component)jLabel15, new GridConstraints(2, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel16 = new JLabel();
        this.$$$loadLabelText$$$(jLabel16, ResourceBundle.getBundle("book").getString("tenderframe.deliveryway"));
        jPanel4.add((Component)jLabel16, new GridConstraints(3, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel17 = new JLabel();
        this.$$$loadLabelText$$$(jLabel17, ResourceBundle.getBundle("book").getString("tenderframe.currency"));
        jPanel4.add((Component)jLabel17, new GridConstraints(4, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel18 = new JLabel();
        this.$$$loadLabelText$$$(jLabel18, ResourceBundle.getBundle("book").getString("invoiceframe.currencyrate"));
        jPanel4.add((Component)jLabel18, new GridConstraints(5, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        SSEditableTableComboBox sSEditableTableComboBox = new SSEditableTableComboBox();
        this.iDeliveryTerm = sSEditableTableComboBox;
        jPanel4.add(sSEditableTableComboBox, new GridConstraints(1, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, 20)));
        SSEditableTableComboBox sSEditableTableComboBox2 = new SSEditableTableComboBox();
        this.iPaymentTerm = sSEditableTableComboBox2;
        jPanel4.add(sSEditableTableComboBox2, new GridConstraints(2, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, 20)));
        SSEditableTableComboBox sSEditableTableComboBox3 = new SSEditableTableComboBox();
        this.iDeliveryWay = sSEditableTableComboBox3;
        jPanel4.add(sSEditableTableComboBox3, new GridConstraints(3, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, 20)));
        SSEditableTableComboBox sSEditableTableComboBox4 = new SSEditableTableComboBox();
        this.iCurrency = sSEditableTableComboBox4;
        ((Component)sSEditableTableComboBox4).setEnabled(false);
        jPanel4.add(sSEditableTableComboBox4, new GridConstraints(4, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, 20)));
        this.iCurrencyRate = sSBigDecimalTextField5 = new SSBigDecimalTextField();
        sSBigDecimalTextField5.setFractionDigits(5);
        sSBigDecimalTextField5.setEditable(false);
        jPanel4.add((Component)sSBigDecimalTextField5, new GridConstraints(5, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, 20)));
        this.iCrediting = jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setEditable(false);
        jPanel4.add((Component)jFormattedTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iCustomer = sSTableComboBox;
        ((Component)sSTableComboBox).setEnabled(false);
        jPanel4.add(sSTableComboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(150, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(5, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("invoiceframe.panel.2"), null, jPanel5, null);
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iInvoiceAddress = sSAdressPanel2 = new SSAdressPanel();
        ((Component)sSAdressPanel2).setEnabled(true);
        sSAdressPanel2.setTitle(ResourceBundle.getBundle("book").getString("tenderframe.invoiceaddress"));
        jPanel6.add((Component)sSAdressPanel2, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 4, 0, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel7.add((Component)jScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, new Dimension(-1, 60), new Dimension(-1, 60), new Dimension(-1, 60)));
        this.iText = jTextArea = new JTextArea();
        jScrollPane2.setViewportView(jTextArea);
        JLabel jLabel19 = new JLabel();
        this.$$$loadLabelText$$$(jLabel19, ResourceBundle.getBundle("book").getString("invoiceframe.invoicetext"));
        jPanel7.add((Component)jLabel19, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel5.add((Component)jPanel8, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.iEuSaleCommodity = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("book").getString("customerframe.eusalecommodity"));
        ((Component)jCheckBox5).setEnabled(false);
        jPanel8.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iEuSaleYhirdPartCommodity = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("book").getString("customerframe.eusalethirdpartcommodity"));
        ((Component)jCheckBox4).setEnabled(false);
        jPanel8.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(1, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel5.add((Component)jPanel9, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iDeliveryAddress = sSAdressPanel = new SSAdressPanel();
        sSAdressPanel.setTitle(ResourceBundle.getBundle("book").getString("tenderframe.deliveryaddress"));
        jPanel9.add((Component)sSAdressPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(1, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel5.add((Component)jPanel10, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel20 = new JLabel();
        this.$$$loadLabelText$$$(jLabel20, ResourceBundle.getBundle("book").getString("tenderframe.delayinterest"));
        jPanel10.add((Component)jLabel20, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDelayInterest = sSBigDecimalTextField4 = new SSBigDecimalTextField();
        sSBigDecimalTextField4.setFractionDigits(2);
        jPanel10.add((Component)sSBigDecimalTextField4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, 20)));
        JLabel jLabel21 = new JLabel();
        jLabel21.setText("%");
        jPanel10.add((Component)jLabel21, new GridConstraints(0, 2, 1, 1, 8, 0, 6, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(3, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("invoiceframe.panel.3"), null, jPanel11, null);
        Spacer spacer4 = new Spacer();
        jPanel11.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel11.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iDefaultAccounts = sSDefaultAccountPanel = new SSDefaultAccountPanel();
        jPanel11.add((Component)sSDefaultAccountPanel, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayoutManager(4, 3, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel11.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel12.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel22 = new JLabel();
        this.$$$loadLabelText$$$(jLabel22, ResourceBundle.getBundle("book").getString("companyframe.taxrate1"));
        jPanel12.add((Component)jLabel22, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel23 = new JLabel();
        this.$$$loadLabelText$$$(jLabel23, ResourceBundle.getBundle("book").getString("companyframe.taxrate2"));
        jPanel12.add((Component)jLabel23, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel24 = new JLabel();
        this.$$$loadLabelText$$$(jLabel24, ResourceBundle.getBundle("book").getString("companyframe.taxrate3"));
        jPanel12.add((Component)jLabel24, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxRate1 = sSBigDecimalTextField3 = new SSBigDecimalTextField();
        jPanel12.add((Component)sSBigDecimalTextField3, new GridConstraints(1, 1, 1, 1, 8, 0, 7, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, 20)));
        JLabel jLabel25 = new JLabel();
        jLabel25.setText("%");
        jPanel12.add((Component)jLabel25, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel26 = new JLabel();
        jLabel26.setText("%");
        jPanel12.add((Component)jLabel26, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel27 = new JLabel();
        jLabel27.setText("%");
        jPanel12.add((Component)jLabel27, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxRate2 = sSBigDecimalTextField2 = new SSBigDecimalTextField();
        jPanel12.add((Component)sSBigDecimalTextField2, new GridConstraints(2, 1, 1, 1, 8, 0, 7, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, 20)));
        this.iTaxRate3 = sSBigDecimalTextField = new SSBigDecimalTextField();
        jPanel12.add((Component)sSBigDecimalTextField, new GridConstraints(3, 1, 1, 1, 8, 0, 7, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, 20)));
        this.iTaxFree = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("book").getString("tenderframe.taxfree"));
        ((Component)jCheckBox3).setEnabled(false);
        jPanel12.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridLayoutManager(4, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("invoiceframe.panel.4"), null, jPanel13, null);
        Spacer spacer6 = new Spacer();
        jPanel13.add((Component)spacer6, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel13.add((Component)spacer7, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridLayoutManager(2, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel13.add((Component)jPanel14, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel14.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane3 = new JScrollPane();
        jPanel14.add((Component)jScrollPane3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, new Dimension(600, 250), null));
        this.iVoucherTable = sSTable = new SSTable();
        jScrollPane3.setViewportView(sSTable);
        this.iRefreshVoucher = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("book").getString("invoiceframe.voucherrefresh"));
        jPanel14.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel14.add((Component)spacer8, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel28 = new JLabel();
        this.$$$loadLabelText$$$(jLabel28, ResourceBundle.getBundle("book").getString("invoiceframe.voucher"));
        jLabel28.setVerticalTextPosition(1);
        jLabel28.setHorizontalAlignment(2);
        jLabel28.setHorizontalTextPosition(2);
        jLabel28.setVerticalAlignment(1);
        jPanel14.add((Component)jLabel28, new GridConstraints(0, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        this.iEntered = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("book").getString("creditinvoiceframe.entered"));
        jPanel13.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.isStockInfluencing = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("invoiceframe.updatestock"));
        jPanel13.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

