/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.customer.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.company.panel.SSAdressPanel;
import se.swedsoft.bookkeeping.gui.util.SSButtonGroup;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSInputVerifier;
import se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSCurrencyTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDeliveryTermTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDeliveryWayTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSPaymentTermTableModel;

public class SSCustomerPanel {
    private SSCustomer iCustomer;
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private SSBigDecimalTextField iDiscount;
    private JCheckBox iEuSaleCommodity;
    private JTextField iYourContactPerson;
    private JTextField iOurContactPerson;
    private JTextField iOrginisationNumber;
    private JTextField iEMail;
    private JTextField iTelefax;
    private JTextField iPhone;
    private JTextField iPhone2;
    private JTextField iName;
    private JTextField iCustomerNr;
    private JCheckBox iVatFreeSale;
    private JCheckBox iEuSaleYhirdPartCommodity;
    private SSAdressPanel iInvoiceAddress;
    private SSAdressPanel iDeliveryAddress;
    private SSBigDecimalTextField iCreditLimit;
    private JTextField iVATNumber;
    private JTextField iBankAccountNumber;
    private JTextField iPlusAccountNumber;
    private SSEditableTableComboBox<SSDeliveryWay> iDeliveryWay;
    private SSEditableTableComboBox<SSDeliveryTerm> iDeliveryTerm;
    private SSEditableTableComboBox<SSPaymentTerm> iPaymentTerm;
    private SSEditableTableComboBox<SSCurrency> iInvoiceCurrency;
    private JCheckBox iUseInvoiceForDelivery;
    private JLabel iCreditLimitCurrency;
    private SSInputVerifier iInputVerifier;
    private JCheckBox iHideUnitPrice;
    private JTextPane iComment;

    public SSCustomerPanel(SSDialog iOwner, boolean iEdit) {
        this.$$$setupUI$$$();
        this.iCustomerNr.setEnabled(!iEdit);
        this.iUseInvoiceForDelivery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCustomerPanel.this.iDeliveryAddress.setEnabled(!SSCustomerPanel.this.iUseInvoiceForDelivery.isSelected());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!SSCustomerPanel.this.iUseInvoiceForDelivery.isSelected()) {
                            SSCustomerPanel.this.iDeliveryAddress.setFocus();
                        } else {
                            SSCustomerPanel.this.iInvoiceAddress.setFocus();
                        }
                    }
                });
            }
        });
        this.iInvoiceCurrency.getComboBox().setModel(SSCurrencyTableModel.getDropDownModel());
        this.iInvoiceCurrency.getComboBox().setSearchColumns(0);
        this.iInvoiceCurrency.setEditingFactory(SSCurrencyTableModel.getEditingFactory(iOwner));
        this.iDeliveryWay.getComboBox().setModel(SSDeliveryWayTableModel.getDropDownModel());
        this.iDeliveryWay.getComboBox().setSearchColumns(0);
        this.iDeliveryWay.setEditingFactory(SSDeliveryWayTableModel.getEditingFactory(iOwner));
        this.iDeliveryTerm.getComboBox().setModel(SSDeliveryTermTableModel.getDropDownModel());
        this.iDeliveryTerm.getComboBox().setSearchColumns(0);
        this.iDeliveryTerm.setEditingFactory(SSDeliveryTermTableModel.getEditingFactory(iOwner));
        this.iPaymentTerm.getComboBox().setModel(SSPaymentTermTableModel.getDropDownModel());
        this.iPaymentTerm.getComboBox().setSearchColumns(0);
        this.iPaymentTerm.setEditingFactory(SSPaymentTermTableModel.getEditingFactory(iOwner));
        SSCurrency iCurrency = SSDB.getInstance().getCurrentCompany().getCurrency();
        this.iCreditLimitCurrency.setText(iCurrency == null ? "" : iCurrency.getName());
        SSButtonGroup iGroup = new SSButtonGroup(true);
        iGroup.add(this.iEuSaleCommodity);
        iGroup.add(this.iEuSaleYhirdPartCommodity);
        this.iInputVerifier = new SSInputVerifier();
        this.iInputVerifier.add(this.iCustomerNr);
        this.iInputVerifier.addListener(new SSInputVerifier.SSVerifierListener(){

            @Override
            public void updated(SSInputVerifier iVerifier, boolean iValid) {
                SSCustomerPanel.this.iButtonPanel.getOkButton().setEnabled(iValid);
            }
        });
        this.addKeyListeners();
    }

    public boolean isValid() {
        return this.iInputVerifier.isValid();
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public SSCustomer getCustomer() {
        this.iCustomer.setNumber(this.iCustomerNr.getText());
        this.iCustomer.setName(this.iName.getText());
        this.iCustomer.setEMail(this.iEMail.getText());
        this.iCustomer.setPhone1(this.iPhone.getText());
        this.iCustomer.setPhone2(this.iPhone2.getText());
        this.iCustomer.setTelefax(this.iTelefax.getText());
        this.iCustomer.setRegistrationNumber(this.iOrginisationNumber.getText());
        this.iCustomer.setOurContactPerson(this.iOurContactPerson.getText());
        this.iCustomer.setYourContactPerson(this.iYourContactPerson.getText());
        this.iCustomer.setVATNumber(this.iVATNumber.getText());
        this.iCustomer.setBankgiro(this.iBankAccountNumber.getText());
        this.iCustomer.setPlusgiro(this.iPlusAccountNumber.getText());
        this.iCustomer.setEuSaleCommodity(this.iEuSaleCommodity.isSelected());
        this.iCustomer.setEuSaleYhirdPartCommodity(this.iEuSaleYhirdPartCommodity.isSelected());
        this.iCustomer.setTaxFree(this.iVatFreeSale.isSelected());
        this.iCustomer.setHideUnitprice(this.iHideUnitPrice.isSelected());
        this.iCustomer.setInvoiceCurrency(this.iInvoiceCurrency.getSelected());
        this.iCustomer.setPaymentTerm(this.iPaymentTerm.getSelected());
        this.iCustomer.setDeliveryTerm(this.iDeliveryTerm.getSelected());
        this.iCustomer.setDeliveryWay(this.iDeliveryWay.getSelected());
        this.iCustomer.setCreditLimit(this.iCreditLimit.getValue());
        this.iCustomer.setDiscount(this.iDiscount.getValue());
        this.iCustomer.setInvoiceAddress(this.iInvoiceAddress.getAddress());
        if (this.iUseInvoiceForDelivery.isSelected()) {
            this.iCustomer.setDeliveryAddress(this.iInvoiceAddress.getAddressCloned());
        } else {
            this.iCustomer.setDeliveryAddress(this.iDeliveryAddress.getAddress());
        }
        this.iCustomer.setComment(this.iComment.getText());
        if (this.iCustomer.getDeliveryAddress().getName() == null || this.iCustomer.getDeliveryAddress().getName().length() == 0) {
            this.iCustomer.getDeliveryAddress().setName(this.iCustomer.getName());
        }
        if (this.iCustomer.getInvoiceAddress().getName() == null || this.iCustomer.getInvoiceAddress().getName().length() == 0) {
            this.iCustomer.getInvoiceAddress().setName(this.iCustomer.getName());
        }
        return this.iCustomer;
    }

    public void setCustomer(SSCustomer iCustomer) {
        this.iCustomerNr.setText(iCustomer.getNumber());
        this.iName.setText(iCustomer.getName());
        this.iEMail.setText(iCustomer.getEMail());
        this.iPhone.setText(iCustomer.getPhone1());
        this.iPhone2.setText(iCustomer.getPhone2());
        this.iTelefax.setText(iCustomer.getTelefax());
        this.iOrginisationNumber.setText(iCustomer.getRegistrationNumber());
        this.iOurContactPerson.setText(iCustomer.getOurContactPerson());
        this.iYourContactPerson.setText(iCustomer.getYourContactPerson());
        this.iVATNumber.setText(iCustomer.getVATNumber());
        this.iBankAccountNumber.setText(iCustomer.getBankgiro());
        this.iPlusAccountNumber.setText(iCustomer.getPlusgiro());
        this.iEuSaleCommodity.setSelected(iCustomer.getEuSaleCommodity());
        this.iEuSaleYhirdPartCommodity.setSelected(iCustomer.getEuSaleYhirdPartCommodity());
        this.iVatFreeSale.setSelected(iCustomer.getTaxFree());
        this.iHideUnitPrice.setSelected(iCustomer.getHideUnitprice());
        this.iInvoiceCurrency.setSelected(iCustomer.getInvoiceCurrency());
        this.iPaymentTerm.setSelected(iCustomer.getPaymentTerm());
        this.iDeliveryTerm.setSelected(iCustomer.getDeliveryTerm());
        this.iDeliveryWay.setSelected(iCustomer.getDeliveryWay());
        this.iCreditLimit.setValue(iCustomer.getCreditLimit());
        this.iDiscount.setValue(iCustomer.getDiscount());
        this.iInvoiceAddress.setAdress(iCustomer.getInvoiceAddress());
        this.iDeliveryAddress.setAdress(iCustomer.getDeliveryAddress());
        this.iUseInvoiceForDelivery.setSelected(iCustomer.getDeliveryAddress().equals(iCustomer.getInvoiceAddress()));
        this.iDeliveryAddress.setEnabled(!this.iUseInvoiceForDelivery.isSelected());
        this.iComment.setText(iCustomer.getComment());
        this.iCustomer = iCustomer;
    }

    public void addOkAction(ActionListener pActionListener) {
        this.iButtonPanel.addOkActionListener(pActionListener);
    }

    public void addCancelAction(ActionListener pActionListener) {
        this.iButtonPanel.addCancelActionListener(pActionListener);
    }

    public void setEditPanel(boolean iEdit) {
        this.iCustomerNr.setEditable(!iEdit);
    }

    public void addKeyListeners() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SSCustomerPanel.this.iCustomerNr.isEnabled()) {
                    SSCustomerPanel.this.iCustomerNr.requestFocusInWindow();
                } else {
                    SSCustomerPanel.this.iName.requestFocusInWindow();
                }
            }
        });
        this.iCustomerNr.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iName.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iEMail.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iEMail.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iOrginisationNumber.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iOrginisationNumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iVATNumber.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iVATNumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iOurContactPerson.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iOurContactPerson.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iYourContactPerson.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iYourContactPerson.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iTelefax.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iTelefax.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iPhone.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPhone.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iPhone2.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPhone2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iEuSaleCommodity.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iEuSaleCommodity.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iEuSaleYhirdPartCommodity.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iEuSaleYhirdPartCommodity.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iVatFreeSale.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iVatFreeSale.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iHideUnitPrice.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iHideUnitPrice.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getOkButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iButtonPanel.getCancelButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getCancelButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iInvoiceCurrency.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iPaymentTerm.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPaymentTerm.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iDeliveryTerm.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDeliveryTerm.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iDeliveryWay.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDeliveryWay.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iCreditLimit.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCreditLimit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iDiscount.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDiscount.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iBankAccountNumber.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iBankAccountNumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iPlusAccountNumber.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPlusAccountNumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSCustomerPanel.this.iComment.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iInvoiceAddress.addKeyListeners();
        this.iDeliveryAddress.addKeyListeners();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.customer.panel.SSCustomerPanel");
        sb.append("{iBankAccountNumber=").append(this.iBankAccountNumber);
        sb.append(", iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iComment=").append(this.iComment);
        sb.append(", iCreditLimit=").append(this.iCreditLimit);
        sb.append(", iCreditLimitCurrency=").append(this.iCreditLimitCurrency);
        sb.append(", iCustomer=").append(this.iCustomer);
        sb.append(", iCustomerNr=").append(this.iCustomerNr);
        sb.append(", iDeliveryAddress=").append(this.iDeliveryAddress);
        sb.append(", iDeliveryTerm=").append(this.iDeliveryTerm);
        sb.append(", iDeliveryWay=").append(this.iDeliveryWay);
        sb.append(", iDiscount=").append(this.iDiscount);
        sb.append(", iEMail=").append(this.iEMail);
        sb.append(", iEuSaleCommodity=").append(this.iEuSaleCommodity);
        sb.append(", iEuSaleYhirdPartCommodity=").append(this.iEuSaleYhirdPartCommodity);
        sb.append(", iHideUnitPrice=").append(this.iHideUnitPrice);
        sb.append(", iInputVerifier=").append(this.iInputVerifier);
        sb.append(", iInvoiceAddress=").append(this.iInvoiceAddress);
        sb.append(", iInvoiceCurrency=").append(this.iInvoiceCurrency);
        sb.append(", iName=").append(this.iName);
        sb.append(", iOrginisationNumber=").append(this.iOrginisationNumber);
        sb.append(", iOurContactPerson=").append(this.iOurContactPerson);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iPaymentTerm=").append(this.iPaymentTerm);
        sb.append(", iPhone=").append(this.iPhone);
        sb.append(", iPhone2=").append(this.iPhone2);
        sb.append(", iPlusAccountNumber=").append(this.iPlusAccountNumber);
        sb.append(", iTelefax=").append(this.iTelefax);
        sb.append(", iUseInvoiceForDelivery=").append(this.iUseInvoiceForDelivery);
        sb.append(", iVatFreeSale=").append(this.iVatFreeSale);
        sb.append(", iVATNumber=").append(this.iVATNumber);
        sb.append(", iYourContactPerson=").append(this.iYourContactPerson);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        JCheckBox jCheckBox;
        SSAdressPanel sSAdressPanel;
        SSAdressPanel sSAdressPanel2;
        JTextPane jTextPane;
        JTextField jTextField;
        JTextField jTextField2;
        JLabel jLabel;
        SSBigDecimalTextField sSBigDecimalTextField;
        SSBigDecimalTextField sSBigDecimalTextField2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JTextField jTextField7;
        JTextField jTextField8;
        JTextField jTextField9;
        JTextField jTextField10;
        JTextField jTextField11;
        JTextField jTextField12;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        JTabbedPane jTabbedPane = new JTabbedPane();
        ((Component)jTabbedPane).setEnabled(true);
        jPanel.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 2, new Insets(4, 4, 4, 4), 4, 4, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("customerframe.panel.1"), null, jPanel2, null);
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(7, 2, new Insets(4, 4, 4, 4), 2, 1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iCustomerNr = jTextField12 = new JTextField();
        jTextField12.setText("A-122145");
        jPanel3.add((Component)jTextField12, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(120, -1), null));
        this.iName = jTextField11 = new JTextField();
        jTextField11.setText("Fribok");
        jPanel3.add((Component)jTextField11, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(300, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("customerframe.name"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("customerframe.customernr"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("customerframe.yourcontact"));
        jPanel3.add((Component)jLabel4, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("book").getString("customerframe.ourcontact"));
        jPanel3.add((Component)jLabel5, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("book").getString("customerframe.vatnr"));
        jPanel3.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, new Dimension(80, -1), null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("book").getString("customerframe.organisationnumber"));
        jPanel3.add((Component)jLabel7, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, new Dimension(80, -1), null, null));
        this.iYourContactPerson = jTextField10 = new JTextField();
        jTextField10.setText("Fribok");
        jPanel3.add((Component)jTextField10, new GridConstraints(6, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.iOurContactPerson = jTextField9 = new JTextField();
        jTextField9.setText("Fribok");
        jPanel3.add((Component)jTextField9, new GridConstraints(5, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.iVATNumber = jTextField8 = new JTextField();
        jTextField8.setText("999999-9999");
        jPanel3.add((Component)jTextField8, new GridConstraints(4, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.iOrginisationNumber = jTextField7 = new JTextField();
        jTextField7.setText("999999-9999");
        jPanel3.add((Component)jTextField7, new GridConstraints(3, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("book").getString("customerframe.email"));
        jPanel3.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, new Dimension(60, -1), null, null));
        this.iEMail = jTextField6 = new JTextField();
        jTextField6.setInheritsPopupMenu(false);
        jTextField6.setText("aa@bb.com");
        jPanel3.add((Component)jTextField6, new GridConstraints(2, 1, 1, 1, 4, 1, 6, 0, null, new Dimension(300, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), 2, 1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("book").getString("customerframe.telefax"));
        jPanel4.add((Component)jLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("book").getString("customerframe.phone"));
        jPanel4.add((Component)jLabel10, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("book").getString("customerframe.phone2"));
        jPanel4.add((Component)jLabel11, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTelefax = jTextField5 = new JTextField();
        jTextField5.setInheritsPopupMenu(false);
        jTextField5.setText("035-18 77 46");
        jPanel4.add((Component)jTextField5, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.iPhone = jTextField4 = new JTextField();
        jTextField4.setInheritsPopupMenu(false);
        jTextField4.setText("035-18 77 46");
        jPanel4.add((Component)jTextField4, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.iPhone2 = jTextField3 = new JTextField();
        jTextField3.setInheritsPopupMenu(false);
        jTextField3.setText("035-18 77 46");
        jPanel4.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.iEuSaleCommodity = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("book").getString("customerframe.eusalecommodity"));
        jPanel5.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iEuSaleYhirdPartCommodity = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("book").getString("customerframe.eusalethirdpartcommodity"));
        jPanel5.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iVatFreeSale = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("book").getString("customerframe.vatfreesale"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iHideUnitPrice = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("D\u00f6lj enhetspris p\u00e5 f\u00f6ljesedel");
        jPanel5.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(3, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("customerframe.panel.2"), null, jPanel6, null);
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(6, 3, new Insets(4, 4, 4, 4), 2, 1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 8, 3, 3, 3, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("book").getString("customerframe.invoicecurrency"));
        jPanel8.add((Component)jLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        SSEditableTableComboBox sSEditableTableComboBox = new SSEditableTableComboBox();
        this.iInvoiceCurrency = sSEditableTableComboBox;
        jPanel8.add(sSEditableTableComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(120, -1), null));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("book").getString("customerframe.paymentterm"));
        jPanel8.add((Component)jLabel13, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SSEditableTableComboBox sSEditableTableComboBox2 = new SSEditableTableComboBox();
        this.iPaymentTerm = sSEditableTableComboBox2;
        jPanel8.add(sSEditableTableComboBox2, new GridConstraints(1, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(120, -1), null));
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("book").getString("customerframe.deliveryterm"));
        jPanel8.add((Component)jLabel14, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SSEditableTableComboBox sSEditableTableComboBox3 = new SSEditableTableComboBox();
        this.iDeliveryTerm = sSEditableTableComboBox3;
        jPanel8.add(sSEditableTableComboBox3, new GridConstraints(2, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(120, -1), null));
        JLabel jLabel15 = new JLabel();
        this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("book").getString("customerframe.delivaryway"));
        jPanel8.add((Component)jLabel15, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SSEditableTableComboBox sSEditableTableComboBox4 = new SSEditableTableComboBox();
        this.iDeliveryWay = sSEditableTableComboBox4;
        jPanel8.add(sSEditableTableComboBox4, new GridConstraints(3, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(120, -1), null));
        JLabel jLabel16 = new JLabel();
        this.$$$loadLabelText$$$(jLabel16, ResourceBundle.getBundle("book").getString("customerframe.creditlimit"));
        jPanel8.add((Component)jLabel16, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iCreditLimit = sSBigDecimalTextField2 = new SSBigDecimalTextField();
        ((JTextComponent)sSBigDecimalTextField2).setText("2.223.245,50");
        jPanel8.add((Component)sSBigDecimalTextField2, new GridConstraints(4, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(150, -1), null));
        JLabel jLabel17 = new JLabel();
        this.$$$loadLabelText$$$(jLabel17, ResourceBundle.getBundle("book").getString("customerframe.discount"));
        jPanel8.add((Component)jLabel17, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDiscount = sSBigDecimalTextField = new SSBigDecimalTextField();
        ((JTextComponent)sSBigDecimalTextField).setText("25.00");
        sSBigDecimalTextField.setInheritsPopupMenu(false);
        jPanel8.add((Component)sSBigDecimalTextField, new GridConstraints(5, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(150, -1), null));
        JLabel jLabel18 = new JLabel();
        jLabel18.setText("%");
        jPanel8.add((Component)jLabel18, new GridConstraints(5, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iCreditLimitCurrency = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel8.add((Component)jLabel, new GridConstraints(4, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(2, 2, new Insets(4, 4, 4, 4), 2, 1, false, false));
        jPanel7.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel19 = new JLabel();
        this.$$$loadLabelText$$$(jLabel19, ResourceBundle.getBundle("book").getString("customerframe.bankaccount"));
        jPanel9.add((Component)jLabel19, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(120, -1), null));
        JLabel jLabel20 = new JLabel();
        this.$$$loadLabelText$$$(jLabel20, ResourceBundle.getBundle("book").getString("customerframe.plusaccount"));
        jPanel9.add((Component)jLabel20, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iBankAccountNumber = jTextField2 = new JTextField();
        jTextField2.setText("999999-9999");
        jPanel9.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.iPlusAccountNumber = jTextField = new JTextField();
        jTextField.setText("999999-9999");
        jPanel9.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel21 = new JLabel();
        jLabel21.setText("Kommentar:");
        jPanel10.add((Component)jLabel21, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel10.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, new Dimension(150, 100), null));
        this.iComment = jTextPane = new JTextPane();
        jScrollPane.setViewportView(jTextPane);
        Spacer spacer4 = new Spacer();
        jPanel6.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(3, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("customerframe.panel.3"), null, jPanel11, null);
        Spacer spacer5 = new Spacer();
        jPanel11.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel11.add((Component)spacer6, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayoutManager(1, 1, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel11.add((Component)jPanel12, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel12.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, null, null));
        this.iInvoiceAddress = sSAdressPanel2 = new SSAdressPanel();
        sSAdressPanel2.setTitle(ResourceBundle.getBundle("book").getString("customerframe.invoiceadress"));
        ((Component)sSAdressPanel2).setEnabled(true);
        jPanel12.add((Component)sSAdressPanel2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridLayoutManager(1, 1, new Insets(4, 4, 4, 4), 0, 0, false, false));
        ((Component)jPanel13).setEnabled(false);
        jPanel11.add((Component)jPanel13, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel13.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "", 0, 0, null, null));
        this.iDeliveryAddress = sSAdressPanel = new SSAdressPanel();
        sSAdressPanel.setTitle(ResourceBundle.getBundle("book").getString("companypanel.deliveryadress"));
        ((Component)sSAdressPanel).setEnabled(false);
        jPanel13.add((Component)sSAdressPanel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.iUseInvoiceForDelivery = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("customerframe.useinvoiceasdelivery"));
        ((Component)jCheckBox).setEnabled(true);
        jPanel11.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

