/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.help.panel.SSHelpPanel;
import se.swedsoft.bookkeeping.gui.help.util.SSHelpHistory;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;

public class SSHelpFrame
extends JFrame {
    private static SSHelpFrame cInstance;
    private HelpSet iHelpSet;
    private JHelpContentViewer iViewer;
    private SSHelpHistory iHistory;
    private SSButton iBackButton;
    private SSButton iForwardButton;

    public static SSHelpFrame getInstance() {
        return cInstance;
    }

    public static void showFrame(SSMainFrame iMainFrame, int pWidth, int pHeight) {
        if (cInstance == null) {
            cInstance = new SSHelpFrame(iMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
    }

    public static void showFrame(SSMainFrame iMainFrame, int pWidth, int pHeight, Class iHelpClass) {
        if (cInstance == null) {
            cInstance = new SSHelpFrame(iMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.setHelpClass(iHelpClass);
    }

    private SSHelpFrame(SSMainFrame iMainFrame, int pWidth, int pHeight) {
        super(SSBundle.getBundle().getString("helpframe.title"));
        this.createHelpSet();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainContent(), "Center");
        this.add((Component)this.getToolBar(), "North");
        this.setSize(pWidth, pHeight);
        this.setLocationRelativeTo(iMainFrame);
    }

    private void createHelpSet() {
        if (this.iHelpSet == null) {
            ClassLoader iClassLoader = SSHelpFrame.class.getClassLoader();
            try {
                URL iHelpSetUrl = HelpSet.findHelpSet(iClassLoader, "jfs.hs");
                this.iHelpSet = new HelpSet(null, iHelpSetUrl);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.setTitle(this.iHelpSet.getTitle());
        this.iViewer = new JHelpContentViewer(this.iHelpSet);
        this.iHistory = new SSHelpHistory(this.iViewer);
    }

    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_HOME", "helpframe.homebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SSHelpFrame.this.iViewer.setCurrentID(SSHelpFrame.this.iHelpSet.getHomeID());
                }
                catch (InvalidHelpSetContextException ex) {
                    ex.printStackTrace();
                }
            }
        });
        toolBar.add(iButton);
        toolBar.addSeparator();
        this.iBackButton = new SSButton("ICON_BACK", "helpframe.prevbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSHelpFrame.this.iHistory.back();
            }
        });
        toolBar.add(this.iBackButton);
        this.iForwardButton = new SSButton("ICON_FORWARD", "helpframe.nextbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSHelpFrame.this.iHistory.forward();
            }
        });
        toolBar.add(this.iForwardButton);
        toolBar.addSeparator();
        this.iHistory.addHistoryListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSHelpFrame.this.iBackButton.setEnabled(SSHelpFrame.this.iHistory.hasPrevious());
                SSHelpFrame.this.iForwardButton.setEnabled(SSHelpFrame.this.iHistory.hasNext());
            }
        });
        this.iBackButton.setEnabled(this.iHistory.hasPrevious());
        this.iForwardButton.setEnabled(this.iHistory.hasNext());
        toolBar.setFloatable(false);
        return toolBar;
    }

    public JComponent getMainContent() {
        try {
            this.iViewer.setCurrentID(this.iHelpSet.getHomeID());
        }
        catch (InvalidHelpSetContextException e) {
            e.printStackTrace();
        }
        SSHelpPanel iHelpPanel = new SSHelpPanel(this.iHelpSet, this.iViewer, this.iViewer.getModel());
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)iHelpPanel.getPanel(), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return iPanel;
    }

    private void setHelpClass(Class pHelpClass) {
        System.out.println(pHelpClass);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.help.SSHelpFrame");
        sb.append("{iBackButton=").append(this.iBackButton);
        sb.append(", iForwardButton=").append(this.iForwardButton);
        sb.append(", iHelpSet=").append(this.iHelpSet);
        sb.append(", iHistory=").append(this.iHistory);
        sb.append(", iViewer=").append(this.iViewer);
        sb.append('}');
        return sb.toString();
    }
}

