/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.help.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;

public class SSHelpHistory {
    private JHelpContentViewer iViewer;
    private List<HelpModelEvent> iHistory;
    private int iIndex;
    private boolean iUpdating;
    private List<ActionListener> iListeners;

    public SSHelpHistory(JHelpContentViewer pViewer) {
        this.iViewer = pViewer;
        this.iHistory = new LinkedList<HelpModelEvent>();
        this.iIndex = 0;
        this.iUpdating = false;
        this.iListeners = new LinkedList<ActionListener>();
        this.iViewer.addHelpModelListener(new HelpModelListener(){

            @Override
            public void idChanged(HelpModelEvent helpModelEvent) {
                SSHelpHistory.this.addHistoryEvent(helpModelEvent);
            }
        });
    }

    public void addHistoryListener(ActionListener iListener) {
        this.iListeners.add(iListener);
    }

    private void notifyListeners() {
        ActionEvent iEvent = new ActionEvent(this, 0, "");
        for (ActionListener iListener : this.iListeners) {
            iListener.actionPerformed(iEvent);
        }
    }

    private void addHistoryEvent(HelpModelEvent pEvent) {
        if (this.iUpdating) {
            return;
        }
        this.iHistory = this.iHistory.subList(0, this.iIndex);
        this.iHistory.add(pEvent);
        this.iIndex = this.iHistory.size();
        this.notifyListeners();
    }

    public boolean hasNext() {
        return this.getNext() != null;
    }

    public boolean hasPrevious() {
        return this.getPrevious() != null;
    }

    public void back() {
        --this.iIndex;
        this.navigate();
    }

    public void forward() {
        ++this.iIndex;
        this.navigate();
    }

    private void navigate() {
        this.iUpdating = true;
        HelpModelEvent iEvent = this.getCurrent();
        try {
            if (iEvent != null) {
                this.iViewer.setCurrentID(iEvent.getID());
                this.notifyListeners();
            }
        }
        catch (InvalidHelpSetContextException e) {
            e.printStackTrace();
        }
        this.iUpdating = false;
    }

    private void setUpdating(boolean pUpdating) {
        this.iUpdating = pUpdating;
    }

    private HelpModelEvent getCurrent() {
        int theIndex = this.iIndex - 1;
        if (theIndex > 0 && theIndex < this.iHistory.size()) {
            return this.iHistory.get(theIndex);
        }
        return null;
    }

    private HelpModelEvent getNext() {
        int theIndex = this.iIndex;
        if (theIndex > 0 && theIndex < this.iHistory.size()) {
            return this.iHistory.get(theIndex);
        }
        return null;
    }

    private HelpModelEvent getPrevious() {
        int theIndex = this.iIndex - 2;
        if (theIndex > 0 && theIndex < this.iHistory.size()) {
            return this.iHistory.get(theIndex);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSHelpHistory {\n");
        int iCounter = 0;
        for (HelpModelEvent iEvent : this.iHistory) {
            if (iCounter == this.iIndex) {
                sb.append(" *");
            } else {
                sb.append("  ");
            }
            sb.append(iEvent.getID());
            sb.append(", ");
            sb.append(iEvent.getHistoryName());
            sb.append('\n');
            ++iCounter;
        }
        sb.append("}\n");
        return sb.toString();
    }
}

