/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.indelivery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSIndelivery;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.indelivery.SSIndeliveryDialog;
import se.swedsoft.bookkeeping.gui.indelivery.util.SSIndeliveryTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSIndeliveryFrame
extends SSDefaultTableFrame {
    private static SSIndeliveryFrame cInstance;
    private SSTable iTable;
    private SSIndeliveryTableModel iModel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSIndeliveryFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
    }

    public static SSIndeliveryFrame getInstance() {
        return cInstance;
    }

    private SSIndeliveryFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("indeliveryframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "indeliveryframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSIndeliveryDialog.newDialog(SSIndeliveryFrame.this.getMainFrame(), SSIndeliveryFrame.this.iModel);
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "indeliveryframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSIndelivery iIndelivery = (SSIndelivery)SSIndeliveryFrame.this.iModel.getSelectedRow(SSIndeliveryFrame.this.iTable);
                Integer iNumber = null;
                if (iIndelivery != null) {
                    iNumber = iIndelivery.getNumber();
                    iIndelivery = SSIndeliveryFrame.this.getIndelivery(iIndelivery);
                }
                if (iIndelivery != null) {
                    SSIndeliveryDialog.editDialog(SSIndeliveryFrame.this.getMainFrame(), iIndelivery, SSIndeliveryFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSIndeliveryFrame.this.getMainFrame(), "indeliveryframe.indeliverygone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "indeliveryframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSIndelivery iIndelivery = (SSIndelivery)SSIndeliveryFrame.this.iModel.getSelectedRow(SSIndeliveryFrame.this.iTable);
                Integer iNumber = null;
                if (iIndelivery != null) {
                    iNumber = iIndelivery.getNumber();
                    iIndelivery = SSIndeliveryFrame.this.getIndelivery(iIndelivery);
                }
                if (iIndelivery != null) {
                    SSIndeliveryDialog.copyDialog(SSIndeliveryFrame.this.getMainFrame(), iIndelivery, SSIndeliveryFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSIndeliveryFrame.this.getMainFrame(), "indeliveryframe.indeliverygone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "indeliveryframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSIndeliveryFrame.this.iTable.getSelectedRows();
                List toDelete = SSIndeliveryFrame.this.iModel.getObjects(selected);
                SSIndeliveryFrame.this.deleteSelected(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        SSMenuButton iMenuButton = new SSMenuButton("ICON_PRINT", "indeliveryframe.printbutton");
        iMenuButton.add("indeliveryframe.print.list", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.IndeliveryList(SSIndeliveryFrame.this.getMainFrame());
            }
        });
        toolBar.add(iMenuButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSIndeliveryTableModel();
        this.iModel.addColumn(SSIndeliveryTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSIndeliveryTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSIndeliveryTableModel.COLUMN_TEXT);
        this.iModel.addColumn(SSIndeliveryTableModel.COLUMN_TOTALCOUNT);
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSIndelivery iIndelivery = (SSIndelivery)SSIndeliveryFrame.this.iModel.getSelectedRow(SSIndeliveryFrame.this.iTable);
                if (iIndelivery == null) {
                    return;
                }
                Integer iNumber = iIndelivery.getNumber();
                iIndelivery = SSIndeliveryFrame.this.getIndelivery(iIndelivery);
                if (iIndelivery != null) {
                    SSIndeliveryDialog.editDialog(SSIndeliveryFrame.this.getMainFrame(), iIndelivery, SSIndeliveryFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSIndeliveryFrame.this.getMainFrame(), "indeliveryframe.indeliverygone", iNumber);
                }
            }
        });
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public SSIndeliveryTableModel getModel() {
        return this.iModel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    private void deleteSelected(List<SSIndelivery> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "indeliveryframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSIndelivery iIndelivery : delete) {
                if (SSPostLock.isLocked("indelivery" + iIndelivery.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "indeliveryframe.indeliveryopen", iIndelivery.getNumber());
                    continue;
                }
                SSDB.getInstance().deleteIndelivery(iIndelivery);
            }
        }
    }

    private SSIndelivery getIndelivery(SSIndelivery iIndelivery) {
        return SSDB.getInstance().getIndelivery(iIndelivery);
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getIndeliveries());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.indelivery.SSIndeliveryFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

