/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.inpayment.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSInpaymentMath;
import se.swedsoft.bookkeeping.data.SSInpayment;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSDateCellRenderer;

public class SSInpaymentTableModel
extends SSDefaultTableModel<SSInpayment> {
    public SSInpaymentTableModel() {
        this(SSDB.getInstance().getInpayments());
    }

    public SSInpaymentTableModel(List<SSInpayment> pObjects) {
        super(pObjects);
        this.addColumn(SSBundle.getBundle().getString("inpaymenttable.column.1"));
        this.addColumn(SSBundle.getBundle().getString("inpaymenttable.column.2"));
        this.addColumn(SSBundle.getBundle().getString("inpaymenttable.column.3"));
        this.addColumn(SSBundle.getBundle().getString("inpaymenttable.column.4"));
    }

    @Override
    public Class getType() {
        return SSProduct.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SSInpayment iInpayment = (SSInpayment)this.getObject(rowIndex);
        Object value = null;
        switch (columnIndex) {
            case 0: {
                value = iInpayment.getNumber();
                break;
            }
            case 1: {
                value = iInpayment.getDate();
                break;
            }
            case 2: {
                value = iInpayment.getText();
                break;
            }
            case 3: {
                value = SSInpaymentMath.getSum(iInpayment);
            }
        }
        return value;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Date.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return BigDecimal.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    public static void setupTable(SSTable iTable) {
        iTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        iTable.getColumnModel().getColumn(1).setPreferredWidth(110);
        iTable.getColumnModel().getColumn(2).setPreferredWidth(470);
        iTable.getColumnModel().getColumn(3).setPreferredWidth(95);
        iTable.setDefaultRenderer(Date.class, new SSDateCellRenderer());
        iTable.setDefaultRenderer(BigDecimal.class, new SSBigDecimalCellRenderer(2));
    }
}

