/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.invoice;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.common.SSInvoiceType;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.invoice.dialog.SSInvoiceTypeDialog;
import se.swedsoft.bookkeeping.gui.invoice.panel.SSInvoicePanel;
import se.swedsoft.bookkeeping.gui.invoice.util.SSInvoiceTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;

public class SSInvoiceDialog {
    private SSInvoiceDialog() {
    }

    public static void newDialog(final SSMainFrame iMainFrame, final SSInvoiceTableModel pModel) {
        final SSDialog iDialog = new SSDialog(iMainFrame, SSBundle.getBundle().getString("invoiceframe.new.title"));
        SSInvoiceType iInvoiceType = SSInvoiceTypeDialog.showDialog(iMainFrame);
        if (iInvoiceType == null) {
            return;
        }
        final SSInvoicePanel iPanel = new SSInvoicePanel(iDialog);
        iPanel.setInvoice(new SSInvoice(iInvoiceType));
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoice iInvoice = iPanel.getInvoice();
                SSDB.getInstance().addInvoice(iInvoice);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSInvoiceMath.addCustomerAndProducts(iInvoice);
                }
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "invoiceframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.showDialog();
    }

    public static void editDialog(final SSMainFrame iMainFrame, SSInvoice iInvoice, final SSInvoiceTableModel pModel) {
        final String lockString = "invoice" + iInvoice.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "invoiceframe.invoiceopen", iInvoice.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, SSBundle.getBundle().getString("invoiceframe.edit.title"));
        final SSInvoicePanel iPanel = new SSInvoicePanel(iDialog);
        iPanel.setInvoice(new SSInvoice(iInvoice));
        iPanel.setSavecustomerandproductsSelected(false);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoice iInvoice = iPanel.getInvoice();
                SSDB.getInstance().updateInvoice(iInvoice);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSInvoiceMath.addCustomerAndProducts(iInvoice);
                }
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "invoiceframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void copyDialog(final SSMainFrame iMainFrame, SSInvoice iInvoice, final SSInvoiceTableModel pModel) {
        String lockString = "invoice" + iInvoice.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (SSPostLock.isLocked(lockString)) {
            new SSErrorDialog(iMainFrame, "invoiceframe.invoiceopen", iInvoice.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, SSBundle.getBundle().getString("invoiceframe.copy.title"));
        final SSInvoicePanel iPanel = new SSInvoicePanel(iDialog);
        SSInvoice iNew = new SSInvoice(iInvoice);
        iNew.setNumber(null);
        iNew.setDate(new Date());
        iNew.setDueDate();
        iNew.setEntered(false);
        iNew.setPrinted(false);
        iNew.setInterestInvoiced(false);
        iNew.setOCRNumber(null);
        iNew.setNumRemainders(0);
        iPanel.setInvoice(iNew);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoice iInvoice = iPanel.getInvoice();
                SSDB.getInstance().addInvoice(iInvoice);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSInvoiceMath.addCustomerAndProducts(iInvoice);
                }
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "invoiceframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void newDialog(final SSMainFrame iMainFrame, SSInvoice iInvoice, final List<SSOrder> iOrders, AbstractTableModel pModel) {
        final String lockString = "ordertoinvoice" + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "invoiceframe.ordertoinvoiceopen", iInvoice.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, SSBundle.getBundle().getString("invoiceframe.new.title"));
        final SSInvoicePanel iPanel = new SSInvoicePanel(iDialog);
        iInvoice.setDueDate();
        iInvoice.setEntered(false);
        iInvoice.setPrinted(false);
        iPanel.setInvoice(new SSInvoice(iInvoice));
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoice iInvoice = iPanel.getInvoice();
                SSDB.getInstance().addInvoice(iInvoice);
                for (SSOrder iOrder : iOrders) {
                    if (!SSDB.getInstance().getOrders().contains(iOrder)) continue;
                    iOrder.setInvoice(iInvoice);
                    SSDB.getInstance().updateOrder(iOrder);
                }
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSInvoiceMath.addCustomerAndProducts(iInvoice);
                }
                iPanel.dispose();
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iDialog.closeDialog();
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "invoiceframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }
}

