/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.invoice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.calc.math.SSCustomerMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSPeriodicInvoiceMath;
import se.swedsoft.bookkeeping.data.SSInpayment;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSMail;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.creditinvoice.SSCreditInvoiceDialog;
import se.swedsoft.bookkeeping.gui.creditinvoice.SSCreditInvoiceFrame;
import se.swedsoft.bookkeeping.gui.inpayment.SSInpaymentDialog;
import se.swedsoft.bookkeeping.gui.inpayment.SSInpaymentFrame;
import se.swedsoft.bookkeeping.gui.invoice.SSInvoiceDialog;
import se.swedsoft.bookkeeping.gui.invoice.dialog.SSInterestInvoiceDialog;
import se.swedsoft.bookkeeping.gui.invoice.panel.SSInvoiceSearchPanel;
import se.swedsoft.bookkeeping.gui.invoice.util.SSInvoiceTableModel;
import se.swedsoft.bookkeeping.gui.periodicinvoice.SSPeriodicInvoiceDialog;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.components.SSTabbedPanePanel;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSConfirmDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSInvoiceFrame
extends SSDefaultTableFrame {
    private static SSInvoiceFrame cInstance;
    private JTabbedPane iTabbedPane;
    private SSTable iTable;
    private SSInvoiceTableModel iModel;
    private SSInvoiceSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSInvoiceFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
        if (SSPeriodicInvoiceMath.hasPendingPeriodicInvoices() && new SSConfirmDialog("periodicinvoiceframe.pendingperiodicinvoices").openDialog(pMainFrame) == 0 && SSPeriodicInvoiceDialog.pendingPeriodicInvoicesDialog(pMainFrame)) {
            SSPostLock.removeLock("periodicinvoicepending" + SSDB.getInstance().getCurrentCompany().getId());
        }
    }

    public static SSInvoiceFrame getInstance() {
        return cInstance;
    }

    private SSInvoiceFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("invoiceframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "invoiceframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoiceDialog.newDialog(SSInvoiceFrame.this.getMainFrame(), SSInvoiceFrame.this.iModel);
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "invoiceframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoice iSelected = (SSInvoice)SSInvoiceFrame.this.iModel.getSelectedRow(SSInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSInvoiceFrame.this.getInvoice(iSelected);
                }
                if (iSelected != null) {
                    SSInvoiceDialog.editDialog(SSInvoiceFrame.this.getMainFrame(), iSelected, SSInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSInvoiceFrame.this.getMainFrame(), "invoiceframe.invoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "invoiceframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoice iSelected = (SSInvoice)SSInvoiceFrame.this.iModel.getSelectedRow(SSInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSInvoiceFrame.this.getInvoice(iSelected);
                }
                if (iSelected != null) {
                    SSInvoiceDialog.copyDialog(SSInvoiceFrame.this.getMainFrame(), iSelected, SSInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSInvoiceFrame.this.getMainFrame(), "invoiceframe.invoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "invoiceframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSInvoiceFrame.this.iTable.getSelectedRows();
                List toDelete = SSInvoiceFrame.this.iModel.getObjects(selected);
                SSInvoiceFrame.this.deleteSelectedInvoice(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_COINS24", "invoiceframe.inpaymentbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SSInvoiceFrame.this.iTable.getSelectedRowCount() > 0) {
                    List iSelected = SSInvoiceFrame.this.iModel.getObjects(SSInvoiceFrame.this.iTable.getSelectedRows());
                    iSelected = SSInvoiceFrame.this.getInvoices(iSelected);
                    SSInpayment iInpayment = new SSInpayment();
                    if (!iSelected.isEmpty()) {
                        iInpayment.addInvoices(iSelected);
                        if (SSInpaymentFrame.getInstance() != null) {
                            SSInpaymentDialog.newDialog(SSInvoiceFrame.this.getMainFrame(), iInpayment, SSInpaymentFrame.getInstance().getModel());
                        } else {
                            SSInpaymentDialog.newDialog(SSInvoiceFrame.this.getMainFrame(), iInpayment, null);
                        }
                    }
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        iButton = new SSButton("ICON_CREATECHANGE", "invoiceframe.creditinvoicebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoice iSelected = (SSInvoice)SSInvoiceFrame.this.iModel.getSelectedRow(SSInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSInvoiceFrame.this.getInvoice(iSelected);
                }
                if (iSelected != null) {
                    if (SSCreditInvoiceFrame.getInstance() != null) {
                        SSCreditInvoiceDialog.newDialog(SSInvoiceFrame.this.getMainFrame(), iSelected, SSCreditInvoiceFrame.getInstance().getModel());
                    } else {
                        SSCreditInvoiceDialog.newDialog(SSInvoiceFrame.this.getMainFrame(), iSelected, null);
                    }
                } else {
                    new SSErrorDialog(SSInvoiceFrame.this.getMainFrame(), "invoiceframe.invoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        iButton = new SSButton("ICON_EXCLAMATION24", "invoiceframe.reminderbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSInvoiceFrame.this.iModel.getObjects(SSInvoiceFrame.this.iTable.getSelectedRows());
                if (!(iSelected = SSInvoiceFrame.this.getInvoices(iSelected)).isEmpty()) {
                    SSReportFactory.ReminderReport(SSInvoiceFrame.this.getMainFrame(), iSelected);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        iButton = new SSButton("ICON_INVOICE24", "invoiceframe.interestinvoicebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInterestInvoiceDialog.showDialog(SSInvoiceFrame.this.getMainFrame(), SSInvoiceFrame.this.iModel);
            }
        });
        toolBar.add(iButton);
        toolBar.addSeparator();
        SSMenuButton iMenuButton = new SSMenuButton("ICON_PRINT", "invoiceframe.printbutton");
        JMenuItem iMenuItem = iMenuButton.add("invoiceframe.print.invoicereport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSInvoiceFrame.this.iModel.getSelectedRows(SSInvoiceFrame.this.iTable);
                if (!(iSelected = SSInvoiceFrame.this.getInvoices(iSelected)).isEmpty()) {
                    SSReportFactory.InvoiceReport(SSInvoiceFrame.this.getMainFrame(), iSelected);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuItem = iMenuButton.add("invoiceframe.print.emailinvoicereport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoice iSelected = (SSInvoice)SSInvoiceFrame.this.iModel.getSelectedRow(SSInvoiceFrame.this.iTable);
                if ((iSelected = SSInvoiceFrame.this.getInvoice(iSelected)) == null) {
                    return;
                }
                if (!SSMail.isOk(iSelected.getCustomer())) {
                    return;
                }
                SSReportFactory.EmailInvoiceReport(SSInvoiceFrame.this.getMainFrame(), iSelected);
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuItem = iMenuButton.add("invoiceframe.print.reminder", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSInvoiceFrame.this.iModel.getObjects(SSInvoiceFrame.this.iTable.getSelectedRows());
                if (!(iSelected = SSInvoiceFrame.this.getInvoices(iSelected)).isEmpty()) {
                    SSReportFactory.ReminderReport(SSInvoiceFrame.this.getMainFrame(), iSelected);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuButton.addSeparator();
        iMenuItem = iMenuButton.add("invoiceframe.print.ocrinvoicereport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSInvoiceFrame.this.iModel.getSelectedRows(SSInvoiceFrame.this.iTable);
                if (!(iSelected = SSInvoiceFrame.this.getInvoices(iSelected)).isEmpty()) {
                    SSReportFactory.OCRInvoiceReport(SSInvoiceFrame.this.getMainFrame(), iSelected);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuButton.addSeparator();
        iMenuButton.add("invoiceframe.print.invoicelistreport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.InvoiceListReport(SSInvoiceFrame.this.getMainFrame());
            }
        });
        toolBar.add(iMenuButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSInvoiceTableModel();
        this.iModel.addColumn(SSInvoiceTableModel.COLUMN_PRINTED);
        this.iModel.addColumn(SSInvoiceTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSInvoiceTableModel.COLUMN_TYPE);
        this.iModel.addColumn(SSInvoiceTableModel.COLUMN_CUSTOMER_NR);
        this.iModel.addColumn(SSInvoiceTableModel.COLUMN_CUSTOMER_NAME);
        this.iModel.addColumn(SSInvoiceTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSInvoiceTableModel.COLUMN_DUEDATE);
        this.iModel.addColumn(SSInvoiceTableModel.COLUMN_NET_SUM);
        this.iModel.addColumn(SSInvoiceTableModel.COLUMN_CURRENCY);
        this.iModel.addColumn(SSInvoiceTableModel.COLUMN_CURRENCY_RATE);
        this.iModel.addColumn(SSInvoiceTableModel.COLUMN_TOTAL_SUM);
        this.iModel.addColumn(SSInvoiceTableModel.getSaldoColumn());
        this.iModel.addColumn(SSInvoiceTableModel.COLUMN_REMINDERS);
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoice iSelected = (SSInvoice)SSInvoiceFrame.this.iModel.getSelectedRow(SSInvoiceFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                Integer iNumber = iSelected.getNumber();
                iSelected = SSInvoiceFrame.this.getInvoice(iSelected);
                if (iSelected != null) {
                    SSInvoiceDialog.editDialog(SSInvoiceFrame.this.getMainFrame(), iSelected, SSInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSInvoiceFrame.this.getMainFrame(), "invoiceframe.invoicegone", iNumber);
                }
            }
        });
        this.iTabbedPane = new JTabbedPane();
        this.iTabbedPane.add(SSBundle.getBundle().getString("invoiceframe.filter.1"), new SSTabbedPanePanel());
        this.iTabbedPane.add(SSBundle.getBundle().getString("invoiceframe.filter.2"), new SSTabbedPanePanel());
        this.iTabbedPane.add(SSBundle.getBundle().getString("invoiceframe.filter.3"), new SSTabbedPanePanel());
        this.iTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SSInvoiceFrame.this.iSearchPanel.ApplyFilter(SSDB.getInstance().getInvoices());
            }
        });
        JPanel iPanel = new JPanel();
        this.iSearchPanel = new SSInvoiceSearchPanel(this.iModel);
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)this.iTabbedPane, "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public void setFilterIndex(int index, List<SSInvoice> iInvoices) {
        JPanel iPanel = (JPanel)this.iTabbedPane.getComponentAt(index);
        iPanel.removeAll();
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        List<Object> iFiltered = Collections.emptyList();
        switch (index) {
            case 0: {
                iFiltered = iInvoices;
                break;
            }
            case 1: {
                iFiltered = new LinkedList();
                for (SSInvoice iInvoice : iInvoices) {
                    if (!SSInvoiceMath.iSaldoMap.containsKey(iInvoice.getNumber()) || SSInvoiceMath.iSaldoMap.get(iInvoice.getNumber()).signum() == 0) continue;
                    iFiltered.add(iInvoice);
                }
                break;
            }
            case 2: {
                iFiltered = new LinkedList();
                for (SSInvoice iInvoice : iInvoices) {
                    if (!SSInvoiceMath.iSaldoMap.containsKey(iInvoice.getNumber()) || SSInvoiceMath.iSaldoMap.get(iInvoice.getNumber()).signum() == 0 || !SSInvoiceMath.expired(iInvoice)) continue;
                    iFiltered.add(iInvoice);
                }
                break;
            }
        }
        this.iModel.setObjects(iFiltered);
        this.iTabbedPane.repaint();
    }

    public SSInvoiceTableModel getModel() {
        return this.iModel;
    }

    public JTabbedPane getTabbedPane() {
        return this.iTabbedPane;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    private void deleteSelectedInvoice(List<SSInvoice> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "invoiceframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSInvoice iInvoice : delete) {
                if (SSPostLock.isLocked("invoice" + iInvoice.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "invoiceframe.invoiceopen", iInvoice.getNumber());
                    continue;
                }
                LinkedList<SSOrder> iOrdersToUpdate = new LinkedList<SSOrder>();
                for (SSOrder iOrder : SSDB.getInstance().getOrders()) {
                    if (!iOrder.hasInvoice(iInvoice)) continue;
                    iOrder.setInvoice(null);
                    iOrdersToUpdate.add(iOrder);
                }
                for (SSOrder iOrder : iOrdersToUpdate) {
                    SSDB.getInstance().updateOrder(iOrder);
                }
                iOrdersToUpdate = null;
                int iIndex = SSCustomerMath.iInvoicesForCustomers.get(iInvoice.getCustomerNr()).indexOf(iInvoice);
                if (iIndex != -1) {
                    SSCustomerMath.iInvoicesForCustomers.get(iInvoice.getCustomerNr()).remove(iIndex);
                }
                SSDB.getInstance().deleteInvoice(iInvoice);
            }
        }
    }

    private SSInvoice getInvoice(SSInvoice iInvoice) {
        return SSDB.getInstance().getInvoice(iInvoice);
    }

    private List<SSInvoice> getInvoices(List<SSInvoice> iInvoices) {
        return SSDB.getInstance().getInvoices(iInvoices);
    }

    public static void fireTableDataChanged() {
        if (cInstance != null) {
            SSInvoiceFrame.cInstance.iModel.fireTableDataChanged();
        }
    }

    public void updateFrame() {
        this.iSearchPanel.ApplyFilter(SSDB.getInstance().getInvoices());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.invoice.SSInvoiceFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTabbedPane=").append(this.iTabbedPane);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

