/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.invoice.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.invoice.panel.SSInterestInvoicePanel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;

public class SSInterestInvoiceDialog {
    private static ResourceBundle bundle = SSBundle.getBundle();

    private SSInterestInvoiceDialog() {
    }

    public static void showDialog(SSMainFrame iMainFrame, final AbstractTableModel pModel) {
        final String lockString = "interestinvoice" + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "interestinvoice.open");
            return;
        }
        List<SSInvoice> iRows = SSInterestInvoicePanel.getRows();
        if (iRows.isEmpty()) {
            SSPostLock.removeLock(lockString);
            new SSInformationDialog(iMainFrame, "interestinvoice.noinvoices");
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("invoiceframe.interestinvoice.title"));
        final SSInterestInvoicePanel iPanel = new SSInterestInvoicePanel(iRows);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        iPanel.addOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SSInvoice> iInterestInvoices = iPanel.getInterestInvoices();
                for (SSInvoice iInvoice : iInterestInvoices) {
                    SSDB.getInstance().addInvoice(iInvoice);
                }
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        });
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock(lockString);
                iDialog.setVisible(false);
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SSPostLock.removeLock(lockString);
            }
        });
        iDialog.setSize(900, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }
}

