/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.invoice.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSProductMath;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.company.panel.SSAdressPanel;
import se.swedsoft.bookkeeping.gui.company.panel.SSDefaultAccountPanel;
import se.swedsoft.bookkeeping.gui.customer.util.SSCustomerTableModel;
import se.swedsoft.bookkeeping.gui.invoice.util.SSInvoiceRowTableModel;
import se.swedsoft.bookkeeping.gui.tender.dialog.SSExchangeRateDialog;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonGroup;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSInputVerifier;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSCurrencyTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDeliveryTermTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDeliveryWayTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSPaymentTermTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSDeleteAction;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSTraversalAction;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSTaxCodeCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSTaxCodeCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherRowTableModelOld;

public class SSInvoicePanel {
    private SSInvoice iInvoice;
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JFormattedTextField iNumber;
    private JTextField iOrders;
    private SSBigDecimalTextField iCurrencyRate;
    private SSDateChooser iDate;
    private SSTableComboBox<SSCustomer> iCustomer;
    private JTextField iCustomerName;
    private JCheckBox iTaxFree;
    private SSBigDecimalTextField iDelayInterest;
    private SSAdressPanel iDeliveryAddress;
    private SSAdressPanel iInvoiceAddress;
    private JTextArea iText;
    private JTextField iYourContactPerson;
    private JTextField iOurContactPerson;
    private SSBigDecimalTextField iTaxRate1;
    private SSBigDecimalTextField iTaxRate2;
    private SSBigDecimalTextField iTaxRate3;
    private JTextField iYourOrderNumber;
    private JCheckBox iEuSaleCommodity;
    private JCheckBox iEuSaleYhirdPartCommodity;
    private SSEditableTableComboBox<SSDeliveryWay> iDeliveryWay;
    private SSEditableTableComboBox<SSDeliveryTerm> iDeliveryTerm;
    private SSEditableTableComboBox<SSPaymentTerm> iPaymentTerm;
    private SSEditableTableComboBox<SSCurrency> iCurrency;
    private SSTable iTable;
    private SSDefaultAccountPanel iDefaultAccounts;
    private SSButton iCurrencyCalculatorButton;
    private SSBigDecimalTextField iNetSum;
    private SSBigDecimalTextField iTaxSum1;
    private SSBigDecimalTextField iTaxSum2;
    private SSBigDecimalTextField iTaxSum3;
    private SSBigDecimalTextField iRoundingSum;
    private SSBigDecimalTextField iTotalSum;
    private JLabel iTaxLabel1;
    private JLabel iTaxLabel2;
    private JLabel iTaxLabel3;
    private JCheckBox iSavecustomerandproducts;
    private SSInvoiceRowTableModel iModel;
    private SSTable iVoucherTable;
    private SSVoucherRowTableModelOld iVoucherTableModel;
    private SSDateChooser iPaymentDay;
    private JButton iRefreshVoucher;
    private JCheckBox iEntered;
    private JCheckBox iPrinted;
    private JCheckBox isStockInfluencing;
    private JCheckBox iInterestInvoiced;
    private JTextField iOCRNumber;
    private SSInputVerifier iInputVerifier;
    private JCheckBox iUseInvoiceForDelivery;

    public SSInvoicePanel(final SSDialog iOwner) {
        this.$$$setupUI$$$();
        this.iNumber.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("0"))));
        this.iNumber.setHorizontalAlignment(4);
        this.iUseInvoiceForDelivery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoicePanel.this.iDeliveryAddress.setEnabled(!SSInvoicePanel.this.iUseInvoiceForDelivery.isSelected());
            }
        });
        this.iTable.setColorReadOnly(true);
        this.iTable.setColumnSortingEnabled(false);
        this.iModel = new SSInvoiceRowTableModel();
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_PRODUCT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_DESCRIPTION, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_UNITPRICE, true);
        this.iModel.addColumn(new ContributionRateColumn(), false);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_QUANTITY, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_UNIT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_DISCOUNT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_SUM, false);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_TAX, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_ACCOUNT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_PROJECT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_RESULTUNIT, true);
        this.iModel.setupTable(this.iTable);
        this.iModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SSInvoicePanel.this.updateSumFields();
            }
        });
        this.iVoucherTableModel = new SSVoucherRowTableModelOld(false, true);
        this.iVoucherTable.setModel(this.iVoucherTableModel);
        SSVoucherRowTableModelOld.setupTable(this.iVoucherTable, this.iVoucherTableModel);
        this.iCustomer.setModel(SSCustomerTableModel.getDropDownModel());
        this.iCustomer.setSearchColumns(0, 1);
        this.iCustomer.setAllowCustomValues(true);
        this.iCustomer.addSelectionListener(new SSSelectionListener<SSCustomer>(){

            @Override
            public void selected(SSCustomer selected) {
                if (selected != null) {
                    SSInvoicePanel.this.iModel.setCustomer(selected);
                    SSInvoicePanel.this.iInvoice.setCustomer(selected);
                    SSInvoicePanel.this.iInvoice.setDueDate();
                    SSInvoicePanel.this.iInvoice.setCurrencyRate(selected.getInvoiceCurrency() == null ? new BigDecimal(1) : selected.getInvoiceCurrency().getExchangeRate());
                    if (selected.getDiscount() != null) {
                        for (SSSaleRow iRow : SSInvoicePanel.this.iModel.getObjects()) {
                            iRow.setDiscount(selected.getDiscount().doubleValue() == new BigDecimal(0).doubleValue() ? null : selected.getDiscount());
                        }
                    }
                    SSInvoicePanel.this.setInvoice(SSInvoicePanel.this.iInvoice);
                }
            }
        });
        new SSTraversalAction(this.iTable){

            @Override
            protected Point doTraversal(Point iPosition) {
                if (iPosition.x <= 4) {
                    ++iPosition.x;
                }
                if (iPosition.x == 5) {
                    ++iPosition.y;
                    iPosition.x = 0;
                    if (iPosition.y == SSInvoicePanel.this.iModel.getRowCount()) {
                        SSInvoicePanel.this.iButtonPanel.getOkButton().requestFocus();
                        return null;
                    }
                }
                return iPosition;
            }
        };
        new SSDeleteAction(this.iTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSSaleRow iSelected = (SSSaleRow)SSInvoicePanel.this.iModel.getSelectedRow(SSInvoicePanel.this.iTable);
                if (iSelected != null) {
                    SSQueryDialog dialog = new SSQueryDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "tenderframe.deleterow", iSelected.toString());
                    if (dialog.getResponce() != 0) {
                        return null;
                    }
                    SSInvoicePanel.this.iModel.deleteRow(iSelected);
                }
                return iPosition;
            }
        };
        this.iCurrency.getComboBox().setModel(SSCurrencyTableModel.getDropDownModel());
        this.iCurrency.getComboBox().setSearchColumns(0);
        this.iCurrency.setEditingFactory(SSCurrencyTableModel.getEditingFactory(iOwner));
        this.iCurrency.getComboBox().addSelectionListener(new SSSelectionListener<SSCurrency>(){

            @Override
            public void selected(SSCurrency selected) {
                if (selected != null) {
                    SSInvoicePanel.this.iCurrencyRate.setValue(selected.getExchangeRate());
                }
                SSInvoicePanel.this.iModel.fireTableDataChanged();
            }
        });
        this.iCurrencyRate.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SSInvoicePanel.this.iInvoice.setCurrencyRate(SSInvoicePanel.this.iCurrencyRate.getValue());
                SSInvoicePanel.this.updateSumFields();
            }
        });
        this.iDeliveryWay.getComboBox().setModel(SSDeliveryWayTableModel.getDropDownModel());
        this.iDeliveryWay.getComboBox().setSearchColumns(0);
        this.iDeliveryWay.setEditingFactory(SSDeliveryWayTableModel.getEditingFactory(iOwner));
        this.iDeliveryTerm.getComboBox().setModel(SSDeliveryTermTableModel.getDropDownModel());
        this.iDeliveryTerm.getComboBox().setSearchColumns(0);
        this.iDeliveryTerm.setEditingFactory(SSDeliveryTermTableModel.getEditingFactory(iOwner));
        this.iPaymentTerm.getComboBox().setModel(SSPaymentTermTableModel.getDropDownModel());
        this.iPaymentTerm.getComboBox().setSearchColumns(0);
        this.iPaymentTerm.setEditingFactory(SSPaymentTermTableModel.getEditingFactory(iOwner));
        this.iPaymentTerm.getComboBox().addSelectionListener(new SSSelectionListener<SSPaymentTerm>(){

            @Override
            public void selected(SSPaymentTerm selected) {
                if (selected != null) {
                    SSInvoicePanel.this.iPaymentDay.setDate(selected.addDaysToDate(new Date()));
                }
            }
        });
        this.iTaxRate1.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSInvoicePanel.this.iInvoice.setTaxRate1(SSInvoicePanel.this.iTaxRate1.getValue());
                SSInvoicePanel.this.updateTaxTexts();
                SSInvoicePanel.this.updateSumFields();
            }
        });
        this.iTaxRate2.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSInvoicePanel.this.iInvoice.setTaxRate2(SSInvoicePanel.this.iTaxRate2.getValue());
                SSInvoicePanel.this.updateTaxTexts();
                SSInvoicePanel.this.updateSumFields();
            }
        });
        this.iTaxRate3.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSInvoicePanel.this.iInvoice.setTaxRate3(SSInvoicePanel.this.iTaxRate3.getValue());
                SSInvoicePanel.this.updateTaxTexts();
                SSInvoicePanel.this.updateSumFields();
            }
        });
        this.iTaxFree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSInvoicePanel.this.iInvoice.setTaxFree(SSInvoicePanel.this.iTaxFree.isSelected());
                SSInvoicePanel.this.updateSumFields();
            }
        });
        this.iCurrencyCalculatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCurrency iCompanyCurrency = SSDB.getInstance().getCurrentCompany().getCurrency();
                SSCurrency iCurrentCurrency = (SSCurrency)SSInvoicePanel.this.iCurrency.getSelected();
                if (iCompanyCurrency == null || iCurrentCurrency == null) {
                    new SSInformationDialog(iOwner, "invoiceframe.selectcurrency");
                    return;
                }
                SSExchangeRateDialog.showDialog(iOwner, SSInvoicePanel.this.iInvoice, iCompanyCurrency, iCurrentCurrency, SSInvoicePanel.this.iModel);
            }
        });
        this.iRefreshVoucher.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucher iVoucher = SSInvoicePanel.this.iInvoice.generateVoucher();
                SSInvoicePanel.this.iVoucherTableModel.setVoucher(iVoucher);
            }
        });
        SSButtonGroup iGroup = new SSButtonGroup(true);
        iGroup.add(this.iEuSaleCommodity);
        iGroup.add(this.iEuSaleYhirdPartCommodity);
        this.iInputVerifier = new SSInputVerifier();
        this.iInputVerifier.add(this.iCustomer);
        this.iInputVerifier.add(this.iCustomerName);
        this.iInputVerifier.addListener(new SSInputVerifier.SSVerifierListener(){

            @Override
            public void updated(SSInputVerifier iVerifier, boolean iValid) {
                SSInvoicePanel.this.iButtonPanel.getOkButton().setEnabled(iValid);
            }
        });
        this.iSavecustomerandproducts.setSelected(true);
        this.addKeyListeners();
    }

    public void dispose() {
        ActionListener[] iActionListeners;
        PropertyChangeListener[] iPropertyChangeListeners;
        this.iModel.setCustomer(null);
        this.iPanel.removeAll();
        this.iPanel = null;
        this.iButtonPanel.dispose();
        this.iButtonPanel = null;
        this.iTable.dispose();
        this.iTable = null;
        this.iNumber.removeAll();
        this.iNumber = null;
        this.iOrders.removeAll();
        this.iOrders = null;
        this.iCurrencyRate.removeAll();
        this.iCurrencyRate = null;
        this.iDate.dispose();
        this.iDate = null;
        this.iCustomer.dispose();
        this.iCustomer = null;
        this.iCustomerName = null;
        this.iTaxFree = null;
        this.iDelayInterest = null;
        this.iDeliveryAddress = null;
        this.iInvoiceAddress = null;
        this.iText.removeAll();
        this.iText = null;
        this.iYourContactPerson.removeAll();
        this.iYourContactPerson = null;
        this.iOurContactPerson.removeAll();
        this.iOurContactPerson = null;
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners = this.iTaxRate1.getPropertyChangeListeners()) {
            this.iTaxRate1.removePropertyChangeListener(iPropertyChangeListener);
        }
        this.iTaxRate1.removeAll();
        this.iTaxRate1 = null;
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners = this.iTaxRate2.getPropertyChangeListeners()) {
            this.iTaxRate2.removePropertyChangeListener(iPropertyChangeListener);
        }
        this.iTaxRate2.removeAll();
        this.iTaxRate2 = null;
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners = this.iTaxRate3.getPropertyChangeListeners()) {
            this.iTaxRate3.removePropertyChangeListener(iPropertyChangeListener);
        }
        this.iYourOrderNumber = null;
        this.iTaxRate3.removeAll();
        this.iTaxRate3 = null;
        this.iEuSaleCommodity.removeAll();
        this.iEuSaleCommodity = null;
        this.iEuSaleYhirdPartCommodity.removeAll();
        this.iEuSaleYhirdPartCommodity = null;
        this.iDeliveryWay.dispose();
        this.iDeliveryWay = null;
        this.iDeliveryTerm.dispose();
        this.iDeliveryTerm = null;
        this.iPaymentTerm.dispose();
        this.iPaymentTerm = null;
        this.iCurrency.dispose();
        this.iCurrency = null;
        this.iDefaultAccounts.dispose();
        this.iDefaultAccounts = null;
        this.iCurrencyCalculatorButton.dispose();
        this.iCurrencyCalculatorButton = null;
        this.iNetSum.removeAll();
        this.iNetSum = null;
        this.iTaxSum1.removeAll();
        this.iTaxSum1 = null;
        this.iTaxSum2.removeAll();
        this.iTaxSum2 = null;
        this.iTaxSum3.removeAll();
        this.iTaxSum3 = null;
        this.iRoundingSum.removeAll();
        this.iRoundingSum = null;
        this.iTotalSum.removeAll();
        this.iTotalSum = null;
        this.iTaxLabel1 = null;
        this.iTaxLabel2 = null;
        this.iTaxLabel3 = null;
        this.iSavecustomerandproducts = null;
        this.iModel = null;
        this.iInputVerifier = null;
        this.iUseInvoiceForDelivery = null;
        this.iVoucherTable.dispose();
        this.iVoucherTable = null;
        this.iPaymentDay.dispose();
        this.iPaymentDay = null;
        for (ActionListener iActionListener : iActionListeners = this.iRefreshVoucher.getActionListeners()) {
            this.iRefreshVoucher.removeActionListener(iActionListener);
        }
        this.iRefreshVoucher.removeAll();
        this.iRefreshVoucher = null;
        this.iModel = null;
        this.iVoucherTableModel = null;
        this.iEntered = null;
        this.iPrinted = null;
        this.isStockInfluencing = null;
        this.iInterestInvoiced = null;
        this.iOCRNumber = null;
        this.iInputVerifier = null;
        this.iUseInvoiceForDelivery = null;
    }

    public boolean isValid() {
        return this.iInputVerifier.isValid();
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener pActionListener) {
        this.iButtonPanel.addOkActionListener(pActionListener);
    }

    public void addCancelAction(ActionListener pActionListener) {
        this.iButtonPanel.addCancelActionListener(pActionListener);
    }

    public void setInvoice(SSInvoice pOrder) {
        this.iInvoice = pOrder;
        this.iVoucherTableModel.setVoucher(this.iInvoice.getVoucher());
        this.iModel.setObjects(this.iInvoice.getRows());
        this.iNumber.setValue(this.iInvoice.getNumber());
        this.iOrders.setText(this.getOrderNumbers(this.iInvoice));
        this.iDate.setDate(this.iInvoice.getDate());
        this.iYourOrderNumber.setText(this.iInvoice.getYourOrderNumber());
        this.iCustomer.setText(this.iInvoice.getCustomerNr());
        for (SSCustomer pCustomer : SSDB.getInstance().getCustomers()) {
            if (!pCustomer.getNumber().equals(this.iCustomer.getText())) continue;
            this.iModel.setCustomer(pCustomer);
        }
        this.iCustomerName.setText(this.iInvoice.getCustomerName());
        this.iOurContactPerson.setText(this.iInvoice.getOurContactPerson());
        this.iYourContactPerson.setText(this.iInvoice.getYourContactPerson());
        this.iDelayInterest.setValue(this.iInvoice.getDelayInterest());
        this.iOCRNumber.setText(this.iInvoice.getOCRNumber());
        this.iCurrency.setSelected(this.iInvoice.getCurrency());
        this.iCurrencyRate.setValue(this.iInvoice.getCurrencyRate());
        this.iPaymentTerm.setSelected(this.iInvoice.getPaymentTerm(), true);
        this.iPaymentDay.setDate(this.iInvoice.getDueDate());
        this.iDeliveryTerm.setSelected(this.iInvoice.getDeliveryTerm());
        this.iDeliveryWay.setSelected(this.iInvoice.getDeliveryWay());
        this.iTaxFree.setSelected(this.iInvoice.getTaxFree());
        this.iTaxRate1.setValue(this.iInvoice.getTaxRate1());
        this.iTaxRate2.setValue(this.iInvoice.getTaxRate2());
        this.iTaxRate3.setValue(this.iInvoice.getTaxRate3());
        this.iEuSaleCommodity.setSelected(this.iInvoice.getEuSaleCommodity());
        this.iEuSaleYhirdPartCommodity.setSelected(this.iInvoice.getEuSaleThirdPartCommodity());
        this.iText.setText(this.iInvoice.getText());
        this.iInvoiceAddress.setAdress(this.iInvoice.getInvoiceAddress());
        this.iDeliveryAddress.setAdress(this.iInvoice.getDeliveryAddress());
        this.iDefaultAccounts.setDefaultAccounts(this.iInvoice.getDefaultAccounts());
        this.iEntered.setSelected(this.iInvoice.isEntered());
        this.iPrinted.setSelected(this.iInvoice.isPrinted());
        this.isStockInfluencing.setSelected(this.iInvoice.isStockInfluencing());
        this.iInterestInvoiced.setSelected(this.iInvoice.isInterestInvoiced());
        this.updateSumFields();
        this.updateTaxTexts();
        this.iUseInvoiceForDelivery.setSelected(this.iInvoice.getDeliveryAddress().equals(this.iInvoice.getInvoiceAddress()));
        this.iDeliveryAddress.setEnabled(!this.iUseInvoiceForDelivery.isSelected());
        this.iInputVerifier.update();
    }

    public SSInvoice getInvoice() {
        this.iInvoice.setDate(this.iDate.getDate());
        this.iInvoice.setCustomerNr(this.iCustomer.getText());
        this.iInvoice.setCustomerName(this.iCustomerName.getText());
        this.iInvoice.setOurContactPerson(this.iOurContactPerson.getText());
        this.iInvoice.setYourContactPerson(this.iYourContactPerson.getText());
        this.iInvoice.setDelayInterest(this.iDelayInterest.getValue());
        this.iInvoice.setYourOrderNumber(this.iYourOrderNumber.getText());
        this.iInvoice.setCurrencyRate(this.iCurrencyRate.getValue());
        this.iInvoice.setPaymentTerm(this.iPaymentTerm.getSelected());
        this.iInvoice.setDueDate(this.iPaymentDay.getDate());
        this.iInvoice.setDeliveryTerm(this.iDeliveryTerm.getSelected());
        this.iInvoice.setDeliveryWay(this.iDeliveryWay.getSelected());
        this.iInvoice.setEuSaleCommodity(this.iEuSaleCommodity.isSelected());
        this.iInvoice.setEuSaleYhirdPartCommodity(this.iEuSaleYhirdPartCommodity.isSelected());
        this.iInvoice.setCurrency(this.iCurrency.getSelected());
        this.iInvoice.setTaxFree(this.iTaxFree.isSelected());
        this.iInvoice.setTaxRate1(this.iTaxRate1.getValue());
        this.iInvoice.setTaxRate2(this.iTaxRate2.getValue());
        this.iInvoice.setTaxRate3(this.iTaxRate3.getValue());
        this.iInvoice.setOrderNumbers(this.iOrders.getText());
        this.iInvoice.setText(this.iText.getText());
        this.iInvoice.setDefaultAccounts(this.iDefaultAccounts.getDefaultAccounts());
        this.iInvoice.setEntered(this.iEntered.isSelected());
        this.iInvoice.setPrinted(this.iPrinted.isSelected());
        this.iInvoice.setStockInfluencing(this.isStockInfluencing.isSelected());
        this.iInvoice.setInterestInvoiced(this.iInterestInvoiced.isSelected());
        this.iInvoice.generateVoucher();
        this.iInvoice.setInvoiceAddress(this.iInvoiceAddress.getAddress());
        if (this.iUseInvoiceForDelivery.isSelected()) {
            this.iInvoice.setDeliveryAddress(this.iInvoiceAddress.getAddressCloned());
        } else {
            this.iInvoice.setDeliveryAddress(this.iDeliveryAddress.getAddress());
        }
        return this.iInvoice;
    }

    public boolean doSaveCustomerAndProducts() {
        return this.iSavecustomerandproducts.isSelected();
    }

    private String getOrderNumbers(SSInvoice iInvoice) {
        String iOrderNumbers = iInvoice.getOrderNumbers();
        if (iOrderNumbers == null) {
            List<SSOrder> iOrders = SSInvoiceMath.getOrdersForInvoice(iInvoice);
            if (iOrders.isEmpty()) {
                return "Fakturan har inga ordrar";
            }
            Collections.sort(iOrders, new Comparator<SSOrder>(){

                @Override
                public int compare(SSOrder o1, SSOrder o2) {
                    return o1.getNumber() - o2.getNumber();
                }
            });
            StringBuilder sb = new StringBuilder();
            for (SSOrder iOrder : iOrders) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(iOrder.getNumber());
            }
            return sb.toString();
        }
        return iOrderNumbers;
    }

    public void setOrderNumbers(List<SSOrder> iOrders) {
        String iOrdersForInvoice = "";
        for (SSOrder iOrder : iOrders) {
            iOrdersForInvoice = iOrdersForInvoice + iOrder.getNumber() + ", ";
        }
        iOrdersForInvoice = iOrdersForInvoice.substring(0, iOrdersForInvoice.lastIndexOf(", "));
        this.iOrders.setText(iOrdersForInvoice);
    }

    private void updateTaxTexts() {
        SSTaxCodeCellEditor iEditor = new SSTaxCodeCellEditor();
        SSTaxCodeCellRenderer iRenderer = new SSTaxCodeCellRenderer();
        String iTaxText = SSBundle.getBundle().getString("tenderframe.tax");
        BigDecimal iTaxRate1 = this.iTaxRate1.getValue() == null ? new BigDecimal(25) : this.iTaxRate1.getValue();
        BigDecimal iTaxRate2 = this.iTaxRate2.getValue() == null ? new BigDecimal(12) : this.iTaxRate2.getValue();
        BigDecimal iTaxRate3 = this.iTaxRate3.getValue() == null ? new BigDecimal(6) : this.iTaxRate3.getValue();
        NumberFormat iFormat = NumberFormat.getNumberInstance();
        iEditor.setValue(SSTaxCode.TAXRATE_0, new BigDecimal(0));
        iEditor.setValue(SSTaxCode.TAXRATE_1, iTaxRate1);
        iEditor.setValue(SSTaxCode.TAXRATE_2, iTaxRate2);
        iEditor.setValue(SSTaxCode.TAXRATE_3, iTaxRate3);
        iRenderer.setValue(SSTaxCode.TAXRATE_0, new BigDecimal(0));
        iRenderer.setValue(SSTaxCode.TAXRATE_1, iTaxRate1);
        iRenderer.setValue(SSTaxCode.TAXRATE_2, iTaxRate2);
        iRenderer.setValue(SSTaxCode.TAXRATE_3, iTaxRate3);
        this.iTaxLabel1.setText(iTaxText + ' ' + iFormat.format(iTaxRate1) + '%');
        this.iTaxLabel2.setText(iTaxText + ' ' + iFormat.format(iTaxRate2) + '%');
        this.iTaxLabel3.setText(iTaxText + ' ' + iFormat.format(iTaxRate3) + '%');
        this.iTable.setDefaultEditor(SSTaxCode.class, iEditor);
        this.iTable.setDefaultRenderer(SSTaxCode.class, iRenderer);
        this.iModel.fireTableDataChanged();
    }

    private void updateSumFields() {
        BigDecimal iNetSum = SSInvoiceMath.getNetSum(this.iInvoice);
        Map<SSTaxCode, BigDecimal> iTaxSum = SSInvoiceMath.getTaxSum(this.iInvoice);
        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(this.iInvoice);
        BigDecimal iRounding = SSInvoiceMath.getRounding(this.iInvoice);
        this.iNetSum.setValue(iNetSum);
        this.iTaxSum1.setValue(iTaxSum.get(SSTaxCode.TAXRATE_1));
        this.iTaxSum2.setValue(iTaxSum.get(SSTaxCode.TAXRATE_2));
        this.iTaxSum3.setValue(iTaxSum.get(SSTaxCode.TAXRATE_3));
        if (!SSDB.getInstance().getCurrentCompany().isRoundingOff()) {
            this.iRoundingSum.setValue(iRounding);
        }
        this.iTotalSum.setValue(iTotalSum);
    }

    public void setSavecustomerandproductsSelected(boolean iSelected) {
        this.iSavecustomerandproducts.setSelected(iSelected);
    }

    public void addKeyListeners() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SSInvoicePanel.this.iCustomer.getComponent(0).requestFocusInWindow();
            }
        });
        this.iCustomer.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iCustomerName.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCustomerName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iOurContactPerson.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iOurContactPerson.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iYourContactPerson.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iYourContactPerson.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iDate.getEditor().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDate.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iPaymentDay.getEditor().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPaymentDay.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iDeliveryTerm.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDeliveryTerm.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iPaymentTerm.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPaymentTerm.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iDeliveryWay.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDeliveryWay.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iCurrency.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCurrency.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iCurrencyRate.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCurrencyRate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iTable.requestFocusInWindow();
                            SSInvoicePanel.this.iTable.changeSelection(0, 0, false, false);
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getOkButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iButtonPanel.getCancelButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getCancelButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSInvoicePanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iNumber.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SSInvoicePanel.this.iCustomer.getComponent(0).requestFocusInWindow();
                    }
                });
            }
        });
        this.iInvoiceAddress.addKeyListeners();
        this.iDeliveryAddress.addKeyListeners();
        this.iUseInvoiceForDelivery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SSInvoicePanel.this.iUseInvoiceForDelivery.isSelected()) {
                    SSInvoicePanel.this.iDeliveryAddress.setFocus();
                } else {
                    SSInvoicePanel.this.iInvoiceAddress.setFocus();
                }
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.invoice.panel.SSInvoicePanel");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCurrency=").append(this.iCurrency);
        sb.append(", iCurrencyCalculatorButton=").append(this.iCurrencyCalculatorButton);
        sb.append(", iCurrencyRate=").append(this.iCurrencyRate);
        sb.append(", iCustomer=").append(this.iCustomer);
        sb.append(", iCustomerName=").append(this.iCustomerName);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iDefaultAccounts=").append(this.iDefaultAccounts);
        sb.append(", iDelayInterest=").append(this.iDelayInterest);
        sb.append(", iDeliveryAddress=").append(this.iDeliveryAddress);
        sb.append(", iDeliveryTerm=").append(this.iDeliveryTerm);
        sb.append(", iDeliveryWay=").append(this.iDeliveryWay);
        sb.append(", iEntered=").append(this.iEntered);
        sb.append(", iEuSaleCommodity=").append(this.iEuSaleCommodity);
        sb.append(", iEuSaleYhirdPartCommodity=").append(this.iEuSaleYhirdPartCommodity);
        sb.append(", iInputVerifier=").append(this.iInputVerifier);
        sb.append(", iInterestInvoiced=").append(this.iInterestInvoiced);
        sb.append(", iInvoice=").append(this.iInvoice);
        sb.append(", iInvoiceAddress=").append(this.iInvoiceAddress);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iNetSum=").append(this.iNetSum);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iOCRNumber=").append(this.iOCRNumber);
        sb.append(", iOrders=").append(this.iOrders);
        sb.append(", iOurContactPerson=").append(this.iOurContactPerson);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iPaymentDay=").append(this.iPaymentDay);
        sb.append(", iPaymentTerm=").append(this.iPaymentTerm);
        sb.append(", iPrinted=").append(this.iPrinted);
        sb.append(", iRefreshVoucher=").append(this.iRefreshVoucher);
        sb.append(", iRoundingSum=").append(this.iRoundingSum);
        sb.append(", iSavecustomerandproducts=").append(this.iSavecustomerandproducts);
        sb.append(", isStockInfluencing=").append(this.isStockInfluencing);
        sb.append(", iTable=").append(this.iTable);
        sb.append(", iTaxFree=").append(this.iTaxFree);
        sb.append(", iTaxLabel1=").append(this.iTaxLabel1);
        sb.append(", iTaxLabel2=").append(this.iTaxLabel2);
        sb.append(", iTaxLabel3=").append(this.iTaxLabel3);
        sb.append(", iTaxRate1=").append(this.iTaxRate1);
        sb.append(", iTaxRate2=").append(this.iTaxRate2);
        sb.append(", iTaxRate3=").append(this.iTaxRate3);
        sb.append(", iTaxSum1=").append(this.iTaxSum1);
        sb.append(", iTaxSum2=").append(this.iTaxSum2);
        sb.append(", iTaxSum3=").append(this.iTaxSum3);
        sb.append(", iText=").append(this.iText);
        sb.append(", iTotalSum=").append(this.iTotalSum);
        sb.append(", iUseInvoiceForDelivery=").append(this.iUseInvoiceForDelivery);
        sb.append(", iVoucherTable=").append(this.iVoucherTable);
        sb.append(", iVoucherTableModel=").append(this.iVoucherTableModel);
        sb.append(", iYourContactPerson=").append(this.iYourContactPerson);
        sb.append(", iYourOrderNumber=").append(this.iYourOrderNumber);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JButton jButton;
        SSTable sSTable;
        JCheckBox jCheckBox5;
        SSBigDecimalTextField sSBigDecimalTextField;
        SSBigDecimalTextField sSBigDecimalTextField2;
        SSBigDecimalTextField sSBigDecimalTextField3;
        SSDefaultAccountPanel sSDefaultAccountPanel;
        JCheckBox jCheckBox6;
        SSBigDecimalTextField sSBigDecimalTextField4;
        JTextField jTextField;
        SSAdressPanel sSAdressPanel;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JTextArea jTextArea;
        SSAdressPanel sSAdressPanel2;
        JTextField jTextField2;
        JTextField jTextField3;
        SSButton sSButton;
        SSBigDecimalTextField sSBigDecimalTextField5;
        SSDateChooser sSDateChooser;
        SSDateChooser sSDateChooser2;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JFormattedTextField jFormattedTextField;
        JCheckBox jCheckBox9;
        SSBigDecimalTextField sSBigDecimalTextField6;
        SSBigDecimalTextField sSBigDecimalTextField7;
        SSBigDecimalTextField sSBigDecimalTextField8;
        SSBigDecimalTextField sSBigDecimalTextField9;
        SSBigDecimalTextField sSBigDecimalTextField10;
        SSBigDecimalTextField sSBigDecimalTextField11;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        SSTable sSTable2;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), 4, 2, false, false));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(5, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("invoiceframe.panel.1"), null, jPanel2, null);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, new Dimension(-1, 120), null, null));
        this.iTable = sSTable2 = new SSTable();
        jScrollPane.setViewportView(sSTable2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 6, new Insets(0, 2, 4, 2), 2, 0, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("tenderframe.netsum"));
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxLabel1 = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("tenderframe.tax"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(80, -1), null));
        this.iTaxLabel2 = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("tenderframe.tax"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxLabel3 = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("tenderframe.tax"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("book").getString("tenderframe.rounding"));
        jPanel3.add((Component)jLabel5, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("book").getString("tenderframe.totalsum"));
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 5, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iNetSum = sSBigDecimalTextField11 = new SSBigDecimalTextField();
        sSBigDecimalTextField11.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField11, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.iTaxSum1 = sSBigDecimalTextField10 = new SSBigDecimalTextField();
        sSBigDecimalTextField10.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField10, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 3, null, new Dimension(100, -1), null));
        this.iTaxSum2 = sSBigDecimalTextField9 = new SSBigDecimalTextField();
        sSBigDecimalTextField9.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField9, new GridConstraints(1, 2, 1, 1, 8, 1, 3, 3, null, new Dimension(100, -1), null));
        this.iTaxSum3 = sSBigDecimalTextField8 = new SSBigDecimalTextField();
        sSBigDecimalTextField8.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField8, new GridConstraints(1, 3, 1, 1, 8, 1, 3, 3, null, new Dimension(100, -1), null));
        this.iRoundingSum = sSBigDecimalTextField7 = new SSBigDecimalTextField();
        sSBigDecimalTextField7.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField7, new GridConstraints(1, 4, 1, 1, 0, 1, 7, 3, null, null, null));
        this.iTotalSum = sSBigDecimalTextField6 = new SSBigDecimalTextField();
        sSBigDecimalTextField6.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField6, new GridConstraints(1, 5, 1, 1, 0, 1, 7, 3, null, null, null));
        this.iSavecustomerandproducts = jCheckBox9 = new JCheckBox();
        jCheckBox9.setHorizontalAlignment(2);
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("book").getString("tenderframe.dontsavecustomerandproducts"));
        jCheckBox9.setInheritsPopupMenu(false);
        jCheckBox9.setVerticalAlignment(3);
        jCheckBox9.setVerticalTextPosition(0);
        jCheckBox9.setSelected(true);
        jPanel2.add((Component)jCheckBox9, new GridConstraints(1, 0, 1, 1, 10, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(8, 6, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("book").getString("invoiceframe.number"));
        jPanel4.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iNumber = jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setEditable(false);
        jPanel4.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("book").getString("invoiceframe.date"));
        jPanel4.add((Component)jLabel8, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("book").getString("tenderframe.yourcontactperson"));
        jPanel4.add((Component)jLabel9, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iYourContactPerson = jTextField6 = new JTextField();
        jPanel4.add((Component)jTextField6, new GridConstraints(5, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("book").getString("tenderframe.ourcontactperson"));
        jPanel4.add((Component)jLabel10, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iOurContactPerson = jTextField5 = new JTextField();
        jPanel4.add((Component)jTextField5, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        this.iCustomerName = jTextField4 = new JTextField();
        jPanel4.add((Component)jTextField4, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("book").getString("tenderframe.customername"));
        jPanel4.add((Component)jLabel11, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("book").getString("tenderframe.customernr"));
        jPanel4.add((Component)jLabel12, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("book").getString("orderframe.number"));
        jPanel4.add((Component)jLabel13, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDate = sSDateChooser2 = new SSDateChooser();
        ((Component)sSDateChooser2).setEnabled(true);
        sSDateChooser2.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel4.add((Component)sSDateChooser2, new GridConstraints(0, 4, 1, 1, 4, 0, 1, 3, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1)));
        this.iPaymentDay = sSDateChooser = new SSDateChooser();
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel4.add((Component)sSDateChooser, new GridConstraints(1, 4, 1, 1, 4, 0, 1, 3, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1)));
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("book").getString("invoiceframe.paymentday"));
        jPanel4.add((Component)jLabel14, new GridConstraints(1, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        SSEditableTableComboBox sSEditableTableComboBox = new SSEditableTableComboBox();
        this.iDeliveryTerm = sSEditableTableComboBox;
        jPanel4.add(sSEditableTableComboBox, new GridConstraints(2, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        SSEditableTableComboBox sSEditableTableComboBox2 = new SSEditableTableComboBox();
        this.iPaymentTerm = sSEditableTableComboBox2;
        jPanel4.add(sSEditableTableComboBox2, new GridConstraints(3, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        SSEditableTableComboBox sSEditableTableComboBox3 = new SSEditableTableComboBox();
        this.iDeliveryWay = sSEditableTableComboBox3;
        jPanel4.add(sSEditableTableComboBox3, new GridConstraints(4, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        SSEditableTableComboBox sSEditableTableComboBox4 = new SSEditableTableComboBox();
        this.iCurrency = sSEditableTableComboBox4;
        jPanel4.add(sSEditableTableComboBox4, new GridConstraints(5, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        this.iCurrencyRate = sSBigDecimalTextField5 = new SSBigDecimalTextField();
        sSBigDecimalTextField5.setFractionDigits(5);
        ((JTextComponent)sSBigDecimalTextField5).setText("1,0000");
        sSBigDecimalTextField5.setEditable(true);
        jPanel4.add((Component)sSBigDecimalTextField5, new GridConstraints(6, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        this.iCurrencyCalculatorButton = sSButton = new SSButton();
        sSButton.setIconName("ICON_CALCULATOR16");
        sSButton.setToolTipText(ResourceBundle.getBundle("book").getString("tenderframe.currencycalculator"));
        jPanel4.add((Component)sSButton, new GridConstraints(5, 5, 1, 1, 6, 0, 3, 3, new Dimension(20, 20), new Dimension(20, 20), new Dimension(20, 20)));
        JLabel jLabel15 = new JLabel();
        this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("book").getString("tenderframe.deliveryterm"));
        jPanel4.add((Component)jLabel15, new GridConstraints(2, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel16 = new JLabel();
        this.$$$loadLabelText$$$(jLabel16, ResourceBundle.getBundle("book").getString("tenderframe.paymentterm"));
        jPanel4.add((Component)jLabel16, new GridConstraints(3, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel17 = new JLabel();
        this.$$$loadLabelText$$$(jLabel17, ResourceBundle.getBundle("book").getString("tenderframe.deliveryway"));
        jPanel4.add((Component)jLabel17, new GridConstraints(4, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel18 = new JLabel();
        this.$$$loadLabelText$$$(jLabel18, ResourceBundle.getBundle("book").getString("tenderframe.currency"));
        jPanel4.add((Component)jLabel18, new GridConstraints(5, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel19 = new JLabel();
        this.$$$loadLabelText$$$(jLabel19, ResourceBundle.getBundle("book").getString("invoiceframe.currencyrate"));
        jPanel4.add((Component)jLabel19, new GridConstraints(6, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel20 = new JLabel();
        this.$$$loadLabelText$$$(jLabel20, ResourceBundle.getBundle("book").getString("invoiceframe.ocrnumber"));
        jLabel20.setToolTipText(ResourceBundle.getBundle("book").getString("invoiceframe.ocrnumber"));
        jPanel4.add((Component)jLabel20, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iOCRNumber = jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        jPanel4.add((Component)jTextField3, new GridConstraints(6, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iCustomer = sSTableComboBox;
        jPanel4.add(sSTableComboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(150, -1), null));
        this.iOrders = jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        jPanel4.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(6, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("invoiceframe.panel.2"), null, jPanel5, null);
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iInvoiceAddress = sSAdressPanel2 = new SSAdressPanel();
        sSAdressPanel2.setTitle(ResourceBundle.getBundle("book").getString("tenderframe.invoiceaddress"));
        jPanel6.add((Component)sSAdressPanel2, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 4, 0, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel7.add((Component)jScrollPane2, new GridConstraints(1, 0, 1, 1, 8, 3, 7, 7, new Dimension(-1, 60), new Dimension(-1, 60), new Dimension(500, 60)));
        this.iText = jTextArea = new JTextArea();
        jScrollPane2.setViewportView(jTextArea);
        JLabel jLabel21 = new JLabel();
        this.$$$loadLabelText$$$(jLabel21, ResourceBundle.getBundle("book").getString("invoiceframe.invoicetext"));
        jPanel7.add((Component)jLabel21, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel5.add((Component)jPanel8, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        this.iEuSaleCommodity = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("book").getString("customerframe.eusalecommodity"));
        jPanel8.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iEuSaleYhirdPartCommodity = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("book").getString("customerframe.eusalethirdpartcommodity"));
        jPanel8.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(1, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel5.add((Component)jPanel9, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iDeliveryAddress = sSAdressPanel = new SSAdressPanel();
        sSAdressPanel.setTitle(ResourceBundle.getBundle("book").getString("tenderframe.deliveryaddress"));
        jPanel9.add((Component)sSAdressPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(2, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel5.add((Component)jPanel10, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel22 = new JLabel();
        this.$$$loadLabelText$$$(jLabel22, ResourceBundle.getBundle("book").getString("orderframe.yourordernumber"));
        jPanel10.add((Component)jLabel22, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iYourOrderNumber = jTextField = new JTextField();
        jTextField.setColumns(2);
        jPanel10.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel23 = new JLabel();
        this.$$$loadLabelText$$$(jLabel23, ResourceBundle.getBundle("book").getString("tenderframe.delayinterest"));
        jPanel10.add((Component)jLabel23, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDelayInterest = sSBigDecimalTextField4 = new SSBigDecimalTextField();
        sSBigDecimalTextField4.setFractionDigits(2);
        jPanel10.add((Component)sSBigDecimalTextField4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        JLabel jLabel24 = new JLabel();
        jLabel24.setText("%");
        jPanel10.add((Component)jLabel24, new GridConstraints(0, 2, 1, 1, 8, 0, 6, 0, null, null, null));
        this.iUseInvoiceForDelivery = jCheckBox6 = new JCheckBox();
        ((Component)jCheckBox6).setEnabled(true);
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("book").getString("customerframe.useinvoiceasdelivery"));
        jCheckBox6.setSelected(true);
        jPanel5.add((Component)jCheckBox6, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(3, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("invoiceframe.panel.3"), null, jPanel11, null);
        Spacer spacer4 = new Spacer();
        jPanel11.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel11.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iDefaultAccounts = sSDefaultAccountPanel = new SSDefaultAccountPanel();
        jPanel11.add((Component)sSDefaultAccountPanel, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayoutManager(4, 3, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel11.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel12.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel25 = new JLabel();
        this.$$$loadLabelText$$$(jLabel25, ResourceBundle.getBundle("book").getString("companyframe.taxrate1"));
        jPanel12.add((Component)jLabel25, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel26 = new JLabel();
        this.$$$loadLabelText$$$(jLabel26, ResourceBundle.getBundle("book").getString("companyframe.taxrate2"));
        jPanel12.add((Component)jLabel26, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel27 = new JLabel();
        this.$$$loadLabelText$$$(jLabel27, ResourceBundle.getBundle("book").getString("companyframe.taxrate3"));
        jPanel12.add((Component)jLabel27, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxRate1 = sSBigDecimalTextField3 = new SSBigDecimalTextField();
        jPanel12.add((Component)sSBigDecimalTextField3, new GridConstraints(1, 1, 1, 1, 8, 0, 7, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, -1)));
        JLabel jLabel28 = new JLabel();
        jLabel28.setText("%");
        jPanel12.add((Component)jLabel28, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel29 = new JLabel();
        jLabel29.setText("%");
        jPanel12.add((Component)jLabel29, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel30 = new JLabel();
        jLabel30.setText("%");
        jPanel12.add((Component)jLabel30, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxRate2 = sSBigDecimalTextField2 = new SSBigDecimalTextField();
        jPanel12.add((Component)sSBigDecimalTextField2, new GridConstraints(2, 1, 1, 1, 8, 0, 7, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, -1)));
        this.iTaxRate3 = sSBigDecimalTextField = new SSBigDecimalTextField();
        jPanel12.add((Component)sSBigDecimalTextField, new GridConstraints(3, 1, 1, 1, 8, 0, 7, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, -1)));
        this.iTaxFree = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("book").getString("tenderframe.taxfree"));
        jPanel12.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridLayoutManager(6, 2, new Insets(4, 4, 4, 4), 0, 0, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("invoiceframe.panel.4"), null, jPanel13, null);
        Spacer spacer6 = new Spacer();
        jPanel13.add((Component)spacer6, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel13.add((Component)spacer7, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridLayoutManager(2, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel13.add((Component)jPanel14, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel14.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane3 = new JScrollPane();
        jPanel14.add((Component)jScrollPane3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, new Dimension(600, 250), null));
        this.iVoucherTable = sSTable = new SSTable();
        jScrollPane3.setViewportView(sSTable);
        this.iRefreshVoucher = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("book").getString("invoiceframe.voucherrefresh"));
        jPanel14.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel14.add((Component)spacer8, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel31 = new JLabel();
        jLabel31.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel31, ResourceBundle.getBundle("book").getString("invoiceframe.voucher"));
        jLabel31.setVerticalAlignment(1);
        jLabel31.setVerticalTextPosition(1);
        jLabel31.setHorizontalAlignment(2);
        jPanel14.add((Component)jLabel31, new GridConstraints(0, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        this.iEntered = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("book").getString("invoiceframe.entered"));
        jPanel13.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iPrinted = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("book").getString("invoiceframe.printed"));
        jPanel13.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.isStockInfluencing = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("book").getString("invoiceframe.updatestock"));
        jPanel13.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iInterestInvoiced = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("invoiceframe.interestinvoiced"));
        jPanel13.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class ContributionRateColumn
    extends SSTableColumn<SSSaleRow> {
        public ContributionRateColumn() {
            super(SSBundle.getBundle().getString("salerowtable.column.12"));
        }

        private BigDecimal getExchangeRate() {
            BigDecimal iValue = SSInvoicePanel.this.iCurrencyRate.getValue();
            if (iValue != null) {
                return iValue;
            }
            SSCurrency iSelected = (SSCurrency)SSInvoicePanel.this.iCurrency.getSelected();
            if (iSelected != null) {
                return iSelected.getExchangeRate();
            }
            return null;
        }

        @Override
        public Object getValue(SSSaleRow iRow) {
            SSProduct iProduct = iRow.getProduct();
            if (iProduct == null) {
                return null;
            }
            BigDecimal iInprice = SSProductMath.getInprice(iProduct, SSInvoicePanel.this.iDate.getDate());
            BigDecimal iUnitprice = iRow.getUnitprice();
            BigDecimal iExchangeRate = this.getExchangeRate();
            if (iInprice == null || iUnitprice == null) {
                return null;
            }
            if (iExchangeRate != null) {
                return iUnitprice.multiply(iExchangeRate).subtract(iInprice);
            }
            return iUnitprice.subtract(iInprice);
        }

        @Override
        public void setValue(SSSaleRow iObject, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    }
}

