/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.invoice.util;

import java.awt.Component;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.table.DefaultTableCellRenderer;
import se.swedsoft.bookkeeping.calc.math.SSInpaymentMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSCurrencyCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSDateCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSPercentCellRenderer;

public class SSInterestInvoiceTableModel
extends SSDefaultTableModel<SSInvoice> {
    private Map<SSInvoice, InterestAction> iActions = new HashMap<SSInvoice, InterestAction>();

    public SSInterestInvoiceTableModel(List<SSInvoice> iInvoices) {
        super(iInvoices);
        for (SSInvoice iInvoice : iInvoices) {
            this.iActions.put(iInvoice, InterestAction.INVOICE);
        }
        this.addColumn(SSBundle.getBundle().getString("interestinvoicetable.column.1"));
        this.addColumn(SSBundle.getBundle().getString("interestinvoicetable.column.2"));
        this.addColumn(SSBundle.getBundle().getString("interestinvoicetable.column.3"));
        this.addColumn(SSBundle.getBundle().getString("interestinvoicetable.column.4"));
        this.addColumn(SSBundle.getBundle().getString("interestinvoicetable.column.5"));
        this.addColumn(SSBundle.getBundle().getString("interestinvoicetable.column.6"));
        this.addColumn(SSBundle.getBundle().getString("interestinvoicetable.column.7"));
        this.addColumn(SSBundle.getBundle().getString("interestinvoicetable.column.8"));
        this.addColumn(SSBundle.getBundle().getString("interestinvoicetable.column.9"));
        this.addColumn(SSBundle.getBundle().getString("interestinvoicetable.column.10"));
    }

    @Override
    public Class getType() {
        return SSInvoice.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SSInvoice iInvoice = (SSInvoice)this.getObject(rowIndex);
        Object value = null;
        switch (columnIndex) {
            case 0: {
                value = iInvoice.getNumber();
                break;
            }
            case 1: {
                value = iInvoice.getCustomerNr();
                break;
            }
            case 2: {
                value = iInvoice.getCustomerName();
                break;
            }
            case 3: {
                value = iInvoice.getDueDate();
                break;
            }
            case 4: {
                value = SSInpaymentMath.getLastInpaymentForInvoice(iInvoice);
                break;
            }
            case 5: {
                value = SSInvoiceMath.getInterestSaldo(iInvoice);
                break;
            }
            case 6: {
                value = iInvoice.getCurrency();
                break;
            }
            case 7: {
                value = iInvoice.getDelayInterest();
                break;
            }
            case 8: {
                value = SSInvoiceMath.getInterestSum(iInvoice, SSInvoiceMath.getInterestSaldo(iInvoice), SSInvoiceMath.getNumDelayedDays(iInvoice));
                break;
            }
            case 9: {
                value = this.iActions.get(iInvoice);
            }
        }
        return value;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return SSInvoice.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Date.class;
            }
            case 4: {
                return Date.class;
            }
            case 5: {
                return BigDecimal.class;
            }
            case 6: {
                return SSCurrency.class;
            }
            case 7: {
                return BigDecimal.class;
            }
            case 8: {
                return BigDecimal.class;
            }
            case 9: {
                return InterestAction.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 9;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SSInvoice iInvoice = (SSInvoice)this.getObject(rowIndex);
        switch (columnIndex) {
            case 9: {
                this.iActions.put(iInvoice, (InterestAction)aValue);
            }
        }
        this.fireTableDataChanged();
    }

    public List<SSInvoice> getInterestInvoices(String iDescription, SSAccount iAccount) {
        LinkedList<SSInvoice> iInvoices = new LinkedList<SSInvoice>();
        for (SSInvoice iInvoice : this.getObjects()) {
            if (SSPostLock.isLocked("invoice" + iInvoice.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                new SSErrorDialog(new JFrame(), "interestinvoice.invoiceopen", iInvoice.getNumber(), iInvoice.getNumber());
                iInvoice.setInterestInvoiced(false);
                continue;
            }
            InterestAction iAction = this.iActions.get(iInvoice);
            if (iAction == InterestAction.SKIP) continue;
            iInvoice.setInterestInvoiced(true);
            SSDB.getInstance().updateInvoice(iInvoice);
            if (iAction == InterestAction.OBLITERATE) continue;
            SSInvoice iInterestInvoice = new SSInvoice(iInvoice);
            iInterestInvoice.setEntered(false);
            iInterestInvoice.setPrinted(false);
            iInterestInvoice.setNumRemainders(0);
            iInterestInvoice.setDate(new Date());
            iInterestInvoice.setEuSaleCommodity(false);
            iInterestInvoice.setEuSaleYhirdPartCommodity(false);
            iInterestInvoice.setDueDate();
            iInterestInvoice.setInterestInvoiced(false);
            SSSaleRow iRow = new SSSaleRow();
            iRow.setDescription(iDescription);
            iRow.setAccount(iAccount);
            iRow.setTaxCode(SSTaxCode.TAXRATE_0);
            iRow.setQuantity(1);
            iRow.setUnitprice(SSInvoiceMath.getInterestSum(iInvoice, SSInvoiceMath.getInterestSaldo(iInvoice), SSInvoiceMath.getNumDelayedDays(iInvoice)));
            iInterestInvoice.setRows(iRow);
            iInvoices.add(iInterestInvoice);
        }
        return iInvoices;
    }

    public static void setupTable(SSTable iTable) {
        iTable.setAutoResizeMode(0);
        iTable.getColumnModel().getColumn(0).setPreferredWidth(70);
        iTable.getColumnModel().getColumn(1).setPreferredWidth(120);
        iTable.getColumnModel().getColumn(2).setPreferredWidth(120);
        iTable.getColumnModel().getColumn(3).setPreferredWidth(90);
        iTable.getColumnModel().getColumn(4).setPreferredWidth(90);
        iTable.getColumnModel().getColumn(5).setPreferredWidth(80);
        iTable.getColumnModel().getColumn(6).setPreferredWidth(50);
        iTable.getColumnModel().getColumn(7).setPreferredWidth(60);
        iTable.getColumnModel().getColumn(8).setPreferredWidth(80);
        iTable.getColumnModel().getColumn(9).setPreferredWidth(90);
        iTable.getColumnModel().getColumn(7).setCellRenderer(new SSPercentCellRenderer(2));
        iTable.setDefaultRenderer(Date.class, new SSDateCellRenderer());
        iTable.setDefaultRenderer(SSCurrency.class, new SSCurrencyCellRenderer());
        iTable.setDefaultEditor(BigDecimal.class, new SSBigDecimalCellEditor(2));
        iTable.setDefaultRenderer(BigDecimal.class, new SSBigDecimalCellRenderer(2));
        iTable.setDefaultEditor(InterestAction.class, new InterestActionCellEditor());
        iTable.setDefaultRenderer(InterestAction.class, new InterestActionCellRenderer());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.invoice.util.SSInterestInvoiceTableModel");
        sb.append("{iActions=").append(this.iActions);
        sb.append('}');
        return sb.toString();
    }

    private static class InterestActionCellRenderer
    extends DefaultTableCellRenderer {
        private InterestActionCellRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof InterestAction) {
                InterestAction iAction = (InterestAction)value;
                this.setText(iAction.getDescription());
            } else {
                this.setText("");
            }
        }
    }

    private static class InterestActionCellEditor
    extends DefaultCellEditor {
        public InterestActionCellEditor() {
            super(new JComboBox());
            JComboBox iComboBox = (JComboBox)this.getComponent();
            iComboBox.setModel(new DefaultComboBoxModel<InterestAction>(InterestAction.values()));
            iComboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof InterestAction) {
                        InterestAction iAction = (InterestAction)value;
                        this.setText(iAction.getDescription());
                    } else {
                        this.setText("");
                    }
                    return this;
                }
            });
        }
    }

    private static enum InterestAction implements SSTableSearchable
    {
        SKIP("interestinvoice.action.1"),
        INVOICE("interestinvoice.action.2"),
        OBLITERATE("interestinvoice.action.3");

        private String iBundleName;

        private InterestAction(String iBundleName) {
            this.iBundleName = iBundleName;
        }

        public String getDescription() {
            return SSBundle.getBundle().getString(this.iBundleName);
        }

        @Override
        public String toRenderString() {
            return this.getDescription();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.invoice.util.SSInterestInvoiceTableModel.InterestAction");
            sb.append("{iBundleName='").append(this.iBundleName).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

