/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.invoice.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.graphics.SSIcon;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSInvoiceTableModel
extends SSTableModel<SSInvoice> {
    public static SSTableColumn<SSInvoice> COLUMN_PRINTED = new SSTableColumn<SSInvoice>(""){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return iInvoice.isPrinted() ? SSIcon.getIcon("ICON_PROPERTIES16", SSIcon.IconState.NORMAL) : null;
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return ImageIcon.class;
        }

        @Override
        public int getDefaultWidth() {
            return 20;
        }
    };
    public static SSTableColumn<SSInvoice> COLUMN_NUMBER = new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.1")){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return iInvoice.getNumber();
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
            iInvoice.setNumber((Integer)iValue);
        }

        @Override
        public Class getColumnClass() {
            return Integer.class;
        }

        @Override
        public int getDefaultWidth() {
            return 80;
        }
    };
    public static SSTableColumn<SSInvoice> COLUMN_OCRNUMBER = new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.13")){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return iInvoice.getOCRNumber();
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 120;
        }
    };
    public static SSTableColumn<SSInvoice> COLUMN_TYPE = new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.2")){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return iInvoice.getType() != null ? iInvoice.getType().getDescription() : "";
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 70;
        }
    };
    public static SSTableColumn<SSInvoice> COLUMN_CUSTOMER_NR = new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.3")){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return iInvoice.getCustomerNr();
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
            iInvoice.setCustomerNr((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<SSInvoice> COLUMN_CUSTOMER_NAME = new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.4")){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return iInvoice.getCustomerName();
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
            iInvoice.setCustomerName((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 150;
        }
    };
    public static SSTableColumn<SSInvoice> COLUMN_DATE = new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.5")){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return iInvoice.getDate();
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
            iInvoice.setDate((Date)iValue);
        }

        @Override
        public Class getColumnClass() {
            return Date.class;
        }

        @Override
        public int getDefaultWidth() {
            return 90;
        }
    };
    public static SSTableColumn<SSInvoice> COLUMN_DUEDATE = new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.6")){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return iInvoice.getDueDate();
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
            iInvoice.setDueDate((Date)iValue);
        }

        @Override
        public Class getColumnClass() {
            return Date.class;
        }

        @Override
        public int getDefaultWidth() {
            return 90;
        }
    };
    public static SSTableColumn<SSInvoice> COLUMN_NET_SUM = new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.7")){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return SSInvoiceMath.getNetSum(iInvoice);
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 90;
        }
    };
    public static SSTableColumn<SSInvoice> COLUMN_CURRENCY = new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.8")){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return iInvoice.getCurrency();
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
            iInvoice.setCurrency((SSCurrency)iValue);
        }

        @Override
        public Class getColumnClass() {
            return SSCurrency.class;
        }

        @Override
        public int getDefaultWidth() {
            return 50;
        }
    };
    public static SSTableColumn<SSInvoice> COLUMN_CURRENCY_RATE = new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.9")){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return iInvoice.getCurrencyRate();
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
            iInvoice.setCurrencyRate((BigDecimal)iValue);
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 60;
        }
    };
    public static SSTableColumn<SSInvoice> COLUMN_TOTAL_SUM = new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.10")){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return SSInvoiceMath.getTotalSum(iInvoice);
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 90;
        }
    };
    public static SSTableColumn<SSInvoice> COLUMN_REMINDERS = new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.12")){

        @Override
        public Object getValue(SSInvoice iInvoice) {
            return iInvoice.getNumReminders();
        }

        @Override
        public void setValue(SSInvoice iInvoice, Object iValue) {
            iInvoice.setNumRemainders((Integer)iValue);
        }

        @Override
        public Class getColumnClass() {
            return Integer.class;
        }

        @Override
        public int getDefaultWidth() {
            return 50;
        }
    };

    public SSInvoiceTableModel() {
        super(SSDB.getInstance().getInvoices());
    }

    public SSInvoiceTableModel(List<SSInvoice> iInvoices) {
        super(iInvoices);
    }

    @Override
    public Class getType() {
        return SSInvoice.class;
    }

    public static SSInvoiceTableModel getDropDownModel() {
        return SSInvoiceTableModel.getDropDownModel(SSDB.getInstance().getInvoices());
    }

    public static SSInvoiceTableModel getDropDownModel(List<SSInvoice> iInvoices) {
        SSInvoiceTableModel iModel = new SSInvoiceTableModel(iInvoices);
        iModel.addColumn(COLUMN_NUMBER);
        iModel.addColumn(COLUMN_CUSTOMER_NR);
        iModel.addColumn(COLUMN_CUSTOMER_NAME);
        return iModel;
    }

    public static SSTableColumn<SSInvoice> getSaldoColumn() {
        return new SSTableColumn<SSInvoice>(SSBundle.getBundle().getString("invoicetable.column.11")){

            @Override
            public Object getValue(SSInvoice iInvoice) {
                return SSInvoiceMath.getSaldo(iInvoice.getNumber());
            }

            @Override
            public void setValue(SSInvoice iObject, Object iValue) {
            }

            @Override
            public Class<?> getColumnClass() {
                return BigDecimal.class;
            }

            @Override
            public int getDefaultWidth() {
                return 90;
            }
        };
    }
}

