/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.order;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.calc.math.SSOrderMath;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSPurchaseOrderRow;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSMail;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.order.SSOrderDialog;
import se.swedsoft.bookkeeping.gui.order.panel.SSOrderSearchPanel;
import se.swedsoft.bookkeeping.gui.order.util.SSOrderTableModel;
import se.swedsoft.bookkeeping.gui.purchaseorder.SSPurchaseOrderDialog;
import se.swedsoft.bookkeeping.gui.purchaseorder.SSPurchaseOrderFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.components.SSTabbedPanePanel;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInitDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSDefaultFileChooser;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSXMLFileChooser;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;
import se.swedsoft.bookkeeping.importexport.xml.SSOrderExporter;
import se.swedsoft.bookkeeping.importexport.xml.SSOrderImporter;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSOrderFrame
extends SSDefaultTableFrame {
    private static SSOrderFrame cInstance;
    private JTabbedPane iTabbedPane;
    private SSTable iTable;
    private SSOrderTableModel iModel;
    private SSOrderSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSOrderFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
    }

    public static SSOrderFrame getInstance() {
        return cInstance;
    }

    private SSOrderFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("orderframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "orderframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOrderDialog.newDialog(SSOrderFrame.this.getMainFrame(), SSOrderFrame.this.iModel);
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "orderframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOrder iSelected = (SSOrder)SSOrderFrame.this.iModel.getSelectedRow(SSOrderFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSOrderFrame.this.getOrder(iSelected);
                }
                if (iSelected != null) {
                    SSOrderDialog.editDialog(SSOrderFrame.this.getMainFrame(), iSelected, SSOrderFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSOrderFrame.this.getMainFrame(), "orderframe.ordergone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "orderframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOrder iSelected = (SSOrder)SSOrderFrame.this.iModel.getSelectedRow(SSOrderFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSOrderFrame.this.getOrder(iSelected);
                }
                if (iSelected != null) {
                    SSOrderDialog.copyDialog(SSOrderFrame.this.getMainFrame(), iSelected, SSOrderFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSOrderFrame.this.getMainFrame(), "orderframe.ordergone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "orderframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSOrderFrame.this.iTable.getSelectedRows();
                List toDelete = SSOrderFrame.this.iModel.getObjects(selected);
                SSOrderFrame.this.deleteSelectedOrder(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        SSMenuButton iButton2 = new SSMenuButton("ICON_INVOICE24", "orderframe.createinvoicebutton");
        iButton2.add("orderframe.customerinvoice", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSOrderFrame.this.iModel.getSelectedRows(SSOrderFrame.this.iTable);
                if (!(iSelected = SSOrderFrame.this.getOrders(iSelected)).isEmpty()) {
                    SSOrderDialog.invoiceDialog(SSOrderFrame.this.getMainFrame(), iSelected, SSOrderFrame.this.iModel);
                }
            }
        });
        iButton2.add("orderframe.cashreceipt", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSOrderFrame.this.iModel.getSelectedRows(SSOrderFrame.this.iTable);
                if (!(iSelected = SSOrderFrame.this.getOrders(iSelected)).isEmpty()) {
                    SSOrderDialog.cashReceiptDialog(SSOrderFrame.this.getMainFrame(), iSelected, SSOrderFrame.this.iModel);
                }
            }
        });
        iButton2.add("orderframe.periodicinvoice", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSOrderFrame.this.iModel.getSelectedRows(SSOrderFrame.this.iTable);
                if (!(iSelected = SSOrderFrame.this.getOrders(iSelected)).isEmpty()) {
                    SSOrderDialog.periodicInvoiceDialog(SSOrderFrame.this.getMainFrame(), iSelected, SSOrderFrame.this.iModel);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton2);
        toolBar.add(iButton2);
        iButton = new SSButton("ICON_INVOICE24", "orderframe.createspurchaseorderbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSOrderFrame.this.iModel.getSelectedRows(SSOrderFrame.this.iTable);
                if ((iSelected = SSOrderFrame.this.getOrders(iSelected)) == null) {
                    return;
                }
                for (SSOrder iOrder : iSelected) {
                    if (iOrder.getPurchaseOrderNr() == null) continue;
                    SSInformationDialog.showDialog(SSOrderFrame.this.getMainFrame(), "orderframe.orderhaspurchaseorder", iOrder.getNumber());
                    return;
                }
                Map<SSProduct, Integer> iProductCount = null;
                try {
                    iProductCount = SSOrderMath.getProductCount(iSelected);
                }
                catch (NullPointerException e1) {
                    new SSErrorDialog(SSOrderFrame.this.getMainFrame(), "orderframe.orderwrong");
                }
                SSPurchaseOrder iPurchaseOrder = new SSPurchaseOrder();
                for (Map.Entry<SSProduct, Integer> ssProductIntegerEntry : iProductCount.entrySet()) {
                    if (ssProductIntegerEntry.getKey().isParcel()) {
                        for (SSProductRow iParcelRow : ssProductIntegerEntry.getKey().getParcelRows()) {
                            SSPurchaseOrderRow iRow = new SSPurchaseOrderRow();
                            iRow.setProduct(iParcelRow.getProduct(SSDB.getInstance().getProducts()));
                            iRow.setQuantity(ssProductIntegerEntry.getValue() * iParcelRow.getQuantity());
                            iPurchaseOrder.getRows().add(iRow);
                        }
                        continue;
                    }
                    SSPurchaseOrderRow iRow = new SSPurchaseOrderRow();
                    iRow.setProduct(ssProductIntegerEntry.getKey());
                    iRow.setQuantity(ssProductIntegerEntry.getValue());
                    iPurchaseOrder.getRows().add(iRow);
                }
                if (SSPurchaseOrderFrame.getInstance() != null) {
                    SSPurchaseOrderDialog.newDialog(SSOrderFrame.this.getMainFrame(), iPurchaseOrder, iSelected, SSPurchaseOrderFrame.getInstance().getModel());
                } else {
                    SSPurchaseOrderDialog.newDialog(SSOrderFrame.this.getMainFrame(), iPurchaseOrder, iSelected, null);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton2 = new SSMenuButton("ICON_IMPORT", "orderframe.importbutton");
        iButton2.add("orderframe.importxml", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSXMLFileChooser iFilechooser = SSXMLFileChooser.getInstance();
                iFilechooser.setSelectedFile(new File("Orderlista.xml"));
                if (iFilechooser.showOpenDialog(SSOrderFrame.this.getMainFrame()) == 0) {
                    final SSOrderImporter iImporter = new SSOrderImporter(iFilechooser.getSelectedFile());
                    try {
                        SSInitDialog.runProgress(SSOrderFrame.this.getMainFrame(), "Importerar ordrar", new Runnable(){

                            @Override
                            public void run() {
                                iImporter.doImport();
                            }
                        });
                    }
                    catch (SSImportException e1) {
                        SSErrorDialog.showDialog(SSOrderFrame.this.getMainFrame(), "", e1.getLocalizedMessage());
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        });
        iButton2.add("orderframe.importebutik", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSDefaultFileChooser iFilechooser = new SSDefaultFileChooser();
                if (iFilechooser.showOpenDialog(SSOrderFrame.this.getMainFrame()) == 0) {
                    final SSOrderImporter iImporter = new SSOrderImporter(iFilechooser.getSelectedFile());
                    try {
                        SSInitDialog.runProgress(SSOrderFrame.this.getMainFrame(), "Importerar ordrar", new Runnable(){

                            @Override
                            public void run() {
                                iImporter.doEbutikImport();
                            }
                        });
                    }
                    catch (SSImportException e1) {
                        SSErrorDialog.showDialog(SSOrderFrame.this.getMainFrame(), "", e1.getLocalizedMessage());
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        });
        toolBar.add(iButton2);
        iButton = new SSButton("ICON_EXPORT", "orderframe.exportbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SSOrder> iItems;
                List<SSOrder> iSelected = SSOrderFrame.this.iModel.getSelectedRows(SSOrderFrame.this.iTable);
                if ((iSelected = SSOrderFrame.this.getOrders(iSelected)) != null) {
                    int select = SSQueryDialog.showDialog((JFrame)SSOrderFrame.this.getMainFrame(), 1, SSOrderFrame.this.getTitle(), SSBundle.getBundle().getString("orderframe.exportallorselected"));
                    switch (select) {
                        case 0: {
                            iItems = iSelected;
                            break;
                        }
                        case 1: {
                            iItems = SSDB.getInstance().getOrders();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    iItems = SSDB.getInstance().getOrders();
                }
                if (!iItems.isEmpty()) {
                    SSXMLFileChooser iFilechooser = SSXMLFileChooser.getInstance();
                    iFilechooser.setSelectedFile(new File("Orderlista.xml"));
                    if (iFilechooser.showSaveDialog(SSOrderFrame.this.getMainFrame()) == 0) {
                        SSOrderExporter iExporter = new SSOrderExporter(iFilechooser.getSelectedFile(), iItems);
                        iExporter.doExport();
                    }
                }
            }
        });
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton2 = new SSMenuButton("ICON_PRINT", "orderframe.printbutton");
        JMenuItem iMenuItem = iButton2.add("orderframe.print.orderreport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSOrderFrame.this.iModel.getSelectedRows(SSOrderFrame.this.iTable);
                if (!(iSelected = SSOrderFrame.this.getOrders(iSelected)).isEmpty()) {
                    SSReportFactory.OrderReport(SSOrderFrame.this.getMainFrame(), iSelected);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuItem = iButton2.add("orderframe.print.emailorderreport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOrder iSelected = (SSOrder)SSOrderFrame.this.iModel.getSelectedRow(SSOrderFrame.this.iTable);
                if ((iSelected = SSOrderFrame.this.getOrder(iSelected)) == null) {
                    return;
                }
                if (!SSMail.isOk(iSelected.getCustomer())) {
                    return;
                }
                SSReportFactory.EmailOrderReport(SSOrderFrame.this.getMainFrame(), iSelected);
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuItem = iButton2.add("orderframe.print.deliverynote", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSOrderFrame.this.iModel.getSelectedRows(SSOrderFrame.this.iTable);
                if (!(iSelected = SSOrderFrame.this.getOrders(iSelected)).isEmpty()) {
                    SSReportFactory.DeliverynoteReport(SSOrderFrame.this.getMainFrame(), iSelected);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuItem = iButton2.add("orderframe.print.pickingslip", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSOrderFrame.this.iModel.getSelectedRows(SSOrderFrame.this.iTable);
                if (!(iSelected = SSOrderFrame.this.getOrders(iSelected)).isEmpty()) {
                    SSReportFactory.PickingslipReport(SSOrderFrame.this.getMainFrame(), iSelected);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iButton2.addSeparator();
        iButton2.add("orderframe.print.orderlistreport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.OrderListReport(SSOrderFrame.this.getMainFrame());
            }
        });
        toolBar.add(iButton2);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSOrderTableModel();
        this.iModel.addColumn(SSOrderTableModel.COLUMN_PRINTED);
        this.iModel.addColumn(SSOrderTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSOrderTableModel.COLUMN_CUSTOMER_NR);
        this.iModel.addColumn(SSOrderTableModel.COLUMN_CUSTOMER_NAME);
        this.iModel.addColumn(SSOrderTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSOrderTableModel.COLUMN_NET_SUM);
        this.iModel.addColumn(SSOrderTableModel.COLUMN_CURRENCY);
        this.iModel.addColumn(SSOrderTableModel.COLUMN_ESTIMATED_DELIVERY);
        this.iModel.addColumn(SSOrderTableModel.COLUMN_INVOICE);
        this.iModel.addColumn(SSOrderTableModel.COLUMN_PURCHASEORDER);
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOrder iSelected = (SSOrder)SSOrderFrame.this.iModel.getSelectedRow(SSOrderFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                Integer iNumber = iSelected.getNumber();
                iSelected = SSOrderFrame.this.getOrder(iSelected);
                if (iSelected != null) {
                    SSOrderDialog.editDialog(SSOrderFrame.this.getMainFrame(), iSelected, SSOrderFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSOrderFrame.this.getMainFrame(), "orderframe.ordergone", iNumber);
                }
            }
        });
        this.iTabbedPane = new JTabbedPane();
        this.iTabbedPane.add(SSBundle.getBundle().getString("orderframe.filter.1"), new SSTabbedPanePanel());
        this.iTabbedPane.add(SSBundle.getBundle().getString("orderframe.filter.2"), new SSTabbedPanePanel());
        this.iTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SSOrderFrame.this.iSearchPanel.ApplyFilter(SSDB.getInstance().getOrders());
            }
        });
        JPanel iPanel = new JPanel();
        this.iSearchPanel = new SSOrderSearchPanel(this.iModel);
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)this.iTabbedPane, "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public void setFilterIndex(int index, List<SSOrder> iOrders) {
        JPanel iPanel = (JPanel)this.iTabbedPane.getComponentAt(index);
        iPanel.removeAll();
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        List<Object> iFiltered = Collections.emptyList();
        List<SSInvoice> iInvoices = SSDB.getInstance().getInvoices();
        switch (index) {
            case 0: {
                iFiltered = iOrders;
                break;
            }
            case 1: {
                iFiltered = new LinkedList();
                for (SSOrder iOrder : iOrders) {
                    if (iOrder.getInvoiceNr() != null || iOrder.getPeriodicInvoiceNr() != null) continue;
                    iFiltered.add(iOrder);
                }
                break;
            }
        }
        this.iModel.setObjects(iFiltered);
        this.iTabbedPane.repaint();
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    public SSOrderTableModel getModel() {
        return this.iModel;
    }

    public JTabbedPane getTabbedPane() {
        return this.iTabbedPane;
    }

    private void deleteSelectedOrder(List<SSOrder> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "orderframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSOrder iOrder : delete) {
                if (SSPostLock.isLocked("order" + iOrder.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "orderframe.orderopen", iOrder.getNumber());
                    continue;
                }
                LinkedList<SSTender> iTenders = new LinkedList<SSTender>(SSDB.getInstance().getTenders());
                for (SSTender iTender : iTenders) {
                    if (!iTender.hasOrder(iOrder)) continue;
                    iTender.setOrder(null);
                    SSDB.getInstance().updateTender(iTender);
                }
                iTenders = null;
                SSDB.getInstance().deleteOrder(iOrder);
            }
        }
    }

    private SSOrder getOrder(SSOrder iOrder) {
        return SSDB.getInstance().getOrder(iOrder);
    }

    private List<SSOrder> getOrders(List<SSOrder> iOrders) {
        return SSDB.getInstance().getOrders(iOrders);
    }

    public void updateFrame() {
        this.iSearchPanel.ApplyFilter(SSDB.getInstance().getOrders());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        this.iTabbedPane = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.order.SSOrderFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTabbedPane=").append(this.iTabbedPane);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

