/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.outdelivery;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import se.swedsoft.bookkeeping.data.SSOutdelivery;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.outdelivery.panel.SSOutdeliveryPanel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;

public class SSOutdeliveryDialog {
    private SSOutdeliveryDialog() {
    }

    public static void newDialog(final SSMainFrame iMainFrame, final AbstractTableModel pModel) {
        final SSDialog iDialog = new SSDialog(iMainFrame, SSBundle.getBundle().getString("outdeliveryframe.new.title"));
        final SSOutdeliveryPanel iPanel = new SSOutdeliveryPanel(iDialog);
        SSOutdelivery iOutdelivery = new SSOutdelivery();
        iOutdelivery.setNumber(null);
        iPanel.setOutdelivery(iOutdelivery);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        iPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutdelivery iOutdelivery = iPanel.getoutdelivery();
                SSDB.getInstance().addOutdelivery(iOutdelivery);
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iDialog.closeDialog();
            }
        });
        iPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "outdeliveryframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                SSOutdelivery iOutdelivery = iPanel.getoutdelivery();
                SSDB.getInstance().addOutdelivery(iOutdelivery);
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iDialog.closeDialog();
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.showDialog();
    }

    public static void editDialog(final SSMainFrame iMainFrame, SSOutdelivery iOutdelivery, final AbstractTableModel pModel) {
        final String lockString = "outdelivery" + iOutdelivery.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "outdeliveryframe.outdeliveryopen", iOutdelivery.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, SSBundle.getBundle().getString("outdeliveryframe.edit.title"));
        final SSOutdeliveryPanel iPanel = new SSOutdeliveryPanel(iDialog);
        iPanel.setOutdelivery(new SSOutdelivery(iOutdelivery));
        iDialog.add((Component)iPanel.getPanel(), "Center");
        iPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutdelivery iOutdelivery = iPanel.getoutdelivery();
                SSDB.getInstance().updateOutdelivery(iOutdelivery);
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        });
        iPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "outdeliveryframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                SSOutdelivery iOutdelivery = iPanel.getoutdelivery();
                SSDB.getInstance().updateOutdelivery(iOutdelivery);
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.showDialog();
    }

    public static void copyDialog(final SSMainFrame iMainFrame, SSOutdelivery iCopyFrom, final AbstractTableModel pModel) {
        String lockString = "outdelivery" + iCopyFrom.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (SSPostLock.isLocked(lockString)) {
            new SSErrorDialog(iMainFrame, "outdeliveryframe.outdeliveryopen", iCopyFrom.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, SSBundle.getBundle().getString("outdeliveryframe.copy.title"));
        final SSOutdeliveryPanel iPanel = new SSOutdeliveryPanel(iDialog);
        SSOutdelivery iOutdelivery = new SSOutdelivery(iCopyFrom);
        iOutdelivery.setNumber(null);
        iPanel.setOutdelivery(iOutdelivery);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        iPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutdelivery iOutdelivery = iPanel.getoutdelivery();
                SSDB.getInstance().addOutdelivery(iOutdelivery);
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iDialog.closeDialog();
            }
        });
        iPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "outdeliveryframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                SSOutdelivery iOutdelivery = iPanel.getoutdelivery();
                SSDB.getInstance().addOutdelivery(iOutdelivery);
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iDialog.closeDialog();
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.showDialog();
    }
}

