/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.outdelivery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSOutdelivery;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.outdelivery.SSOutdeliveryDialog;
import se.swedsoft.bookkeeping.gui.outdelivery.util.SSOutdeliveryTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSOutdeliveryFrame
extends SSDefaultTableFrame {
    private static SSOutdeliveryFrame cInstance;
    private SSTable iTable;
    private SSOutdeliveryTableModel iModel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSOutdeliveryFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
    }

    public static SSOutdeliveryFrame getInstance() {
        return cInstance;
    }

    private SSOutdeliveryFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("outdeliveryframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "outdeliveryframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutdeliveryDialog.newDialog(SSOutdeliveryFrame.this.getMainFrame(), SSOutdeliveryFrame.this.iModel);
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "outdeliveryframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutdelivery iOutdelivery = (SSOutdelivery)SSOutdeliveryFrame.this.iModel.getSelectedRow(SSOutdeliveryFrame.this.iTable);
                Integer iNumber = null;
                if (iOutdelivery != null) {
                    iNumber = iOutdelivery.getNumber();
                    iOutdelivery = SSOutdeliveryFrame.this.getOutdelivery(iOutdelivery);
                }
                if (iOutdelivery != null) {
                    SSOutdeliveryDialog.editDialog(SSOutdeliveryFrame.this.getMainFrame(), iOutdelivery, SSOutdeliveryFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSOutdeliveryFrame.this.getMainFrame(), "outdeliveryframe.outdeliverygone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "outdeliveryframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutdelivery iOutdelivery = (SSOutdelivery)SSOutdeliveryFrame.this.iModel.getSelectedRow(SSOutdeliveryFrame.this.iTable);
                Integer iNumber = null;
                if (iOutdelivery != null) {
                    iNumber = iOutdelivery.getNumber();
                    iOutdelivery = SSOutdeliveryFrame.this.getOutdelivery(iOutdelivery);
                }
                if (iOutdelivery != null) {
                    SSOutdeliveryDialog.copyDialog(SSOutdeliveryFrame.this.getMainFrame(), iOutdelivery, SSOutdeliveryFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSOutdeliveryFrame.this.getMainFrame(), "outdeliveryframe.outdeliverygone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "outdeliveryframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSOutdeliveryFrame.this.iTable.getSelectedRows();
                List toDelete = SSOutdeliveryFrame.this.iModel.getObjects(selected);
                SSOutdeliveryFrame.this.deleteSelected(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        SSMenuButton iMenuButton = new SSMenuButton("ICON_PRINT", "outdeliveryframe.printbutton");
        iMenuButton.add("outdeliveryframe.print.list", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.OutdeliveryList(SSOutdeliveryFrame.this.getMainFrame());
            }
        });
        toolBar.add(iMenuButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSOutdeliveryTableModel();
        this.iModel.addColumn(SSOutdeliveryTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSOutdeliveryTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSOutdeliveryTableModel.COLUMN_TEXT);
        this.iModel.addColumn(SSOutdeliveryTableModel.COLUMN_TOTALCOUNT);
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSOutdelivery iOutdelivery = (SSOutdelivery)SSOutdeliveryFrame.this.iModel.getSelectedRow(SSOutdeliveryFrame.this.iTable);
                if (iOutdelivery == null) {
                    return;
                }
                Integer iNumber = iOutdelivery.getNumber();
                iOutdelivery = SSOutdeliveryFrame.this.getOutdelivery(iOutdelivery);
                if (iOutdelivery != null) {
                    SSOutdeliveryDialog.editDialog(SSOutdeliveryFrame.this.getMainFrame(), iOutdelivery, SSOutdeliveryFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSOutdeliveryFrame.this.getMainFrame(), "outdeliveryframe.outdeliverygone", iNumber);
                }
            }
        });
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public SSOutdeliveryTableModel getModel() {
        return this.iModel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    private void deleteSelected(List<SSOutdelivery> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "outdeliveryframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSOutdelivery iOutdelivery : delete) {
                if (SSPostLock.isLocked("outdelivery" + iOutdelivery.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "outdeliveryframe.outdeliveryopen", iOutdelivery.getNumber());
                    continue;
                }
                SSDB.getInstance().deleteOutdelivery(iOutdelivery);
            }
        }
    }

    private SSOutdelivery getOutdelivery(SSOutdelivery iOutdelivery) {
        return SSDB.getInstance().getOutdelivery(iOutdelivery);
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getOutdeliveries());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.outdelivery.SSOutdeliveryFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

