/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.ownreport.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSOwnReport;
import se.swedsoft.bookkeeping.data.SSOwnReportRow;
import se.swedsoft.bookkeeping.data.common.SSHeadingType;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.ownreport.util.SSOwnReportAccountRow;
import se.swedsoft.bookkeeping.gui.ownreport.util.SSOwnReportAccountTableModel;
import se.swedsoft.bookkeeping.gui.ownreport.util.SSOwnReportMonthlyTableModel;
import se.swedsoft.bookkeeping.gui.ownreport.util.SSOwnReportRowTableModel;
import se.swedsoft.bookkeeping.gui.project.util.SSProjectTableModel;
import se.swedsoft.bookkeeping.gui.resultunit.util.SSResultUnitTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSInputVerifier;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSAccountTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSDeleteAction;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellRenderer;

public class SSOwnReportPanel {
    private JPanel iPanel;
    private SSTable iHeadingTable;
    private SSOwnReportRowTableModel iHeadingTableModel;
    private SSTable iAccountTable;
    private SSOwnReportAccountTableModel iAccountTableModel;
    private SSTable iMonthlyTable;
    private SSOwnReportMonthlyTableModel iMonthlyTableModel;
    private JTabbedPane iTabbedPane;
    private JTextField iName;
    private SSButton iAddRowButton;
    private SSTableComboBox<SSOwnReportRow> iHeadingComboBox;
    private SSTableComboBox<SSAccount> iAccountComboBox;
    private SSTableComboBox<SSNewProject> iProjectComboBox;
    private SSTableComboBox<SSNewResultUnit> iResultUnitComboBox;
    SSOwnReport iOwnReport;
    SSInputVerifier iInputVerifier;
    private SSButtonPanel iButtonPanel;
    List<SSOwnReportRow> iOwnReportRows;

    public SSOwnReportPanel(SSOwnReport pOwnReport) {
        this.iOwnReport = pOwnReport;
        this.$$$setupUI$$$();
        this.iOwnReportRows = this.iOwnReport.getHeadings();
        this.iName.setText(this.iOwnReport.getName());
        this.iInputVerifier = new SSInputVerifier();
        this.iInputVerifier.add(this.iName);
        this.iInputVerifier.addListener(new SSInputVerifier.SSVerifierListener(){

            @Override
            public void updated(SSInputVerifier iVerifier, boolean iValid) {
                SSOwnReportPanel.this.iButtonPanel.getOkButton().setEnabled(iValid);
            }
        });
        this.iHeadingTable.setColorReadOnly(true);
        this.iHeadingTable.setColumnSortingEnabled(false);
        this.iHeadingTable.setSingleSelect();
        this.iHeadingTableModel = new SSOwnReportRowTableModel();
        this.iHeadingTableModel.addColumn(SSOwnReportRowTableModel.COLUMN_TYPE, true);
        this.iHeadingTableModel.addColumn(SSOwnReportRowTableModel.COLUMN_HEADING, true);
        this.iHeadingTableModel.setObjects(this.iOwnReportRows);
        this.iHeadingTableModel.setupTable(this.iHeadingTable);
        this.iHeadingComboBox.setModel(SSOwnReportRowTableModel.getDropDownModel());
        this.iHeadingComboBox.setSearchColumns(0);
        this.iHeadingComboBox.setAllowCustomValues(false);
        this.iAccountComboBox.setModel(SSAccountTableModel.getDropDownModel(this.getAccounts()));
        this.iAccountComboBox.setSearchColumns(0, 1);
        this.iAccountComboBox.setAllowCustomValues(false);
        this.iProjectComboBox.setModel(SSProjectTableModel.getDropDownModel());
        this.iProjectComboBox.setSearchColumns(0, 1);
        this.iProjectComboBox.setAllowCustomValues(false);
        this.iProjectComboBox.addSelectionListener(new SSSelectionListener<SSNewProject>(){

            @Override
            public void selected(SSNewProject iProject) {
                if (iProject != null) {
                    SSOwnReportPanel.this.iResultUnitComboBox.setSelected(null);
                }
            }
        });
        this.iProjectComboBox.setSelected(SSDB.getInstance().getProject(this.iOwnReport.getProjectNr()));
        this.iProjectComboBox.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                    SSOwnReportPanel.this.iProjectComboBox.setSelected(null);
                }
            }
        });
        this.iResultUnitComboBox.setModel(SSResultUnitTableModel.getDropDownModel());
        this.iResultUnitComboBox.setSearchColumns(0, 1);
        this.iResultUnitComboBox.setAllowCustomValues(false);
        this.iResultUnitComboBox.addSelectionListener(new SSSelectionListener<SSNewResultUnit>(){

            @Override
            public void selected(SSNewResultUnit iResultUnit) {
                if (iResultUnit != null) {
                    SSOwnReportPanel.this.iProjectComboBox.setSelected(null);
                }
            }
        });
        this.iResultUnitComboBox.setSelected(SSDB.getInstance().getResultUnit(this.iOwnReport.getResultUnitNr()));
        this.iResultUnitComboBox.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                    SSOwnReportPanel.this.iResultUnitComboBox.setSelected(null);
                }
            }
        });
        this.iHeadingTable.addSelectionDependentComponent(this.iAddRowButton);
        this.iAccountTable.setColorReadOnly(true);
        this.iAccountTable.setColumnSortingEnabled(false);
        this.iAccountTable.setSingleSelect();
        this.iAccountTableModel = new SSOwnReportAccountTableModel();
        this.iAccountTableModel.addColumn(SSOwnReportAccountTableModel.COLUMN_ACCOUNT, true);
        this.iAccountTableModel.addColumn(SSOwnReportAccountTableModel.COLUMN_DESCRIPTION, false);
        this.iAccountTableModel.addColumn(SSOwnReportAccountTableModel.COLUMN_BUDGET, true);
        this.iAccountTableModel.setupTable(this.iAccountTable);
        this.iAccountTable.setEnabled(false);
        this.iMonthlyTable.setColorReadOnly(true);
        this.iMonthlyTable.setColumnSortingEnabled(false);
        this.iMonthlyTable.setSingleSelect();
        this.iMonthlyTableModel = new SSOwnReportMonthlyTableModel(null, this.iOwnReportRows);
        List<SSMonth> iMonths = SSMonth.splitYearIntoMonths(SSDB.getInstance().getCurrentYear());
        this.iMonthlyTableModel = new SSOwnReportMonthlyTableModel(null, this.iOwnReportRows);
        this.iMonthlyTableModel.addColumn(SSBundle.getBundle().getString("ownreport.monthtable.column.1"));
        this.iMonthlyTableModel.addColumn(SSBundle.getBundle().getString("ownreport.monthtable.column.2"));
        Collections.sort(iMonths, new Comparator<SSMonth>(){

            @Override
            public int compare(SSMonth o1, SSMonth o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        this.iMonthlyTableModel.setObjects(iMonths);
        this.iMonthlyTable.setModel(this.iMonthlyTableModel);
        this.iMonthlyTable.getColumnModel().getColumn(0).setMaxWidth(75);
        this.iMonthlyTable.getColumnModel().getColumn(1).setMaxWidth(100);
        this.iMonthlyTable.getColumnModel().getColumn(1).setCellRenderer(new SSBigDecimalCellRenderer(2, true));
        this.iMonthlyTable.getColumnModel().getColumn(1).setCellEditor(new SSBigDecimalCellEditor(2));
        new SSDeleteAction(this.iHeadingTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSOwnReportRow iSelected = (SSOwnReportRow)SSOwnReportPanel.this.iHeadingTableModel.getSelectedRow(SSOwnReportPanel.this.iHeadingTable);
                if (iSelected != null) {
                    SSQueryDialog dialog = new SSQueryDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "tenderframe.deleterow", iSelected.toString());
                    if (dialog.getResponce() != 0) {
                        return null;
                    }
                    SSOwnReportPanel.this.iHeadingTableModel.deleteRow(iSelected);
                }
                return iPosition;
            }
        };
        new SSDeleteAction(this.iAccountTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSOwnReportAccountRow iSelected = (SSOwnReportAccountRow)SSOwnReportPanel.this.iAccountTableModel.getSelectedRow(SSOwnReportPanel.this.iAccountTable);
                if (iSelected != null) {
                    SSQueryDialog dialog = new SSQueryDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "tenderframe.deleterow", iSelected.toString());
                    if (dialog.getResponce() != 0) {
                        return null;
                    }
                    SSOwnReportPanel.this.iAccountTableModel.deleteRow(iSelected);
                }
                return iPosition;
            }
        };
        this.iAddRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = SSOwnReportPanel.this.iHeadingTable.getSelectedRow();
                List iObjects = SSOwnReportPanel.this.iHeadingTableModel.getObjects();
                iObjects.add(selected, new SSOwnReportRow());
                SSOwnReportPanel.this.iHeadingTableModel.fireTableDataChanged();
            }
        });
        this.iTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                switch (SSOwnReportPanel.this.iTabbedPane.getSelectedIndex()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        for (SSOwnReportRow iRow : SSOwnReportPanel.this.iOwnReportRows) {
                            if (SSOwnReportPanel.this.iHeadingComboBox.getModel().getObjects().contains(iRow) || iRow.getType() != SSHeadingType.HEADING2) continue;
                            SSOwnReportPanel.this.iHeadingComboBox.getModel().add(iRow);
                        }
                        SSOwnReportPanel.this.iHeadingComboBox.getModel().fireTableDataChanged();
                        break;
                    }
                    case 2: {
                        SSOwnReportPanel.this.iAccountComboBox.setModel(SSAccountTableModel.getDropDownModel(SSOwnReportPanel.this.getAccounts()));
                    }
                }
            }
        });
        this.iHeadingComboBox.addSelectionListener(new SSSelectionListener<SSOwnReportRow>(){

            @Override
            public void selected(SSOwnReportRow selected) {
                if (selected != null) {
                    if (selected.getHeading() != null && selected.getHeading().length() != 0) {
                        SSOwnReportPanel.this.iAccountTable.setEnabled(true);
                    } else {
                        SSOwnReportPanel.this.iAccountTable.setEnabled(false);
                    }
                    SSOwnReportPanel.this.iAccountTableModel.setObjects(selected.getAccountRows());
                } else {
                    SSOwnReportPanel.this.iAccountTable.setEnabled(false);
                }
            }
        });
        this.iAccountComboBox.addSelectionListener(new SSSelectionListener<SSAccount>(){

            @Override
            public void selected(SSAccount iAccount) {
                SSOwnReportPanel.this.iMonthlyTableModel.setAccount(iAccount);
            }
        });
    }

    public SSOwnReport getOwnReport() {
        this.iOwnReport.setName(this.iName.getText());
        if (this.iProjectComboBox.getText() != null && this.iProjectComboBox.getText().length() != 0) {
            this.iOwnReport.setProjectNr(this.iProjectComboBox.getText());
        } else {
            this.iOwnReport.setProjectNr(null);
        }
        if (this.iResultUnitComboBox.getText() != null && this.iResultUnitComboBox.getText().length() != 0) {
            this.iOwnReport.setResultUnitNr(this.iResultUnitComboBox.getText());
        } else {
            this.iOwnReport.setResultUnitNr(null);
        }
        this.iOwnReport.setHeadings(this.iOwnReportRows);
        return this.iOwnReport;
    }

    public boolean isValid() {
        return this.iName.getText().length() != 0;
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener al) {
        this.iButtonPanel.addOkActionListener(al);
    }

    public void addCancelAction(ActionListener al) {
        this.iButtonPanel.addCancelActionListener(al);
    }

    public List<SSAccount> getAccounts() {
        LinkedList<SSAccount> iAccounts = new LinkedList<SSAccount>();
        for (SSOwnReportRow iRow : this.iOwnReportRows) {
            for (SSOwnReportAccountRow iAccountRow : iRow.getAccountRows()) {
                if (iAccountRow.getAccount() == null) continue;
                iAccounts.add(iAccountRow.getAccount());
            }
        }
        return iAccounts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.ownreport.panel.SSOwnReportPanel");
        sb.append("{iAccountComboBox=").append(this.iAccountComboBox);
        sb.append(", iAccountTable=").append(this.iAccountTable);
        sb.append(", iAccountTableModel=").append(this.iAccountTableModel);
        sb.append(", iAddRowButton=").append(this.iAddRowButton);
        sb.append(", iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iHeadingComboBox=").append(this.iHeadingComboBox);
        sb.append(", iHeadingTable=").append(this.iHeadingTable);
        sb.append(", iHeadingTableModel=").append(this.iHeadingTableModel);
        sb.append(", iInputVerifier=").append(this.iInputVerifier);
        sb.append(", iMonthlyTable=").append(this.iMonthlyTable);
        sb.append(", iMonthlyTableModel=").append(this.iMonthlyTableModel);
        sb.append(", iName=").append(this.iName);
        sb.append(", iOwnReport=").append(this.iOwnReport);
        sb.append(", iOwnReportRows=").append(this.iOwnReportRows);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iProjectComboBox=").append(this.iProjectComboBox);
        sb.append(", iResultUnitComboBox=").append(this.iResultUnitComboBox);
        sb.append(", iTabbedPane=").append(this.iTabbedPane);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        SSButtonPanel sSButtonPanel;
        SSTable sSTable;
        SSTable sSTable2;
        SSButton sSButton;
        SSTable sSTable3;
        JTabbedPane jTabbedPane;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setFocusTraversalPolicyProvider(false);
        this.iTabbedPane = jTabbedPane = new JTabbedPane();
        jTabbedPane.setFocusTraversalPolicyProvider(true);
        jTabbedPane.setTabPlacement(1);
        jTabbedPane.setInheritsPopupMenu(true);
        jPanel.add((Component)jTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        ((Component)jPanel2).setEnabled(true);
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("ownreportpanel.tab1"), null, jPanel2, null);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.iHeadingTable = sSTable3 = new SSTable();
        ((Component)sSTable3).setEnabled(true);
        jScrollPane.setViewportView(sSTable3);
        this.iAddRowButton = sSButton = new SSButton();
        sSButton.setToolTipText("L\u00e4gg till rad ovanf\u00f6r markerad");
        sSButton.setIconName("ICON_BOTTOM16");
        jPanel2.add((Component)sSButton, new GridConstraints(0, 0, 1, 1, 4, 0, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        ((Component)jPanel3).setEnabled(true);
        jPanel3.setRequestFocusEnabled(false);
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("ownreportpanel.tab2"), null, jPanel3, null);
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel3.add((Component)jScrollPane2, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.iAccountTable = sSTable2 = new SSTable();
        jScrollPane2.setViewportView(sSTable2);
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iHeadingComboBox = sSTableComboBox;
        jPanel3.add(sSTableComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(250, -1), null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Rubrik:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(2, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("ownreportpanel.tab4"), null, jPanel4, null);
        JScrollPane jScrollPane3 = new JScrollPane();
        jPanel4.add((Component)jScrollPane3, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.iMonthlyTable = sSTable = new SSTable();
        jScrollPane3.setViewportView(sSTable);
        SSTableComboBox sSTableComboBox2 = new SSTableComboBox();
        this.iAccountComboBox = sSTableComboBox2;
        ((Component)sSTableComboBox2).setEnabled(true);
        jPanel4.add(sSTableComboBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(75, -1), null, new Dimension(75, -1)));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Konto:");
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 4, 0, 7, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(3, 4, new Insets(5, 5, 5, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("ownreportpanel.name"));
        jPanel5.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iName = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, new Dimension(200, -1), new Dimension(150, -1), new Dimension(200, -1)));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Projekt:");
        jPanel5.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Resultatenhet:");
        jPanel5.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        SSTableComboBox sSTableComboBox3 = new SSTableComboBox();
        this.iProjectComboBox = sSTableComboBox3;
        jPanel5.add(sSTableComboBox3, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, new Dimension(75, -1), null, new Dimension(75, -1)));
        SSTableComboBox sSTableComboBox4 = new SSTableComboBox();
        this.iResultUnitComboBox = sSTableComboBox4;
        jPanel5.add(sSTableComboBox4, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, new Dimension(75, -1), null, new Dimension(75, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

