/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.ownreport.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSOwnReportAccountRow
implements Serializable {
    static final long serialVersionUID = 1L;
    private SSAccount iAccount = new SSAccount();
    private Map<SSMonth, BigDecimal> iBudget = new HashMap<SSMonth, BigDecimal>();

    public SSOwnReportAccountRow() {
        SSNewAccountingYear iYear = SSDB.getInstance().getCurrentYear();
        List<SSMonth> iMonths = SSMonth.splitYearIntoMonths(iYear);
        for (SSMonth iMonth : iMonths) {
            this.iBudget.put(iMonth, new BigDecimal(0));
        }
    }

    public SSAccount getAccount() {
        return this.iAccount;
    }

    public void setAccount(SSAccount iAccount) {
        this.iAccount = iAccount;
    }

    public void setAccount(String iAccountNr) {
        Integer iNumber = Integer.parseInt(iAccountNr);
        for (SSAccount pAccount : SSDB.getInstance().getCurrentYear().getAccounts()) {
            if (!pAccount.getNumber().equals(iNumber)) continue;
            this.iAccount = pAccount;
        }
    }

    public Map<SSMonth, BigDecimal> getBudget() {
        return this.iBudget;
    }

    public void setBudget(Map<SSMonth, BigDecimal> iBudget) {
        this.iBudget = iBudget;
    }

    public void setYearBudget(BigDecimal iValue) {
        SSNewAccountingYear iYear = SSDB.getInstance().getCurrentYear();
        if (iYear == null) {
            return;
        }
        BigDecimal iMonthly = iValue.divide(new BigDecimal(this.iBudget.keySet().size()), new MathContext(100));
        for (SSMonth iMonth : this.iBudget.keySet()) {
            if (!this.iBudget.containsKey(iMonth)) continue;
            this.iBudget.put(iMonth, iMonthly);
        }
    }

    public BigDecimal getSum() {
        BigDecimal iSum = new BigDecimal(0);
        for (Map.Entry<SSMonth, BigDecimal> ssMonthBigDecimalEntry : this.iBudget.entrySet()) {
            iSum = iSum.add(ssMonthBigDecimalEntry.getValue());
        }
        return iSum;
    }

    public BigDecimal getSumForMonths(Date iFrom, Date iTo) {
        BigDecimal iSum = new BigDecimal(0);
        List<SSMonth> iMonths = SSMonth.splitYearIntoMonths(iFrom, iTo);
        for (SSMonth iMonth : iMonths) {
            if (!this.iBudget.containsKey(iMonth)) continue;
            iSum = iSum.add(this.iBudget.get(iMonth));
        }
        return iSum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.ownreport.util.SSOwnReportAccountRow");
        sb.append("{iAccount=").append(this.iAccount);
        sb.append(", iBudget=").append(this.iBudget);
        sb.append('}');
        return sb.toString();
    }
}

