/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.ownreport.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.table.TableCellEditor;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.gui.ownreport.util.SSOwnReportAccountRow;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSAccountCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.model.SSEditableTableModel;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;

public class SSOwnReportAccountTableModel
extends SSEditableTableModel<SSOwnReportAccountRow> {
    public static SSTableColumn<SSOwnReportAccountRow> COLUMN_ACCOUNT = new SSTableColumn<SSOwnReportAccountRow>(SSBundle.getBundle().getString("ownreport.accounttable.column.1")){

        @Override
        public Object getValue(SSOwnReportAccountRow iObject) {
            return iObject.getAccount() == null ? "" : (iObject.getAccount().getNumber() == null ? "" : iObject.getAccount().getNumber().toString());
        }

        @Override
        public void setValue(SSOwnReportAccountRow iObject, Object iValue) {
            iObject.setAccount((SSAccount)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 75;
        }

        @Override
        public TableCellEditor getCellEditor() {
            return new SSAccountCellEditor();
        }
    };
    public static SSTableColumn<SSOwnReportAccountRow> COLUMN_DESCRIPTION = new SSTableColumn<SSOwnReportAccountRow>(SSBundle.getBundle().getString("ownreport.accounttable.column.2")){

        @Override
        public Object getValue(SSOwnReportAccountRow iObject) {
            return iObject.getAccount() == null ? null : iObject.getAccount().getDescription();
        }

        @Override
        public void setValue(SSOwnReportAccountRow iObject, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 300;
        }
    };
    public static SSTableColumn<SSOwnReportAccountRow> COLUMN_BUDGET = new SSTableColumn<SSOwnReportAccountRow>(SSBundle.getBundle().getString("ownreport.accounttable.column.3")){

        @Override
        public Object getValue(SSOwnReportAccountRow iObject) {
            BigDecimal iSum = new BigDecimal(0);
            for (SSMonth iMonth : iObject.getBudget().keySet()) {
                BigDecimal iMonthly = iObject.getBudget().get(iMonth);
                if (iMonthly == null) continue;
                iSum = iSum.add(iMonthly);
            }
            return iSum.setScale(2, RoundingMode.HALF_UP);
        }

        @Override
        public void setValue(SSOwnReportAccountRow iObject, Object iValue) {
            iObject.setYearBudget((BigDecimal)iValue);
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };

    @Override
    public SSOwnReportAccountRow newObject() {
        return new SSOwnReportAccountRow();
    }

    @Override
    public Class getType() {
        return SSOwnReportAccountRow.class;
    }
}

