/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.periodicinvoice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSPeriodicInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.periodicinvoice.SSPeriodicInvoiceDialog;
import se.swedsoft.bookkeeping.gui.periodicinvoice.panel.SSListInvoicesPanel;
import se.swedsoft.bookkeeping.gui.periodicinvoice.panel.SSPeriodicInvoiceSearchPanel;
import se.swedsoft.bookkeeping.gui.periodicinvoice.util.SSPeriodicInvoiceTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSPeriodicInvoiceFrame
extends SSDefaultTableFrame {
    private static SSPeriodicInvoiceFrame cInstance;
    private SSTable iTable;
    private SSPeriodicInvoiceTableModel iModel;
    private SSPeriodicInvoiceSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSPeriodicInvoiceFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
    }

    public static SSPeriodicInvoiceFrame getInstance() {
        return cInstance;
    }

    private SSPeriodicInvoiceFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("periodicinvoiceframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "periodicinvoiceframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPeriodicInvoiceDialog.newDialog(SSPeriodicInvoiceFrame.this.getMainFrame(), SSPeriodicInvoiceFrame.this.iModel);
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "periodicinvoiceframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPeriodicInvoice iSelected = (SSPeriodicInvoice)SSPeriodicInvoiceFrame.this.iModel.getSelectedRow(SSPeriodicInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSPeriodicInvoiceFrame.this.getPeriodicInvoice(iSelected);
                }
                if (iSelected != null) {
                    SSPeriodicInvoiceDialog.editDialog(SSPeriodicInvoiceFrame.this.getMainFrame(), iSelected, SSPeriodicInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSPeriodicInvoiceFrame.this.getMainFrame(), "periodicinvoiceframe.invoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        iButton = new SSButton("ICON_COPYITEM", "periodicinvoiceframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPeriodicInvoice iSelected = (SSPeriodicInvoice)SSPeriodicInvoiceFrame.this.iModel.getSelectedRow(SSPeriodicInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSPeriodicInvoiceFrame.this.getPeriodicInvoice(iSelected);
                }
                if (iSelected != null) {
                    SSPeriodicInvoiceDialog.copyDialog(SSPeriodicInvoiceFrame.this.getMainFrame(), iSelected, SSPeriodicInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSPeriodicInvoiceFrame.this.getMainFrame(), "periodicinvoiceframe.invoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "periodicinvoiceframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSPeriodicInvoiceFrame.this.iTable.getSelectedRows();
                List toDelete = SSPeriodicInvoiceFrame.this.iModel.getObjects(selected);
                SSPeriodicInvoiceFrame.this.deleteSelectedInvoice(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_TASKLIST24", "periodicinvoiceframe.invoicelistbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPeriodicInvoice iSelected = (SSPeriodicInvoice)SSPeriodicInvoiceFrame.this.iModel.getSelectedRow(SSPeriodicInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSPeriodicInvoiceFrame.this.getPeriodicInvoice(iSelected);
                }
                if (iSelected != null) {
                    SSListInvoicesPanel.showDialog(SSPeriodicInvoiceFrame.this.getMainFrame(), iSelected);
                } else {
                    new SSErrorDialog(SSPeriodicInvoiceFrame.this.getMainFrame(), "periodicinvoiceframe.invoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_CREATECHANGE", "periodicinvoiceframe.invoicebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SSPeriodicInvoiceDialog.pendingPeriodicInvoicesDialog(SSPeriodicInvoiceFrame.this.getMainFrame())) {
                    SSPostLock.removeLock("periodicinvoicepending" + SSDB.getInstance().getCurrentCompany().getId());
                }
            }
        });
        toolBar.add(iButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSPeriodicInvoiceTableModel();
        this.iModel.addColumn(SSPeriodicInvoiceTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSPeriodicInvoiceTableModel.COLUMN_DESCRIPTION);
        this.iModel.addColumn(SSPeriodicInvoiceTableModel.COLUMN_CUSTOMER_NR);
        this.iModel.addColumn(SSPeriodicInvoiceTableModel.COLUMN_CUSTOMER_NAME);
        this.iModel.addColumn(SSPeriodicInvoiceTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSPeriodicInvoiceTableModel.COLUMN_NEXT);
        this.iModel.addColumn(SSPeriodicInvoiceTableModel.COLUMN_TOTAL_SUM);
        this.iModel.addColumn(SSPeriodicInvoiceTableModel.COLUMN_CURRENCY);
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPeriodicInvoice iSelected = (SSPeriodicInvoice)SSPeriodicInvoiceFrame.this.iModel.getSelectedRow(SSPeriodicInvoiceFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                Integer iNumber = iSelected.getNumber();
                iSelected = SSPeriodicInvoiceFrame.this.getPeriodicInvoice(iSelected);
                if (iSelected != null) {
                    SSPeriodicInvoiceDialog.editDialog(SSPeriodicInvoiceFrame.this.getMainFrame(), iSelected, SSPeriodicInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSPeriodicInvoiceFrame.this.getMainFrame(), "periodicinvoiceframe.invoicegone", iNumber);
                }
            }
        });
        JPanel iPanel = new JPanel();
        this.iSearchPanel = new SSPeriodicInvoiceSearchPanel(this.iModel);
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return iPanel;
    }

    public SSTableModel<SSPeriodicInvoice> getModel() {
        return this.iModel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    private void deleteSelectedInvoice(List<SSPeriodicInvoice> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "periodicinvoiceframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSPeriodicInvoice iPeriodicInvoice : delete) {
                if (SSPostLock.isLocked("periodicinvoice" + iPeriodicInvoice.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "periodicinvoiceframe.periodicinvoiceopen", iPeriodicInvoice.getNumber());
                    continue;
                }
                LinkedList<SSOrder> iOrdersToUpdate = new LinkedList<SSOrder>();
                for (SSOrder iOrder : SSDB.getInstance().getOrders()) {
                    if (!iOrder.hasPeriodicInvoice(iPeriodicInvoice)) continue;
                    iOrder.setPeriodicInvoice(null);
                    iOrdersToUpdate.add(iOrder);
                }
                for (SSOrder iOrder : iOrdersToUpdate) {
                    SSDB.getInstance().updateOrder(iOrder);
                }
                iOrdersToUpdate = null;
                SSDB.getInstance().deletePeriodicInvoice(iPeriodicInvoice);
            }
        }
    }

    public static void fireTableDataChanged() {
        if (cInstance != null) {
            cInstance.getModel().fireTableDataChanged();
        }
    }

    private SSPeriodicInvoice getPeriodicInvoice(SSPeriodicInvoice iPeriodicInvoice) {
        return SSDB.getInstance().getPeriodicInvoice(iPeriodicInvoice);
    }

    public void updateFrame() {
        this.iSearchPanel.ApplyFilter();
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.periodicinvoice.SSPeriodicInvoiceFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

