/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.periodicinvoice.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import se.swedsoft.bookkeeping.calc.math.SSDateMath;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSCustomer;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSPeriodicInvoice;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.company.panel.SSAdressPanel;
import se.swedsoft.bookkeeping.gui.company.panel.SSDefaultAccountPanel;
import se.swedsoft.bookkeeping.gui.customer.util.SSCustomerTableModel;
import se.swedsoft.bookkeeping.gui.invoice.util.SSInvoiceRowTableModel;
import se.swedsoft.bookkeeping.gui.tender.dialog.SSExchangeRateDialog;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonGroup;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSInputVerifier;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.components.SSIntegerTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSCurrencyTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDeliveryTermTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDeliveryWayTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSPaymentTermTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSDeleteAction;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSTraversalAction;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSTaxCodeCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSTaxCodeCellRenderer;
import se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherRowTableModelOld;

public class SSPeriodicInvoicePanel {
    private SSPeriodicInvoice iPeriodicInvoice;
    private SSInvoice iInvoice;
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JFormattedTextField iNumber;
    private SSBigDecimalTextField iCurrencyRate;
    private SSTableComboBox<SSCustomer> iCustomer;
    private JTextField iCustomerName;
    private JCheckBox iTaxFree;
    private SSBigDecimalTextField iDelayInterest;
    private SSAdressPanel iDeliveryAddress;
    private SSAdressPanel iInvoiceAddress;
    private JTextArea iText;
    private JTextField iYourContactPerson;
    private JTextField iOurContactPerson;
    private SSBigDecimalTextField iTaxRate1;
    private SSBigDecimalTextField iTaxRate2;
    private SSBigDecimalTextField iTaxRate3;
    private JTextField iYourOrderNumber;
    private JCheckBox iEuSaleCommodity;
    private JCheckBox iEuSaleYhirdPartCommodity;
    private SSEditableTableComboBox<SSDeliveryWay> iDeliveryWay;
    private SSEditableTableComboBox<SSDeliveryTerm> iDeliveryTerm;
    private SSEditableTableComboBox<SSPaymentTerm> iPaymentTerm;
    private SSEditableTableComboBox<SSCurrency> iCurrency;
    private SSTable iTable;
    private SSDefaultAccountPanel iDefaultAccounts;
    private SSButton iCurrencyCalculatorButton;
    private SSBigDecimalTextField iNetSum;
    private SSBigDecimalTextField iTaxSum1;
    private SSBigDecimalTextField iTaxSum2;
    private SSBigDecimalTextField iTaxSum3;
    private SSBigDecimalTextField iRoundingSum;
    private SSBigDecimalTextField iTotalSum;
    private JLabel iTaxLabel1;
    private JLabel iTaxLabel2;
    private JLabel iTaxLabel3;
    private JCheckBox iSavecustomerandproducts;
    private SSInvoiceRowTableModel iModel;
    private SSTable iVoucherTable;
    private SSVoucherRowTableModelOld iVoucherTableModel;
    private JButton iRefreshVoucher;
    private SSInputVerifier iInputVerifier;
    private SSDateChooser iDate;
    private SSIntegerTextField iCount;
    private SSIntegerTextField iPeriod;
    private JTextField iDescription;
    private JCheckBox iAppendPeriod;
    private SSDateChooser iPeriodStart;
    private SSDateChooser iPeriodEnd;
    private SSTable iInvoices;
    private JTabbedPane iTabbedPane;
    private JCheckBox isStockInfluencing;
    private JCheckBox iAddInfo;
    private JTextField iInformation;
    private JTextField textField1;

    public SSPeriodicInvoicePanel(final SSDialog iOwner) {
        this.$$$setupUI$$$();
        this.iTable.setColorReadOnly(true);
        this.iTable.setColumnSortingEnabled(false);
        this.iModel = new SSInvoiceRowTableModel();
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_PRODUCT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_DESCRIPTION, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_UNITPRICE, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_QUANTITY, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_UNIT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_DISCOUNT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_SUM, false);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_TAX, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_ACCOUNT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_PROJECT, true);
        this.iModel.addColumn(SSInvoiceRowTableModel.COLUMN_RESULTUNIT, true);
        this.iModel.setupTable(this.iTable);
        this.iModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SSPeriodicInvoicePanel.this.updateSumFields();
            }
        });
        this.iVoucherTableModel = new SSVoucherRowTableModelOld(false, true);
        this.iVoucherTable.setModel(this.iVoucherTableModel);
        SSVoucherRowTableModelOld.setupTable(this.iVoucherTable, this.iVoucherTableModel);
        this.iCustomer.setModel(SSCustomerTableModel.getDropDownModel());
        this.iCustomer.setSearchColumns(0, 1);
        this.iCustomer.setAllowCustomValues(true);
        this.iCustomer.addSelectionListener(new SSSelectionListener<SSCustomer>(){

            @Override
            public void selected(SSCustomer selected) {
                if (selected != null) {
                    SSPeriodicInvoicePanel.this.iModel.setCustomer(selected);
                    SSPeriodicInvoicePanel.this.iInvoice.setCustomer(selected);
                    SSPeriodicInvoicePanel.this.iInvoice.setCurrencyRate(selected.getInvoiceCurrency() == null ? new BigDecimal(1) : selected.getInvoiceCurrency().getExchangeRate());
                    if (selected.getDiscount() != null) {
                        for (SSSaleRow iRow : SSPeriodicInvoicePanel.this.iModel.getObjects()) {
                            iRow.setDiscount(selected.getDiscount().doubleValue() == new BigDecimal(0).doubleValue() ? null : selected.getDiscount());
                        }
                    }
                    SSPeriodicInvoicePanel.this.setPeriodicInvoice(SSPeriodicInvoicePanel.this.iPeriodicInvoice);
                }
            }
        });
        new SSTraversalAction(this.iTable){

            @Override
            protected Point doTraversal(Point iPosition) {
                if (iPosition.x <= 4) {
                    ++iPosition.x;
                }
                if (iPosition.x == 5) {
                    ++iPosition.y;
                    iPosition.x = 0;
                    if (iPosition.y == SSPeriodicInvoicePanel.this.iModel.getRowCount()) {
                        SSPeriodicInvoicePanel.this.iButtonPanel.getOkButton().requestFocus();
                        return null;
                    }
                }
                return iPosition;
            }
        };
        new SSDeleteAction(this.iTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSSaleRow iSelected = (SSSaleRow)SSPeriodicInvoicePanel.this.iModel.getSelectedRow(SSPeriodicInvoicePanel.this.iTable);
                if (iSelected != null) {
                    SSQueryDialog dialog = new SSQueryDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "tenderframe.deleterow", iSelected.toString());
                    if (dialog.getResponce() != 0) {
                        return null;
                    }
                    SSPeriodicInvoicePanel.this.iModel.deleteRow(iSelected);
                }
                return iPosition;
            }
        };
        this.iCurrency.getComboBox().setModel(SSCurrencyTableModel.getDropDownModel());
        this.iCurrency.getComboBox().setSearchColumns(0);
        this.iCurrency.setEditingFactory(SSCurrencyTableModel.getEditingFactory(iOwner));
        this.iCurrency.getComboBox().addSelectionListener(new SSSelectionListener<SSCurrency>(){

            @Override
            public void selected(SSCurrency selected) {
                if (selected != null) {
                    SSPeriodicInvoicePanel.this.iCurrencyRate.setValue(selected.getExchangeRate());
                }
                SSPeriodicInvoicePanel.this.iModel.fireTableDataChanged();
            }
        });
        this.iCurrencyRate.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SSPeriodicInvoicePanel.this.iInvoice.setCurrencyRate(SSPeriodicInvoicePanel.this.iCurrencyRate.getValue());
                SSPeriodicInvoicePanel.this.updateSumFields();
            }
        });
        this.iDeliveryWay.getComboBox().setModel(SSDeliveryWayTableModel.getDropDownModel());
        this.iDeliveryWay.getComboBox().setSearchColumns(0);
        this.iDeliveryWay.setEditingFactory(SSDeliveryWayTableModel.getEditingFactory(iOwner));
        this.iDeliveryTerm.getComboBox().setModel(SSDeliveryTermTableModel.getDropDownModel());
        this.iDeliveryTerm.getComboBox().setSearchColumns(0);
        this.iDeliveryTerm.setEditingFactory(SSDeliveryTermTableModel.getEditingFactory(iOwner));
        this.iPaymentTerm.getComboBox().setModel(SSPaymentTermTableModel.getDropDownModel());
        this.iPaymentTerm.getComboBox().setSearchColumns(0);
        this.iPaymentTerm.setEditingFactory(SSPaymentTermTableModel.getEditingFactory(iOwner));
        this.iTaxRate1.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSPeriodicInvoicePanel.this.iInvoice.setTaxRate1(SSPeriodicInvoicePanel.this.iTaxRate1.getValue());
                SSPeriodicInvoicePanel.this.updateTaxTexts();
                SSPeriodicInvoicePanel.this.updateSumFields();
            }
        });
        this.iTaxRate2.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSPeriodicInvoicePanel.this.iInvoice.setTaxRate2(SSPeriodicInvoicePanel.this.iTaxRate2.getValue());
                SSPeriodicInvoicePanel.this.updateTaxTexts();
                SSPeriodicInvoicePanel.this.updateSumFields();
            }
        });
        this.iTaxRate3.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSPeriodicInvoicePanel.this.iInvoice.setTaxRate3(SSPeriodicInvoicePanel.this.iTaxRate3.getValue());
                SSPeriodicInvoicePanel.this.updateTaxTexts();
                SSPeriodicInvoicePanel.this.updateSumFields();
            }
        });
        this.iTaxFree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPeriodicInvoicePanel.this.iInvoice.setTaxFree(SSPeriodicInvoicePanel.this.iTaxFree.isSelected());
                SSPeriodicInvoicePanel.this.updateSumFields();
            }
        });
        this.iCurrencyCalculatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSCurrency iCompanyCurrency = SSDB.getInstance().getCurrentCompany().getCurrency();
                SSCurrency iCurrentCurrency = (SSCurrency)SSPeriodicInvoicePanel.this.iCurrency.getSelected();
                if (iCompanyCurrency == null || iCurrentCurrency == null) {
                    new SSInformationDialog(iOwner, "invoiceframe.selectcurrency");
                    return;
                }
                SSExchangeRateDialog.showDialog(iOwner, SSPeriodicInvoicePanel.this.iInvoice, iCompanyCurrency, iCurrentCurrency, SSPeriodicInvoicePanel.this.iModel);
            }
        });
        this.iRefreshVoucher.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucher iVoucher = SSPeriodicInvoicePanel.this.iInvoice.generateVoucher();
                SSPeriodicInvoicePanel.this.iVoucherTableModel.setVoucher(iVoucher);
            }
        });
        SSButtonGroup iGroup = new SSButtonGroup(true);
        iGroup.add(this.iEuSaleCommodity);
        iGroup.add(this.iEuSaleYhirdPartCommodity);
        this.iInputVerifier = new SSInputVerifier();
        this.iInputVerifier.add(this.iCustomer);
        this.iInputVerifier.add(this.iCustomerName);
        this.iInputVerifier.addListener(new SSInputVerifier.SSVerifierListener(){

            @Override
            public void updated(SSInputVerifier iVerifier, boolean iValid) {
                SSPeriodicInvoicePanel.this.iButtonPanel.getOkButton().setEnabled(iValid);
            }
        });
        this.iDate.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date iDate = SSPeriodicInvoicePanel.this.iDate.getDate();
                Integer iPeriod = SSPeriodicInvoicePanel.this.iPeriod.getValue();
                if (iPeriod == null || iDate == null) {
                    return;
                }
                Date iPeriodStart = SSDateMath.getFirstDayInMonth(iDate);
                Date iPeriodEnd = SSDateMath.addMonths(iPeriodStart, iPeriod);
                SSPeriodicInvoicePanel.this.iPeriodStart.setDate(iPeriodStart);
                SSPeriodicInvoicePanel.this.iPeriodEnd.setDate(iPeriodEnd);
            }
        });
        this.iCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date iDate = SSPeriodicInvoicePanel.this.iDate.getDate();
                Integer iPeriod = SSPeriodicInvoicePanel.this.iPeriod.getValue();
                if (iPeriod == null || iDate == null) {
                    return;
                }
                Date iPeriodStart = SSDateMath.getFirstDayInMonth(iDate);
                Date iPeriodEnd = SSDateMath.addMonths(iPeriodStart, iPeriod);
                SSPeriodicInvoicePanel.this.iPeriodStart.setDate(iPeriodStart);
                SSPeriodicInvoicePanel.this.iPeriodEnd.setDate(iPeriodEnd);
            }
        });
        this.iSavecustomerandproducts.setSelected(true);
        this.addKeyListeners();
    }

    public void dispose() {
        ActionListener[] iActionListeners;
        PropertyChangeListener[] iPropertyChangeListeners;
        this.iModel.setCustomer(null);
        this.iPanel.removeAll();
        this.iPanel = null;
        this.iButtonPanel.dispose();
        this.iButtonPanel = null;
        this.iTable.dispose();
        this.iTable = null;
        this.iNumber.removeAll();
        this.iNumber = null;
        this.iCurrencyRate.removeAll();
        this.iCurrencyRate = null;
        this.iDate.dispose();
        this.iDate = null;
        this.iCustomer.dispose();
        this.iCustomer = null;
        this.iCustomerName = null;
        this.iTaxFree = null;
        this.iDelayInterest = null;
        this.iDeliveryAddress = null;
        this.iInvoiceAddress = null;
        this.iText.removeAll();
        this.iText = null;
        this.iYourContactPerson.removeAll();
        this.iYourContactPerson = null;
        this.iOurContactPerson.removeAll();
        this.iOurContactPerson = null;
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners = this.iTaxRate1.getPropertyChangeListeners()) {
            this.iTaxRate1.removePropertyChangeListener(iPropertyChangeListener);
        }
        this.iTaxRate1.removeAll();
        this.iTaxRate1 = null;
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners = this.iTaxRate2.getPropertyChangeListeners()) {
            this.iTaxRate2.removePropertyChangeListener(iPropertyChangeListener);
        }
        this.iTaxRate2.removeAll();
        this.iTaxRate2 = null;
        for (PropertyChangeListener iPropertyChangeListener : iPropertyChangeListeners = this.iTaxRate3.getPropertyChangeListeners()) {
            this.iTaxRate3.removePropertyChangeListener(iPropertyChangeListener);
        }
        this.iYourOrderNumber = null;
        this.iTaxRate3.removeAll();
        this.iTaxRate3 = null;
        this.iEuSaleCommodity.removeAll();
        this.iEuSaleCommodity = null;
        this.iEuSaleYhirdPartCommodity.removeAll();
        this.iEuSaleYhirdPartCommodity = null;
        this.iDeliveryWay.dispose();
        this.iDeliveryWay = null;
        this.iDeliveryTerm.dispose();
        this.iDeliveryTerm = null;
        this.iPaymentTerm.dispose();
        this.iPaymentTerm = null;
        this.iCurrency.dispose();
        this.iCurrency = null;
        this.iDefaultAccounts.dispose();
        this.iDefaultAccounts = null;
        this.iCurrencyCalculatorButton.dispose();
        this.iCurrencyCalculatorButton = null;
        this.iNetSum.removeAll();
        this.iNetSum = null;
        this.iTaxSum1.removeAll();
        this.iTaxSum1 = null;
        this.iTaxSum2.removeAll();
        this.iTaxSum2 = null;
        this.iTaxSum3.removeAll();
        this.iTaxSum3 = null;
        this.iRoundingSum.removeAll();
        this.iRoundingSum = null;
        this.iTotalSum.removeAll();
        this.iTotalSum = null;
        this.iTaxLabel1 = null;
        this.iTaxLabel2 = null;
        this.iTaxLabel3 = null;
        this.iSavecustomerandproducts = null;
        this.iModel = null;
        this.iInputVerifier = null;
        this.iVoucherTable.dispose();
        this.iVoucherTable = null;
        for (ActionListener iActionListener : iActionListeners = this.iRefreshVoucher.getActionListeners()) {
            this.iRefreshVoucher.removeActionListener(iActionListener);
        }
        this.iRefreshVoucher.removeAll();
        this.iRefreshVoucher = null;
        this.iVoucherTableModel = null;
        this.isStockInfluencing = null;
        this.iCount.dispose();
        this.iCount = null;
        this.iPeriod.dispose();
        this.iPeriod = null;
        this.iAppendPeriod.removeAll();
        this.iAppendPeriod = null;
        this.iPeriodStart.dispose();
        this.iPeriodStart = null;
        this.iPeriodEnd.dispose();
        this.iPeriodEnd = null;
        this.iInputVerifier = null;
        this.iTabbedPane.removeAll();
        this.iTabbedPane = null;
    }

    public boolean isValid() {
        return this.iInputVerifier.isValid();
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener pActionListener) {
        this.iButtonPanel.addOkActionListener(pActionListener);
    }

    public void addCancelAction(ActionListener pActionListener) {
        this.iButtonPanel.addCancelActionListener(pActionListener);
    }

    public void setPeriodicInvoice(SSPeriodicInvoice iPeriodicInvoice) {
        this.iPeriodicInvoice = iPeriodicInvoice;
        this.iInvoice = iPeriodicInvoice.getTemplate();
        this.iDate.setDate(iPeriodicInvoice.getDate());
        this.iCount.setValue(iPeriodicInvoice.getCount());
        this.iPeriod.setValue(iPeriodicInvoice.getPeriod());
        this.iDescription.setText(iPeriodicInvoice.getDescription());
        this.iAppendPeriod.setSelected(iPeriodicInvoice.getAppendPeriod());
        this.iPeriodStart.setDate(iPeriodicInvoice.getPeriodStart());
        this.iPeriodEnd.setDate(iPeriodicInvoice.getPeriodEnd());
        this.iAddInfo.setSelected(iPeriodicInvoice.isAppendInformation());
        this.iInformation.setText(iPeriodicInvoice.getInformation());
        this.iVoucherTableModel.setVoucher(this.iInvoice.getVoucher());
        this.iModel.setObjects(this.iInvoice.getRows());
        this.iNumber.setValue(iPeriodicInvoice.getNumber());
        this.iYourOrderNumber.setText(this.iInvoice.getYourOrderNumber());
        this.iCustomer.setText(this.iInvoice.getCustomerNr());
        for (SSCustomer pCustomer : SSDB.getInstance().getCustomers()) {
            if (!pCustomer.getNumber().equals(this.iCustomer.getText())) continue;
            this.iModel.setCustomer(pCustomer);
        }
        this.iCustomerName.setText(this.iInvoice.getCustomerName());
        this.iOurContactPerson.setText(this.iInvoice.getOurContactPerson());
        this.iYourContactPerson.setText(this.iInvoice.getYourContactPerson());
        this.iDelayInterest.setValue(this.iInvoice.getDelayInterest());
        this.iCurrency.setSelected(this.iInvoice.getCurrency());
        this.iCurrencyRate.setValue(this.iInvoice.getCurrencyRate());
        this.iPaymentTerm.setSelected(this.iInvoice.getPaymentTerm(), true);
        this.iDeliveryTerm.setSelected(this.iInvoice.getDeliveryTerm());
        this.iDeliveryWay.setSelected(this.iInvoice.getDeliveryWay());
        this.iTaxFree.setSelected(this.iInvoice.getTaxFree());
        this.iTaxRate1.setValue(this.iInvoice.getTaxRate1());
        this.iTaxRate2.setValue(this.iInvoice.getTaxRate2());
        this.iTaxRate3.setValue(this.iInvoice.getTaxRate3());
        this.iEuSaleCommodity.setSelected(this.iInvoice.getEuSaleCommodity());
        this.iEuSaleYhirdPartCommodity.setSelected(this.iInvoice.getEuSaleThirdPartCommodity());
        this.iText.setText(this.iInvoice.getText());
        this.iInvoiceAddress.setAdress(this.iInvoice.getInvoiceAddress());
        this.iDeliveryAddress.setAdress(this.iInvoice.getDeliveryAddress());
        this.iDefaultAccounts.setDefaultAccounts(this.iInvoice.getDefaultAccounts());
        this.isStockInfluencing.setSelected(this.iInvoice.isStockInfluencing());
        this.updateSumFields();
        this.updateTaxTexts();
        this.iInputVerifier.update();
    }

    public SSPeriodicInvoice getPeriodicInvoice() {
        this.iPeriodicInvoice.setDate(this.iDate.getDate());
        this.iPeriodicInvoice.setCount(this.iCount.getValue());
        this.iPeriodicInvoice.setPeriod(this.iPeriod.getValue());
        this.iPeriodicInvoice.setDescription(this.iDescription.getText());
        this.iPeriodicInvoice.setAppendPeriod(this.iAppendPeriod.isSelected());
        this.iPeriodicInvoice.setPeriodStart(this.iPeriodStart.getDate());
        this.iPeriodicInvoice.setPeriodEnd(this.iPeriodEnd.getDate());
        this.iPeriodicInvoice.setAppendInformation(this.iAddInfo.isSelected());
        this.iPeriodicInvoice.setInformation(this.iInformation.getText());
        this.iInvoice.setCustomerNr(this.iCustomer.getText());
        this.iInvoice.setCustomerName(this.iCustomerName.getText());
        this.iInvoice.setOurContactPerson(this.iOurContactPerson.getText());
        this.iInvoice.setYourContactPerson(this.iYourContactPerson.getText());
        this.iInvoice.setDelayInterest(this.iDelayInterest.getValue());
        this.iInvoice.setYourOrderNumber(this.iYourOrderNumber.getText());
        this.iInvoice.setCurrency(this.iCurrency.getSelected());
        this.iInvoice.setCurrencyRate(this.iCurrencyRate.getValue());
        this.iInvoice.setPaymentTerm(this.iPaymentTerm.getSelected());
        this.iInvoice.setDeliveryTerm(this.iDeliveryTerm.getSelected());
        this.iInvoice.setDeliveryWay(this.iDeliveryWay.getSelected());
        this.iInvoice.setTaxFree(this.iTaxFree.isSelected());
        this.iInvoice.setEuSaleCommodity(this.iEuSaleCommodity.isSelected());
        this.iInvoice.setEuSaleYhirdPartCommodity(this.iEuSaleYhirdPartCommodity.isSelected());
        this.iInvoice.setTaxRate1(this.iTaxRate1.getValue());
        this.iInvoice.setTaxRate2(this.iTaxRate2.getValue());
        this.iInvoice.setTaxRate3(this.iTaxRate3.getValue());
        this.iInvoice.setText(this.iText.getText());
        this.iInvoice.setInvoiceAddress(this.iInvoiceAddress.getAddress());
        this.iInvoice.setDeliveryAddress(this.iDeliveryAddress.getAddress());
        this.iInvoice.setDefaultAccounts(this.iDefaultAccounts.getDefaultAccounts());
        this.iInvoice.setEntered(false);
        this.iInvoice.setPrinted(false);
        this.iInvoice.setStockInfluencing(this.isStockInfluencing.isSelected());
        this.iInvoice.setInterestInvoiced(false);
        this.iInvoice.generateVoucher();
        this.iPeriodicInvoice.setTemplate(this.iInvoice);
        this.iPeriodicInvoice.createInvoices();
        return this.iPeriodicInvoice;
    }

    public boolean doSaveCustomerAndProducts() {
        return this.iSavecustomerandproducts.isSelected();
    }

    private void updateTaxTexts() {
        SSTaxCodeCellEditor iEditor = new SSTaxCodeCellEditor();
        SSTaxCodeCellRenderer iRenderer = new SSTaxCodeCellRenderer();
        String iTaxText = SSBundle.getBundle().getString("tenderframe.tax");
        BigDecimal iTaxRate1 = this.iTaxRate1.getValue() == null ? new BigDecimal(25) : this.iTaxRate1.getValue();
        BigDecimal iTaxRate2 = this.iTaxRate2.getValue() == null ? new BigDecimal(12) : this.iTaxRate2.getValue();
        BigDecimal iTaxRate3 = this.iTaxRate3.getValue() == null ? new BigDecimal(6) : this.iTaxRate3.getValue();
        iEditor.setValue(SSTaxCode.TAXRATE_0, new BigDecimal(0));
        iEditor.setValue(SSTaxCode.TAXRATE_1, iTaxRate1);
        iEditor.setValue(SSTaxCode.TAXRATE_2, iTaxRate2);
        iEditor.setValue(SSTaxCode.TAXRATE_3, iTaxRate3);
        iRenderer.setValue(SSTaxCode.TAXRATE_0, new BigDecimal(0));
        iRenderer.setValue(SSTaxCode.TAXRATE_1, iTaxRate1);
        iRenderer.setValue(SSTaxCode.TAXRATE_2, iTaxRate2);
        iRenderer.setValue(SSTaxCode.TAXRATE_3, iTaxRate3);
        NumberFormat iFormat = NumberFormat.getNumberInstance();
        this.iTaxLabel1.setText(iTaxText + ' ' + iFormat.format(iTaxRate1) + '%');
        this.iTaxLabel2.setText(iTaxText + ' ' + iFormat.format(iTaxRate2) + '%');
        this.iTaxLabel3.setText(iTaxText + ' ' + iFormat.format(iTaxRate3) + '%');
        this.iTable.setDefaultEditor(SSTaxCode.class, iEditor);
        this.iTable.setDefaultRenderer(SSTaxCode.class, iRenderer);
        this.iModel.fireTableDataChanged();
    }

    private void updateSumFields() {
        BigDecimal iNetSum = SSInvoiceMath.getNetSum(this.iInvoice);
        Map<SSTaxCode, BigDecimal> iTaxSum = SSInvoiceMath.getTaxSum(this.iInvoice);
        BigDecimal iTotalSum = SSInvoiceMath.getTotalSum(this.iInvoice);
        BigDecimal iRounding = SSInvoiceMath.getRounding(this.iInvoice);
        this.iNetSum.setValue(iNetSum);
        this.iTaxSum1.setValue(iTaxSum.get(SSTaxCode.TAXRATE_1));
        this.iTaxSum2.setValue(iTaxSum.get(SSTaxCode.TAXRATE_2));
        this.iTaxSum3.setValue(iTaxSum.get(SSTaxCode.TAXRATE_3));
        if (!SSDB.getInstance().getCurrentCompany().isRoundingOff()) {
            this.iRoundingSum.setValue(iRounding);
        }
        this.iTotalSum.setValue(iTotalSum);
    }

    public void setSavecustomerandproductsSelected(boolean iSelected) {
        this.iSavecustomerandproducts.setSelected(iSelected);
    }

    public void addKeyListeners() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SSPeriodicInvoicePanel.this.iCustomer.getComponent(0).requestFocusInWindow();
            }
        });
        this.iCustomer.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iCustomerName.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCustomerName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iOurContactPerson.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iOurContactPerson.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iYourContactPerson.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iYourContactPerson.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iDeliveryTerm.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDeliveryTerm.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iPaymentTerm.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPaymentTerm.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iDeliveryWay.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDeliveryWay.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iCurrency.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCurrency.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iCurrencyRate.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCurrencyRate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iTable.requestFocusInWindow();
                            SSPeriodicInvoicePanel.this.iTable.changeSelection(0, 0, false, false);
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getOkButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iButtonPanel.getCancelButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getCancelButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iNumber.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SSPeriodicInvoicePanel.this.iCustomer.getComponent(0).requestFocusInWindow();
                    }
                });
            }
        });
        this.iDate.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iDescription.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDescription.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iPeriod.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPeriod.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iCount.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCount.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iAppendPeriod.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iAppendPeriod.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iPeriodStart.getEditor().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPeriodStart.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iPeriodEnd.getEditor().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPeriodEnd.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iAddInfo.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iAddInfo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPeriodicInvoicePanel.this.iInformation.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iInvoiceAddress.addKeyListeners();
        this.iDeliveryAddress.addKeyListeners();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.periodicinvoice.panel.SSPeriodicInvoicePanel");
        sb.append("{iAddInfo=").append(this.iAddInfo);
        sb.append(", iAppendPeriod=").append(this.iAppendPeriod);
        sb.append(", iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCount=").append(this.iCount);
        sb.append(", iCurrency=").append(this.iCurrency);
        sb.append(", iCurrencyCalculatorButton=").append(this.iCurrencyCalculatorButton);
        sb.append(", iCurrencyRate=").append(this.iCurrencyRate);
        sb.append(", iCustomer=").append(this.iCustomer);
        sb.append(", iCustomerName=").append(this.iCustomerName);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iDefaultAccounts=").append(this.iDefaultAccounts);
        sb.append(", iDelayInterest=").append(this.iDelayInterest);
        sb.append(", iDeliveryAddress=").append(this.iDeliveryAddress);
        sb.append(", iDeliveryTerm=").append(this.iDeliveryTerm);
        sb.append(", iDeliveryWay=").append(this.iDeliveryWay);
        sb.append(", iDescription=").append(this.iDescription);
        sb.append(", iEuSaleCommodity=").append(this.iEuSaleCommodity);
        sb.append(", iEuSaleYhirdPartCommodity=").append(this.iEuSaleYhirdPartCommodity);
        sb.append(", iInformation=").append(this.iInformation);
        sb.append(", iInputVerifier=").append(this.iInputVerifier);
        sb.append(", iInvoice=").append(this.iInvoice);
        sb.append(", iInvoiceAddress=").append(this.iInvoiceAddress);
        sb.append(", iInvoices=").append(this.iInvoices);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iNetSum=").append(this.iNetSum);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iOurContactPerson=").append(this.iOurContactPerson);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iPaymentTerm=").append(this.iPaymentTerm);
        sb.append(", iPeriod=").append(this.iPeriod);
        sb.append(", iPeriodEnd=").append(this.iPeriodEnd);
        sb.append(", iPeriodicInvoice=").append(this.iPeriodicInvoice);
        sb.append(", iPeriodStart=").append(this.iPeriodStart);
        sb.append(", iRefreshVoucher=").append(this.iRefreshVoucher);
        sb.append(", iRoundingSum=").append(this.iRoundingSum);
        sb.append(", iSavecustomerandproducts=").append(this.iSavecustomerandproducts);
        sb.append(", isStockInfluencing=").append(this.isStockInfluencing);
        sb.append(", iTabbedPane=").append(this.iTabbedPane);
        sb.append(", iTable=").append(this.iTable);
        sb.append(", iTaxFree=").append(this.iTaxFree);
        sb.append(", iTaxLabel1=").append(this.iTaxLabel1);
        sb.append(", iTaxLabel2=").append(this.iTaxLabel2);
        sb.append(", iTaxLabel3=").append(this.iTaxLabel3);
        sb.append(", iTaxRate1=").append(this.iTaxRate1);
        sb.append(", iTaxRate2=").append(this.iTaxRate2);
        sb.append(", iTaxRate3=").append(this.iTaxRate3);
        sb.append(", iTaxSum1=").append(this.iTaxSum1);
        sb.append(", iTaxSum2=").append(this.iTaxSum2);
        sb.append(", iTaxSum3=").append(this.iTaxSum3);
        sb.append(", iText=").append(this.iText);
        sb.append(", iTotalSum=").append(this.iTotalSum);
        sb.append(", iVoucherTable=").append(this.iVoucherTable);
        sb.append(", iVoucherTableModel=").append(this.iVoucherTableModel);
        sb.append(", iYourContactPerson=").append(this.iYourContactPerson);
        sb.append(", iYourOrderNumber=").append(this.iYourOrderNumber);
        sb.append(", textField1=").append(this.textField1);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JButton jButton;
        SSTable sSTable;
        JCheckBox jCheckBox2;
        SSBigDecimalTextField sSBigDecimalTextField;
        SSBigDecimalTextField sSBigDecimalTextField2;
        SSBigDecimalTextField sSBigDecimalTextField3;
        SSDefaultAccountPanel sSDefaultAccountPanel;
        SSBigDecimalTextField sSBigDecimalTextField4;
        JTextField jTextField;
        SSAdressPanel sSAdressPanel;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JTextArea jTextArea;
        SSAdressPanel sSAdressPanel2;
        JTextField jTextField2;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        SSDateChooser sSDateChooser;
        SSDateChooser sSDateChooser2;
        JTextField jTextField3;
        SSIntegerTextField sSIntegerTextField;
        SSIntegerTextField sSIntegerTextField2;
        SSDateChooser sSDateChooser3;
        SSBigDecimalTextField sSBigDecimalTextField5;
        SSButton sSButton;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JFormattedTextField jFormattedTextField;
        JCheckBox jCheckBox7;
        SSBigDecimalTextField sSBigDecimalTextField6;
        SSBigDecimalTextField sSBigDecimalTextField7;
        SSBigDecimalTextField sSBigDecimalTextField8;
        SSBigDecimalTextField sSBigDecimalTextField9;
        SSBigDecimalTextField sSBigDecimalTextField10;
        SSBigDecimalTextField sSBigDecimalTextField11;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        SSTable sSTable2;
        JTabbedPane jTabbedPane;
        SSButtonPanel sSButtonPanel;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), 4, 2, false, false));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        this.iTabbedPane = jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(5, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("periodicinvoiceframe.panel.1"), null, jPanel2, null);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, new Dimension(-1, 120), null, null));
        this.iTable = sSTable2 = new SSTable();
        jScrollPane.setViewportView(sSTable2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(2, 6, new Insets(0, 2, 4, 2), 2, 0, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("tenderframe.netsum"));
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxLabel1 = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("tenderframe.tax"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(80, -1), null));
        this.iTaxLabel2 = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("tenderframe.tax"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxLabel3 = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("tenderframe.tax"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("book").getString("tenderframe.rounding"));
        jPanel3.add((Component)jLabel5, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("book").getString("tenderframe.totalsum"));
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 5, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iNetSum = sSBigDecimalTextField11 = new SSBigDecimalTextField();
        sSBigDecimalTextField11.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField11, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.iTaxSum1 = sSBigDecimalTextField10 = new SSBigDecimalTextField();
        sSBigDecimalTextField10.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField10, new GridConstraints(1, 1, 1, 1, 8, 1, 3, 3, null, new Dimension(100, -1), null));
        this.iTaxSum2 = sSBigDecimalTextField9 = new SSBigDecimalTextField();
        sSBigDecimalTextField9.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField9, new GridConstraints(1, 2, 1, 1, 8, 1, 3, 3, null, new Dimension(100, -1), null));
        this.iTaxSum3 = sSBigDecimalTextField8 = new SSBigDecimalTextField();
        sSBigDecimalTextField8.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField8, new GridConstraints(1, 3, 1, 1, 8, 1, 3, 3, null, new Dimension(100, -1), null));
        this.iRoundingSum = sSBigDecimalTextField7 = new SSBigDecimalTextField();
        sSBigDecimalTextField7.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField7, new GridConstraints(1, 4, 1, 1, 0, 1, 7, 3, null, null, null));
        this.iTotalSum = sSBigDecimalTextField6 = new SSBigDecimalTextField();
        sSBigDecimalTextField6.setEditable(false);
        jPanel3.add((Component)sSBigDecimalTextField6, new GridConstraints(1, 5, 1, 1, 0, 1, 7, 3, null, null, null));
        this.iSavecustomerandproducts = jCheckBox7 = new JCheckBox();
        jCheckBox7.setSelected(true);
        jCheckBox7.setInheritsPopupMenu(false);
        jCheckBox7.setHorizontalAlignment(2);
        jCheckBox7.setVerticalAlignment(3);
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("book").getString("tenderframe.dontsavecustomerandproducts"));
        jCheckBox7.setVerticalTextPosition(0);
        jPanel2.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 10, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(6, 6, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("book").getString("invoiceframe.number"));
        jPanel4.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iNumber = jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setEditable(false);
        jPanel4.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("book").getString("tenderframe.customernr"));
        jPanel4.add((Component)jLabel8, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("book").getString("tenderframe.customername"));
        jPanel4.add((Component)jLabel9, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iCustomerName = jTextField6 = new JTextField();
        jPanel4.add((Component)jTextField6, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("book").getString("tenderframe.ourcontactperson"));
        jPanel4.add((Component)jLabel10, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iOurContactPerson = jTextField5 = new JTextField();
        jPanel4.add((Component)jTextField5, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("book").getString("tenderframe.yourcontactperson"));
        jPanel4.add((Component)jLabel11, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iYourContactPerson = jTextField4 = new JTextField();
        jPanel4.add((Component)jTextField4, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("book").getString("tenderframe.deliveryterm"));
        jPanel4.add((Component)jLabel12, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        SSEditableTableComboBox sSEditableTableComboBox = new SSEditableTableComboBox();
        this.iDeliveryTerm = sSEditableTableComboBox;
        jPanel4.add(sSEditableTableComboBox, new GridConstraints(0, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("book").getString("tenderframe.paymentterm"));
        jPanel4.add((Component)jLabel13, new GridConstraints(1, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        SSEditableTableComboBox sSEditableTableComboBox2 = new SSEditableTableComboBox();
        this.iPaymentTerm = sSEditableTableComboBox2;
        jPanel4.add(sSEditableTableComboBox2, new GridConstraints(1, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("book").getString("tenderframe.deliveryway"));
        jPanel4.add((Component)jLabel14, new GridConstraints(2, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        SSEditableTableComboBox sSEditableTableComboBox3 = new SSEditableTableComboBox();
        this.iDeliveryWay = sSEditableTableComboBox3;
        jPanel4.add(sSEditableTableComboBox3, new GridConstraints(2, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        JLabel jLabel15 = new JLabel();
        this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("book").getString("tenderframe.currency"));
        jPanel4.add((Component)jLabel15, new GridConstraints(3, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        SSEditableTableComboBox sSEditableTableComboBox4 = new SSEditableTableComboBox();
        this.iCurrency = sSEditableTableComboBox4;
        jPanel4.add(sSEditableTableComboBox4, new GridConstraints(3, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        this.iCurrencyCalculatorButton = sSButton = new SSButton();
        sSButton.setIconName("ICON_CALCULATOR16");
        sSButton.setToolTipText(ResourceBundle.getBundle("book").getString("tenderframe.currencycalculator"));
        jPanel4.add((Component)sSButton, new GridConstraints(3, 5, 1, 1, 6, 0, 3, 3, new Dimension(20, 20), new Dimension(20, 20), new Dimension(20, 20)));
        JLabel jLabel16 = new JLabel();
        this.$$$loadLabelText$$$(jLabel16, ResourceBundle.getBundle("book").getString("invoiceframe.currencyrate"));
        jPanel4.add((Component)jLabel16, new GridConstraints(4, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iCurrencyRate = sSBigDecimalTextField5 = new SSBigDecimalTextField();
        sSBigDecimalTextField5.setEditable(true);
        sSBigDecimalTextField5.setFractionDigits(5);
        jPanel4.add((Component)sSBigDecimalTextField5, new GridConstraints(4, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iCustomer = sSTableComboBox;
        jPanel4.add(sSTableComboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(150, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(5, 4, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("periodicinvoiceframe.panel.2"), null, jPanel5, null);
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(5, 2, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel17 = new JLabel();
        this.$$$loadLabelText$$$(jLabel17, ResourceBundle.getBundle("book").getString("periodicinvoiceframe.startdate"));
        jPanel6.add((Component)jLabel17, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDate = sSDateChooser3 = new SSDateChooser();
        ((Component)sSDateChooser3).setEnabled(true);
        sSDateChooser3.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel6.add((Component)sSDateChooser3, new GridConstraints(0, 1, 1, 1, 8, 0, 1, 3, null, new Dimension(200, -1), null));
        JLabel jLabel18 = new JLabel();
        this.$$$loadLabelText$$$(jLabel18, ResourceBundle.getBundle("book").getString("periodicinvoiceframe.count"));
        jPanel6.add((Component)jLabel18, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iCount = sSIntegerTextField2 = new SSIntegerTextField();
        sSIntegerTextField2.setText("");
        jPanel6.add((Component)sSIntegerTextField2, new GridConstraints(3, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(120, -1), null));
        JLabel jLabel19 = new JLabel();
        this.$$$loadLabelText$$$(jLabel19, ResourceBundle.getBundle("book").getString("periodicinvoiceframe.period"));
        jPanel6.add((Component)jLabel19, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iPeriod = sSIntegerTextField = new SSIntegerTextField();
        sSIntegerTextField.setText("");
        jPanel6.add((Component)sSIntegerTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(120, -1), null));
        this.iDescription = jTextField3 = new JTextField();
        jTextField3.setFocusTraversalPolicyProvider(false);
        jTextField3.setText("");
        jPanel6.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(200, -1), null));
        JLabel jLabel20 = new JLabel();
        this.$$$loadLabelText$$$(jLabel20, ResourceBundle.getBundle("book").getString("periodicinvoiceframe.description"));
        jPanel6.add((Component)jLabel20, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iPeriodStart = sSDateChooser2 = new SSDateChooser();
        ((Component)sSDateChooser2).setEnabled(true);
        sSDateChooser2.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel7.add((Component)sSDateChooser2, new GridConstraints(1, 1, 1, 1, 4, 0, 1, 3, null, new Dimension(200, -1), null));
        this.iPeriodEnd = sSDateChooser = new SSDateChooser();
        ((Component)sSDateChooser).setEnabled(true);
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel7.add((Component)sSDateChooser, new GridConstraints(2, 1, 1, 1, 4, 0, 1, 3, null, new Dimension(200, -1), null));
        JLabel jLabel21 = new JLabel();
        this.$$$loadLabelText$$$(jLabel21, ResourceBundle.getBundle("book").getString("periodicinvoiceframe.fistperioddate"));
        jPanel7.add((Component)jLabel21, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel22 = new JLabel();
        this.$$$loadLabelText$$$(jLabel22, ResourceBundle.getBundle("book").getString("periodicinvoiceframe.lastperioddate"));
        jPanel7.add((Component)jLabel22, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iAppendPeriod = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("book").getString("periodicinvoiceframe.appendperiod"));
        jPanel7.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel5.add((Component)jPanel8, new GridConstraints(2, 0, 2, 1, 8, 0, 3, 3, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iAddInfo = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("L\u00e4gg till informationsrad i fakturan");
        jPanel8.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel23 = new JLabel();
        jLabel23.setText("Information:");
        jPanel8.add((Component)jLabel23, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iInformation = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel8.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel24 = new JLabel();
        jLabel24.setText("Skriv [FAK] f\u00f6r fakturanummer och [TOT] f\u00f6r totalt antal fakturor.");
        jPanel8.add((Component)jLabel24, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(5, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("periodicinvoiceframe.panel.3"), null, jPanel9, null);
        Spacer spacer4 = new Spacer();
        jPanel9.add((Component)spacer4, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(1, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iInvoiceAddress = sSAdressPanel2 = new SSAdressPanel();
        sSAdressPanel2.setTitle(ResourceBundle.getBundle("book").getString("tenderframe.invoiceaddress"));
        jPanel10.add((Component)sSAdressPanel2, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 4, 0, false, false));
        jPanel9.add((Component)jPanel11, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel11.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel11.add((Component)jScrollPane2, new GridConstraints(1, 0, 1, 1, 8, 3, 7, 7, new Dimension(-1, 60), new Dimension(-1, 60), new Dimension(500, 60)));
        this.iText = jTextArea = new JTextArea();
        jScrollPane2.setViewportView(jTextArea);
        JLabel jLabel25 = new JLabel();
        this.$$$loadLabelText$$$(jLabel25, ResourceBundle.getBundle("book").getString("invoiceframe.invoicetext"));
        jPanel11.add((Component)jLabel25, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel9.add((Component)jPanel12, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        this.iEuSaleCommodity = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("book").getString("customerframe.eusalecommodity"));
        jPanel12.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iEuSaleYhirdPartCommodity = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("book").getString("customerframe.eusalethirdpartcommodity"));
        jPanel12.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridLayoutManager(1, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel9.add((Component)jPanel13, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel13.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iDeliveryAddress = sSAdressPanel = new SSAdressPanel();
        sSAdressPanel.setTitle(ResourceBundle.getBundle("book").getString("tenderframe.deliveryaddress"));
        jPanel13.add((Component)sSAdressPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridLayoutManager(2, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel9.add((Component)jPanel14, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        jPanel14.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel26 = new JLabel();
        this.$$$loadLabelText$$$(jLabel26, ResourceBundle.getBundle("book").getString("orderframe.yourordernumber"));
        jPanel14.add((Component)jLabel26, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iYourOrderNumber = jTextField = new JTextField();
        jTextField.setColumns(2);
        jPanel14.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel27 = new JLabel();
        this.$$$loadLabelText$$$(jLabel27, ResourceBundle.getBundle("book").getString("tenderframe.delayinterest"));
        jPanel14.add((Component)jLabel27, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDelayInterest = sSBigDecimalTextField4 = new SSBigDecimalTextField();
        sSBigDecimalTextField4.setFractionDigits(2);
        jPanel14.add((Component)sSBigDecimalTextField4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        JLabel jLabel28 = new JLabel();
        jLabel28.setText("%");
        jPanel14.add((Component)jLabel28, new GridConstraints(0, 2, 1, 1, 8, 0, 6, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel9.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new GridLayoutManager(3, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("periodicinvoiceframe.panel.4"), null, jPanel15, null);
        Spacer spacer6 = new Spacer();
        jPanel15.add((Component)spacer6, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel15.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iDefaultAccounts = sSDefaultAccountPanel = new SSDefaultAccountPanel();
        jPanel15.add((Component)sSDefaultAccountPanel, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel16, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel16.add((Component)spacer8, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new GridLayoutManager(4, 3, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel16.add((Component)jPanel17, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel17.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel29 = new JLabel();
        this.$$$loadLabelText$$$(jLabel29, ResourceBundle.getBundle("book").getString("companyframe.taxrate1"));
        jPanel17.add((Component)jLabel29, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel30 = new JLabel();
        this.$$$loadLabelText$$$(jLabel30, ResourceBundle.getBundle("book").getString("companyframe.taxrate2"));
        jPanel17.add((Component)jLabel30, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel31 = new JLabel();
        this.$$$loadLabelText$$$(jLabel31, ResourceBundle.getBundle("book").getString("companyframe.taxrate3"));
        jPanel17.add((Component)jLabel31, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxRate1 = sSBigDecimalTextField3 = new SSBigDecimalTextField();
        jPanel17.add((Component)sSBigDecimalTextField3, new GridConstraints(1, 1, 1, 1, 8, 0, 7, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, 20)));
        JLabel jLabel32 = new JLabel();
        jLabel32.setText("%");
        jPanel17.add((Component)jLabel32, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel33 = new JLabel();
        jLabel33.setText("%");
        jPanel17.add((Component)jLabel33, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel34 = new JLabel();
        jLabel34.setText("%");
        jPanel17.add((Component)jLabel34, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTaxRate2 = sSBigDecimalTextField2 = new SSBigDecimalTextField();
        jPanel17.add((Component)sSBigDecimalTextField2, new GridConstraints(2, 1, 1, 1, 8, 0, 7, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, 20)));
        this.iTaxRate3 = sSBigDecimalTextField = new SSBigDecimalTextField();
        jPanel17.add((Component)sSBigDecimalTextField, new GridConstraints(3, 1, 1, 1, 8, 0, 7, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, 20)));
        this.iTaxFree = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("book").getString("tenderframe.taxfree"));
        jPanel17.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel16.add((Component)spacer9, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), 0, 0, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("periodicinvoiceframe.panel.5"), null, jPanel18, null);
        Spacer spacer10 = new Spacer();
        jPanel18.add((Component)spacer10, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer11 = new Spacer();
        jPanel18.add((Component)spacer11, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout(new GridLayoutManager(2, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel18.add((Component)jPanel19, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel19.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane3 = new JScrollPane();
        jPanel19.add((Component)jScrollPane3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, new Dimension(600, 250), null));
        this.iVoucherTable = sSTable = new SSTable();
        jScrollPane3.setViewportView(sSTable);
        this.iRefreshVoucher = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("book").getString("invoiceframe.voucherrefresh"));
        jPanel19.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer12 = new Spacer();
        jPanel19.add((Component)spacer12, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel35 = new JLabel();
        jLabel35.setHorizontalAlignment(2);
        jLabel35.setVerticalAlignment(1);
        this.$$$loadLabelText$$$(jLabel35, ResourceBundle.getBundle("book").getString("invoiceframe.voucher"));
        jLabel35.setVerticalTextPosition(1);
        jLabel35.setHorizontalTextPosition(2);
        jPanel19.add((Component)jLabel35, new GridConstraints(0, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        this.isStockInfluencing = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("invoiceframe.updatestock"));
        jPanel18.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

