/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.product.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import se.swedsoft.bookkeeping.calc.math.SSProductMath;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSAccountPlan;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.common.SSDefaultAccount;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.common.SSUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.product.util.SSProductRowTableModel;
import se.swedsoft.bookkeeping.gui.project.util.SSProjectTableModel;
import se.swedsoft.bookkeeping.gui.resultunit.util.SSResultUnitTableModel;
import se.swedsoft.bookkeeping.gui.supplier.util.SSSupplierTableModel;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSInputVerifier;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSCurrencyTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.components.SSIntegerTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSLocalizedTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSAccountTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSTaxCodeTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSUnitTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSProductCellEditor;

public class SSProductPanel {
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private SSProduct iProduct;
    private JTextField iProductNr;
    private JTextField iDescription;
    private SSCurrencyTextField iUnitprice;
    private SSTableComboBox<SSTaxCode> iTax;
    private SSCurrencyTextField iPurchasePrice;
    private SSBigDecimalTextField iWeight;
    private SSBigDecimalTextField iVolume;
    private SSEditableTableComboBox<SSUnit> iUnit;
    private SSTableComboBox<SSAccount> iPurchaseAccount;
    private SSTableComboBox<SSAccount> iSellingAccount;
    private SSTableComboBox<SSNewProject> iProject;
    private SSTableComboBox<SSNewResultUnit> iResultUnit;
    private JCheckBox iExpired;
    private JCheckBox iStockGoods;
    private SSIntegerTextField iOrderpoint;
    private SSIntegerTextField iOrdercount;
    private JTextField iWarehouseLocation;
    private SSTableComboBox<SSSupplier> iSupplier;
    private JTextField iSupplierProductNr;
    private SSCurrencyTextField iFreight;
    private JButton iCalculateButton;
    private JTextField iSellingAccountDescription;
    private JTextField iPurchaseAccountDescription;
    private JTextField iProjectDescription;
    private JTextField iResultUnitDescription;
    private SSLocalizedTextField iDescriptions;
    private SSTable iParcel;
    private SSDefaultTableModel<SSProductRow> iParcelModel;
    private JLabel iVolumeUnit;
    private JLabel iWeightUnit;
    private JButton iDeleteParcelButton;
    private JButton iUpdateContributionButton;
    private SSCurrencyTextField iInprice;
    private SSCurrencyTextField iContribution;
    private SSBigDecimalTextField iContributionRate;
    private SSInputVerifier iInputVerifier;
    private SSBigDecimalTextField iStockPrice;

    public SSProductPanel(SSDialog iOwner, boolean iEdit) {
        this.$$$setupUI$$$();
        this.iProductNr.setEnabled(!iEdit);
        this.iParcelModel = new SSProductRowTableModel();
        this.iParcelModel.addDeleteAction(this.iParcel);
        this.iParcel.setModel(this.iParcelModel);
        this.iParcel.setColorReadOnly(true);
        this.iParcel.setDefaultEditor(SSProduct.class, new SSProductCellEditor(SSProductMath.getNormalProducts(), false));
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.iVolumeUnit.setText(iCompany.getVolumeUnit());
            this.iWeightUnit.setText(iCompany.getWeightUnit());
        }
        this.iSupplier.setModel(SSSupplierTableModel.getDropDownModel());
        this.iSupplier.setSearchColumns(0);
        this.iOrderpoint.setValue(0);
        this.iOrdercount.setValue(0);
        this.iSellingAccount.setModel(SSAccountTableModel.getDropDownModel());
        this.iSellingAccount.setSearchColumns(0);
        this.iSellingAccount.addSelectionListener(new SSSelectionListener(){

            public void selected(SSTableSearchable selected) {
                SSAccount iSelected = (SSAccount)SSProductPanel.this.iSellingAccount.getSelected();
                SSProductPanel.this.iSellingAccountDescription.setText(iSelected == null ? "" : iSelected.getDescription());
            }
        });
        this.iSellingAccount.setSelected(SSDB.getInstance().getCurrentAccountPlan().getAccount(3041), true);
        this.iPurchaseAccount.setModel(SSAccountTableModel.getDropDownModel());
        this.iPurchaseAccount.setSearchColumns(0);
        this.iPurchaseAccount.addSelectionListener(new SSSelectionListener(){

            public void selected(SSTableSearchable selected) {
                SSAccount iSelected = (SSAccount)SSProductPanel.this.iPurchaseAccount.getSelected();
                SSProductPanel.this.iPurchaseAccountDescription.setText(iSelected == null ? "" : iSelected.getDescription());
            }
        });
        this.iPurchaseAccount.setSelected(SSDB.getInstance().getCurrentAccountPlan().getAccount(4010), true);
        this.iProject.setModel(SSProjectTableModel.getDropDownModel());
        this.iProject.setSearchColumns(0);
        this.iProject.addSelectionListener(new SSSelectionListener(){

            public void selected(SSTableSearchable selected) {
                SSNewProject iSelected = (SSNewProject)SSProductPanel.this.iProject.getSelected();
                if (SSProductPanel.this.iProject.getText() != null && SSProductPanel.this.iProject.getText().length() != 0) {
                    SSProductPanel.this.iProjectDescription.setText(iSelected == null ? "" : iSelected.getName());
                } else {
                    SSProductPanel.this.iProjectDescription.setText(null);
                }
            }
        });
        this.iProject.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    SSProductPanel.this.iProject.cancelCellEditing();
                    SSProductPanel.this.iProject.setSelected(null);
                    SSProductPanel.this.iProjectDescription.setText(null);
                }
            }
        });
        this.iResultUnit.setModel(SSResultUnitTableModel.getDropDownModel());
        this.iResultUnit.setSearchColumns(0);
        this.iResultUnit.addSelectionListener(new SSSelectionListener(){

            public void selected(SSTableSearchable selected) {
                SSNewResultUnit iSelected = (SSNewResultUnit)SSProductPanel.this.iResultUnit.getSelected();
                if (SSProductPanel.this.iResultUnit.getText() != null && SSProductPanel.this.iResultUnit.getText().length() != 0) {
                    SSProductPanel.this.iResultUnitDescription.setText(iSelected == null ? "" : iSelected.getName());
                } else {
                    SSProductPanel.this.iResultUnitDescription.setText(null);
                }
            }
        });
        this.iResultUnit.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    SSProductPanel.this.iResultUnit.cancelCellEditing();
                    SSProductPanel.this.iResultUnit.setSelected(null);
                    SSProductPanel.this.iResultUnitDescription.setText(null);
                }
            }
        });
        this.iTax.setModel(SSTaxCodeTableModel.getDropDownModel());
        this.iTax.setSearchColumns(0);
        this.iUnit.getComboBox().setModel(SSUnitTableModel.getDropDownModel());
        this.iUnit.getComboBox().setSearchColumns(0);
        this.iUnit.setEditingFactory(SSUnitTableModel.getEditingFactory(iOwner));
        this.iCalculateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProductPanel.this.calculateFields();
            }
        });
        this.iDeleteParcelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProductPanel.this.iProduct.getParcelRows().clear();
                SSProductPanel.this.iParcelModel.fireTableDataChanged();
            }
        });
        this.iUpdateContributionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProductPanel.this.getProduct();
                SSProductPanel.this.updateContribution();
            }
        });
        this.iInputVerifier = new SSInputVerifier();
        this.iInputVerifier.add(this.iProductNr);
        this.iInputVerifier.add(this.iUnitprice);
        this.iInputVerifier.addListener(new SSInputVerifier.SSVerifierListener(){

            @Override
            public void updated(SSInputVerifier iVerifier, boolean iValid) {
                SSProductPanel.this.iButtonPanel.getOkButton().setEnabled(iValid);
            }
        });
        this.iDescriptions.addLocale(new Locale("se"), "Svenska:");
        this.iDescriptions.addLocale(new Locale("en"), "Engelska:");
        NumberFormat iFormat = NumberFormat.getNumberInstance();
        iFormat.setMinimumFractionDigits(2);
        iFormat.setMaximumFractionDigits(2);
        iFormat.setGroupingUsed(false);
        NumberFormatter iFormatter = new NumberFormatter(iFormat);
        iFormatter.setFormat(iFormat);
        this.iContributionRate.setFormatterFactory(new DefaultFormatterFactory(iFormatter));
        this.addKeyListeners();
    }

    public boolean isValid() {
        return this.iInputVerifier.isValid();
    }

    private void updateContribution() {
        BigDecimal iInprice = SSProductMath.getInprice(this.iProduct);
        BigDecimal iContribution = SSProductMath.getContribution(this.iProduct);
        BigDecimal iContributionRate = SSProductMath.getContributionRate(this.iProduct);
        if (iInprice != null) {
            this.iInprice.setValue(iInprice);
            this.iContribution.setValue(iContribution);
            this.iContributionRate.setValue(iContributionRate);
        } else {
            this.iInprice.setValue(new BigDecimal(0));
            this.iContribution.setValue(this.iProduct.getSellingPrice());
            this.iContributionRate.setValue(new BigDecimal(100));
        }
    }

    public void setProduct(SSProduct pProduct) {
        this.iProduct = pProduct;
        this.iProductNr.setText(this.iProduct.getNumber());
        this.iDescription.setText(this.iProduct.getDescription());
        this.iUnitprice.setValue(this.iProduct.getSellingPrice());
        this.iTax.setSelected(this.iProduct.getTaxCode());
        this.iPurchasePrice.setValue(this.iProduct.getPurchasePrice());
        this.iStockPrice.setValue(this.iProduct.getStockPrice());
        this.iFreight.setValue(this.iProduct.getUnitFreight());
        this.iWeight.setValue(this.iProduct.getWeight());
        this.iVolume.setValue(this.iProduct.getVolume());
        this.iUnit.setSelected(this.iProduct.getUnit());
        this.iExpired.setSelected(this.iProduct.isExpired());
        this.iStockGoods.setSelected(this.iProduct.isStockProduct());
        this.iOrderpoint.setValue(this.iProduct.getOrderpoint());
        this.iOrdercount.setValue(this.iProduct.getOrdercount());
        this.iWarehouseLocation.setText(this.iProduct.getWarehouseLocation());
        this.iSupplierProductNr.setText(this.iProduct.getSupplierProductNr());
        this.iSupplier.setSelected(this.iProduct.getSupplier(SSDB.getInstance().getSuppliers()));
        this.iDescriptions.setValues(this.iProduct.getDescriptions());
        SSAccountPlan iAccountPlan = SSDB.getInstance().getCurrentAccountPlan();
        if (iAccountPlan != null) {
            this.iSellingAccount.setSelected(iAccountPlan.getAccount(this.iProduct.getDefaultAccount(SSDefaultAccount.Sales)), true);
            this.iPurchaseAccount.setSelected(iAccountPlan.getAccount(this.iProduct.getDefaultAccount(SSDefaultAccount.Purchases)), true);
        }
        if (this.iProduct.getProjectNr() != null) {
            for (SSNewProject pProject : SSDB.getInstance().getProjects()) {
                if (!pProject.getNumber().equals(this.iProduct.getProjectNr())) continue;
                this.iProject.setSelected(pProject);
                this.iProjectDescription.setText(pProject.getName());
            }
        } else {
            this.iProject.setSelected(null);
            this.iProject.setText(null);
        }
        if (this.iProduct.getResultUnitNr() != null) {
            for (SSNewResultUnit pResultUnit : SSDB.getInstance().getResultUnits()) {
                if (!pResultUnit.getNumber().equals(this.iProduct.getResultUnitNr())) continue;
                this.iResultUnit.setSelected(pResultUnit);
                this.iResultUnitDescription.setText(pResultUnit.getName());
            }
        } else {
            this.iResultUnit.setSelected(null);
            this.iResultUnit.setText(null);
        }
        SSProductRowTableModel.setupTable(this.iParcel, this.iProduct);
        this.iParcelModel.setObjects(this.iProduct.getParcelRows());
        this.updateContribution();
    }

    public SSProduct getProduct() {
        this.iProduct.setNumber(this.iProductNr.getText());
        this.iProduct.setDescription(this.iDescription.getText());
        this.iProduct.setSellingPrice(this.iUnitprice.getValue());
        this.iProduct.setTaxCode(this.iTax.getSelected());
        this.iProduct.setPurchasePrice(this.iPurchasePrice.getValue());
        this.iProduct.setStockPrice(this.iStockPrice.getValue());
        this.iProduct.setUnitFreight(this.iFreight.getValue());
        this.iProduct.setWeight(this.iWeight.getValue());
        this.iProduct.setVolume(this.iVolume.getValue());
        this.iProduct.setUnit(this.iUnit.getSelected());
        this.iProduct.setExpired(this.iExpired.isSelected());
        this.iProduct.setStockProduct(this.iStockGoods.isSelected());
        this.iProduct.setOrdercount(this.iOrdercount.getValue());
        this.iProduct.setOrderpoint(this.iOrderpoint.getValue());
        this.iProduct.setWarehouseLocation(this.iWarehouseLocation.getText());
        this.iProduct.setSupplierProductNr(this.iSupplierProductNr.getText());
        this.iProduct.setSupplier(this.iSupplier.getSelected());
        this.iProduct.setDescriptions(this.iDescriptions.getValues());
        this.iProduct.setDefaultAccount(SSDefaultAccount.Purchases, this.iPurchaseAccount.getSelected());
        this.iProduct.setDefaultAccount(SSDefaultAccount.Sales, this.iSellingAccount.getSelected());
        if (this.iProject.getText() != null && this.iProject.getText().length() != 0) {
            this.iProduct.setProject(this.iProject.getSelected());
        } else {
            this.iProduct.setProject(null);
        }
        if (this.iResultUnit.getText() != null && this.iResultUnit.getText().length() != 0) {
            this.iProduct.setResultUnit(this.iResultUnit.getSelected());
        } else {
            this.iProduct.setResultUnit(null);
        }
        this.iProduct.setParcelRows(this.iParcelModel.getObjects());
        return this.iProduct;
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener pActionListener) {
        this.iButtonPanel.addOkActionListener(pActionListener);
    }

    public void addCancelAction(ActionListener pActionListener) {
        this.iButtonPanel.addCancelActionListener(pActionListener);
    }

    private void calculateFields() {
        BigDecimal iUnitpriceSum = new BigDecimal(0);
        BigDecimal iVolumeSum = new BigDecimal(0);
        BigDecimal iWeightSum = new BigDecimal(0);
        BigDecimal iPurchasePriceSum = new BigDecimal(0);
        BigDecimal iFreightSum = new BigDecimal(0);
        for (SSProductRow iRow : this.iProduct.getParcelRows()) {
            SSProduct iProduct = iRow.getProduct();
            Integer iCount = iRow.getQuantity();
            if (iCount == null || iProduct == null) continue;
            BigDecimal iUnitprice = iProduct.getSellingPrice();
            BigDecimal iVolume = iProduct.getVolume();
            BigDecimal iWeight = iProduct.getWeight();
            BigDecimal iPurchasePrice = iProduct.getPurchasePrice();
            BigDecimal iFreightPrice = iProduct.getUnitFreight();
            BigDecimal dCount = new BigDecimal(iCount);
            if (iUnitprice != null) {
                iUnitpriceSum = iUnitpriceSum.add(iUnitprice.multiply(dCount));
            }
            if (iVolume != null) {
                iVolumeSum = iVolumeSum.add(iVolume.multiply(dCount));
            }
            if (iWeight != null) {
                iWeightSum = iWeightSum.add(iWeight.multiply(dCount));
            }
            if (iPurchasePrice != null) {
                iPurchasePriceSum = iPurchasePriceSum.add(iPurchasePrice.multiply(dCount));
            }
            if (iFreightPrice == null) continue;
            iFreightSum = iFreightSum.add(iFreightPrice.multiply(dCount));
        }
        this.iUnitprice.setValue(iUnitpriceSum);
        this.iVolume.setValue(iVolumeSum);
        this.iWeight.setValue(iWeightSum);
        this.iPurchasePrice.setValue(iPurchasePriceSum);
        this.iFreight.setValue(iFreightSum);
    }

    public void setEditPanel() {
        this.iProductNr.setEditable(false);
    }

    public void addKeyListeners() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SSProductPanel.this.iProductNr.isEnabled()) {
                    SSProductPanel.this.iProductNr.requestFocusInWindow();
                } else {
                    SSProductPanel.this.iDescription.requestFocusInWindow();
                }
            }
        });
        this.iProductNr.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iDescription.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDescription.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iUnitprice.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iUnitprice.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iTax.getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iTax.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iPurchasePrice.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPurchasePrice.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iFreight.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iFreight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iUnit.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iUnit.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iWeight.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iWeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iVolume.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iVolume.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iSellingAccount.getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iSellingAccount.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iPurchaseAccount.getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPurchaseAccount.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iProject.getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iProject.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iResultUnit.getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iResultUnit.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iExpired.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iExpired.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iStockGoods.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iStockGoods.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getOkButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iButtonPanel.getCancelButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getCancelButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iWarehouseLocation.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iOrderpoint.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iOrderpoint.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iOrdercount.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iOrdercount.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iSupplier.getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iSupplier.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProductPanel.this.iSupplierProductNr.requestFocusInWindow();
                        }
                    });
                }
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.product.panel.SSProductPanel");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCalculateButton=").append(this.iCalculateButton);
        sb.append(", iContribution=").append(this.iContribution);
        sb.append(", iContributionRate=").append(this.iContributionRate);
        sb.append(", iDeleteParcelButton=").append(this.iDeleteParcelButton);
        sb.append(", iDescription=").append(this.iDescription);
        sb.append(", iDescriptions=").append(this.iDescriptions);
        sb.append(", iExpired=").append(this.iExpired);
        sb.append(", iFreight=").append(this.iFreight);
        sb.append(", iInprice=").append(this.iInprice);
        sb.append(", iInputVerifier=").append(this.iInputVerifier);
        sb.append(", iOrdercount=").append(this.iOrdercount);
        sb.append(", iOrderpoint=").append(this.iOrderpoint);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iParcel=").append(this.iParcel);
        sb.append(", iParcelModel=").append(this.iParcelModel);
        sb.append(", iProduct=").append(this.iProduct);
        sb.append(", iProductNr=").append(this.iProductNr);
        sb.append(", iProject=").append(this.iProject);
        sb.append(", iProjectDescription=").append(this.iProjectDescription);
        sb.append(", iPurchaseAccount=").append(this.iPurchaseAccount);
        sb.append(", iPurchaseAccountDescription=").append(this.iPurchaseAccountDescription);
        sb.append(", iPurchasePrice=").append(this.iPurchasePrice);
        sb.append(", iResultUnit=").append(this.iResultUnit);
        sb.append(", iResultUnitDescription=").append(this.iResultUnitDescription);
        sb.append(", iSellingAccount=").append(this.iSellingAccount);
        sb.append(", iSellingAccountDescription=").append(this.iSellingAccountDescription);
        sb.append(", iStockGoods=").append(this.iStockGoods);
        sb.append(", iStockPrice=").append(this.iStockPrice);
        sb.append(", iSupplier=").append(this.iSupplier);
        sb.append(", iSupplierProductNr=").append(this.iSupplierProductNr);
        sb.append(", iTax=").append(this.iTax);
        sb.append(", iUnit=").append(this.iUnit);
        sb.append(", iUnitprice=").append(this.iUnitprice);
        sb.append(", iUpdateContributionButton=").append(this.iUpdateContributionButton);
        sb.append(", iVolume=").append(this.iVolume);
        sb.append(", iVolumeUnit=").append(this.iVolumeUnit);
        sb.append(", iWarehouseLocation=").append(this.iWarehouseLocation);
        sb.append(", iWeight=").append(this.iWeight);
        sb.append(", iWeightUnit=").append(this.iWeightUnit);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        SSTable sSTable;
        SSBigDecimalTextField sSBigDecimalTextField;
        SSCurrencyTextField sSCurrencyTextField;
        SSCurrencyTextField sSCurrencyTextField2;
        SSLocalizedTextField sSLocalizedTextField;
        JTextField jTextField;
        SSBigDecimalTextField sSBigDecimalTextField2;
        SSIntegerTextField sSIntegerTextField;
        SSIntegerTextField sSIntegerTextField2;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField5;
        JTextField jTextField6;
        JLabel jLabel;
        JLabel jLabel2;
        SSCurrencyTextField sSCurrencyTextField3;
        SSCurrencyTextField sSCurrencyTextField4;
        SSBigDecimalTextField sSBigDecimalTextField3;
        SSBigDecimalTextField sSBigDecimalTextField4;
        SSCurrencyTextField sSCurrencyTextField5;
        JTextField jTextField7;
        JTextField jTextField8;
        SSButtonPanel sSButtonPanel;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 1, null, null, null));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(5, 2, new Insets(4, 4, 4, 4), 4, 4, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("productpanel.panel.1"), null, jPanel2, null);
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(7, 7, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("productpanel.productnr"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(100, -1), null));
        this.iProductNr = jTextField8 = new JTextField();
        jPanel3.add((Component)jTextField8, new GridConstraints(0, 1, 1, 5, 8, 1, 6, 0, null, new Dimension(380, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("productpanel.description"));
        jPanel3.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDescription = jTextField7 = new JTextField();
        jPanel3.add((Component)jTextField7, new GridConstraints(1, 1, 1, 5, 8, 1, 6, 0, null, new Dimension(380, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("book").getString("productpanel.unitprice"));
        jPanel3.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("book").getString("productpanel.tax"));
        jPanel3.add((Component)jLabel6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("book").getString("productpanel.purchasePrice"));
        jPanel3.add((Component)jLabel7, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iPurchasePrice = sSCurrencyTextField5 = new SSCurrencyTextField();
        jPanel3.add((Component)sSCurrencyTextField5, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(120, -1), null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("book").getString("productpanel.unit"));
        jPanel3.add((Component)jLabel8, new GridConstraints(2, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("book").getString("productpanel.weight"));
        jPanel3.add((Component)jLabel9, new GridConstraints(3, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("book").getString("productpanel.volume"));
        jPanel3.add((Component)jLabel10, new GridConstraints(4, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        SSButton sSButton = new SSButton();
        this.iCalculateButton = sSButton;
        sSButton.setToolTipText(ResourceBundle.getBundle("book").getString("productpanel.calculatefromrows.tooltip"));
        sSButton.setIconName("ICON_CALCULATOR16");
        jPanel3.add((Component)sSButton, new GridConstraints(2, 2, 1, 1, 4, 0, 3, 3, new Dimension(20, 20), new Dimension(20, 20), new Dimension(20, 20)));
        this.iWeight = sSBigDecimalTextField4 = new SSBigDecimalTextField();
        sSBigDecimalTextField4.setFractionDigits(3);
        jPanel3.add((Component)sSBigDecimalTextField4, new GridConstraints(3, 5, 1, 1, 4, 0, 7, 3, null, new Dimension(120, -1), null));
        this.iVolume = sSBigDecimalTextField3 = new SSBigDecimalTextField();
        sSBigDecimalTextField3.setFractionDigits(3);
        jPanel3.add((Component)sSBigDecimalTextField3, new GridConstraints(4, 5, 1, 1, 4, 0, 7, 3, null, new Dimension(120, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(2, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("book").getString("productpanel.freight"));
        jPanel3.add((Component)jLabel11, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iFreight = sSCurrencyTextField4 = new SSCurrencyTextField();
        jPanel3.add((Component)sSCurrencyTextField4, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(120, -1), null));
        this.iUnitprice = sSCurrencyTextField3 = new SSCurrencyTextField();
        jPanel3.add((Component)sSCurrencyTextField3, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(120, -1), null));
        this.iWeightUnit = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel3.add((Component)jLabel2, new GridConstraints(3, 6, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iVolumeUnit = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel3.add((Component)jLabel, new GridConstraints(4, 6, 1, 1, 8, 0, 0, 0, null, null, null));
        SSEditableTableComboBox sSEditableTableComboBox = new SSEditableTableComboBox();
        this.iUnit = sSEditableTableComboBox;
        jPanel3.add(sSEditableTableComboBox, new GridConstraints(2, 5, 1, 1, 4, 0, 7, 3, null, new Dimension(120, -1), null));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iTax = sSTableComboBox;
        jPanel3.add(sSTableComboBox, new GridConstraints(3, 1, 1, 1, 0, 0, 3, 3, null, new Dimension(120, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(2, 4, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("book").getString("productpanel.sellingaccount"));
        jPanel4.add((Component)jLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(100, -1), null));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("book").getString("productpanel.purchaseaccount"));
        jPanel4.add((Component)jLabel13, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iSellingAccountDescription = jTextField6 = new JTextField();
        jTextField6.setEditable(false);
        jPanel4.add((Component)jTextField6, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(228, -1), null));
        this.iPurchaseAccountDescription = jTextField5 = new JTextField();
        jTextField5.setEditable(false);
        jPanel4.add((Component)jTextField5, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(228, -1), null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        SSTableComboBox sSTableComboBox2 = new SSTableComboBox();
        this.iSellingAccount = sSTableComboBox2;
        jPanel4.add(sSTableComboBox2, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, new Dimension(120, -1), null));
        SSTableComboBox sSTableComboBox3 = new SSTableComboBox();
        this.iPurchaseAccount = sSTableComboBox3;
        jPanel4.add(sSTableComboBox3, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 3, null, new Dimension(120, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.iExpired = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("book").getString("productpanel.expired"));
        jPanel5.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iStockGoods = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("productpanel.stockgoods"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(2, 4, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("Projekt:");
        jPanel6.add((Component)jLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(100, -1), null));
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("Resultatenhet:");
        jPanel6.add((Component)jLabel15, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iProjectDescription = jTextField4 = new JTextField();
        jTextField4.setEditable(false);
        jPanel6.add((Component)jTextField4, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(228, -1), null));
        this.iResultUnitDescription = jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        jPanel6.add((Component)jTextField3, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(228, -1), null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        SSTableComboBox sSTableComboBox4 = new SSTableComboBox();
        this.iProject = sSTableComboBox4;
        jPanel6.add(sSTableComboBox4, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, new Dimension(120, -1), null));
        SSTableComboBox sSTableComboBox5 = new SSTableComboBox();
        this.iResultUnit = sSTableComboBox5;
        jPanel6.add(sSTableComboBox5, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 3, null, new Dimension(120, -1), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("productpanel.panel.2"), null, jPanel7, null);
        Spacer spacer6 = new Spacer();
        jPanel7.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel7.add((Component)spacer7, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(4, 2, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel16 = new JLabel();
        this.$$$loadLabelText$$$(jLabel16, ResourceBundle.getBundle("book").getString("productpanel.orderpoint"));
        jPanel8.add((Component)jLabel16, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel17 = new JLabel();
        this.$$$loadLabelText$$$(jLabel17, ResourceBundle.getBundle("book").getString("productpanel.warehouselocation"));
        jPanel8.add((Component)jLabel17, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(100, -1), null));
        this.iWarehouseLocation = jTextField2 = new JTextField();
        jPanel8.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.iOrderpoint = sSIntegerTextField2 = new SSIntegerTextField();
        sSIntegerTextField2.setHorizontalAlignment(2);
        jPanel8.add((Component)sSIntegerTextField2, new GridConstraints(1, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(150, -1), null));
        this.iOrdercount = sSIntegerTextField = new SSIntegerTextField();
        sSIntegerTextField.setHorizontalAlignment(2);
        jPanel8.add((Component)sSIntegerTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(150, -1), null));
        JLabel jLabel18 = new JLabel();
        this.$$$loadLabelText$$$(jLabel18, ResourceBundle.getBundle("book").getString("productpanel.ordercount"));
        jPanel8.add((Component)jLabel18, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iStockPrice = sSBigDecimalTextField2 = new SSBigDecimalTextField();
        jPanel8.add((Component)sSBigDecimalTextField2, new GridConstraints(3, 1, 1, 1, 0, 0, 7, 3, null, new Dimension(150, -1), null));
        JLabel jLabel19 = new JLabel();
        jLabel19.setText("Lagerpris:");
        jPanel8.add((Component)jLabel19, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(3, 3, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel7.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel20 = new JLabel();
        this.$$$loadLabelText$$$(jLabel20, ResourceBundle.getBundle("book").getString("productpanel.supplierproductnr"));
        jPanel9.add((Component)jLabel20, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iSupplierProductNr = jTextField = new JTextField();
        jPanel9.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel21 = new JLabel();
        this.$$$loadLabelText$$$(jLabel21, ResourceBundle.getBundle("book").getString("productpanel.mainsupplier"));
        jPanel9.add((Component)jLabel21, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(100, -1), null));
        SSTableComboBox sSTableComboBox6 = new SSTableComboBox();
        this.iSupplier = sSTableComboBox6;
        jPanel9.add(sSTableComboBox6, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(150, -1), null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("productpanel.panel.3"), null, jPanel10, null);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(2, 1, new Insets(4, 4, 4, 4), -1, -1, true, false));
        jPanel10.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel11.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iDescriptions = sSLocalizedTextField = new SSLocalizedTextField();
        jPanel11.add((Component)sSLocalizedTextField, new GridConstraints(1, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        JLabel jLabel22 = new JLabel();
        this.$$$loadLabelText$$$(jLabel22, ResourceBundle.getBundle("book").getString("productframe.descriptions"));
        jPanel11.add((Component)jLabel22, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel10.add((Component)spacer8, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel10.add((Component)spacer9, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayoutManager(5, 3, new Insets(4, 4, 4, 4), 4, 2, false, false));
        jPanel10.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        jPanel12.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel23 = new JLabel();
        this.$$$loadLabelText$$$(jLabel23, ResourceBundle.getBundle("book").getString("productframe.inprice"));
        jPanel12.add((Component)jLabel23, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel24 = new JLabel();
        this.$$$loadLabelText$$$(jLabel24, ResourceBundle.getBundle("book").getString("productframe.contribution"));
        jPanel12.add((Component)jLabel24, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel25 = new JLabel();
        this.$$$loadLabelText$$$(jLabel25, ResourceBundle.getBundle("book").getString("productframe.contributionrate"));
        jPanel12.add((Component)jLabel25, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel26 = new JLabel();
        jLabel26.setText("%");
        jPanel12.add((Component)jLabel26, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel27 = new JLabel();
        this.$$$loadLabelText$$$(jLabel27, ResourceBundle.getBundle("book").getString("productframe.contributioncalculation"));
        jPanel12.add((Component)jLabel27, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.iInprice = sSCurrencyTextField2 = new SSCurrencyTextField();
        sSCurrencyTextField2.setEditable(false);
        jPanel12.add((Component)sSCurrencyTextField2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(120, -1), null));
        this.iContribution = sSCurrencyTextField = new SSCurrencyTextField();
        sSCurrencyTextField.setEditable(false);
        jPanel12.add((Component)sSCurrencyTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(120, -1), null));
        SSButton sSButton2 = new SSButton();
        this.iUpdateContributionButton = sSButton2;
        sSButton2.setIconName("ICON_REFRESH16");
        jPanel12.add((Component)sSButton2, new GridConstraints(1, 2, 1, 1, 4, 0, 3, 3, new Dimension(22, 22), new Dimension(22, 22), new Dimension(22, 22)));
        this.iContributionRate = sSBigDecimalTextField = new SSBigDecimalTextField();
        sSBigDecimalTextField.setEditable(false);
        jPanel12.add((Component)sSBigDecimalTextField, new GridConstraints(3, 1, 1, 1, 8, 0, 7, 3, null, new Dimension(120, -1), null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridLayoutManager(2, 1, new Insets(8, 8, 8, 8), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("productpanel.panel.4"), null, jPanel13, null);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridLayoutManager(2, 1, new Insets(4, 4, 4, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel14, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel14.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel14.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.iParcel = sSTable = new SSTable();
        sSTable.setFocusTraversalPolicyProvider(true);
        jScrollPane.setViewportView(sSTable);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel15, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer10 = new Spacer();
        jPanel15.add((Component)spacer10, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iDeleteParcelButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("book").getString("productpanel.deleteparcel"));
        jPanel15.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

