/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.product.util;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSProductRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBoxOld;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSDefaultTableCellRenderer;

public class SSProductRowTableModel
extends SSDefaultTableModel<SSProductRow> {
    private SSProductRow iEditingRow = new SSProductRow();

    public SSProductRowTableModel() {
        this((List<SSProductRow>)new LinkedList<SSProductRow>());
    }

    public SSProductRowTableModel(List<SSProductRow> pObjects) {
        super(pObjects);
        this.addColumn(SSBundle.getBundle().getString("productrowtable.column.1"));
        this.addColumn(SSBundle.getBundle().getString("productrowtable.column.2"));
        this.addColumn(SSBundle.getBundle().getString("productrowtable.column.3"));
        this.addColumn(SSBundle.getBundle().getString("productrowtable.column.4"));
    }

    @Override
    public Class getType() {
        return SSProduct.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SSProductRow iRow = this.getObject(rowIndex);
        SSProduct iProduct = iRow.getProduct(SSDB.getInstance().getProducts());
        Object value = null;
        switch (columnIndex) {
            case 0: {
                value = iProduct;
                break;
            }
            case 1: {
                value = iRow.getDescription();
                break;
            }
            case 2: {
                value = iRow.getQuantity();
                break;
            }
            case 3: {
                value = iProduct == null ? null : iProduct.getUnit();
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SSProductRow iRow = this.getObject(rowIndex);
        switch (columnIndex) {
            case 0: {
                iRow.setProduct((SSProduct)aValue);
                break;
            }
            case 1: {
                iRow.setDescription((String)aValue);
                break;
            }
            case 2: {
                iRow.setQuantity((Integer)aValue);
                break;
            }
        }
        if (iRow == this.iEditingRow && aValue != null && !"".equals(aValue)) {
            this.add(this.iEditingRow);
            this.iEditingRow = new SSProductRow();
        }
    }

    @Override
    public int getRowCount() {
        return super.getRowCount() + 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return SSProduct.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return String.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        SSProduct iProduct = this.getObject(rowIndex).getProduct(SSDB.getInstance().getProducts());
        return columnIndex == 0 || iProduct != null && columnIndex != 3;
    }

    @Override
    public SSProductRow getObject(int row) {
        if (row == super.getRowCount()) {
            return this.iEditingRow;
        }
        return (SSProductRow)super.getObject(row);
    }

    @Override
    public void deleteRow(SSProductRow iObject) {
        if (iObject == this.iEditingRow) {
            this.iEditingRow = new SSProductRow();
            this.fireTableDataChanged();
        } else {
            super.deleteRow(iObject);
        }
    }

    public static void setupTable(SSTable iTable, SSProduct iProduct) {
        iTable.setColumnSortingEnabled(false);
        iTable.getColumnModel().getColumn(0).setPreferredWidth(70);
        iTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        iTable.getColumnModel().getColumn(2).setPreferredWidth(70);
        iTable.getColumnModel().getColumn(3).setPreferredWidth(70);
        iTable.setDefaultRenderer(BigDecimal.class, new SSBigDecimalCellRenderer(2));
        iTable.setDefaultEditor(SSProduct.class, new SSProductEditor(SSDB.getInstance().getProducts(), iProduct));
        iTable.setDefaultRenderer(SSProduct.class, new SSProductRenderer());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.product.util.SSProductRowTableModel");
        sb.append("{iEditingRow=").append(this.iEditingRow);
        sb.append('}');
        return sb.toString();
    }

    private static class SSProductEditor
    extends SSTableComboBoxOld.CellEditor<SSProduct> {
        public SSProductEditor(List<SSProduct> iProducts, SSProduct iExcluded) {
            LinkedList<SSProduct> iFiltered = new LinkedList<SSProduct>();
            for (SSProduct iProduct : iProducts) {
                if (iExcluded == iProduct) continue;
                iFiltered.add(iProduct);
            }
            SSDefaultTableModel<SSProduct> model = new SSDefaultTableModel<SSProduct>(iFiltered){

                @Override
                public Class getType() {
                    return SSProduct.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    SSProduct iProduct = (SSProduct)this.getObject(rowIndex);
                    String value = null;
                    switch (columnIndex) {
                        case 0: {
                            value = iProduct.getNumber();
                            break;
                        }
                        case 1: {
                            value = iProduct.getDescription();
                        }
                    }
                    return value;
                }
            };
            model.addColumn(SSBundle.getBundle().getString("producttable.column.1"));
            model.addColumn(SSBundle.getBundle().getString("producttable.column.2"));
            this.setModel(model);
            this.setSearchColumns(0, 1);
            this.setPopupSize(360, 200);
            this.setColumnWidths(60, 300);
        }
    }

    private static class SSProductRenderer
    extends SSDefaultTableCellRenderer<SSProduct> {
        private SSProductRenderer() {
        }

        @Override
        protected void setValue(SSProduct value) {
            if (value != null) {
                super.setValue(value.getNumber());
            } else {
                super.setValue("");
            }
        }
    }
}

