/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.project;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.project.panel.SSProjectPanel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;

public class SSProjectDialog {
    static final SSBundle bundle = SSBundle.getBundle();

    private SSProjectDialog() {
    }

    public static void newDialog(final SSMainFrame iMainFrame, final AbstractTableModel iModel) {
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("projectframe.new.title"));
        final SSProjectPanel iPanel = new SSProjectPanel(false);
        iPanel.setProject(new SSNewProject());
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewProject iProject = iPanel.getProject();
                List<SSNewProject> iProjects = SSDB.getInstance().getProjects();
                for (SSNewProject pProject : iProjects) {
                    if (!iProject.getNumber().equals(pProject.getNumber())) continue;
                    new SSErrorDialog(iMainFrame, "projectframe.duplicate", iProject.getNumber());
                    return;
                }
                SSDB.getInstance().addProject(iProject);
                if (iModel != null) {
                    iModel.fireTableDataChanged();
                }
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "projectframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.add((Component)iPanel.getPanel(), "Center");
        iDialog.pack();
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void editDialog(final SSMainFrame iMainFrame, SSNewProject pProject, final AbstractTableModel iModel) {
        Integer iCompanyId = SSDB.getInstance().getCurrentCompany().getId();
        final String lockString = "project" + pProject.getNumber() + iCompanyId;
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "projectframe.projectopen", pProject.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("projectframe.edit.title"));
        final SSProjectPanel iPanel = new SSProjectPanel(true);
        iPanel.setProject(pProject);
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewProject iProject = iPanel.getProject();
                SSDB.getInstance().updateProject(iProject);
                if (iModel != null) {
                    iModel.fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "projectframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.add((Component)iPanel.getPanel(), "Center");
        iDialog.pack();
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }
}

