/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.project.SSProjectDialog;
import se.swedsoft.bookkeeping.gui.project.util.SSProjectTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSProgressDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.print.dialog.SSPeriodSelectionDialog;
import se.swedsoft.bookkeeping.print.report.SSProjectRevenuePrinter;
import se.swedsoft.bookkeeping.print.report.SSProjectsPrinter;

public class SSProjectFrame
extends SSDefaultTableFrame {
    private static SSProjectFrame cInstance;
    private SSTable iTable;
    private SSProjectTableModel iModel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSProjectFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static SSProjectFrame getInstance() {
        return cInstance;
    }

    private SSProjectFrame(SSMainFrame mainFrame, int width, int height) {
        super(mainFrame, SSBundle.getBundle().getString("projectframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "projectframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProjectFrame.this.newProject();
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "projectframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewProject iSelected = SSProjectFrame.this.getSelected();
                String iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSProjectFrame.this.getProject(iSelected);
                }
                if (iSelected != null) {
                    SSProjectDialog.editDialog(SSProjectFrame.this.getMainFrame(), iSelected, SSProjectFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSProjectFrame.this.getMainFrame(), "projectframe.projectgone", iNumber);
                }
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        this.iTable.addSelectionDependentComponent(iButton);
        iButton = new SSButton("ICON_DELETEITEM", "projectframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSProjectFrame.this.iTable.getSelectedRows();
                List toDelete = SSProjectFrame.this.iModel.getObjects(selected);
                SSProjectFrame.this.deleteSelectedProjects(toDelete);
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        this.iTable.addSelectionDependentComponent(iButton);
        SSMenuButton iButton2 = new SSMenuButton("ICON_PRINT", "projectframe.printbutton");
        iButton2.add("projectframe.print.projectrevenue", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProjectFrame.this.ProjectRevenueReport();
            }
        });
        iButton2.add("projectframe.print.projectlist", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProjectFrame.this.printProjects();
            }
        });
        iToolBar.add(iButton2);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSProjectTableModel();
        this.iModel.addColumn(SSProjectTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSProjectTableModel.COLUMN_NAME);
        this.iModel.addColumn(SSProjectTableModel.COLUMN_CONCLUDED);
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewProject iSelected = SSProjectFrame.this.getSelected();
                if (iSelected == null) {
                    return;
                }
                String iNumber = iSelected.getNumber();
                if ((iSelected = SSProjectFrame.this.getProject(iSelected)) != null) {
                    SSProjectDialog.editDialog(SSProjectFrame.this.getMainFrame(), iSelected, SSProjectFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSProjectFrame.this.getMainFrame(), "projectframe.projectgone", iNumber);
                }
            }
        });
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return iPanel;
    }

    private SSNewProject getSelected() {
        int selected = this.iTable.getSelectedRow();
        if (selected >= 0) {
            return (SSNewProject)this.iModel.getObject(selected);
        }
        return null;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    private void newProject() {
        SSProjectDialog.newDialog(this.getMainFrame(), this.iModel);
    }

    private void deleteSelectedProjects(List<SSNewProject> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "projectframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSNewProject iProject : delete) {
                if (SSPostLock.isLocked("project" + iProject.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "projectframe.projectopen", iProject.getNumber());
                    continue;
                }
                SSDB.getInstance().deleteProject(iProject);
            }
        }
    }

    private SSNewProject getProject(SSNewProject iProject) {
        return SSDB.getInstance().getProject(iProject);
    }

    private List<SSNewProject> getProjects(List<SSNewProject> iProjects) {
        return SSDB.getInstance().getProjects(iProjects);
    }

    private void ProjectRevenueReport() {
        List<SSNewProject> iProjects;
        if (this.iTable.getSelectedRowCount() > 0) {
            int iOption = SSQueryDialog.showDialog(this.getMainFrame(), 1, "projectframe.printallorselected");
            switch (iOption) {
                case 0: {
                    iProjects = this.iModel.getObjects(this.iTable.getSelectedRows());
                    iProjects = this.getProjects(iProjects);
                    break;
                }
                case 1: {
                    iProjects = SSDB.getInstance().getProjects();
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            iProjects = SSDB.getInstance().getProjects();
        }
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(this.getMainFrame(), SSBundle.getBundle().getString("projectrevenue.perioddialog.title"));
        if (SSDB.getInstance().getCurrentYear() != null) {
            iDialog.setFrom(SSDB.getInstance().getCurrentYear().getFrom());
            iDialog.setTo(SSDB.getInstance().getCurrentYear().getTo());
        } else {
            Calendar iCal = Calendar.getInstance();
            iDialog.setFrom(iCal.getTime());
            iCal.add(2, 1);
            iDialog.setTo(iCal.getTime());
        }
        iDialog.setLocationRelativeTo(this.getMainFrame());
        if (iDialog.showDialog() != 0) {
            return;
        }
        Date iFrom = iDialog.getFrom();
        Date iTo = iDialog.getTo();
        final SSProjectRevenuePrinter iPrinter = new SSProjectRevenuePrinter(iProjects, iFrom, iTo);
        SSProgressDialog.runProgress(this.getMainFrame(), new Runnable(){

            @Override
            public void run() {
                iPrinter.preview(SSProjectFrame.this.getMainFrame());
            }
        });
    }

    private void printProjects() {
        SSProjectsPrinter iPrinter;
        if (this.iTable.getSelectedRowCount() > 0) {
            SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), 1, "projectframe.print");
            int iResponce = iDialog.getResponce();
            switch (iResponce) {
                case 0: {
                    List<SSNewProject> iProjects = this.getProjects(this.iModel.getObjects(this.iTable.getSelectedRows()));
                    iPrinter = new SSProjectsPrinter(iProjects);
                    break;
                }
                case 1: {
                    List<SSNewProject> iProjects = this.getProjects(this.iModel.getObjects());
                    iPrinter = new SSProjectsPrinter(iProjects);
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            List<SSNewProject> iProjects = this.getProjects(this.iModel.getObjects(this.iTable.getSelectedRows()));
            iPrinter = new SSProjectsPrinter(iProjects);
        }
        SSProgressDialog.runProgress(this.getMainFrame(), new Runnable(){

            @Override
            public void run() {
                iPrinter.preview(SSProjectFrame.this.getMainFrame());
            }
        });
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getProjects());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.project.SSProjectFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

