/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.project.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;

public class SSProjectPanel {
    private SSNewProject iProject;
    protected JPanel iPanel;
    private JButton iOkButton;
    private JButton iCancelButton;
    protected JTextArea iDescription;
    protected JTextField iName;
    protected JFormattedTextField iNumber;
    protected JCheckBox iConcluded;
    protected SSDateChooser iConcludedDate;

    public SSProjectPanel(boolean iEdit) {
        this.$$$setupUI$$$();
        this.iNumber.setEnabled(!iEdit);
        this.iNumber.setValue("");
        this.iConcluded.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SSProjectPanel.this.iConcludedDate.setEnabled(SSProjectPanel.this.iConcluded.isSelected());
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SSProjectPanel.this.iNumber.isEnabled()) {
                    SSProjectPanel.this.iNumber.requestFocusInWindow();
                } else {
                    SSProjectPanel.this.iName.requestFocusInWindow();
                }
            }
        });
        this.iNumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProjectPanel.this.iName.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProjectPanel.this.iDescription.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDescription.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProjectPanel.this.iConcluded.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iConcluded.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SSProjectPanel.this.iConcluded.isSelected()) {
                                SSProjectPanel.this.iConcludedDate.getEditor().getComponent(0).requestFocusInWindow();
                            } else {
                                SSProjectPanel.this.iOkButton.requestFocusInWindow();
                            }
                        }
                    });
                }
            }
        });
        this.iConcludedDate.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProjectPanel.this.iOkButton.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iOkButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProjectPanel.this.iCancelButton.requestFocusInWindow();
                        }
                    });
                } else if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (ActionListener al : SSProjectPanel.this.iOkButton.getActionListeners()) {
                                al.actionPerformed(null);
                            }
                        }
                    });
                }
            }
        });
        this.iCancelButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSProjectPanel.this.iOkButton.requestFocusInWindow();
                        }
                    });
                } else if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (ActionListener al : SSProjectPanel.this.iCancelButton.getActionListeners()) {
                                al.actionPerformed(null);
                            }
                        }
                    });
                }
            }
        });
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener pActionListener) {
        this.iOkButton.addActionListener(pActionListener);
    }

    public void addCancelAction(ActionListener pActionListener) {
        this.iCancelButton.addActionListener(pActionListener);
    }

    public void setProject(SSNewProject iProject) {
        this.iProject = iProject;
        this.iNumber.setValue(iProject.getNumber());
        this.iName.setText(iProject.getName());
        this.iDescription.setText(iProject.getDescription());
        this.iConcluded.setSelected(iProject.getConcluded());
        this.iConcludedDate.setDate(iProject.getConcludedDate() != null ? iProject.getConcludedDate() : new Date());
    }

    public SSNewProject getProject() {
        this.iProject.setNumber(this.iNumber.getText());
        this.iProject.setName(this.iName.getText());
        this.iProject.setDescription(this.iDescription.getText());
        this.iProject.setConcluded(this.iConcluded.isSelected());
        this.iProject.setConcludedDate(this.iConcludedDate.getDate());
        return this.iProject;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.project.panel.SSProjectPanel");
        sb.append("{iCancelButton=").append(this.iCancelButton);
        sb.append(", iConcluded=").append(this.iConcluded);
        sb.append(", iConcludedDate=").append(this.iConcludedDate);
        sb.append(", iDescription=").append(this.iDescription);
        sb.append(", iName=").append(this.iName);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iOkButton=").append(this.iOkButton);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iProject=").append(this.iProject);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        SSDateChooser sSDateChooser;
        JCheckBox jCheckBox;
        JTextArea jTextArea;
        JTextField jTextField;
        JFormattedTextField jFormattedTextField;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 3, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iNumber = jFormattedTextField = new JFormattedTextField();
        jPanel2.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), new Dimension(80, 20)));
        this.iName = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), new Dimension(-1, 20)));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(2, 1, 1, 2, 0, 3, 7, 7, new Dimension(300, 120), null, null));
        this.iDescription = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jScrollPane.setViewportView(jTextArea);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("projectpanel.name"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setFocusTraversalPolicyProvider(true);
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("projectpanel.number"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("projectpanel.description"));
        jLabel3.setVerticalAlignment(0);
        jLabel3.setVerticalTextPosition(0);
        jLabel3.setInheritsPopupMenu(false);
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 4, 1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.iConcluded = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("projectpanel.concluded"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        this.iConcludedDate = sSDateChooser = new SSDateChooser();
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        ((Component)sSDateChooser).setEnabled(false);
        jPanel3.add((Component)sSDateChooser, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(160, -1), null, new Dimension(-1, 20)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 3, new Insets(0, 4, 4, 4), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iCancelButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("book").getString("okcancelpanel.cancelbutton"));
        jPanel4.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, new Dimension(100, -1), null));
        this.iOkButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("book").getString("okcancelpanel.okbutton"));
        jPanel4.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(100, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

