/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.project.util;

import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSProjectTableModel
extends SSTableModel<SSNewProject> {
    public static SSTableColumn<SSNewProject> COLUMN_NUMBER = new SSTableColumn<SSNewProject>(SSBundle.getBundle().getString("projecttable.column.1")){

        @Override
        public Object getValue(SSNewProject iProject) {
            return iProject.getNumber();
        }

        @Override
        public void setValue(SSNewProject iProject, Object iValue) {
            iProject.setNumber((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 80;
        }
    };
    public static SSTableColumn<SSNewProject> COLUMN_NAME = new SSTableColumn<SSNewProject>(SSBundle.getBundle().getString("projecttable.column.2")){

        @Override
        public Object getValue(SSNewProject iProject) {
            return iProject.getName();
        }

        @Override
        public void setValue(SSNewProject iProject, Object iValue) {
            iProject.setName((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 200;
        }
    };
    public static SSTableColumn<SSNewProject> COLUMN_DESCRIPTION = new SSTableColumn<SSNewProject>(SSBundle.getBundle().getString("projecttable.column.3")){

        @Override
        public Object getValue(SSNewProject iProject) {
            return iProject.getDescription();
        }

        @Override
        public void setValue(SSNewProject iProject, Object iValue) {
            iProject.setDescription((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 400;
        }
    };
    public static SSTableColumn<SSNewProject> COLUMN_CONCLUDED = new SSTableColumn<SSNewProject>(SSBundle.getBundle().getString("projecttable.column.4")){

        @Override
        public Object getValue(SSNewProject iProject) {
            return iProject.getConcluded();
        }

        @Override
        public void setValue(SSNewProject iProject, Object iValue) {
            iProject.setConcluded((Boolean)iValue);
        }

        @Override
        public Class getColumnClass() {
            return Boolean.class;
        }

        @Override
        public int getDefaultWidth() {
            return 80;
        }
    };

    public SSProjectTableModel() {
        super(SSDB.getInstance().getProjects());
    }

    public SSProjectTableModel(List<SSNewProject> iProjects) {
        super(iProjects);
    }

    @Override
    public Class getType() {
        return SSNewProject.class;
    }

    @Override
    public void setupTable(SSTable iTable) {
        iTable.setModel(this);
        iTable.setAutoResizeMode(0);
        iTable.tableChanged(null);
        int iIndex = 0;
        for (SSTableColumn iColumn : this.getColumns()) {
            int iWidth = iColumn.getDefaultWidth();
            TableCellEditor iEditor = iColumn.getCellEditor();
            TableCellRenderer iRenderer = iColumn.getCellRenderer();
            iTable.getColumnModel().getColumn(iIndex).setPreferredWidth(iWidth);
            iTable.getColumnModel().getColumn(iIndex).setCellEditor(iEditor);
            iTable.getColumnModel().getColumn(iIndex).setCellRenderer(iRenderer);
            ++iIndex;
        }
    }

    public static SSProjectTableModel getDropDownModel() {
        SSProjectTableModel iModel = new SSProjectTableModel();
        iModel.addColumn(COLUMN_NUMBER);
        iModel.addColumn(COLUMN_NAME);
        return iModel;
    }

    public static SSProjectTableModel getDropDownModel(List<SSNewProject> iProjects) {
        SSProjectTableModel iModel = new SSProjectTableModel(iProjects);
        iModel.addColumn(COLUMN_NUMBER);
        iModel.addColumn(COLUMN_NAME);
        return iModel;
    }
}

