/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.purchaseorder;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import se.swedsoft.bookkeeping.calc.math.SSPurchaseOrderMath;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.purchaseorder.panel.SSPurchaseOrderPanel;
import se.swedsoft.bookkeeping.gui.supplierinvoice.SSSupplierInvoiceDialog;
import se.swedsoft.bookkeeping.gui.supplierinvoice.SSSupplierInvoiceFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;

public class SSPurchaseOrderDialog {
    private static ResourceBundle bundle = SSBundle.getBundle();

    private SSPurchaseOrderDialog() {
    }

    public static void newDialog(final SSMainFrame iMainFrame, final AbstractTableModel pModel) {
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("purchaseorderframe.new.title"));
        final SSPurchaseOrderPanel iPanel = new SSPurchaseOrderPanel(iDialog);
        iPanel.setOrder(new SSPurchaseOrder());
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseOrder iOrder = iPanel.getOrder();
                SSDB.getInstance().addPurchaseOrder(iOrder);
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "purchaseorderframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void newDialog(final SSMainFrame iMainFrame, SSPurchaseOrder iPurchaseOrder, final List<SSOrder> iSelected, AbstractTableModel pModel) {
        final String lockString = "ordertopurchaseorder" + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "purchaseorderframe.ordertopurchaseorder");
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("purchaseorderframe.new.title"));
        final SSPurchaseOrderPanel iPanel = new SSPurchaseOrderPanel(iDialog);
        iPanel.setOrder(iPurchaseOrder);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseOrder iPurchaseOrder = iPanel.getOrder();
                SSDB.getInstance().addPurchaseOrder(iPurchaseOrder);
                for (SSOrder iOrder : iSelected) {
                    if (!SSDB.getInstance().getOrders().contains(iOrder)) continue;
                    iOrder.setPurchaseOrder(iPurchaseOrder);
                    SSDB.getInstance().updateOrder(iOrder);
                }
                iPanel.dispose();
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "purchaseorderframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void editDialog(final SSMainFrame iMainFrame, SSPurchaseOrder iPurchaseOrder, final AbstractTableModel pModel) {
        final String lockString = "purchaseorder" + iPurchaseOrder.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "purchaseorderframe.purchaseorderopen", iPurchaseOrder.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("purchaseorderframe.edit.title"));
        final SSPurchaseOrderPanel iPanel = new SSPurchaseOrderPanel(iDialog);
        iPanel.setOrder(iPurchaseOrder);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseOrder iOrder = iPanel.getOrder();
                SSDB.getInstance().updatePurchaseOrder(iOrder);
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "purchaseorderframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void copyDialog(final SSMainFrame iMainFrame, SSPurchaseOrder iPurchaseOrder, final AbstractTableModel pModel) {
        String lockString = "purchaseorder" + iPurchaseOrder.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (SSPostLock.isLocked(lockString)) {
            new SSErrorDialog(iMainFrame, "purchaseorderframe.purchaseorderopen", iPurchaseOrder.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("purchaseorderframe.copy.title"));
        final SSPurchaseOrderPanel iPanel = new SSPurchaseOrderPanel(iDialog);
        SSPurchaseOrder iNew = new SSPurchaseOrder(iPurchaseOrder);
        iNew.setNumber(null);
        iNew.setDate(new Date());
        iNew.setInvoice(null);
        iNew.setPrinted(false);
        iNew.setEstimatedDelivery(new Date());
        iPanel.setOrder(iNew);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseOrder iOrder = iPanel.getOrder();
                SSDB.getInstance().addPurchaseOrder(iOrder);
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "purchaseorderframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void createInvoiceDialog(SSMainFrame iMainFrame, List<SSPurchaseOrder> iPurchaseOrders, AbstractTableModel iModel) {
        if (iPurchaseOrders.isEmpty()) {
            return;
        }
        SSSupplier iSupplier = iPurchaseOrders.get(0).getSupplier();
        if (iPurchaseOrders.size() > 1) {
            if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "purchaseorderframe.createcollectioninvoice", iSupplier.getNumber()) != 0) {
                return;
            }
            iPurchaseOrders = SSPurchaseOrderMath.getOrdersBySupplierNr(iPurchaseOrders, iSupplier.getNumber());
        }
        SSSupplierInvoice iSupplierInvoice = new SSSupplierInvoice(iPurchaseOrders.get(0));
        iSupplierInvoice.setNumber(null);
        iSupplierInvoice.setStockInfluencing(true);
        for (SSPurchaseOrder iCurrent : iPurchaseOrders) {
            if (iCurrent.getInvoice() != null) {
                SSInformationDialog.showDialog(iMainFrame, "purchaseorderframe.orderhasinvoice", iCurrent.getNumber());
                return;
            }
            iSupplierInvoice.append(iCurrent);
        }
        if (SSSupplierInvoiceFrame.getInstance() != null) {
            SSSupplierInvoiceDialog.newDialog(iMainFrame, iSupplierInvoice, iPurchaseOrders, SSSupplierInvoiceFrame.getInstance().getModel());
        } else {
            SSSupplierInvoiceDialog.newDialog(iMainFrame, iSupplierInvoice, iPurchaseOrders, null);
        }
        if (iModel != null) {
            iModel.fireTableDataChanged();
        }
    }
}

