/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.purchaseorder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.data.SSOrder;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSMail;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.purchaseorder.SSPurchaseOrderDialog;
import se.swedsoft.bookkeeping.gui.purchaseorder.panel.SSPurchaseOrderSearchPanel;
import se.swedsoft.bookkeeping.gui.purchaseorder.util.SSPurchaseOrderTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.components.SSTabbedPanePanel;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSPurchaseOrderFrame
extends SSDefaultTableFrame {
    private static SSPurchaseOrderFrame cInstance;
    private JTabbedPane iTabbedPane;
    private SSTable iTable;
    private SSPurchaseOrderTableModel iModel;
    private SSPurchaseOrderSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSPurchaseOrderFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
    }

    public static SSPurchaseOrderFrame getInstance() {
        return cInstance;
    }

    private SSPurchaseOrderFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("purchaseorderframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "purchaseorderframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseOrderDialog.newDialog(SSPurchaseOrderFrame.this.getMainFrame(), SSPurchaseOrderFrame.this.iModel);
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "purchaseorderframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseOrder iSelected = (SSPurchaseOrder)SSPurchaseOrderFrame.this.iModel.getSelectedRow(SSPurchaseOrderFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSPurchaseOrderFrame.this.getPurchaseOrder(iSelected);
                }
                if (iSelected != null) {
                    SSPurchaseOrderDialog.editDialog(SSPurchaseOrderFrame.this.getMainFrame(), iSelected, SSPurchaseOrderFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSPurchaseOrderFrame.this.getMainFrame(), "purchaseorderframe.purchaseordergone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "purchaseorderframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseOrder iSelected = (SSPurchaseOrder)SSPurchaseOrderFrame.this.iModel.getSelectedRow(SSPurchaseOrderFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSPurchaseOrderFrame.this.getPurchaseOrder(iSelected);
                }
                if (iSelected != null) {
                    SSPurchaseOrderDialog.copyDialog(SSPurchaseOrderFrame.this.getMainFrame(), iSelected, SSPurchaseOrderFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSPurchaseOrderFrame.this.getMainFrame(), "purchaseorderframe.purchaseordergone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "purchaseorderframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSPurchaseOrderFrame.this.iTable.getSelectedRows();
                List toDelete = SSPurchaseOrderFrame.this.iModel.getObjects(selected);
                SSPurchaseOrderFrame.this.deleteSelected(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_INVOICE24", "purchaseorderframe.createorderbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSPurchaseOrderFrame.this.iModel.getSelectedRows(SSPurchaseOrderFrame.this.iTable);
                if (!(iSelected = SSPurchaseOrderFrame.this.getPurchaseOrders(iSelected)).isEmpty()) {
                    SSPurchaseOrderDialog.createInvoiceDialog(SSPurchaseOrderFrame.this.getMainFrame(), iSelected, SSPurchaseOrderFrame.this.iModel);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        SSMenuButton iMenuButton = new SSMenuButton("ICON_PRINT", "purchaseorderframe.printbutton");
        JMenuItem iMenuItem = iMenuButton.add("purchaseorderframe.print.purchaseorder", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSPurchaseOrderFrame.this.iModel.getSelectedRows(SSPurchaseOrderFrame.this.iTable);
                if (!(iSelected = SSPurchaseOrderFrame.this.getPurchaseOrders(iSelected)).isEmpty()) {
                    SSReportFactory.PurchaseOrderReport(SSPurchaseOrderFrame.this.getMainFrame(), iSelected);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuItem = iMenuButton.add("purchaseorderframe.print.emailpurchaseorderreport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseOrder iSelected = (SSPurchaseOrder)SSPurchaseOrderFrame.this.iModel.getSelectedRow(SSPurchaseOrderFrame.this.iTable);
                if ((iSelected = SSPurchaseOrderFrame.this.getPurchaseOrder(iSelected)) == null) {
                    return;
                }
                if (!SSMail.isOk(iSelected.getSupplier())) {
                    return;
                }
                SSReportFactory.EmailPurchaseOrderReport(SSPurchaseOrderFrame.this.getMainFrame(), iSelected);
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuItem = iMenuButton.add("purchaseorderframe.print.inquiry", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSPurchaseOrderFrame.this.iModel.getSelectedRows(SSPurchaseOrderFrame.this.iTable);
                if (!(iSelected = SSPurchaseOrderFrame.this.getPurchaseOrders(iSelected)).isEmpty()) {
                    SSReportFactory.InquiryReport(SSPurchaseOrderFrame.this.getMainFrame(), iSelected);
                }
            }
        });
        Double.parseDouble("12.20");
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuItem = iMenuButton.add("purchaseorderframe.print.emailinquiry", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseOrder iSelected = (SSPurchaseOrder)SSPurchaseOrderFrame.this.iModel.getSelectedRow(SSPurchaseOrderFrame.this.iTable);
                if ((iSelected = SSPurchaseOrderFrame.this.getPurchaseOrder(iSelected)) == null) {
                    return;
                }
                if (!SSMail.isOk(iSelected.getSupplier())) {
                    return;
                }
                SSReportFactory.EmailInquiryReport(SSPurchaseOrderFrame.this.getMainFrame(), iSelected);
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuButton.addSeparator();
        iMenuButton.add("purchaseorderframe.print.purchaseorderlist", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.PurchaseOrderListReport(SSPurchaseOrderFrame.this.getMainFrame());
            }
        });
        iToolBar.add(iMenuButton);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iModel = new SSPurchaseOrderTableModel();
        this.iModel.addColumn(SSPurchaseOrderTableModel.COLUMN_PRINTED);
        this.iModel.addColumn(SSPurchaseOrderTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSPurchaseOrderTableModel.COLUMN_SUPPLIER_NR);
        this.iModel.addColumn(SSPurchaseOrderTableModel.COLUMN_SUPPLIER_NAME);
        this.iModel.addColumn(SSPurchaseOrderTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSPurchaseOrderTableModel.COLUMN_ESTIMATED_DELIVERY);
        this.iModel.addColumn(SSPurchaseOrderTableModel.COLUMN_SUM);
        this.iModel.addColumn(SSPurchaseOrderTableModel.COLUMN_CURRENCY);
        this.iModel.addColumn(SSPurchaseOrderTableModel.COLUMN_INVOICE);
        this.iTable = new SSTable();
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseOrder iSelected = (SSPurchaseOrder)SSPurchaseOrderFrame.this.iModel.getSelectedRow(SSPurchaseOrderFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                Integer iNumber = iSelected.getNumber();
                iSelected = SSPurchaseOrderFrame.this.getPurchaseOrder(iSelected);
                if (iSelected != null) {
                    SSPurchaseOrderDialog.editDialog(SSPurchaseOrderFrame.this.getMainFrame(), iSelected, SSPurchaseOrderFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSPurchaseOrderFrame.this.getMainFrame(), "purchaseorderframe.purchaseordergone", iNumber);
                }
            }
        });
        this.iTabbedPane = new JTabbedPane();
        this.iTabbedPane.add(SSBundle.getBundle().getString("orderframe.filter.1"), new SSTabbedPanePanel());
        this.iTabbedPane.add(SSBundle.getBundle().getString("orderframe.filter.2"), new SSTabbedPanePanel());
        this.iTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SSPurchaseOrderFrame.this.iSearchPanel.ApplyFilter(SSDB.getInstance().getPurchaseOrders());
            }
        });
        JPanel iPanel = new JPanel();
        this.iSearchPanel = new SSPurchaseOrderSearchPanel(this.iModel);
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)this.iTabbedPane, "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public void setFilterIndex(int index, List<SSPurchaseOrder> iOrders) {
        JPanel iPanel = (JPanel)this.iTabbedPane.getComponentAt(index);
        iPanel.removeAll();
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        List<Object> iFiltered = Collections.emptyList();
        List<SSSupplierInvoice> iInvoices = SSDB.getInstance().getSupplierInvoices();
        switch (index) {
            case 0: {
                iFiltered = iOrders;
                break;
            }
            case 1: {
                iFiltered = new LinkedList();
                for (SSPurchaseOrder iOrder : iOrders) {
                    if (iOrder.getInvoiceNr() != null) continue;
                    iFiltered.add(iOrder);
                }
                break;
            }
        }
        this.iModel.setObjects(iFiltered);
        this.iTabbedPane.repaint();
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    public JTabbedPane getTabbedPane() {
        return this.iTabbedPane;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    private void deleteSelected(List<SSPurchaseOrder> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "purchaseorderframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSPurchaseOrder iPurchaseOrder : delete) {
                if (SSPostLock.isLocked("purchaseorder" + iPurchaseOrder.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "purchaseorderframe.purchaseorderopen", iPurchaseOrder.getNumber());
                    continue;
                }
                for (SSOrder iOrder : SSDB.getInstance().getOrders()) {
                    if (!iOrder.hasPurchaseOrder(iPurchaseOrder)) continue;
                    iOrder.setPurchaseOrder(null);
                    SSDB.getInstance().updateOrder(iOrder);
                }
                SSDB.getInstance().deletePurchaseOrder(iPurchaseOrder);
            }
        }
    }

    public SSPurchaseOrderTableModel getModel() {
        return this.iModel;
    }

    private SSPurchaseOrder getPurchaseOrder(SSPurchaseOrder iPurchaseOrder) {
        return SSDB.getInstance().getPurchaseOrder(iPurchaseOrder);
    }

    private List<SSPurchaseOrder> getPurchaseOrders(List<SSPurchaseOrder> iPurchaseOrders) {
        return SSDB.getInstance().getPurchaseOrders(iPurchaseOrders);
    }

    public void updateFrame() {
        this.iSearchPanel.ApplyFilter(SSDB.getInstance().getPurchaseOrders());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        this.iTabbedPane = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.purchaseorder.SSPurchaseOrderFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTabbedPane=").append(this.iTabbedPane);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

