/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.purchaseorder.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSPurchaseOrderRow;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.common.SSPaymentTerm;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.company.panel.SSAdressPanel;
import se.swedsoft.bookkeeping.gui.company.panel.SSDefaultAccountPanel;
import se.swedsoft.bookkeeping.gui.purchaseorder.util.SSPurchaseOrderRowTableModel;
import se.swedsoft.bookkeeping.gui.supplier.util.SSSupplierTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSInputVerifier;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSCurrencyTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDeliveryTermTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSDeliveryWayTableModel;
import se.swedsoft.bookkeeping.gui.util.model.SSPaymentTermTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSDeleteAction;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSTraversalAction;

public class SSPurchaseOrderPanel {
    private SSPurchaseOrder iPurchaseOrder;
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JFormattedTextField iNumber;
    private SSDateChooser iDate;
    private SSTableComboBox<SSSupplier> iSupplier;
    private JTextField iSupplierName;
    private SSAdressPanel iSupplierAddress;
    private SSAdressPanel iDeliveryAddress;
    private JTextArea iText;
    private JTextField iYourContactPerson;
    private JTextField iOurContactPerson;
    private SSDateChooser iEstimatedDelivery;
    private SSEditableTableComboBox<SSDeliveryWay> iDeliveryWay;
    private SSEditableTableComboBox<SSDeliveryTerm> iDeliveryTerm;
    private SSEditableTableComboBox<SSPaymentTerm> iPaymentTerm;
    private SSEditableTableComboBox<SSCurrency> iCurrency;
    private SSTable iTable;
    private SSDefaultAccountPanel iDefaultAccounts;
    private SSBigDecimalTextField iTotalSum;
    private SSPurchaseOrderRowTableModel iModel;
    private SSInputVerifier iInputVerifier;
    private SSBigDecimalTextField iCurrencyRate;

    public SSPurchaseOrderPanel(SSDialog iOwner) {
        this.$$$setupUI$$$();
        this.iNumber.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("0"))));
        this.iNumber.setHorizontalAlignment(4);
        this.iTable.setColorReadOnly(true);
        this.iTable.setColumnSortingEnabled(false);
        this.iTable.setSingleSelect();
        this.iModel = new SSPurchaseOrderRowTableModel();
        this.iModel.addColumn(SSPurchaseOrderRowTableModel.COLUMN_PRODUCT, true);
        this.iModel.addColumn(SSPurchaseOrderRowTableModel.COLUMN_DESCRIPTION, true);
        this.iModel.addColumn(SSPurchaseOrderRowTableModel.COLUMN_SUPPLIER_ARTICLE_NR, true);
        this.iModel.addColumn(SSPurchaseOrderRowTableModel.COLUMN_UNITPRICE, true);
        this.iModel.addColumn(SSPurchaseOrderRowTableModel.COLUMN_QUANTITY, true);
        this.iModel.addColumn(SSPurchaseOrderRowTableModel.COLUMN_UNIT, true);
        this.iModel.addColumn(SSPurchaseOrderRowTableModel.COLUMN_SUM, false);
        this.iModel.setupTable(this.iTable);
        this.iModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SSPurchaseOrderPanel.this.updateSumFields();
            }
        });
        this.iSupplier.setModel(SSSupplierTableModel.getDropDownModel());
        this.iSupplier.setSearchColumns(0, 1);
        this.iSupplier.setAllowCustomValues(true);
        this.iSupplier.addSelectionListener(new SSSelectionListener<SSSupplier>(){

            @Override
            public void selected(SSSupplier selected) {
                if (selected != null) {
                    SSPurchaseOrderPanel.this.iPurchaseOrder.setSupplier(selected);
                    SSPurchaseOrderPanel.this.iPurchaseOrder.setCurrencyRate(selected.getCurrency() == null ? new BigDecimal(1) : selected.getCurrency().getExchangeRate());
                    SSPurchaseOrderPanel.this.setOrder(SSPurchaseOrderPanel.this.iPurchaseOrder);
                }
            }
        });
        new SSTraversalAction(this.iTable){

            @Override
            protected Point doTraversal(Point iPosition) {
                if (iPosition.x <= 5) {
                    ++iPosition.x;
                }
                if (iPosition.x == 6) {
                    ++iPosition.y;
                    iPosition.x = 0;
                    if (iPosition.y == SSPurchaseOrderPanel.this.iModel.getRowCount()) {
                        SSPurchaseOrderPanel.this.iButtonPanel.getOkButton().requestFocus();
                        return null;
                    }
                }
                return iPosition;
            }
        };
        new SSDeleteAction(this.iTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSPurchaseOrderRow iSelected = (SSPurchaseOrderRow)SSPurchaseOrderPanel.this.iModel.getSelectedRow(SSPurchaseOrderPanel.this.iTable);
                if (iSelected != null) {
                    SSQueryDialog dialog = new SSQueryDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "tenderframe.deleterow", iSelected.toString());
                    if (dialog.getResponce() != 0) {
                        return null;
                    }
                    SSPurchaseOrderPanel.this.iModel.deleteRow(iSelected);
                }
                return iPosition;
            }
        };
        this.iCurrency.getComboBox().setModel(SSCurrencyTableModel.getDropDownModel());
        this.iCurrency.getComboBox().setSearchColumns(0);
        this.iCurrency.setEditingFactory(SSCurrencyTableModel.getEditingFactory(iOwner));
        this.iCurrency.getComboBox().addSelectionListener(new SSSelectionListener<SSCurrency>(){

            @Override
            public void selected(SSCurrency selected) {
                if (selected != null) {
                    SSPurchaseOrderPanel.this.iCurrencyRate.setValue(selected.getExchangeRate());
                }
                SSPurchaseOrderPanel.this.iModel.fireTableDataChanged();
            }
        });
        this.iDeliveryWay.getComboBox().setModel(SSDeliveryWayTableModel.getDropDownModel());
        this.iDeliveryWay.getComboBox().setSearchColumns(0);
        this.iDeliveryWay.setEditingFactory(SSDeliveryWayTableModel.getEditingFactory(iOwner));
        this.iDeliveryTerm.getComboBox().setModel(SSDeliveryTermTableModel.getDropDownModel());
        this.iDeliveryTerm.getComboBox().setSearchColumns(0);
        this.iDeliveryTerm.setEditingFactory(SSDeliveryTermTableModel.getEditingFactory(iOwner));
        this.iPaymentTerm.getComboBox().setModel(SSPaymentTermTableModel.getDropDownModel());
        this.iPaymentTerm.getComboBox().setSearchColumns(0);
        this.iPaymentTerm.setEditingFactory(SSPaymentTermTableModel.getEditingFactory(iOwner));
        this.iInputVerifier = new SSInputVerifier();
        this.iInputVerifier.add(this.iSupplier);
        this.iInputVerifier.add(this.iSupplierName);
        this.iInputVerifier.addListener(new SSInputVerifier.SSVerifierListener(){

            @Override
            public void updated(SSInputVerifier iVerifier, boolean iValid) {
                JComponent iCurrent = iVerifier.getCurrentComponent();
                SSPurchaseOrderPanel.this.iButtonPanel.getOkButton().setEnabled(iValid);
            }
        });
        this.addKeyListeners();
    }

    public boolean isValid() {
        return this.iInputVerifier.isValid();
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener pActionListener) {
        this.iButtonPanel.addOkActionListener(pActionListener);
    }

    public void addCancelAction(ActionListener pActionListener) {
        this.iButtonPanel.addCancelActionListener(pActionListener);
    }

    public void setOrder(SSPurchaseOrder iPurchaseOrder) {
        this.iPurchaseOrder = iPurchaseOrder;
        this.iModel.setObjects(iPurchaseOrder.getRows());
        this.iNumber.setValue(iPurchaseOrder.getNumber());
        this.iDate.setDate(iPurchaseOrder.getDate());
        this.iEstimatedDelivery.setDate(iPurchaseOrder.getEstimatedDelivery());
        this.iSupplier.setSelected(iPurchaseOrder.getSupplier(SSDB.getInstance().getSuppliers()));
        this.iSupplierName.setText(iPurchaseOrder.getSupplierName());
        this.iOurContactPerson.setText(iPurchaseOrder.getOurContact());
        this.iYourContactPerson.setText(iPurchaseOrder.getYourContact());
        this.iCurrency.setSelected(iPurchaseOrder.getCurrency());
        this.iCurrencyRate.setValue(iPurchaseOrder.getCurrencyRate());
        this.iPaymentTerm.setSelected(iPurchaseOrder.getPaymentTerm());
        this.iDeliveryTerm.setSelected(iPurchaseOrder.getDeliveryTerm());
        this.iDeliveryWay.setSelected(iPurchaseOrder.getDeliveryWay());
        this.iText.setText(iPurchaseOrder.getText());
        this.iSupplierAddress.setAdress(iPurchaseOrder.getSupplierAddress());
        this.iDeliveryAddress.setAdress(iPurchaseOrder.getDeliveryAddress());
        this.iDefaultAccounts.setDefaultAccounts(iPurchaseOrder.getDefaultAccounts());
        this.updateSumFields();
        this.iInputVerifier.update();
    }

    public SSPurchaseOrder getOrder() {
        this.iPurchaseOrder.setDate(this.iDate.getDate());
        this.iPurchaseOrder.setEstimatedDelivery(this.iEstimatedDelivery.getDate());
        this.iPurchaseOrder.setSupplier(this.iSupplier.getSelected());
        this.iPurchaseOrder.setSupplierName(this.iSupplierName.getText());
        this.iPurchaseOrder.setOurContact(this.iOurContactPerson.getText());
        this.iPurchaseOrder.setYourContact(this.iYourContactPerson.getText());
        this.iPurchaseOrder.setCurrency(this.iCurrency.getSelected());
        this.iPurchaseOrder.setCurrencyRate(this.iCurrencyRate.getValue());
        this.iPurchaseOrder.setPaymentTerm(this.iPaymentTerm.getSelected());
        this.iPurchaseOrder.setDeliveryTerm(this.iDeliveryTerm.getSelected());
        this.iPurchaseOrder.setDeliveryWay(this.iDeliveryWay.getSelected());
        this.iPurchaseOrder.setText(this.iText.getText());
        this.iPurchaseOrder.setSupplierAddress(this.iSupplierAddress.getAddress());
        this.iPurchaseOrder.setDeliveryAddress(this.iDeliveryAddress.getAddress());
        return this.iPurchaseOrder;
    }

    private void updateSumFields() {
        BigDecimal iTotalSum = this.iPurchaseOrder.getSum();
        this.iTotalSum.setValue(iTotalSum);
    }

    public void dispose() {
        this.iSupplier.dispose();
        this.iSupplier = null;
        this.iPanel.removeAll();
        this.iPanel = null;
        this.iButtonPanel.dispose();
        this.iButtonPanel = null;
        this.iTable.dispose();
        this.iTable = null;
        this.iNumber.removeAll();
        this.iNumber = null;
        this.iDate.dispose();
        this.iDate = null;
        this.iSupplierAddress = null;
        this.iSupplierName = null;
        this.iDeliveryAddress = null;
        this.iText.removeAll();
        this.iText = null;
        this.iYourContactPerson.removeAll();
        this.iYourContactPerson = null;
        this.iOurContactPerson.removeAll();
        this.iOurContactPerson = null;
        this.iEstimatedDelivery = null;
        this.iDeliveryWay.dispose();
        this.iDeliveryWay = null;
        this.iDeliveryTerm.dispose();
        this.iDeliveryTerm = null;
        this.iPaymentTerm.dispose();
        this.iPaymentTerm = null;
        this.iCurrency.dispose();
        this.iCurrency = null;
        this.iDefaultAccounts.dispose();
        this.iDefaultAccounts = null;
        this.iTotalSum.removeAll();
        this.iTotalSum = null;
        this.iModel = null;
        this.iInputVerifier = null;
        this.iCurrencyRate.removeAll();
        this.iCurrencyRate = null;
    }

    public void addKeyListeners() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SSPurchaseOrderPanel.this.iSupplier.getComponent(0).requestFocusInWindow();
            }
        });
        this.iSupplier.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iSupplierName.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iSupplierName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iOurContactPerson.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iOurContactPerson.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iYourContactPerson.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iYourContactPerson.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iDate.getEditor().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDate.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iEstimatedDelivery.getEditor().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iEstimatedDelivery.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iPaymentTerm.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iPaymentTerm.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iDeliveryTerm.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDeliveryTerm.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iDeliveryWay.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDeliveryWay.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iCurrency.getComboBox().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCurrency.getComboBox().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iCurrencyRate.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCurrencyRate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iTable.requestFocusInWindow();
                            SSPurchaseOrderPanel.this.iTable.changeSelection(0, 0, false, false);
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getOkButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iButtonPanel.getCancelButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getCancelButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSPurchaseOrderPanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iNumber.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SSPurchaseOrderPanel.this.iSupplier.getComponent(0).requestFocusInWindow();
                    }
                });
            }
        });
        this.iSupplierAddress.addKeyListeners();
        this.iDeliveryAddress.addKeyListeners();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.purchaseorder.panel.SSPurchaseOrderPanel");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCurrency=").append(this.iCurrency);
        sb.append(", iCurrencyRate=").append(this.iCurrencyRate);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iDefaultAccounts=").append(this.iDefaultAccounts);
        sb.append(", iDeliveryAddress=").append(this.iDeliveryAddress);
        sb.append(", iDeliveryTerm=").append(this.iDeliveryTerm);
        sb.append(", iDeliveryWay=").append(this.iDeliveryWay);
        sb.append(", iEstimatedDelivery=").append(this.iEstimatedDelivery);
        sb.append(", iInputVerifier=").append(this.iInputVerifier);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iOurContactPerson=").append(this.iOurContactPerson);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iPaymentTerm=").append(this.iPaymentTerm);
        sb.append(", iPurchaseOrder=").append(this.iPurchaseOrder);
        sb.append(", iSupplier=").append(this.iSupplier);
        sb.append(", iSupplierAddress=").append(this.iSupplierAddress);
        sb.append(", iSupplierName=").append(this.iSupplierName);
        sb.append(", iTable=").append(this.iTable);
        sb.append(", iText=").append(this.iText);
        sb.append(", iTotalSum=").append(this.iTotalSum);
        sb.append(", iYourContactPerson=").append(this.iYourContactPerson);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        SSDefaultAccountPanel sSDefaultAccountPanel;
        JTextArea jTextArea;
        SSAdressPanel sSAdressPanel;
        SSAdressPanel sSAdressPanel2;
        SSBigDecimalTextField sSBigDecimalTextField;
        SSBigDecimalTextField sSBigDecimalTextField2;
        SSDateChooser sSDateChooser;
        JTextField jTextField;
        JTextField jTextField2;
        SSDateChooser sSDateChooser2;
        JFormattedTextField jFormattedTextField;
        JTextField jTextField3;
        SSTable sSTable;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), 4, 2, false, false));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("purchaseorderframe.panel.1"), null, jPanel2, null);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, new Dimension(-1, 120), null, null));
        this.iTable = sSTable = new SSTable();
        jScrollPane.setViewportView(sSTable);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(7, 7, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("purchaseorderframe.number"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("purchaseorderframe.supplier"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("purchaseorderframe.suppliername"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iSupplierName = jTextField3 = new JTextField();
        jPanel3.add((Component)jTextField3, new GridConstraints(2, 1, 1, 2, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        this.iNumber = jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setEditable(false);
        jPanel3.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("purchaseorderframe.estimateddelivery"));
        jPanel3.add((Component)jLabel4, new GridConstraints(1, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDate = sSDateChooser2 = new SSDateChooser();
        sSDateChooser2.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel3.add((Component)sSDateChooser2, new GridConstraints(0, 5, 1, 1, 4, 0, 3, 3, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1)));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("book").getString("purchaseorderframe.date"));
        jPanel3.add((Component)jLabel5, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        SSEditableTableComboBox sSEditableTableComboBox = new SSEditableTableComboBox();
        this.iPaymentTerm = sSEditableTableComboBox;
        ((Component)sSEditableTableComboBox).setEnabled(true);
        jPanel3.add(sSEditableTableComboBox, new GridConstraints(2, 5, 1, 1, 4, 0, 7, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        SSEditableTableComboBox sSEditableTableComboBox2 = new SSEditableTableComboBox();
        this.iDeliveryTerm = sSEditableTableComboBox2;
        jPanel3.add(sSEditableTableComboBox2, new GridConstraints(3, 5, 1, 1, 4, 0, 7, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        SSEditableTableComboBox sSEditableTableComboBox3 = new SSEditableTableComboBox();
        this.iDeliveryWay = sSEditableTableComboBox3;
        jPanel3.add(sSEditableTableComboBox3, new GridConstraints(4, 5, 1, 1, 4, 0, 7, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        SSEditableTableComboBox sSEditableTableComboBox4 = new SSEditableTableComboBox();
        this.iCurrency = sSEditableTableComboBox4;
        jPanel3.add(sSEditableTableComboBox4, new GridConstraints(5, 5, 1, 1, 4, 0, 7, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("book").getString("tenderframe.currency"));
        jPanel3.add((Component)jLabel6, new GridConstraints(5, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("book").getString("purchaseorderframe.deliveryway"));
        jPanel3.add((Component)jLabel7, new GridConstraints(4, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("book").getString("purchaseorderframe.ourcontact"));
        jPanel3.add((Component)jLabel8, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iOurContactPerson = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("book").getString("purchaseorderframe.yourcontact"));
        jPanel3.add((Component)jLabel9, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iYourContactPerson = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        this.iEstimatedDelivery = sSDateChooser = new SSDateChooser();
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel3.add((Component)sSDateChooser, new GridConstraints(1, 5, 1, 1, 4, 0, 3, 3, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1)));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iSupplier = sSTableComboBox;
        jPanel3.add(sSTableComboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("book").getString("purchaseorderframe.paymentterm"));
        jPanel3.add((Component)jLabel10, new GridConstraints(2, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("book").getString("purchaseorderframe.deliveryterm"));
        jPanel3.add((Component)jLabel11, new GridConstraints(3, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iCurrencyRate = sSBigDecimalTextField2 = new SSBigDecimalTextField();
        sSBigDecimalTextField2.setFractionDigits(5);
        ((JTextComponent)sSBigDecimalTextField2).setText("1,00000");
        jPanel3.add((Component)sSBigDecimalTextField2, new GridConstraints(6, 5, 1, 1, 4, 0, 7, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Valutakurs:");
        jPanel3.add((Component)jLabel12, new GridConstraints(6, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 1, new Insets(0, 2, 4, 2), 2, 0, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("book").getString("purchaseorderframe.sum"));
        jPanel5.add((Component)jLabel13, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTotalSum = sSBigDecimalTextField = new SSBigDecimalTextField();
        sSBigDecimalTextField.setEditable(false);
        jPanel5.add((Component)sSBigDecimalTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, new Dimension(150, -1), new Dimension(150, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("purchaseorderframe.panel.2"), null, jPanel6, null);
        Spacer spacer4 = new Spacer();
        jPanel6.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(1, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iDeliveryAddress = sSAdressPanel2 = new SSAdressPanel();
        sSAdressPanel2.setTitle(ResourceBundle.getBundle("book").getString("purchaseorderframe.ourdeliveryaddress"));
        jPanel7.add((Component)sSAdressPanel2, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.iSupplierAddress = sSAdressPanel = new SSAdressPanel();
        sSAdressPanel.setTitle(ResourceBundle.getBundle("book").getString("purchaseorderframe.supplieraddress"));
        jPanel7.add((Component)sSAdressPanel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 4, 0, false, false));
        jPanel6.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel8.add((Component)jScrollPane2, new GridConstraints(1, 0, 1, 1, 8, 3, 0, 0, new Dimension(-1, 60), new Dimension(60, 60), new Dimension(500, 60)));
        this.iText = jTextArea = new JTextArea();
        jScrollPane2.setViewportView(jTextArea);
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("book").getString("purchaseorderframe.text"));
        jPanel8.add((Component)jLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(2, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("purchaseorderframe.panel.3"), null, jPanel9, null);
        Spacer spacer6 = new Spacer();
        jPanel9.add((Component)spacer6, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel9.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iDefaultAccounts = sSDefaultAccountPanel = new SSDefaultAccountPanel();
        jPanel9.add((Component)sSDefaultAccountPanel, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

