/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.purchaseorder.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.graphics.SSIcon;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSPurchaseOrderTableModel
extends SSTableModel<SSPurchaseOrder> {
    public static SSTableColumn<SSPurchaseOrder> COLUMN_PRINTED = new SSTableColumn<SSPurchaseOrder>(""){

        @Override
        public Object getValue(SSPurchaseOrder iPurchaseOrder) {
            return iPurchaseOrder.isPrinted() ? SSIcon.getIcon("ICON_PROPERTIES16", SSIcon.IconState.NORMAL) : null;
        }

        @Override
        public void setValue(SSPurchaseOrder iPurchaseOrder, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return ImageIcon.class;
        }

        @Override
        public int getDefaultWidth() {
            return 20;
        }
    };
    public static SSTableColumn<SSPurchaseOrder> COLUMN_NUMBER = new SSTableColumn<SSPurchaseOrder>("Ordernr"){

        @Override
        public Object getValue(SSPurchaseOrder iObject) {
            return iObject.getNumber();
        }

        @Override
        public void setValue(SSPurchaseOrder iObject, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 70;
        }
    };
    public static SSTableColumn<SSPurchaseOrder> COLUMN_SUPPLIER_NR = new SSTableColumn<SSPurchaseOrder>("Leverant\u00f6rsnummer"){

        @Override
        public Object getValue(SSPurchaseOrder iObject) {
            return iObject.getSupplierNr();
        }

        @Override
        public void setValue(SSPurchaseOrder iObject, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 150;
        }
    };
    public static SSTableColumn<SSPurchaseOrder> COLUMN_SUPPLIER_NAME = new SSTableColumn<SSPurchaseOrder>("Leverant\u00f6rsnamn"){

        @Override
        public Object getValue(SSPurchaseOrder iObject) {
            return iObject.getSupplierName();
        }

        @Override
        public void setValue(SSPurchaseOrder iObject, Object iValue) {
            iObject.setSupplierName((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 150;
        }
    };
    public static SSTableColumn<SSPurchaseOrder> COLUMN_DATE = new SSTableColumn<SSPurchaseOrder>("Ink\u00f6psdatum"){

        @Override
        public Object getValue(SSPurchaseOrder iObject) {
            return iObject.getDate();
        }

        @Override
        public void setValue(SSPurchaseOrder iObject, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return Date.class;
        }

        @Override
        public int getDefaultWidth() {
            return 110;
        }
    };
    public static SSTableColumn<SSPurchaseOrder> COLUMN_SUM = new SSTableColumn<SSPurchaseOrder>("Belopp"){

        @Override
        public Object getValue(SSPurchaseOrder iObject) {
            return iObject.getSum();
        }

        @Override
        public void setValue(SSPurchaseOrder iObject, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<SSPurchaseOrder> COLUMN_CURRENCY = new SSTableColumn<SSPurchaseOrder>("Valuta"){

        @Override
        public Object getValue(SSPurchaseOrder iObject) {
            return iObject.getCurrency();
        }

        @Override
        public void setValue(SSPurchaseOrder iObject, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return SSCurrency.class;
        }

        @Override
        public int getDefaultWidth() {
            return 50;
        }
    };
    public static SSTableColumn<SSPurchaseOrder> COLUMN_ESTIMATED_DELIVERY = new SSTableColumn<SSPurchaseOrder>("Ber\u00e4knad leverans"){

        @Override
        public Object getValue(SSPurchaseOrder iObject) {
            return iObject.getEstimatedDelivery();
        }

        @Override
        public void setValue(SSPurchaseOrder iObject, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return Date.class;
        }

        @Override
        public int getDefaultWidth() {
            return 110;
        }
    };
    public static SSTableColumn<SSPurchaseOrder> COLUMN_INVOICE = new SSTableColumn<SSPurchaseOrder>(SSBundle.getBundle().getString("purchaseordertable.column.8")){

        @Override
        public Object getValue(SSPurchaseOrder iOrder) {
            return iOrder.getInvoiceNr();
        }

        @Override
        public void setValue(SSPurchaseOrder iOrder, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return Integer.class;
        }

        @Override
        public int getDefaultWidth() {
            return 90;
        }
    };

    public SSPurchaseOrderTableModel() {
        super(SSDB.getInstance().getPurchaseOrders());
    }

    public SSPurchaseOrderTableModel(List<SSPurchaseOrder> pObjects) {
        super(pObjects);
    }

    @Override
    public Class getType() {
        return SSPurchaseOrder.class;
    }
}

