/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.purchasesuggestion.util;

import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSPurchaseOrderMath;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSStock;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSPurchaseSuggestionTableModel
extends SSTableModel<Entry> {
    private static SSStock iStock;
    public static SSTableColumn<Entry> COLUMN_NUMBER;
    public static SSTableColumn<Entry> COLUMN_DESCRIPTION;
    public static SSTableColumn<Entry> COLUMN_ORDERPOINT;
    public static SSTableColumn<Entry> COLUMN_STOCK_QUANTITY;
    public static SSTableColumn<Entry> COLUMN_INCOMMING;
    public static SSTableColumn<Entry> COLUMN_ORDER_VOLUME;
    public static SSTableColumn<Entry> COLUMN_SUPPLIER;

    public SSPurchaseSuggestionTableModel(List<SSProduct> iProducts) {
        LinkedList<Entry> iItems = new LinkedList<Entry>();
        iStock = new SSStock(true);
        for (SSProduct iProduct : iProducts) {
            Entry iEntry = new Entry();
            iEntry.iProduct = iProduct;
            iEntry.iSelected = false;
            iEntry.iOrderVolume = iProduct.getOrdercount();
            iEntry.iSupplier = iProduct.getSupplier(SSDB.getInstance().getSuppliers());
            iItems.add(iEntry);
        }
        this.setObjects(iItems);
    }

    @Override
    public Class getType() {
        return Entry.class;
    }

    public List<SSProduct> getSelected() {
        LinkedList<SSProduct> iSelected = new LinkedList<SSProduct>();
        for (Entry iEntry : this.getObjects()) {
            if (!iEntry.iSelected) continue;
            if (iEntry.iSupplier == null) {
                return null;
            }
            SSProduct iProduct = new SSProduct(iEntry.iProduct);
            iProduct.setSupplier(iEntry.iSupplier);
            iProduct.setOrdercount(iEntry.iOrderVolume);
            iSelected.add(iProduct);
        }
        return iSelected;
    }

    public void selectAll() {
        for (Entry entry : this.getObjects()) {
            entry.iSelected = true;
        }
        this.fireTableDataChanged();
    }

    public SSTableColumn<Entry> getSelectionColumn() {
        return new SSTableColumn<Entry>(SSBundle.getBundle().getString("purchasesuggestiontable.column.1")){

            @Override
            public Object getValue(Entry iEntry) {
                return iEntry.iSelected;
            }

            @Override
            public void setValue(Entry iEntry, Object iValue) {
                iEntry.iSelected = (Boolean)iValue;
            }

            @Override
            public Class getColumnClass() {
                return Boolean.class;
            }

            @Override
            public int getDefaultWidth() {
                return 60;
            }
        };
    }

    static {
        COLUMN_NUMBER = new SSTableColumn<Entry>(SSBundle.getBundle().getString("purchasesuggestiontable.column.2")){

            @Override
            public Object getValue(Entry iEntry) {
                return iEntry.iProduct.getNumber();
            }

            @Override
            public void setValue(Entry iEntry, Object iValue) {
            }

            @Override
            public Class getColumnClass() {
                return String.class;
            }

            @Override
            public int getDefaultWidth() {
                return 100;
            }
        };
        COLUMN_DESCRIPTION = new SSTableColumn<Entry>(SSBundle.getBundle().getString("purchasesuggestiontable.column.3")){

            @Override
            public Object getValue(Entry iEntry) {
                return iEntry.iProduct.getDescription();
            }

            @Override
            public void setValue(Entry iEntry, Object iValue) {
                iEntry.iProduct.setDescription((String)iValue);
            }

            @Override
            public Class getColumnClass() {
                return String.class;
            }

            @Override
            public int getDefaultWidth() {
                return 275;
            }
        };
        COLUMN_ORDERPOINT = new SSTableColumn<Entry>(SSBundle.getBundle().getString("purchasesuggestiontable.column.4")){

            @Override
            public Object getValue(Entry iEntry) {
                return iEntry.iProduct.getOrderpoint() == null ? 0 : iEntry.iProduct.getOrderpoint();
            }

            @Override
            public void setValue(Entry iEntry, Object iValue) {
            }

            @Override
            public Class getColumnClass() {
                return Integer.class;
            }

            @Override
            public int getDefaultWidth() {
                return 120;
            }
        };
        COLUMN_STOCK_QUANTITY = new SSTableColumn<Entry>(SSBundle.getBundle().getString("purchasesuggestiontable.column.5")){

            @Override
            public Object getValue(Entry iEntry) {
                return iStock.getQuantity(iEntry.iProduct) == null ? 0 : iStock.getQuantity(iEntry.iProduct);
            }

            @Override
            public void setValue(Entry iObject, Object iValue) {
            }

            @Override
            public Class getColumnClass() {
                return Integer.class;
            }

            @Override
            public int getDefaultWidth() {
                return 90;
            }
        };
        COLUMN_INCOMMING = new SSTableColumn<Entry>(SSBundle.getBundle().getString("purchasesuggestiontable.column.6")){

            @Override
            public Object getValue(Entry iEntry) {
                return SSPurchaseOrderMath.getNumberOfIncommingProducts(iEntry.iProduct);
            }

            @Override
            public void setValue(Entry iObject, Object iValue) {
            }

            @Override
            public Class getColumnClass() {
                return Integer.class;
            }

            @Override
            public int getDefaultWidth() {
                return 90;
            }
        };
        COLUMN_ORDER_VOLUME = new SSTableColumn<Entry>(SSBundle.getBundle().getString("purchasesuggestiontable.column.7")){

            @Override
            public Object getValue(Entry iEntry) {
                return iEntry.iOrderVolume == null ? 0 : iEntry.iOrderVolume;
            }

            @Override
            public void setValue(Entry iEntry, Object iValue) {
                iEntry.iOrderVolume = (Integer)iValue;
            }

            @Override
            public Class getColumnClass() {
                return Integer.class;
            }

            @Override
            public int getDefaultWidth() {
                return 120;
            }
        };
        COLUMN_SUPPLIER = new SSTableColumn<Entry>(SSBundle.getBundle().getString("purchasesuggestiontable.column.8")){

            @Override
            public Object getValue(Entry iEntry) {
                return iEntry.iSupplier;
            }

            @Override
            public void setValue(Entry iEntry, Object iValue) {
                if (iValue instanceof SSSupplier) {
                    iEntry.iSupplier = (SSSupplier)iValue;
                }
            }

            @Override
            public Class getColumnClass() {
                return SSSupplier.class;
            }

            @Override
            public int getDefaultWidth() {
                return 200;
            }

            @Override
            public boolean isEditable(int iRow) {
                return true;
            }
        };
    }

    public static class Entry {
        SSProduct iProduct;
        Integer iOrderVolume;
        SSSupplier iSupplier;
        boolean iSelected;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.purchasesuggestion.util.SSPurchaseSuggestionTableModel.Entry");
            sb.append("{iOrderVolume=").append(this.iOrderVolume);
            sb.append(", iProduct=").append(this.iProduct);
            sb.append(", iSelected=").append(this.iSelected);
            sb.append(", iSupplier=").append(this.iSupplier);
            sb.append('}');
            return sb.toString();
        }
    }
}

