/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.resultunit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.resultunit.SSResultUnitDialog;
import se.swedsoft.bookkeeping.gui.resultunit.util.SSResultUnitTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSProgressDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.print.dialog.SSPeriodSelectionDialog;
import se.swedsoft.bookkeeping.print.report.SSResultUnitPrinter;
import se.swedsoft.bookkeeping.print.report.SSResultUnitRevenuePrinter;

public class SSResultUnitFrame
extends SSDefaultTableFrame {
    private static SSResultUnitFrame cInstance;
    private SSResultUnitTableModel iModel;
    private SSTable iTable;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSResultUnitFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static SSResultUnitFrame getInstance() {
        return cInstance;
    }

    private SSResultUnitFrame(SSMainFrame frame, int width, int height) {
        super(frame, SSBundle.getBundle().getString("resultunitframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "resultunitframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSResultUnitDialog.newDialog(SSResultUnitFrame.this.getMainFrame(), SSResultUnitFrame.this.iModel);
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "resultunitframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewResultUnit iSelected = SSResultUnitFrame.this.getSelected();
                String iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSResultUnitFrame.this.getResultUnit(iSelected);
                }
                if (iSelected != null) {
                    SSResultUnitDialog.editDialog(SSResultUnitFrame.this.getMainFrame(), iSelected, SSResultUnitFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSResultUnitFrame.this.getMainFrame(), "resultunitframe.resultunitgone", iNumber);
                }
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        this.iTable.addSelectionDependentComponent(iButton);
        iButton = new SSButton("ICON_DELETEITEM", "resultunitframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSResultUnitFrame.this.iTable.getSelectedRows();
                List toDelete = SSResultUnitFrame.this.iModel.getObjects(selected);
                SSResultUnitFrame.this.deleteSelectedResultUnits(toDelete);
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        this.iTable.addSelectionDependentComponent(iButton);
        SSMenuButton iButton2 = new SSMenuButton("ICON_PRINT", "resultunitframe.printbutton");
        iButton2.add("resultunitframe.print.resultunitrevenue", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSResultUnitFrame.this.ResultUnitRevenueReport();
            }
        });
        iButton2.add("resultunitframe.print.resultunitlist", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSResultUnitFrame.this.printResultUnits();
            }
        });
        iToolBar.add(iButton2);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSResultUnitTableModel();
        this.iModel.addColumn(SSResultUnitTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSResultUnitTableModel.COLUMN_NAME);
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSNewResultUnit iSelected = SSResultUnitFrame.this.getSelected();
                if (iSelected == null) {
                    return;
                }
                String iNumber = iSelected.getNumber();
                if ((iSelected = SSResultUnitFrame.this.getResultUnit(iSelected)) != null) {
                    SSResultUnitDialog.editDialog(SSResultUnitFrame.this.getMainFrame(), iSelected, SSResultUnitFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSResultUnitFrame.this.getMainFrame(), "resultunitframe.resultunitgone", iNumber);
                }
            }
        });
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        return iPanel;
    }

    private SSNewResultUnit getSelected() {
        int selected = this.iTable.getSelectedRow();
        if (selected >= 0) {
            return (SSNewResultUnit)this.iModel.getObject(selected);
        }
        return null;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    private void deleteSelectedResultUnits(List<SSNewResultUnit> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "resultunitframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSNewResultUnit iResultUnit : delete) {
                if (SSPostLock.isLocked("resultunit" + iResultUnit.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "resultunitframe.resultunitopen", iResultUnit.getNumber());
                    continue;
                }
                SSDB.getInstance().deleteResultUnit(iResultUnit);
            }
        }
    }

    private void ResultUnitRevenueReport() {
        List<SSNewResultUnit> iResultUnits;
        if (this.iTable.getSelectedRowCount() > 0) {
            int iOption = SSQueryDialog.showDialog(this.getMainFrame(), 1, "resultunitframe.printallorselected");
            switch (iOption) {
                case 0: {
                    iResultUnits = this.iModel.getObjects(this.iTable.getSelectedRows());
                    iResultUnits = this.getResultUnits(iResultUnits);
                    break;
                }
                case 1: {
                    iResultUnits = SSDB.getInstance().getResultUnits();
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            iResultUnits = SSDB.getInstance().getResultUnits();
        }
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(this.getMainFrame(), SSBundle.getBundle().getString("resultunitrevenue.perioddialog.title"));
        if (SSDB.getInstance().getCurrentYear() != null) {
            iDialog.setFrom(SSDB.getInstance().getCurrentYear().getFrom());
            iDialog.setTo(SSDB.getInstance().getCurrentYear().getTo());
        } else {
            Calendar iCal = Calendar.getInstance();
            iDialog.setFrom(iCal.getTime());
            iCal.add(2, 1);
            iDialog.setTo(iCal.getTime());
        }
        iDialog.setLocationRelativeTo(this.getMainFrame());
        if (iDialog.showDialog() != 0) {
            return;
        }
        Date iFrom = iDialog.getFrom();
        Date iTo = iDialog.getTo();
        final SSResultUnitRevenuePrinter iPrinter = new SSResultUnitRevenuePrinter(iResultUnits, iFrom, iTo);
        SSProgressDialog.runProgress(this.getMainFrame(), new Runnable(){

            @Override
            public void run() {
                iPrinter.preview(SSResultUnitFrame.this.getMainFrame());
            }
        });
    }

    private void printResultUnits() {
        SSResultUnitPrinter iPrinter;
        if (this.iTable.getSelectedRowCount() > 0) {
            SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), 1, "resultunitframe.print");
            int iResponce = iDialog.getResponce();
            switch (iResponce) {
                case 0: {
                    List<SSNewResultUnit> iResultUnits = this.getResultUnits(this.iModel.getObjects(this.iTable.getSelectedRows()));
                    iPrinter = new SSResultUnitPrinter(iResultUnits);
                    break;
                }
                case 1: {
                    List<SSNewResultUnit> iResultUnits = this.getResultUnits(this.iModel.getObjects());
                    iPrinter = new SSResultUnitPrinter(iResultUnits);
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            List<SSNewResultUnit> iResultUnits = this.getResultUnits(this.iModel.getObjects(this.iTable.getSelectedRows()));
            iPrinter = new SSResultUnitPrinter(iResultUnits);
        }
        SSProgressDialog.runProgress(this.getMainFrame(), new Runnable(){

            @Override
            public void run() {
                iPrinter.preview(SSResultUnitFrame.this.getMainFrame());
            }
        });
    }

    private SSNewResultUnit getResultUnit(SSNewResultUnit iResultUnit) {
        return SSDB.getInstance().getResultUnit(iResultUnit);
    }

    private List<SSNewResultUnit> getResultUnits(List<SSNewResultUnit> iResultUnits) {
        return SSDB.getInstance().getResultUnits(iResultUnits);
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getResultUnits());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.resultunit.SSResultUnitFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

