/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.status;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;

public class SSStatusBar
extends JPanel {
    private List<SSStatusBarPanel> iPanels = new LinkedList<SSStatusBarPanel>();

    public SSStatusBar() {
        StatusBorder iBorder = new StatusBorder();
        this.setMinimumSize(new Dimension(-1, 24));
        this.setMaximumSize(new Dimension(-1, 24));
        this.setPreferredSize(new Dimension(-1, 24));
        this.setBorder(iBorder);
        this.setLayout(null);
        this.setBackground(new Color(236, 233, 216));
    }

    public void addPanel(JComponent iComponent) {
        SSStatusBarPanel iPanel = new SSStatusBarPanel();
        iPanel.component = iComponent;
        iPanel.fill = 0;
        iPanel.weightx = 0.0;
        this.iPanels.add(iPanel);
        this.layoutPanels();
    }

    public void addSeparator() {
        SSStatusBarPanel iPanel = new SSStatusBarPanel();
        iPanel.component = new SeparatorPanel();
        iPanel.fill = 0;
        iPanel.weightx = 0.0;
        this.iPanels.add(iPanel);
        this.layoutPanels();
    }

    public void addSpacer() {
        SSStatusBarPanel iPanel = new SSStatusBarPanel();
        JPanel iSpacer = new JPanel();
        iSpacer.setBackground(new Color(236, 233, 216));
        iPanel.component = iSpacer;
        iPanel.fill = 1;
        iPanel.weightx = 1.0;
        this.iPanels.add(iPanel);
        this.layoutPanels();
    }

    private void layoutPanels() {
        boolean x = false;
        int w = this.getWidth();
        this.removeAll();
        GridBagLayout iLayout = new GridBagLayout();
        GridBagConstraints iConstraints = new GridBagConstraints();
        this.setLayout(iLayout);
        for (SSStatusBarPanel iPanel : this.iPanels) {
            iConstraints.fill = iPanel.fill;
            iConstraints.weightx = iPanel.weightx;
            iLayout.setConstraints(iPanel.component, iConstraints);
            this.add(iPanel.component);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int w = this.getWidth() - 12;
        int h = this.getHeight() - 14;
        for (int x = 0; x < 12; x += 4) {
            for (int y = 0; y < 12; y += 4) {
                if (x + y <= 4) continue;
                g.setColor(new Color(255, 255, 255));
                g.fillRect(w + x + 1, h + y + 1, 2, 2);
                g.setColor(new Color(184, 180, 168));
                g.fillRect(w + x, h + y, 2, 2);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.status.SSStatusBar");
        sb.append("{iPanels=").append(this.iPanels);
        sb.append('}');
        return sb.toString();
    }

    private static class StatusBorder
    extends AbstractBorder {
        private Color cOuterColor = new Color(165, 163, 151);
        private Color cInnerColor = new Color(200, 198, 183);

        private StatusBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(this.cOuterColor);
            g.drawLine(x, y, width, y);
            g.drawLine(x, height - 1, width, height - 1);
            g.setColor(this.cInnerColor);
            g.drawLine(x, y + 1, width, y + 1);
            g.drawLine(x, height - 2, width, height - 2);
            g.setColor(oldColor);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 4, 2, 12);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = 4;
            insets.top = 2;
            insets.right = 12;
            insets.bottom = 2;
            return insets;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.status.SSStatusBar.StatusBorder");
            sb.append("{cInnerColor=").append(this.cInnerColor);
            sb.append(", cOuterColor=").append(this.cOuterColor);
            sb.append('}');
            return sb.toString();
        }
    }

    private static class SeparatorPanel
    extends JPanel {
        private Color cColor1 = new Color(175, 173, 160);
        private Color cColor2 = new Color(243, 241, 231);

        public SeparatorPanel() {
            this.setPreferredSize(new Dimension(8, 18));
            this.setMinimumSize(new Dimension(8, 18));
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(this.cColor1);
            g.drawLine(4, 0, 4, this.getHeight());
            g.setColor(this.cColor2);
            g.drawLine(5, 0, 5, this.getHeight());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.status.SSStatusBar.SeparatorPanel");
            sb.append("{cColor1=").append(this.cColor1);
            sb.append(", cColor2=").append(this.cColor2);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class SSStatusBarPanel {
        int fill;
        JComponent component;
        double weightx;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.status.SSStatusBar.SSStatusBarPanel");
            sb.append("{component=").append(this.component);
            sb.append(", fill=").append(this.fill);
            sb.append(", weightx=").append(this.weightx);
            sb.append('}');
            return sb.toString();
        }
    }
}

