/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.suppliercreditinvoice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSSupplierCreditInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.suppliercreditinvoice.SSSupplierCreditInvoiceDialog;
import se.swedsoft.bookkeeping.gui.suppliercreditinvoice.panel.SSSupplierCreditInvoiceSearchPanel;
import se.swedsoft.bookkeeping.gui.suppliercreditinvoice.util.SSSupplierCreditinvoiceTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSSupplierCreditInvoiceFrame
extends SSDefaultTableFrame {
    private static SSSupplierCreditInvoiceFrame cInstance;
    private SSTable iTable;
    private SSTableModel<SSSupplierCreditInvoice> iModel;
    SSSupplierCreditInvoiceSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSSupplierCreditInvoiceFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
    }

    public static SSSupplierCreditInvoiceFrame getInstance() {
        return cInstance;
    }

    private SSSupplierCreditInvoiceFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("suppliercreditinvoiceframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "suppliercreditinvoiceframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierCreditInvoiceDialog.newDialog(SSSupplierCreditInvoiceFrame.this.getMainFrame(), SSSupplierCreditInvoiceFrame.this.iModel);
            }
        });
        toolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "suppliercreditinvoiceframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierCreditInvoice iSelected = (SSSupplierCreditInvoice)SSSupplierCreditInvoiceFrame.this.iModel.getSelectedRow(SSSupplierCreditInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSSupplierCreditInvoiceFrame.this.getSupplierCreditInvoice(iSelected);
                }
                if (iSelected != null) {
                    SSSupplierCreditInvoiceDialog.editDialog(SSSupplierCreditInvoiceFrame.this.getMainFrame(), iSelected, SSSupplierCreditInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSSupplierCreditInvoiceFrame.this.getMainFrame(), "suppliercreditinvoiceframe.suppliercreditinvoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "suppliercreditinvoiceframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierCreditInvoice iSelected = (SSSupplierCreditInvoice)SSSupplierCreditInvoiceFrame.this.iModel.getSelectedRow(SSSupplierCreditInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSSupplierCreditInvoiceFrame.this.getSupplierCreditInvoice(iSelected);
                }
                if (iSelected != null) {
                    SSSupplierCreditInvoiceDialog.copyDialog(SSSupplierCreditInvoiceFrame.this.getMainFrame(), iSelected, SSSupplierCreditInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSSupplierCreditInvoiceFrame.this.getMainFrame(), "suppliercreditinvoiceframe.suppliercreditinvoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        toolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "suppliercreditinvoiceframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSSupplierCreditInvoiceFrame.this.iTable.getSelectedRows();
                List toDelete = SSSupplierCreditInvoiceFrame.this.iModel.getObjects(selected);
                SSSupplierCreditInvoiceFrame.this.deleteSelected(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        toolBar.add(iButton);
        SSMenuButton iMenuButton = new SSMenuButton("ICON_PRINT", "suppliercreditinvoiceframe.printbutton");
        iMenuButton.add("suppliercreditinvoiceframe.print.list", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.SupplierCreditInvoiceListReport(SSSupplierCreditInvoiceFrame.this.getMainFrame());
            }
        });
        toolBar.add(iMenuButton);
        return toolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iModel = new SSSupplierCreditinvoiceTableModel();
        this.iModel.addColumn(SSSupplierCreditinvoiceTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSSupplierCreditinvoiceTableModel.COLUMN_CREDITNING);
        this.iModel.addColumn(SSSupplierCreditinvoiceTableModel.COLUMN_SUPPLIER_NUMBER);
        this.iModel.addColumn(SSSupplierCreditinvoiceTableModel.COLUMN_SUPPLIER_NAME);
        this.iModel.addColumn(SSSupplierCreditinvoiceTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSSupplierCreditinvoiceTableModel.COLUMN_NETSUM);
        this.iModel.addColumn(SSSupplierCreditinvoiceTableModel.COLUMN_CURRENCY);
        this.iModel.addColumn(SSSupplierCreditinvoiceTableModel.COLUMN_TOTALSUM);
        this.iTable = new SSTable();
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierCreditInvoice iSelected = (SSSupplierCreditInvoice)SSSupplierCreditInvoiceFrame.this.iModel.getSelectedRow(SSSupplierCreditInvoiceFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                Integer iNumber = iSelected.getNumber();
                iSelected = SSSupplierCreditInvoiceFrame.this.getSupplierCreditInvoice(iSelected);
                if (iSelected != null) {
                    SSSupplierCreditInvoiceDialog.editDialog(SSSupplierCreditInvoiceFrame.this.getMainFrame(), iSelected, SSSupplierCreditInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSSupplierCreditInvoiceFrame.this.getMainFrame(), "suppliercreditinvoiceframe.suppliercreditinvoicegone", iNumber);
                }
            }
        });
        this.iSearchPanel = new SSSupplierCreditInvoiceSearchPanel(this.iModel);
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public SSTableModel<SSSupplierCreditInvoice> getModel() {
        return this.iModel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    private void deleteSelected(List<SSSupplierCreditInvoice> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "suppliercreditinvoiceframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSSupplierCreditInvoice iSupplierCreditInvoice : delete) {
                if (SSPostLock.isLocked("suppliercreditinvoice" + iSupplierCreditInvoice.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "suppliercreditinvoiceframe.suppliercreditinvoiceopen", iSupplierCreditInvoice.getNumber());
                    continue;
                }
                if (SSSupplierInvoiceMath.iSaldoMap.containsKey(iSupplierCreditInvoice.getCreditingNr())) {
                    SSSupplierInvoiceMath.iSaldoMap.put(iSupplierCreditInvoice.getCreditingNr(), SSSupplierInvoiceMath.iSaldoMap.get(iSupplierCreditInvoice.getCreditingNr()).add(SSSupplierInvoiceMath.getTotalSum(iSupplierCreditInvoice)));
                }
                SSDB.getInstance().deleteSupplierCreditInvoice(iSupplierCreditInvoice);
            }
        }
    }

    private SSSupplierCreditInvoice getSupplierCreditInvoice(SSSupplierCreditInvoice iSupplierCreditInvoice) {
        return SSDB.getInstance().getSupplierCreditInvoice(iSupplierCreditInvoice);
    }

    public void updateFrame() {
        this.iSearchPanel.ApplyFilter();
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.suppliercreditinvoice.SSSupplierCreditInvoiceFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

