/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.suppliercreditinvoice.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierCreditInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoiceRow;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.company.panel.SSDefaultAccountPanel;
import se.swedsoft.bookkeeping.gui.supplier.util.SSSupplierTableModel;
import se.swedsoft.bookkeeping.gui.supplierinvoice.util.SSSupplierInvoiceRowTableModel;
import se.swedsoft.bookkeeping.gui.supplierinvoice.util.SSSupplierInvoiceTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.SSInputVerifier;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.model.SSCurrencyTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSDeleteAction;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSTraversalAction;
import se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherRowTableModelOld;

public class SSSupplierCreditInvoicePanel {
    private SSSupplierCreditInvoice iSupplierCreditInvoice;
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JFormattedTextField iNumber;
    private SSBigDecimalTextField iCurrencyRate;
    private SSDateChooser iDate;
    private SSTableComboBox<SSSupplier> iSupplier;
    private SSTableComboBox<SSSupplierInvoice> iCrediting;
    private JTextField iReferenceNumber;
    private SSEditableTableComboBox<SSCurrency> iCurrency;
    private SSTable iTable;
    private SSDefaultAccountPanel iDefaultAccounts;
    private SSBigDecimalTextField iNetSum;
    private SSBigDecimalTextField iTotalSum;
    private SSSupplierInvoiceRowTableModel iModel;
    private SSTable iVoucherTable;
    private SSVoucherRowTableModelOld iVoucherTableModel;
    private JButton iRefreshVoucher;
    private SSInputVerifier iInputVerifier;
    private JCheckBox iEntered;
    private SSBigDecimalTextField iTaxSum;
    private SSBigDecimalTextField iRoundingSum;
    private SSTable iCorrectionTable;
    private SSVoucherRowTableModelOld iCorrectionTableModel;
    private JCheckBox isStockInfluencing;

    public SSSupplierCreditInvoicePanel(JDialog iOwner) {
        this.$$$setupUI$$$();
        this.iNumber.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("0"))));
        this.iNumber.setHorizontalAlignment(4);
        this.iTable.setColorReadOnly(true);
        this.iTable.setColumnSortingEnabled(false);
        this.iTable.setSingleSelect();
        this.iModel = new SSSupplierInvoiceRowTableModel();
        this.iModel.addColumn(SSSupplierInvoiceRowTableModel.COLUMN_PRODUCT, true);
        this.iModel.addColumn(SSSupplierInvoiceRowTableModel.COLUMN_DESCRIPTION, true);
        this.iModel.addColumn(SSSupplierInvoiceRowTableModel.COLUMN_UNITPRICE, true);
        this.iModel.addColumn(SSSupplierInvoiceRowTableModel.COLUMN_UNITFREIGHT, true);
        this.iModel.addColumn(SSSupplierInvoiceRowTableModel.COLUMN_QUANTITY, true);
        this.iModel.addColumn(SSSupplierInvoiceRowTableModel.COLUMN_UNIT, true);
        this.iModel.addColumn(SSSupplierInvoiceRowTableModel.COLUMN_SUM, false);
        this.iModel.addColumn(SSSupplierInvoiceRowTableModel.COLUMN_ACCOUNT, true);
        this.iModel.addColumn(SSSupplierInvoiceRowTableModel.COLUMN_PROJECT, true);
        this.iModel.addColumn(SSSupplierInvoiceRowTableModel.COLUMN_RESULTUNIT, true);
        this.iModel.setupTable(this.iTable);
        this.iModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SSSupplierCreditInvoicePanel.this.updateSumFields();
            }
        });
        this.iVoucherTableModel = new SSVoucherRowTableModelOld(false, true);
        this.iVoucherTable.setModel(this.iVoucherTableModel);
        SSVoucherRowTableModelOld.setupTable(this.iVoucherTable, this.iVoucherTableModel);
        this.iCorrectionTableModel = new SSVoucherRowTableModelOld(false, false){

            @Override
            public int getColumnCount() {
                return 4;
            }
        };
        this.iCorrectionTable.setModel(this.iCorrectionTableModel);
        SSVoucherRowTableModelOld.setupTable(this.iCorrectionTable, this.iCorrectionTableModel);
        new SSDeleteAction(this.iCorrectionTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSVoucherRow iSelected = (SSVoucherRow)SSSupplierCreditInvoicePanel.this.iCorrectionTableModel.getSelectedRow(SSSupplierCreditInvoicePanel.this.iCorrectionTable);
                if (iSelected != null) {
                    SSSupplierCreditInvoicePanel.this.iCorrectionTableModel.deleteRow(iSelected);
                }
                SSSupplierCreditInvoicePanel.this.iCorrectionTableModel.fireTableDataChanged();
                return iPosition;
            }
        };
        new SSTraversalAction(this.iCorrectionTable){

            @Override
            protected Point doTraversal(Point iPosition) {
                if (iPosition.x == 0) {
                    iPosition.x += 2;
                } else if (iPosition.x < 3) {
                    ++iPosition.x;
                } else if (iPosition.x == 3) {
                    SSVoucherRow iVoucherRow = SSSupplierCreditInvoicePanel.this.iCorrectionTableModel.getObject(iPosition.y);
                    ++iPosition.y;
                    iPosition.x = 0;
                    SSSupplierCreditInvoicePanel.this.setDifferenceToZero(iVoucherRow);
                } else {
                    ++iPosition.y;
                    iPosition.x = 0;
                }
                return iPosition;
            }
        };
        this.iSupplier.setModel(SSSupplierTableModel.getDropDownModel());
        this.iSupplier.setSearchColumns(0, 1);
        this.iSupplier.setAllowCustomValues(false);
        this.iSupplier.addSelectionListener(new SSSelectionListener<SSSupplier>(){

            @Override
            public void selected(SSSupplier selected) {
                if (selected != null) {
                    SSSupplierCreditInvoicePanel.this.iSupplierCreditInvoice.setSupplier(selected);
                    SSSupplierCreditInvoicePanel.this.setCreditSupplierInvoice(SSSupplierCreditInvoicePanel.this.iSupplierCreditInvoice);
                }
            }
        });
        this.iCrediting.setModel(SSSupplierInvoiceTableModel.getDropDownModel());
        this.iCrediting.setSearchColumns(0);
        this.iCrediting.setAllowCustomValues(false);
        new SSTraversalAction(this.iTable){

            @Override
            protected Point doTraversal(Point iPosition) {
                if (iPosition.x <= 4) {
                    ++iPosition.x;
                }
                if (iPosition.x == 5) {
                    ++iPosition.y;
                    iPosition.x = 0;
                    if (iPosition.y == SSSupplierCreditInvoicePanel.this.iModel.getRowCount()) {
                        SSSupplierCreditInvoicePanel.this.iButtonPanel.getOkButton().requestFocus();
                        return null;
                    }
                }
                return iPosition;
            }
        };
        new SSDeleteAction(this.iTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSSupplierInvoiceRow iSelected = (SSSupplierInvoiceRow)SSSupplierCreditInvoicePanel.this.iModel.getSelectedRow(SSSupplierCreditInvoicePanel.this.iTable);
                if (iSelected != null) {
                    SSQueryDialog dialog = new SSQueryDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "tenderframe.deleterow", iSelected.toString());
                    if (dialog.getResponce() != 0) {
                        return null;
                    }
                    SSSupplierCreditInvoicePanel.this.iModel.deleteRow(iSelected);
                }
                return iPosition;
            }
        };
        this.iCurrency.getComboBox().setModel(SSCurrencyTableModel.getDropDownModel());
        this.iCurrency.getComboBox().setSearchColumns(0);
        this.iCurrency.setEditingFactory(SSCurrencyTableModel.getEditingFactory(iOwner));
        this.iCurrencyRate.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSSupplierCreditInvoicePanel.this.iSupplierCreditInvoice.setCurrencyRate(SSSupplierCreditInvoicePanel.this.iCurrencyRate.getValue());
                SSSupplierCreditInvoicePanel.this.updateSumFields();
            }
        });
        this.iRefreshVoucher.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucher iVoucher = SSSupplierCreditInvoicePanel.this.iSupplierCreditInvoice.generateVoucher();
                SSSupplierCreditInvoicePanel.this.iVoucherTableModel.setVoucher(iVoucher);
            }
        });
        this.iTaxSum.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSSupplierCreditInvoicePanel.this.iSupplierCreditInvoice.setTaxSum(SSSupplierCreditInvoicePanel.this.iTaxSum.getValue());
                SSSupplierCreditInvoicePanel.this.updateSumFields();
            }
        });
        this.iRoundingSum.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSSupplierCreditInvoicePanel.this.iSupplierCreditInvoice.setRoundingSum(SSSupplierCreditInvoicePanel.this.iRoundingSum.getValue());
                SSSupplierCreditInvoicePanel.this.updateSumFields();
            }
        });
        this.iInputVerifier = new SSInputVerifier();
        this.iInputVerifier.add(this.iSupplier);
        this.iInputVerifier.addListener(new SSInputVerifier.SSVerifierListener(){

            @Override
            public void updated(SSInputVerifier iVerifier, boolean iValid) {
                SSSupplierCreditInvoicePanel.this.iButtonPanel.getOkButton().setEnabled(iValid);
            }
        });
        this.addKeyListeners();
    }

    private void setDifferenceToZero(SSVoucherRow iVoucherRow) {
        BigDecimal iDebet = iVoucherRow.getDebet();
        BigDecimal iCredit = iVoucherRow.getCredit();
        if (iDebet == null && iCredit == null) {
            BigDecimal iDifference = this.getDifference();
            if (iDifference.signum() < 0) {
                iVoucherRow.setDebet(iDifference.abs());
            } else {
                iVoucherRow.setCredit(iDifference.abs());
            }
        }
        this.iCorrectionTableModel.fireTableDataChanged();
    }

    private BigDecimal getDifference() {
        BigDecimal iCreditSum = new BigDecimal(0);
        BigDecimal iDebetSum = new BigDecimal(0);
        for (SSVoucherRow iRow : this.iCorrectionTableModel.getObjects()) {
            if (iRow.getDebet() != null) {
                iDebetSum = iDebetSum.add(iRow.getDebet());
                continue;
            }
            if (iRow.getCredit() == null) continue;
            iCreditSum = iCreditSum.add(iRow.getCredit());
        }
        return iDebetSum.subtract(iCreditSum);
    }

    public void dispose() {
        ActionListener[] iActionListeners;
        this.iSupplier.dispose();
        this.iSupplier = null;
        this.iPanel.removeAll();
        this.iPanel = null;
        this.iButtonPanel.dispose();
        this.iButtonPanel = null;
        this.iTable.dispose();
        this.iTable = null;
        this.iNumber.removeAll();
        this.iNumber = null;
        this.iDate.dispose();
        this.iDate = null;
        this.iCurrency.dispose();
        this.iCurrency = null;
        this.iDefaultAccounts.dispose();
        this.iDefaultAccounts = null;
        this.iTotalSum.removeAll();
        this.iTotalSum = null;
        this.iModel = null;
        this.iInputVerifier = null;
        this.iCurrencyRate.removeAll();
        this.iCurrencyRate = null;
        this.iNetSum.removeAll();
        this.iNetSum = null;
        this.iVoucherTable.dispose();
        this.iVoucherTable = null;
        this.iVoucherTableModel = null;
        for (ActionListener iActionListener : iActionListeners = this.iRefreshVoucher.getActionListeners()) {
            this.iRefreshVoucher.removeActionListener(iActionListener);
        }
        this.iRefreshVoucher = null;
        this.iInputVerifier = null;
        this.iEntered = null;
        this.iTaxSum = null;
        this.iCorrectionTable.dispose();
        this.iCorrectionTable = null;
        this.iCorrectionTableModel = null;
        this.isStockInfluencing = null;
        this.iCrediting.dispose();
        this.iCrediting = null;
        this.iReferenceNumber = null;
    }

    public boolean isValid() {
        return this.iInputVerifier.isValid();
    }

    public void addKeyListeners() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SSSupplierCreditInvoicePanel.this.iReferenceNumber.requestFocusInWindow();
            }
        });
        this.iReferenceNumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSSupplierCreditInvoicePanel.this.iDate.getEditor().getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iDate.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSSupplierCreditInvoicePanel.this.iTaxSum.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iTaxSum.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSSupplierCreditInvoicePanel.this.iRoundingSum.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iRoundingSum.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSSupplierCreditInvoicePanel.this.iTable.requestFocusInWindow();
                            SSSupplierCreditInvoicePanel.this.iTable.changeSelection(0, 0, false, false);
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getOkButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSSupplierCreditInvoicePanel.this.iButtonPanel.getCancelButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iButtonPanel.getCancelButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSSupplierCreditInvoicePanel.this.iButtonPanel.getOkButton().requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iNumber.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SSSupplierCreditInvoicePanel.this.iReferenceNumber.requestFocusInWindow();
                    }
                });
            }
        });
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener pActionListener) {
        this.iButtonPanel.addOkActionListener(pActionListener);
    }

    public void addCancelAction(ActionListener pActionListener) {
        this.iButtonPanel.addCancelActionListener(pActionListener);
    }

    public void setCreditSupplierInvoice(SSSupplierCreditInvoice iSSSupplierInvoice) {
        this.iSupplierCreditInvoice = iSSSupplierInvoice;
        List<SSSupplier> iSuppliers = SSDB.getInstance().getSuppliers();
        List<SSSupplierInvoice> iSupplierInvoices = SSDB.getInstance().getSupplierInvoices();
        this.iVoucherTableModel.setVoucher(iSSSupplierInvoice.getVoucher());
        this.iCorrectionTableModel.setVoucher(iSSSupplierInvoice.getCorrection());
        this.iModel.setObjects(this.iSupplierCreditInvoice.getRows());
        this.iNumber.setValue(this.iSupplierCreditInvoice.getNumber());
        this.iDate.setDate(this.iSupplierCreditInvoice.getDate());
        this.iSupplier.setSelected(this.iSupplierCreditInvoice.getSupplier(iSuppliers));
        this.iCrediting.setSelected(this.iSupplierCreditInvoice.getCrediting(iSupplierInvoices));
        this.iTaxSum.setValue(iSSSupplierInvoice.getTaxSum());
        this.iRoundingSum.setValue(this.iSupplierCreditInvoice.getRoundingSum());
        this.iReferenceNumber.setText(this.iSupplierCreditInvoice.getReferencenumber());
        this.iCurrency.setSelected(this.iSupplierCreditInvoice.getCurrency());
        this.iCurrencyRate.setValue(this.iSupplierCreditInvoice.getCurrencyRate());
        this.iDefaultAccounts.setDefaultAccounts(this.iSupplierCreditInvoice.getDefaultAccounts());
        this.iEntered.setSelected(this.iSupplierCreditInvoice.isEntered());
        this.isStockInfluencing.setSelected(this.iSupplierCreditInvoice.isStockInfluencing());
        this.updateSumFields();
        this.iInputVerifier.update();
    }

    public SSSupplierCreditInvoice getSupplierCreditInvoice() {
        this.iSupplierCreditInvoice.setDate(this.iDate.getDate());
        this.iSupplierCreditInvoice.setSupplier(this.iSupplier.getSelected());
        this.iSupplierCreditInvoice.setCrediting(this.iCrediting.getSelected());
        this.iSupplierCreditInvoice.setReferencenumber(this.iReferenceNumber.getText());
        this.iSupplierCreditInvoice.setCurrency(this.iCurrency.getSelected());
        this.iSupplierCreditInvoice.setCurrencyRate(this.iCurrencyRate.getValue());
        this.iSupplierCreditInvoice.setTaxSum(this.iTaxSum.getValue());
        this.iSupplierCreditInvoice.setRoundingSum(this.iRoundingSum.getValue());
        this.iSupplierCreditInvoice.setDefaultAccounts(this.iDefaultAccounts.getDefaultAccounts());
        this.iSupplierCreditInvoice.setEntered(this.iEntered.isSelected());
        this.iSupplierCreditInvoice.setStockInfluencing(this.isStockInfluencing.isSelected());
        this.iSupplierCreditInvoice.generateVoucher();
        return this.iSupplierCreditInvoice;
    }

    private void updateSumFields() {
        BigDecimal iNetSum = SSSupplierInvoiceMath.getNetSum(this.iSupplierCreditInvoice);
        BigDecimal iTotalSum = SSSupplierInvoiceMath.getTotalSum(this.iSupplierCreditInvoice);
        this.iNetSum.setValue(iNetSum);
        this.iTotalSum.setValue(iTotalSum);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.suppliercreditinvoice.panel.SSSupplierCreditInvoicePanel");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iCorrectionTable=").append(this.iCorrectionTable);
        sb.append(", iCorrectionTableModel=").append(this.iCorrectionTableModel);
        sb.append(", iCrediting=").append(this.iCrediting);
        sb.append(", iCurrency=").append(this.iCurrency);
        sb.append(", iCurrencyRate=").append(this.iCurrencyRate);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iDefaultAccounts=").append(this.iDefaultAccounts);
        sb.append(", iEntered=").append(this.iEntered);
        sb.append(", iInputVerifier=").append(this.iInputVerifier);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iNetSum=").append(this.iNetSum);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iReferenceNumber=").append(this.iReferenceNumber);
        sb.append(", iRefreshVoucher=").append(this.iRefreshVoucher);
        sb.append(", iRoundingSum=").append(this.iRoundingSum);
        sb.append(", isStockInfluencing=").append(this.isStockInfluencing);
        sb.append(", iSupplier=").append(this.iSupplier);
        sb.append(", iSupplierCreditInvoice=").append(this.iSupplierCreditInvoice);
        sb.append(", iTable=").append(this.iTable);
        sb.append(", iTaxSum=").append(this.iTaxSum);
        sb.append(", iTotalSum=").append(this.iTotalSum);
        sb.append(", iVoucherTable=").append(this.iVoucherTable);
        sb.append(", iVoucherTableModel=").append(this.iVoucherTableModel);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JButton jButton;
        SSTable sSTable;
        SSTable sSTable2;
        SSDefaultAccountPanel sSDefaultAccountPanel;
        SSBigDecimalTextField sSBigDecimalTextField;
        SSBigDecimalTextField sSBigDecimalTextField2;
        SSBigDecimalTextField sSBigDecimalTextField3;
        SSBigDecimalTextField sSBigDecimalTextField4;
        SSBigDecimalTextField sSBigDecimalTextField5;
        JTextField jTextField;
        SSDateChooser sSDateChooser;
        JFormattedTextField jFormattedTextField;
        SSTable sSTable3;
        SSButtonPanel sSButtonPanel;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), 4, 2, false, false));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("supplierinvoiceframe.panel.1"), null, jPanel2, null);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, new Dimension(-1, 120), null, null));
        this.iTable = sSTable3 = new SSTable();
        jScrollPane.setViewportView(sSTable3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(5, 6, new Insets(4, 4, 4, 4), 4, 1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.number"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iNumber = jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setEditable(false);
        jPanel3.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.date"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.crediting"));
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDate = sSDateChooser = new SSDateChooser();
        ((Component)sSDateChooser).setEnabled(true);
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel3.add((Component)sSDateChooser, new GridConstraints(0, 4, 1, 1, 4, 0, 1, 3, new Dimension(200, -1), new Dimension(200, -1), new Dimension(200, -1)));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.supplier"));
        jPanel3.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iReferenceNumber = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), new Dimension(250, -1), new Dimension(250, -1)));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.referencenumber"));
        jPanel3.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iCrediting = sSTableComboBox;
        ((Component)sSTableComboBox).setEnabled(false);
        jPanel3.add(sSTableComboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        SSTableComboBox sSTableComboBox2 = new SSTableComboBox();
        this.iSupplier = sSTableComboBox2;
        ((Component)sSTableComboBox2).setEnabled(false);
        jPanel3.add(sSTableComboBox2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.currency"));
        jPanel3.add((Component)jLabel6, new GridConstraints(1, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.currencyrate"));
        jPanel3.add((Component)jLabel7, new GridConstraints(2, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.taxsum"));
        jPanel3.add((Component)jLabel8, new GridConstraints(3, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        SSEditableTableComboBox sSEditableTableComboBox = new SSEditableTableComboBox();
        this.iCurrency = sSEditableTableComboBox;
        ((Component)sSEditableTableComboBox).setEnabled(false);
        jPanel3.add(sSEditableTableComboBox, new GridConstraints(1, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        this.iCurrencyRate = sSBigDecimalTextField5 = new SSBigDecimalTextField();
        sSBigDecimalTextField5.setEditable(false);
        sSBigDecimalTextField5.setFractionDigits(5);
        jPanel3.add((Component)sSBigDecimalTextField5, new GridConstraints(2, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        this.iTaxSum = sSBigDecimalTextField4 = new SSBigDecimalTextField();
        sSBigDecimalTextField4.setEditable(true);
        sSBigDecimalTextField4.setFractionDigits(2);
        jPanel3.add((Component)sSBigDecimalTextField4, new GridConstraints(3, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("\u00d6resavrundning:");
        jPanel3.add((Component)jLabel9, new GridConstraints(4, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iRoundingSum = sSBigDecimalTextField3 = new SSBigDecimalTextField();
        sSBigDecimalTextField3.setEditable(true);
        sSBigDecimalTextField3.setFractionDigits(2);
        jPanel3.add((Component)sSBigDecimalTextField3, new GridConstraints(4, 4, 1, 1, 4, 0, 1, 3, new Dimension(120, -1), new Dimension(120, -1), new Dimension(120, -1)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 2, new Insets(0, 2, 4, 2), 2, 0, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.totalsum"));
        jPanel5.add((Component)jLabel10, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iTotalSum = sSBigDecimalTextField2 = new SSBigDecimalTextField();
        sSBigDecimalTextField2.setEditable(false);
        jPanel5.add((Component)sSBigDecimalTextField2, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 3, new Dimension(150, -1), new Dimension(150, -1), null));
        this.iNetSum = sSBigDecimalTextField = new SSBigDecimalTextField();
        sSBigDecimalTextField.setEditable(false);
        jPanel5.add((Component)sSBigDecimalTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, new Dimension(150, -1), new Dimension(150, -1), null));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.netsum"));
        jPanel5.add((Component)jLabel11, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(2, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("supplierinvoiceframe.panel.2"), null, jPanel6, null);
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel6.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iDefaultAccounts = sSDefaultAccountPanel = new SSDefaultAccountPanel();
        jPanel6.add((Component)sSDefaultAccountPanel, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(2, 2, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("supplierinvoiceframe.panel.3"), null, jPanel7, null);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(2, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel8.add((Component)jScrollPane2, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, new Dimension(600, 250), null));
        this.iCorrectionTable = sSTable2 = new SSTable();
        jScrollPane2.setViewportView(sSTable2);
        JLabel jLabel12 = new JLabel();
        jLabel12.setVerticalAlignment(1);
        jLabel12.setHorizontalAlignment(2);
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.correction"));
        jLabel12.setHorizontalTextPosition(2);
        jLabel12.setVerticalTextPosition(1);
        jPanel8.add((Component)jLabel12, new GridConstraints(0, 0, 1, 3, 8, 3, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel7.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel7.add((Component)spacer6, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(4, 2, new Insets(4, 4, 4, 4), 0, 0, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("book").getString("supplierinvoiceframe.panel.4"), null, jPanel9, null);
        Spacer spacer7 = new Spacer();
        jPanel9.add((Component)spacer7, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(2, 3, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane3 = new JScrollPane();
        jPanel10.add((Component)jScrollPane3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, new Dimension(600, 250), null));
        this.iVoucherTable = sSTable = new SSTable();
        jScrollPane3.setViewportView(sSTable);
        this.iRefreshVoucher = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.voucherrefresh"));
        jPanel10.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel10.add((Component)spacer8, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel13 = new JLabel();
        jLabel13.setVerticalAlignment(1);
        jLabel13.setHorizontalAlignment(2);
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.voucher"));
        jLabel13.setHorizontalTextPosition(2);
        jLabel13.setVerticalTextPosition(1);
        jPanel10.add((Component)jLabel13, new GridConstraints(0, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        this.iEntered = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("book").getString("suppliercreditinvoiceframe.entered"));
        jPanel9.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel9.add((Component)spacer9, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.isStockInfluencing = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("invoiceframe.updatestock"));
        jPanel9.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

