/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.supplierinvoice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.calc.math.SSSupplierMath;
import se.swedsoft.bookkeeping.data.SSOutpayment;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.outpayment.SSOutpaymentDialog;
import se.swedsoft.bookkeeping.gui.outpayment.SSOutpaymentFrame;
import se.swedsoft.bookkeeping.gui.suppliercreditinvoice.SSSupplierCreditInvoiceDialog;
import se.swedsoft.bookkeeping.gui.suppliercreditinvoice.SSSupplierCreditInvoiceFrame;
import se.swedsoft.bookkeeping.gui.supplierinvoice.SSSupplierInvoiceDialog;
import se.swedsoft.bookkeeping.gui.supplierinvoice.panel.SSSupplierInvoiceSearchPanel;
import se.swedsoft.bookkeeping.gui.supplierinvoice.util.SSSupplierInvoiceTableModel;
import se.swedsoft.bookkeeping.gui.supplierpayments.SSSupplierPaymentDialog;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.components.SSTabbedPanePanel;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSSupplierInvoiceFrame
extends SSDefaultTableFrame {
    private static SSSupplierInvoiceFrame cInstance;
    private SSTable iTable;
    private SSSupplierInvoiceTableModel iModel;
    private JTabbedPane iTabbedPane;
    private SSSupplierInvoiceSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSSupplierInvoiceFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
    }

    public static SSSupplierInvoiceFrame getInstance() {
        return cInstance;
    }

    private SSSupplierInvoiceFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("supplierinvoiceframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "supplierinvoiceframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierInvoiceDialog.newDialog(SSSupplierInvoiceFrame.this.getMainFrame(), SSSupplierInvoiceFrame.this.iModel);
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "supplierinvoiceframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierInvoice iSelected = (SSSupplierInvoice)SSSupplierInvoiceFrame.this.iModel.getSelectedRow(SSSupplierInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSSupplierInvoiceFrame.this.getSupplierInvoice(iSelected);
                }
                if (iSelected != null) {
                    SSSupplierInvoiceDialog.editDialog(SSSupplierInvoiceFrame.this.getMainFrame(), iSelected, SSSupplierInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSSupplierInvoiceFrame.this.getMainFrame(), "supplierinvoiceframe.supplierinvoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "supplierinvoiceframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierInvoice iSelected = (SSSupplierInvoice)SSSupplierInvoiceFrame.this.iModel.getSelectedRow(SSSupplierInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSSupplierInvoiceFrame.this.getSupplierInvoice(iSelected);
                }
                if (iSelected != null) {
                    SSSupplierInvoiceDialog.copyDialog(SSSupplierInvoiceFrame.this.getMainFrame(), iSelected, SSSupplierInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSSupplierInvoiceFrame.this.getMainFrame(), "supplierinvoiceframe.supplierinvoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "supplierinvoiceframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSSupplierInvoiceFrame.this.iTable.getSelectedRows();
                List toDelete = SSSupplierInvoiceFrame.this.iModel.getObjects(selected);
                SSSupplierInvoiceFrame.this.deleteSelected(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_INVOICE24", "supplierinvoiceframe.suppliercreditinvoicebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierInvoice iSelected = (SSSupplierInvoice)SSSupplierInvoiceFrame.this.iModel.getSelectedRow(SSSupplierInvoiceFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSSupplierInvoiceFrame.this.getSupplierInvoice(iSelected);
                }
                if (iSelected != null) {
                    if (SSSupplierCreditInvoiceFrame.getInstance() != null) {
                        SSSupplierCreditInvoiceDialog.newDialog(SSSupplierInvoiceFrame.this.getMainFrame(), iSelected, SSSupplierCreditInvoiceFrame.getInstance().getModel());
                    } else {
                        SSSupplierCreditInvoiceDialog.newDialog(SSSupplierInvoiceFrame.this.getMainFrame(), iSelected, null);
                    }
                } else {
                    new SSErrorDialog(SSSupplierInvoiceFrame.this.getMainFrame(), "supplierinvoiceframe.supplierinvoicegone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_COINS24", "supplierinvoiceframe.outpaymentbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SSSupplierInvoiceFrame.this.iTable.getSelectedRowCount() > 0) {
                    List iSelected = SSSupplierInvoiceFrame.this.iModel.getObjects(SSSupplierInvoiceFrame.this.iTable.getSelectedRows());
                    iSelected = SSSupplierInvoiceFrame.this.getSupplierInvoices(iSelected);
                    SSOutpayment iOutpayment = new SSOutpayment();
                    if (!iSelected.isEmpty()) {
                        iOutpayment.addInvoices(iSelected);
                        if (SSOutpaymentFrame.getInstance() != null) {
                            SSOutpaymentDialog.newDialog(SSSupplierInvoiceFrame.this.getMainFrame(), iOutpayment, SSOutpaymentFrame.getInstance().getModel());
                        } else {
                            SSOutpaymentDialog.newDialog(SSSupplierInvoiceFrame.this.getMainFrame(), iOutpayment, null);
                        }
                    }
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_TASKLIST24", "supplierinvoiceframe.createsupplierpayment", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lockString = "supplierpayment" + SSDB.getInstance().getCurrentCompany().getId();
                if (!SSPostLock.applyLock(lockString)) {
                    new SSErrorDialog(SSSupplierInvoiceFrame.this.getMainFrame(), "supplierinvoiceframe.supplierpayment");
                    return;
                }
                List iSelected = SSSupplierInvoiceFrame.this.iModel.getSelectedRows(SSSupplierInvoiceFrame.this.iTable);
                if ((iSelected = SSSupplierInvoiceFrame.this.getSupplierInvoices(iSelected)).isEmpty()) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                LinkedList<SSSupplierInvoice> iFiltered = new LinkedList<SSSupplierInvoice>();
                for (SSSupplierInvoice iSupplierInvoice : iSelected) {
                    SSCurrency iCurrency;
                    if (iSupplierInvoice.isBGCEntered() || (iCurrency = iSupplierInvoice.getCurrency()) == null || !"SEK".equals(iCurrency.getName()) && !"EUR".equals(iCurrency.getName())) continue;
                    iFiltered.add(iSupplierInvoice);
                }
                SSSupplierPaymentDialog iDialog = new SSSupplierPaymentDialog(SSSupplierInvoiceFrame.this.getMainFrame(), iFiltered);
                iDialog.setSize(800, 600);
                iDialog.setLocationRelativeTo(SSSupplierInvoiceFrame.this.getMainFrame());
                iDialog.showDialog();
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        SSMenuButton iMenuButton = new SSMenuButton("ICON_PRINT", "supplierinvoiceframe.printbutton");
        iMenuButton.add("supplierinvoiceframe.print.list", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.SupplierInvoiceListReport(SSSupplierInvoiceFrame.this.getMainFrame());
            }
        });
        iToolBar.add(iMenuButton);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iModel = new SSSupplierInvoiceTableModel();
        this.iModel.addColumn(SSSupplierInvoiceTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSSupplierInvoiceTableModel.COLUMN_REFERENCE_NUMBER);
        this.iModel.addColumn(SSSupplierInvoiceTableModel.COLUMN_SUPPLIER_NUMBER);
        this.iModel.addColumn(SSSupplierInvoiceTableModel.COLUMN_SUPPLIER_NAME);
        this.iModel.addColumn(SSSupplierInvoiceTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSSupplierInvoiceTableModel.COLUMN_DUEDATE);
        this.iModel.addColumn(SSSupplierInvoiceTableModel.COLUMN_NETSUM);
        this.iModel.addColumn(SSSupplierInvoiceTableModel.COLUMN_CURRENCY);
        this.iModel.addColumn(SSSupplierInvoiceTableModel.COLUMN_TOTALSUM);
        this.iModel.addColumn(SSSupplierInvoiceTableModel.COLUMN_SALDO);
        this.iTable = new SSTable();
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierInvoice iSelected = (SSSupplierInvoice)SSSupplierInvoiceFrame.this.iModel.getSelectedRow(SSSupplierInvoiceFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                Integer iNumber = iSelected.getNumber();
                iSelected = SSSupplierInvoiceFrame.this.getSupplierInvoice(iSelected);
                if (iSelected != null) {
                    SSSupplierInvoiceDialog.editDialog(SSSupplierInvoiceFrame.this.getMainFrame(), iSelected, SSSupplierInvoiceFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSSupplierInvoiceFrame.this.getMainFrame(), "supplierinvoiceframe.supplierinvoicegone", iNumber);
                }
            }
        });
        this.iTabbedPane = new JTabbedPane();
        this.iTabbedPane.add(SSBundle.getBundle().getString("supplierinvoiceframe.filter.1"), new SSTabbedPanePanel());
        this.iTabbedPane.add(SSBundle.getBundle().getString("supplierinvoiceframe.filter.2"), new SSTabbedPanePanel());
        this.iTabbedPane.add(SSBundle.getBundle().getString("supplierinvoiceframe.filter.3"), new SSTabbedPanePanel());
        this.iTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SSSupplierInvoiceFrame.this.updateFrame();
            }
        });
        JPanel iPanel = new JPanel();
        this.iSearchPanel = new SSSupplierInvoiceSearchPanel(this.iModel);
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)this.iTabbedPane, "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public void setFilterIndex(int index, List<SSSupplierInvoice> iInvoices) {
        JPanel iPanel = (JPanel)this.iTabbedPane.getComponentAt(index);
        iPanel.removeAll();
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        List<Object> iFiltered = Collections.emptyList();
        switch (index) {
            case 0: {
                iFiltered = iInvoices;
                break;
            }
            case 1: {
                iFiltered = new LinkedList();
                for (SSSupplierInvoice iInvoice : iInvoices) {
                    if (SSSupplierInvoiceMath.getSaldo(iInvoice.getNumber()).signum() == 0) continue;
                    iFiltered.add(iInvoice);
                }
                break;
            }
            case 2: {
                iFiltered = new LinkedList();
                for (SSSupplierInvoice iInvoice : iInvoices) {
                    if (SSSupplierInvoiceMath.getSaldo(iInvoice.getNumber()).signum() == 0 || !SSSupplierInvoiceMath.expired(iInvoice)) continue;
                    iFiltered.add(iInvoice);
                }
                break;
            }
        }
        this.iModel.setObjects(iFiltered);
        this.iTabbedPane.repaint();
    }

    public SSTableModel getModel() {
        return this.iModel;
    }

    public JTabbedPane getTabbedPane() {
        return this.iTabbedPane;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    private void deleteSelected(List<SSSupplierInvoice> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "supplierinvoiceframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSSupplierInvoice iSupplierInvoice : delete) {
                if (SSPostLock.isLocked("supplierinvoice" + iSupplierInvoice.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "supplierinvoiceframe.supplierinvoiceopen", iSupplierInvoice.getNumber());
                    continue;
                }
                for (SSPurchaseOrder iPurchaseOrder : SSDB.getInstance().getPurchaseOrders()) {
                    if (!iPurchaseOrder.hasInvoice(iSupplierInvoice)) continue;
                    iPurchaseOrder.setInvoice(null);
                    SSDB.getInstance().updatePurchaseOrder(iPurchaseOrder);
                }
                int iIndex = SSSupplierMath.iInvoicesForSuppliers.get(iSupplierInvoice.getSupplierNr()).indexOf(iSupplierInvoice);
                if (iIndex != -1) {
                    SSSupplierMath.iInvoicesForSuppliers.get(iSupplierInvoice.getSupplierNr()).remove(iIndex);
                }
                SSDB.getInstance().deleteSupplierInvoice(iSupplierInvoice);
            }
        }
    }

    private SSSupplierInvoice getSupplierInvoice(SSSupplierInvoice iSupplierInvoice) {
        return SSDB.getInstance().getSupplierInvoice(iSupplierInvoice);
    }

    private List<SSSupplierInvoice> getSupplierInvoices(List<SSSupplierInvoice> iSupplierInvoices) {
        return SSDB.getInstance().getSupplierInvoices(iSupplierInvoices);
    }

    public void updateFrame() {
        this.iSearchPanel.ApplyFilter(SSDB.getInstance().getSupplierInvoices());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        this.iTabbedPane = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.supplierinvoice.SSSupplierInvoiceFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTabbedPane=").append(this.iTabbedPane);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

