/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.supplierpayments.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.supplier.SSSupplierDialog;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;
import se.swedsoft.bookkeeping.importexport.supplierpayments.data.PaymentMethod;
import se.swedsoft.bookkeeping.importexport.supplierpayments.data.SupplierPayment;

public class SSSupplierPaymentTableModel
extends SSTableModel<SupplierPayment> {
    public static SSTableColumn<SupplierPayment> COLUMN_NUMBER = new SSTableColumn<SupplierPayment>(SSBundle.getBundle().getString("supplierpaymenttable.column.1")){

        @Override
        public Object getValue(SupplierPayment iPayment) {
            SSSupplierInvoice iInvoice = iPayment.getSupplierInvoice();
            return iInvoice.getNumber();
        }

        @Override
        public void setValue(SupplierPayment iPayment, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 70;
        }
    };
    public static SSTableColumn<SupplierPayment> COLUMN_SUPPLIER_NUMBER = new SSTableColumn<SupplierPayment>(SSBundle.getBundle().getString("supplierpaymenttable.column.2")){

        @Override
        public Object getValue(SupplierPayment iPayment) {
            SSSupplierInvoice iInvoice = iPayment.getSupplierInvoice();
            return iInvoice.getSupplierNr();
        }

        @Override
        public void setValue(SupplierPayment iPayment, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 150;
        }
    };
    public static SSTableColumn<SupplierPayment> COLUMN_SUPPLIER_NAME = new SSTableColumn<SupplierPayment>(SSBundle.getBundle().getString("supplierpaymenttable.column.3")){

        @Override
        public Object getValue(SupplierPayment iPayment) {
            SSSupplierInvoice iInvoice = iPayment.getSupplierInvoice();
            return iInvoice.getSupplierName();
        }

        @Override
        public void setValue(SupplierPayment iPayment, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 150;
        }
    };
    public static SSTableColumn<SupplierPayment> COLUMN_DATE = new SSTableColumn<SupplierPayment>(SSBundle.getBundle().getString("supplierpaymenttable.column.4")){

        @Override
        public Object getValue(SupplierPayment iPayment) {
            return iPayment.getDate();
        }

        @Override
        public void setValue(SupplierPayment iPayment, Object iValue) {
            iPayment.setDate((Date)iValue);
        }

        @Override
        public Class getColumnClass() {
            return Date.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<SupplierPayment> COLUMN_VALUE = new SSTableColumn<SupplierPayment>(SSBundle.getBundle().getString("supplierpaymenttable.column.5")){

        @Override
        public Object getValue(SupplierPayment iPayment) {
            return iPayment.getValue();
        }

        @Override
        public void setValue(SupplierPayment iPayment, Object iValue) {
            iPayment.setValue((BigDecimal)iValue);
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<SupplierPayment> COLUMN_CURRENCY = new SSTableColumn<SupplierPayment>(SSBundle.getBundle().getString("supplierpaymenttable.column.6")){

        @Override
        public Object getValue(SupplierPayment iPayment) {
            SSSupplierInvoice iInvoice = iPayment.getSupplierInvoice();
            return iInvoice.getCurrency();
        }

        @Override
        public void setValue(SupplierPayment iPayment, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return SSCurrency.class;
        }

        @Override
        public int getDefaultWidth() {
            return 50;
        }
    };
    public static SSTableColumn<SupplierPayment> COLUMN_PAYMENT_METHOD = new SSTableColumn<SupplierPayment>(SSBundle.getBundle().getString("supplierpaymenttable.column.7")){

        @Override
        public Object getValue(SupplierPayment iPayment) {
            return iPayment.getPaymentMethod();
        }

        @Override
        public void setValue(SupplierPayment iPayment, Object iValue) {
            iPayment.setPaymentMethod((PaymentMethod)((Object)iValue));
            if (iPayment.getPaymentMethod() == PaymentMethod.BANKGIRO) {
                iPayment.setAccount(iPayment.getBankGiro());
            }
            if (iPayment.getPaymentMethod() == PaymentMethod.PLUSGIRO) {
                iPayment.setAccount(iPayment.getPlusGiro());
            }
            if (iPayment.getPaymentMethod() == PaymentMethod.CASH) {
                iPayment.setAccount(iPayment.getOutpaymentNumber().toString());
            }
        }

        @Override
        public Class getColumnClass() {
            return PaymentMethod.class;
        }

        @Override
        public int getDefaultWidth() {
            return 70;
        }
    };
    public static SSTableColumn<SupplierPayment> COLUMN_ACCOUNT = new SSTableColumn<SupplierPayment>(SSBundle.getBundle().getString("supplierpaymenttable.column.8")){

        @Override
        public Object getValue(SupplierPayment iPayment) {
            return iPayment.getAccount();
        }

        @Override
        public void setValue(SupplierPayment iPayment, Object iValue) {
            PaymentMethod iPaymentMethod = iPayment.getPaymentMethod();
            if (iPaymentMethod != PaymentMethod.CASH) {
                iPayment.setAccount((String)iValue);
            }
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<SupplierPayment> COLUMN_EDIT_SUPPLIER = new SSTableColumn<SupplierPayment>(""){

        @Override
        public Object getValue(SupplierPayment iPayment) {
            return iPayment.getSupplierInvoice().getSupplier(SSDB.getInstance().getSuppliers());
        }

        @Override
        public void setValue(SupplierPayment iObject, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return SSSupplier.class;
        }

        @Override
        public int getDefaultWidth() {
            return 20;
        }

        @Override
        public TableCellEditor getCellEditor() {
            return new EditSupplierCellEditor();
        }

        @Override
        public TableCellRenderer getCellRenderer() {
            return new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return new JButton("...");
                }
            };
        }
    };

    public SSSupplierPaymentTableModel(List<SSSupplierInvoice> iSupplierInvoices) {
        LinkedList<SupplierPayment> iPayments = new LinkedList<SupplierPayment>();
        for (SSSupplierInvoice iSupplierInvoice : iSupplierInvoices) {
            iPayments.add(new SupplierPayment(iSupplierInvoice));
        }
        this.setObjects(iPayments);
    }

    @Override
    public Class getType() {
        return SupplierPayment.class;
    }

    @Override
    public void setupTable(SSTable iTable) {
        super.setupTable(iTable);
        iTable.setDefaultRenderer(PaymentMethod.class, new PaymentMethodCellRenderer());
        iTable.setDefaultEditor(PaymentMethod.class, new PaymentMethodCellEditor());
    }

    private static class EditSupplierCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private EditSupplierCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            final SSSupplier iSupplier = (SSSupplier)value;
            final JTable iTable = table;
            JButton iButton = new JButton("..");
            iButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SSSupplierDialog.editDialog(SSMainFrame.getInstance(), iSupplier, null);
                    TableModel iModel = iTable.getModel();
                    if (iModel instanceof AbstractTableModel) {
                        ((AbstractTableModel)iModel).fireTableDataChanged();
                    }
                }
            });
            return iButton;
        }
    }

    private static class PaymentMethodCellRenderer
    extends DefaultTableCellRenderer {
        private PaymentMethodCellRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof PaymentMethod) {
                PaymentMethod iAction = (PaymentMethod)((Object)value);
                this.setText(iAction.getDescription());
            } else {
                this.setText("");
            }
        }
    }

    private static class PaymentMethodCellEditor
    extends DefaultCellEditor {
        public PaymentMethodCellEditor() {
            super(new JComboBox());
            JComboBox iComboBox = (JComboBox)this.getComponent();
            DefaultComboBoxModel<PaymentMethod> iModel = new DefaultComboBoxModel<PaymentMethod>();
            iModel.addElement(PaymentMethod.BANKGIRO);
            iModel.addElement(PaymentMethod.PLUSGIRO);
            iModel.addElement(PaymentMethod.CASH);
            iComboBox.setModel(iModel);
            iComboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof PaymentMethod) {
                        PaymentMethod iAction = (PaymentMethod)((Object)value);
                        this.setText(iAction.getDescription());
                    } else {
                        this.setText("");
                    }
                    return this;
                }
            });
        }
    }
}

