/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.tender;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import se.swedsoft.bookkeeping.calc.math.SSTenderMath;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.tender.panel.SSTenderPanel;
import se.swedsoft.bookkeeping.gui.tender.util.SSTenderTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;

public class SSTenderDialog {
    private static ResourceBundle bundle = SSBundle.getBundle();

    private SSTenderDialog() {
    }

    public static void copyDialog(final SSMainFrame iMainFrame, SSTender iTender, final SSTenderTableModel pModel) {
        String lockString = "tender" + iTender.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (SSPostLock.isLocked(lockString)) {
            new SSErrorDialog(iMainFrame, "tenderframe.tenderopen", iTender.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("tenderframe.copy.title"));
        final SSTenderPanel iPanel = new SSTenderPanel(iDialog);
        SSTender iNew = new SSTender(iTender);
        iNew.setNumber(null);
        iNew.setDate(new Date());
        iNew.setOrder(null);
        iNew.setPrinted(false);
        iPanel.setTender(iNew);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTender iTender = iPanel.getTender();
                SSDB.getInstance().addTender(iTender);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSTenderMath.addCustomerAndProducts(iTender);
                }
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "tenderframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void editDialog(final SSMainFrame iMainFrame, SSTender iTender, final SSTenderTableModel pModel) {
        final String lockString = "tender" + iTender.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "tenderframe.tenderopen", iTender.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("tenderframe.edit.title"));
        final SSTenderPanel iPanel = new SSTenderPanel(iDialog);
        iPanel.setTender(new SSTender(iTender));
        iPanel.setSavecustomerandproductsSelected(false);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTender iTender = iPanel.getTender();
                SSDB.getInstance().updateTender(iTender);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSTenderMath.addCustomerAndProducts(iTender);
                }
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "tenderframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void newDialog(final SSMainFrame iMainFrame, SSTenderTableModel pModel) {
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("tenderframe.new.title"));
        final SSTenderPanel iPanel = new SSTenderPanel(iDialog);
        iPanel.setTender(SSTenderMath.newTender());
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTender iTender = iPanel.getTender();
                SSDB.getInstance().addTender(iTender);
                if (iPanel.doSaveCustomerAndProducts()) {
                    SSTenderMath.addCustomerAndProducts(iTender);
                }
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "tenderframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }
}

